/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextArea;
import org.datacontract.schemas._2004._07.Sat_Cfdi_Negocio_ConsultaCfdi_Servicio.Acuse;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.monitoring.LecturaPAC;
import siti.monitoring.RegistraActivo;
import siti.sinco.cfdi.dao.CfdiCanceladosDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dto.CFDICanceladosDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.CFDUtil;
import siti.sinco.cfdi.tools.CfdiCliente;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class CancelarCFDI
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String modo;

    public CancelarCFDI(JTextArea pTextArea, int numSegundos, int empNum, String modo) {
        this.textArea = pTextArea;
        this.intervalo = numSegundos * 1000;
        this.empNum = empNum;
        this.modo = modo;
        this.start();
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        ConfiguracionDTO configuracionDTO = null;
        try {
            bdUtil.setConexion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        configuracionDTO = new ConfiguracionDTO();
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
        ComprobanteDTO comprobanteDTO = new ComprobanteDTO(this.empNum);
        CFDICanceladosDTO cfdiCanceladoDTO2 = new CFDICanceladosDTO();
        CfdiCanceladosDAO canceladosDAO = new CfdiCanceladosDAO();
        CfdiCliente cfdiCliente = new CfdiCliente();
        CFDUtil cfdiUtil = null;
        Acuse acuse = null;
        LecturaPAC lecturaPAC = new LecturaPAC();
        EnvioCorreo envioCorreo = new EnvioCorreo(bdUtil, configuracionDTO);
        String expresion = "";
        String mensajeCorreo = "";
        String respuestaPAC = "";
        String mensajeInterfaz = "";
        String vTipoDocumento = "";
        String vTipoCancelacion = "";
        RegistraActivo registraActivo = new RegistraActivo();
        try {
            this.proc = bdUtil.connection.prepareCall("{ call registraHorasMonitor(?)}");
            this.proc.setInt(1, 2);
        }
        catch (SQLException e) {
            mensajeInterfaz = "Error en registrar el procedimiento" + e.getMessage();
            EscritorInterfaz.escribeEnTextArea(this.textArea, "Error en registrar el procedimiento" + e.getMessage());
            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "ERROR ORA");
        }
        while (this.bandera == 1) {
            try {
                EscritorInterfaz.escribeEnTextArea(this.textArea, "proceso activado " + Fecha.generaFecha());
                System.out.println("Obteniendo CFDIs a cancelar:" + Fecha.horaEjecucion());
                ArrayList<CFDICanceladosDTO> lista = canceladosDAO.leerComprobantesCancelar(bdUtil, "PC");
                for (CFDICanceladosDTO cfdiCanceladoDTO2 : lista) {
                    String vAsunto;
                    mensajeInterfaz = "Se consulta ante el SAT el UUDI " + cfdiCanceladoDTO2.getUuid() + ".";
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    expresion = "re=" + cfdiCanceladoDTO2.getRfcEmisor() + "&rr=" + cfdiCanceladoDTO2.getRfcReceptor() + "&tt=" + cfdiCanceladoDTO2.getTotal() + "&id=" + cfdiCanceladoDTO2.getUuid();
                    acuse = cfdiCliente.consultaServicioCancelacionSAT(expresion);
                    switch (cfdiCanceladoDTO2.getTipoDocumemnto().toUpperCase()) {
                        case "FC": {
                            vTipoDocumento = "La factura";
                            vTipoCancelacion = "Cancelaci\u00f3n factura";
                            break;
                        }
                        case "CB": {
                            vTipoDocumento = "El complemento de pago";
                            vTipoCancelacion = "Cancelaci\u00f3n complemento";
                            break;
                        }
                        case "NM": {
                            vTipoDocumento = "La n\u00f3mina";
                            vTipoCancelacion = "Cancelaci\u00f3n n\u00f3mina";
                        }
                    }
                    mensajeInterfaz = "El resultado de la consulta ante el SAT del UUDI " + cfdiCanceladoDTO2.getUuid() + " es: \n " + "  Codigo Status = " + acuse.getCodigoEstatus() + "\n" + "  Es Cancelable = " + acuse.getEsCancelable() + " \n " + "  Estado = " + acuse.getEstado() + " \n " + "  Estatus Cancelacion = " + acuse.getEstatusCancelacion() + " \n " + "  UIID sustituto " + cfdiCanceladoDTO2.getUuid_sustitucion();
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    System.out.println("tipo:" + cfdiCanceladoDTO2.getClavesatcancelacion() + "estado:" + acuse.getEstado());
                    if (acuse.getCodigoEstatus().startsWith("S")) {
                        if (acuse.getEstado().equals("Vigente")) {
                            if (acuse.getEsCancelable().equals("Cancelable sin aceptaci\u00f3n") || acuse.getEsCancelable().equals("No cancelable") && cfdiCanceladoDTO2.getClavesatcancelacion().equals("01")) {
                                cfdiUtil = new CFDUtil(bdUtil, comprobanteDTO, configuracionDTO, this.empNum);
                                respuestaPAC = cfdiUtil.cancelaCFD(cfdiCanceladoDTO2, this.modo);
                                respuestaPAC = respuestaPAC.replace("\"", "'");
                                String vuuid = lecturaPAC.leyendoRespuestaCancelacion(respuestaPAC, "UUID");
                                String vEstatusuuid = lecturaPAC.leyendoRespuestaCancelacion(respuestaPAC, "EstatusUUID");
                                mensajeInterfaz = "El PAC ha respondido con " + vuuid + " y estado " + vEstatusuuid;
                                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                                if (vEstatusuuid.equals("201")) {
                                    String vStatus = "PE";
                                    String vStatusTipo = "CS";
                                    String vParrafo = "";
                                    acuse = cfdiCliente.consultaServicioCancelacionSAT(expresion);
                                    if (acuse.getEstatusCancelacion() != null) {
                                        if (acuse.getEstatusCancelacion().toUpperCase().contains("En Proceso".toUpperCase())) {
                                            vStatus = "PR";
                                            vParrafo = "<p>" + vTipoDocumento + " est\u00e1 en proceso de cancelarse, estaremos pendientes de su cancelaci\u00f3n. ";
                                        } else if (acuse.getEstatusCancelacion().toUpperCase().contains("CANCELADO")) {
                                            vStatus = "CA";
                                            vParrafo = "<p>" + vTipoDocumento + " ha sido cancelada. ";
                                        } else if (acuse.getEstatusCancelacion().isEmpty()) {
                                            vStatus = "PE";
                                            vStatus = "PE";
                                            vStatusTipo = "";
                                            vParrafo = "<p>El PAC ha marcado como cancelado " + vTipoDocumento + ", " + "pero en el SAT a\u00fan sigue vigente. Favor de revisar ante el SAT," + " este caso puede ser ocasionado por un fallo en el sistema del SAT o del PAC.";
                                        }
                                    } else if (acuse.getEstado().toUpperCase().contains("Vigente".toUpperCase())) {
                                        vStatus = "PE";
                                        vStatusTipo = "";
                                        vParrafo = "<p>" + vTipoDocumento + " el PAC ha regresado que fue cancelado, " + "pero en el SAT a\u00fan sigue vigente. Favor de revisar ante el SAT," + " este caso puede ser ocasionado por un fallo en el sistema del SAT o del PAC.";
                                    } else {
                                        vStatus = "CA";
                                        vStatusTipo = "CS";
                                        vParrafo = "<p>" + vTipoDocumento + " ha sido cancelada. ";
                                    }
                                    canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), vStatus, vStatusTipo);
                                    canceladosDAO.actualizaFechaCancelacion(bdUtil, cfdiCanceladoDTO2.getUuid(), cfdiCanceladoDTO2.getFolio());
                                    canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, cfdiCanceladoDTO2.getFolio());
                                    mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left;\"><h3>Cancelaci\u00f3n</h3><div style=\"padding:0% 5%;\">" + vParrafo + "<br>" + vTipoDocumento + " (<b>" + cfdiCanceladoDTO2.getFactura() + "</b>) con folio <b>" + cfdiCanceladoDTO2.getFolio() + "</b>. <br>Con el UUID: <b>" + cfdiCanceladoDTO2.getUuid() + "</b></p>" + "</div>" + "</div>";
                                    String vAsunto2 = String.valueOf(vTipoCancelacion) + " - " + cfdiCanceladoDTO2.getFolio();
                                    envioCorreo.enviarCorreo("", vAsunto2, mensajeCorreo, "", cfdiCanceladoDTO2.getNombreEmisor());
                                    if (!vStatus.equals("CA")) continue;
                                    canceladosDAO.actualizaCFdEmisionCancelado(bdUtil, cfdiCanceladoDTO2.getFolio(), cfdiCanceladoDTO2.getUuid());
                                    continue;
                                }
                                if (vEstatusuuid.equals("207")) {
                                    mensajeInterfaz = "El estado cambiar\u00e1 a 'PR', debido a que di\u00f3 un problema con la cancelaci\u00f3n 01, para el comprobante con folio: " + cfdiCanceladoDTO2.getFolio() + " C\u00f3digo devuelto por el PAC:" + vEstatusuuid;
                                    canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), "PR", "");
                                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                                    continue;
                                }
                                mensajeInterfaz = "No se pudo cancelar el comprobante con el folio: " + cfdiCanceladoDTO2.getFolio() + " C\u00f3digo devuelto por el PAC:" + vEstatusuuid;
                                canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), "NC", "");
                                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                                mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>No cancelable</h3><div style=\"padding:0% 5%;\"><p>El SAT ha indicado que no se puede cancelar.<br>" + vTipoDocumento + " (<b>" + cfdiCanceladoDTO2.getFactura() + "</b>) con folio <b>" + cfdiCanceladoDTO2.getFolio() + "</b>.</p> " + "</div>" + "</div>";
                                String vAsunto3 = "No cancelable - " + cfdiCanceladoDTO2.getFolio();
                                envioCorreo.enviarCorreo("", vAsunto3, mensajeCorreo, "", comprobanteDTO.getNombreEmisor());
                                continue;
                            }
                            if (acuse.getEsCancelable().equals("Cancelable con aceptaci\u00f3n")) {
                                cfdiUtil = new CFDUtil(bdUtil, comprobanteDTO, configuracionDTO, this.empNum);
                                respuestaPAC = cfdiUtil.cancelaCFD(cfdiCanceladoDTO2, this.modo);
                                respuestaPAC = respuestaPAC.replace("\"", "'");
                                lecturaPAC.leyendoRespuestaCancelacion(respuestaPAC, "UUID");
                                mensajeInterfaz = "El PAC ha respondido con " + lecturaPAC.leyendoRespuestaCancelacion(respuestaPAC, "UUID") + " y estado " + lecturaPAC.leyendoRespuestaCancelacion(respuestaPAC, "EstatusUUID");
                                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                                canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, cfdiCanceladoDTO2.getFolio());
                                canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), "PR", "CC");
                                mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Cancelaci\u00f3n con aceptaci\u00f3n</h3><div style=\"padding:0% 5%;\"><p>Para la cancelaci\u00f3n de " + vTipoDocumento.toLowerCase() + " (<b>" + cfdiCanceladoDTO2.getFactura() + "</b>) con folio <b>" + cfdiCanceladoDTO2.getFolio() + "</b> se necesita la aprobaci\u00f3n del cliente. <br>Estaremos pendientes para el cambio de estado.</p>" + "</div>" + "</div>";
                                vAsunto = String.valueOf(vTipoCancelacion) + " con aceptaci\u00f3n - " + cfdiCanceladoDTO2.getFolio();
                                envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", comprobanteDTO.getNombreEmisor());
                                continue;
                            }
                            if (!acuse.getEsCancelable().equals("No cancelable")) continue;
                            mensajeInterfaz = "El UID " + cfdiCanceladoDTO2.getUuid() + " no es cancelable ";
                            EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                            canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), "NC", "");
                            canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, cfdiCanceladoDTO2.getFolio());
                            mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>No cancelable</h3><div style=\"padding:0% 5%;\"><p>El SAT ha indicado que no se puede cancelar.<br>" + vTipoDocumento + " (<b>" + cfdiCanceladoDTO2.getFactura() + "</b>) con folio <b>" + cfdiCanceladoDTO2.getFolio() + "</b>.</p> " + "</div>" + "</div>";
                            vAsunto = "No cancelable - " + cfdiCanceladoDTO2.getFolio();
                            envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", comprobanteDTO.getNombreEmisor());
                            continue;
                        }
                        mensajeInterfaz = "El UUID " + cfdiCanceladoDTO2.getUuid() + " ya ha sido cancelado con anterioridad " + acuse.getEstado();
                        canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), "YC", "");
                        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                        continue;
                    }
                    if (acuse.getCodigoEstatus().contains("601")) {
                        mensajeInterfaz = "El RFC del emisor/receptor o el total, est\u00e1 mal. Favor de revisar la informacion. ";
                    } else if (acuse.getCodigoEstatus().contains("602")) {
                        mensajeInterfaz = "El UUID est\u00e1 mal. Favor de revisar la informacion. ";
                    }
                    System.out.println(String.valueOf(mensajeInterfaz) + "Expresion enviada:" + expresion);
                    mensajeInterfaz = "El UUID " + cfdiCanceladoDTO2.getUuid() + " no existe. Verifique la informacion";
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    canceladosDAO.actualizaEstadoCancelado(bdUtil, cfdiCanceladoDTO2.getUuid(), "NE", "");
                    canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, cfdiCanceladoDTO2.getFolio());
                    mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Error a la hora de cancelar</h3><p>" + mensajeInterfaz + "</p>" + "<p>Los datos de " + vTipoDocumento.toLowerCase() + " (<b>" + cfdiCanceladoDTO2.getFactura() + "</b>) con folio <b>" + cfdiCanceladoDTO2.getFolio() + "</b> que se enviaron al SAT son:</p><br>" + "<div style=\"padding:0% 10%;\">" + "<p>" + "<b>RFC Emisor</b>.....:  " + cfdiCanceladoDTO2.getRfcEmisor() + "<br>" + "<b>RFC Receptor</b>.:  " + cfdiCanceladoDTO2.getRfcReceptor() + "<br>" + "<b>Total</b>...............:  " + cfdiCanceladoDTO2.getTotal() + "<br>" + "<b>UUID</b>...............:  " + cfdiCanceladoDTO2.getUuid().toUpperCase() + "</p>" + "</div>" + "</div>";
                    vAsunto = " Error en la cancelaci\u00f3n - " + cfdiCanceladoDTO2.getFolio();
                    envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", comprobanteDTO.getNombreEmisor());
                }
                lista = null;
                Iterator<CFDICanceladosDTO> itera = null;
                registraActivo.ejecutaProc(bdUtil, this.proc, this.textArea);
                Thread.currentThread();
                Thread.sleep(this.intervalo);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.intervalo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mensajeInterfaz = "Error en run de RevisaLog:" + e.toString();
                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
            }
        }
        mensajeInterfaz = "PROCESO TERMINADO";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        String mensajeInterfaz = "Se detendra el proceso en el siguiente ciclo";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }
}

