/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextArea;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.monitoring.RegistraActivo;
import siti.sinco.cfdi.CFD;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.LogcfdDAO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.LogCFD_DTO;

public class Timbrado
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String path;
    public String modo;
    public int esNomina = 0;

    public Timbrado(JTextArea pTextArea, int numSegundos, int empNum, String path, String modo, int esNomina) {
        this.textArea = pTextArea;
        this.intervalo = numSegundos * 1000;
        this.empNum = empNum;
        this.path = path;
        this.modo = modo;
        this.esNomina = esNomina;
        this.start();
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        String UUID = "";
        try {
            bdUtil.setConexion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ComprobantesDAO comprobanteDAO = new ComprobantesDAO("");
        LogcfdDAO logDAO = new LogcfdDAO();
        LogCFD_DTO logCFD_DTO = new LogCFD_DTO();
        ComprobanteDTO comprobanteDTO = new ComprobanteDTO(1);
        CFD cfd = null;
        String mensajeInterfaz = "";
        try {
            this.proc = bdUtil.connection.prepareCall("{ call registraHorasMonitor(?)}");
            this.proc.setInt(1, 1);
        }
        catch (SQLException e) {
            mensajeInterfaz = "Error en registrar el procedimiento" + e.getMessage();
            EscritorInterfaz.escribeEnTextArea(this.textArea, "Error en registrar el procedimiento" + e.getMessage());
            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "ERROR ORA");
        }
        RegistraActivo registraActivo = new RegistraActivo();
        String tipoDoc = "FC";
        if (this.esNomina == 1) {
            tipoDoc = "NM";
        }
        while (this.bandera == 1) {
            try {
                EscritorInterfaz.escribeEnTextArea(this.textArea, "proceso activado " + Fecha.generaFecha());
                System.out.println("Obteniendo CFDIs a Timbrar [" + tipoDoc + "]: " + Fecha.horaEjecucion());
                ArrayList<ComprobanteDTO> lista_Sello = comprobanteDAO.leerSellosNoTimbrados(bdUtil, this.esNomina);
                Iterator<ComprobanteDTO> itera = lista_Sello.iterator();
                while (itera.hasNext()) {
                    UUID = "";
                    comprobanteDTO = itera.next();
                    logDAO.insertaLogError(bdUtil, comprobanteDTO.getComprobante(), "", "", "", "EN PROCESO");
                    mensajeInterfaz = "Timbrando Comprobante: " + comprobanteDTO.getComprobante() + " de tipo " + comprobanteDTO.getSubtipoDoc() + "\n" + "  Con Fecha: " + comprobanteDTO.getFecha() + " y folio: " + comprobanteDTO.getFolio();
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    cfd = new CFD(this.empNum, comprobanteDTO.getComprobante(), this.path, "@", bdUtil, 0, this.modo, comprobanteDTO.getTipoDoc(), 2, 0);
                    System.out.println("cfd = " + cfd.toString());
                    UUID = cfd.generaCFD();
                    logCFD_DTO = logDAO.leerLog(bdUtil, comprobanteDTO.getComprobante());
                    if (logCFD_DTO == null) continue;
                    System.out.println("getStatus= " + logCFD_DTO.getStatus());
                    if (logCFD_DTO.getStatus().equals("ERROR")) {
                        mensajeInterfaz = "Se intento timbrar comprobante: " + logCFD_DTO.getComprobante() + "\n" + "  Codigo Error: " + logCFD_DTO.getCodigoError() + "\n" + "  Error: " + logCFD_DTO.getTextoError() + "\n" + "  Estatus: " + logCFD_DTO.getStatus();
                        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                        continue;
                    }
                    if (logCFD_DTO.getStatus().equals("EN PROCESO")) {
                        mensajeInterfaz = "El comprobante " + comprobanteDTO.getComprobante() + " con folio " + logCFD_DTO.getFolio() + " se quedo en proceso";
                        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                        continue;
                    }
                    mensajeInterfaz = "Se timbro el comprobante " + comprobanteDTO.getComprobante() + " con folio " + logCFD_DTO.getFolio() + " y se obtuvo el UUID:" + UUID;
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                }
                lista_Sello = null;
                itera = null;
                registraActivo.ejecutaProc(bdUtil, this.proc, this.textArea);
                Thread.currentThread();
                Thread.sleep(this.intervalo);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EscritorInterfaz.escribeEnTextArea(this.textArea, "Error en run de RegistrarSellos:" + e.toString());
            }
        }
        EscritorInterfaz.escribeEnTextArea(this.textArea, "PROCESO TERMINADO");
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        EscritorInterfaz.escribeEnTextArea(this.textArea, "Se detendra el proceso en el siguiente ciclo");
    }
}

