/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.LogcfdDAO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.pdf.PDFBuilder;
import siti.sinco.cfdi.tools.CFDUtil;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class CFD {
    private int empNum;
    private int numComprobante;
    private ConfiguracionDTO configuracion;
    private ComprobanteDTO comprobante;
    public String path;
    private String mail;
    public String modo;
    private int preview;
    public String tipoDoc;
    public int envios;
    public int cierraConexion;
    private BDUtil bdUtil;
    public static String certificado;

    public CFD(int empNum, int numComprobante, String path, String mail, BDUtil bdUtil, int cierraConexion, String modo, String tipoDoc, int envios, int preview) {
        this.empNum = empNum;
        this.numComprobante = numComprobante;
        this.path = path;
        this.mail = mail;
        this.bdUtil = bdUtil;
        this.cierraConexion = cierraConexion;
        this.modo = modo;
        this.tipoDoc = tipoDoc;
        this.envios = envios;
        this.preview = preview;
    }

    public static void main(String[] args) throws IOException, DocumentException, GeneralSecurityException {
        System.out.println("empresa=" + args[0] + " comprobante=" + args[8]);
        LeeConexion.path = args[1];
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
            System.out.println("Se establecio conexion");
        }
        catch (Exception e) {
            System.out.println("error=" + e.toString());
        }
        CFD cfd = new CFD(Integer.parseInt(args[0]), Integer.parseInt(args[8]), args[1], args[2], bdUtil, Integer.parseInt(args[3]), args[4], args[5], Integer.parseInt(args[6]), Integer.parseInt(args[7]));
        cfd.generaCFD();
    }

    public String generaCFD() {
        LeeConexion.path = this.path;
        String nombreArchivo = "";
        String vPaso = "";
        String UUID = "";
        this.configuracion = new ConfiguracionDTO();
        this.comprobante = new ComprobanteDTO(this.numComprobante);
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        ComprobantesDAO comprobantesDAO = null;
        configDAO.llenarConfiguracion(this.bdUtil, this.configuracion, this.empNum);
        comprobantesDAO = new ComprobantesDAO(this.configuracion.getRutaSalidaTimbre());
        comprobantesDAO.llenarComprobante(this.bdUtil, this.comprobante);
        vPaso = "01 - llenado de configuraci\u00f3n y comprobante";
        CFDUtil cfdiUtil = new CFDUtil(this.bdUtil, this.comprobante, this.configuracion, this.empNum);
        try {
            vPaso = "02 - Generando el XML";
            cfdiUtil.generaCFD(this.bdUtil, this.modo, this.tipoDoc, this.preview);
            if (this.comprobante.getUUID() != null) {
                vPaso = "03 - Generando el PDF, sin embargo, si se timbr\u00f3.";
                PDFBuilder builder = new PDFBuilder(this.comprobante, this.configuracion, this.tipoDoc, this.modo, this.preview, "NO");
                nombreArchivo = builder.creaPDF(null);
                CfdEmisionDAO vCfdEmision = new CfdEmisionDAO();
                vCfdEmision.actualizarRutaPDF(this.bdUtil, this.comprobante.getUUID(), nombreArchivo, this.tipoDoc);
                this.comprobante.setRutaPDF(nombreArchivo);
                System.out.println("Se comprobar\u00e1 si se el cliente tiene habilitado el envio de correos");
                if (!this.comprobante.getCorreoReceptor().equals("@")) {
                    String vArchivos = "";
                    String vSubmensaje = "";
                    vSubmensaje = this.tipoDoc.equals("NM") ? " el recibo " : " la factura ";
                    String vMensaje = "<h3>" + this.comprobante.getRfcReceptor() + " - " + this.comprobante.getNombreReceptor() + "</h3>" + "<p>Se ha timbrado " + vSubmensaje + " <b>" + this.comprobante.getFolioDoc() + "</b>" + " y ha obtenido el folio fiscal: <br><b>" + this.comprobante.getUUID().toUpperCase() + "</b></br>" + "</p><br>";
                    System.out.println("Se verifica que archivos se enviar\u00e1n, usando el tipo de envio: " + this.envios);
                    if (this.envios != 3) {
                        switch (this.envios) {
                            case 0: {
                                vArchivos = this.comprobante.getRutaPDF();
                                vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF relacionado</p>";
                                break;
                            }
                            case 1: {
                                vArchivos = this.comprobante.getRutaCdfi();
                                vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el CFDI relacionado</p>";
                                break;
                            }
                            case 2: {
                                vArchivos = String.valueOf(this.comprobante.getRutaPDF()) + ";" + this.comprobante.getRutaCdfi();
                                vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF y el CFDI relacionado</p>";
                            }
                        }
                    }
                    System.out.println("Archivos: " + vArchivos);
                    EnvioCorreo correo = new EnvioCorreo(this.bdUtil, this.configuracion);
                    correo.enviarCorreo(this.comprobante.getCorreoReceptor(), "TIMBRADO", vMensaje, vArchivos, this.comprobante.getNombreEmisor());
                    UUID = this.comprobante.getUUID();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error en el paso:" + vPaso + " " + e.toString());
            LogcfdDAO log = new LogcfdDAO();
            log.actualizaLogError(this.bdUtil, this.comprobante.getComprobante(), "002", "Error al generar archivos", e.toString(), "ERROR");
        }
        if (this.cierraConexion == 1) {
            this.bdUtil.cerrarConexion();
        }
        return UUID;
    }

    public int getEnvios() {
        return this.envios;
    }

    public String toString() {
        return String.valueOf(this.empNum) + " " + this.numComprobante + " " + this.path + " " + this.mail + " " + this.cierraConexion + " " + this.modo + " " + this.tipoDoc + " " + this.envios + " " + this.preview;
    }
}

