/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.dao;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import siti.conexion.BDResultados;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dto.CfdEmisionDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;

public class CfdEmisionDAO {
    public String insertaCfdiEmision(BDUtil bdUtil, ComprobanteDTO pComprobante) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        sentencia = "{ call BDPKGCFD.Insertar_CFD_EMISION(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)  }";
        String idfactura = "";
        idfactura = pComprobante.getSubtipoDoc().equals("cob") ? String.valueOf(pComprobante.getSerie()) + pComprobante.getFolioDoc() : String.valueOf(pComprobante.getFolio()) + "-" + pComprobante.getFolioDoc();
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setString(1, idfactura);
            callStatement.setString(2, pComprobante.getSerie());
            callStatement.setString(3, String.valueOf(pComprobante.getFolioDoc()));
            callStatement.setString(4, pComprobante.getRfcEmisor());
            callStatement.setString(5, pComprobante.getNombreEmisor());
            callStatement.setString(6, pComprobante.getRfcReceptor());
            callStatement.setString(7, pComprobante.getNombreReceptor());
            callStatement.setString(8, pComprobante.getTotal().replace(",", ""));
            callStatement.setString(9, pComprobante.getTotalImpuestosTrasladados().replace(",", ""));
            callStatement.setString(10, pComprobante.getSubtotal().replace(",", ""));
            callStatement.setString(11, pComprobante.getFecha());
            callStatement.setString(12, pComprobante.getRutaCdfi());
            callStatement.setString(13, pComprobante.getRutaInterpretado());
            callStatement.setString(14, pComprobante.getRutaOriginal());
            callStatement.setString(15, pComprobante.getTipoDoc());
            callStatement.setString(16, pComprobante.getFechaTimbrado());
            callStatement.setString(17, pComprobante.getVersion());
            callStatement.setString(18, pComprobante.getUUID());
            callStatement.setString(19, null);
            callStatement.setString(20, null);
            callStatement.setString(21, pComprobante.getUsoCFDI());
            callStatement.setString(22, null);
            callStatement.setString(23, pComprobante.getRutaPDF());
            String rutaCfdi = pComprobante.getRutaCdfi();
            String rutaOriginal = pComprobante.getRutaCdfi().replace("CFDI\\CFDi_", "ORIGINAL\\");
            System.out.println("Ruta ORIGINAL: " + rutaOriginal);
            System.out.println("Ruta CFDI: " + rutaCfdi);
            String texto = "";
            try {
                File fOriginal = new File(rutaOriginal);
                BufferedReader brOriginal = new BufferedReader(new FileReader(fOriginal));
                String linea = "";
                texto = "";
                while ((linea = brOriginal.readLine()) != null) {
                    texto = String.valueOf(texto) + linea + "\n";
                }
                System.out.println("Se ley\u00f3 de ORIGINAL: " + texto);
                callStatement.setString(24, texto);
                File fCfdi = new File(rutaCfdi);
                BufferedReader brCfdi = new BufferedReader(new FileReader(fCfdi));
                linea = "";
                texto = "";
                while ((linea = brCfdi.readLine()) != null) {
                    texto = String.valueOf(texto) + linea + "\n";
                }
                System.out.println("Se ley\u00f3 de CFDI: " + texto);
                callStatement.setString(25, texto);
            }
            catch (IOException e) {
                callStatement.setString(24, null);
                callStatement.setString(25, null);
                System.out.println("No se pasaron par\u00e1metros clob");
            }
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto en CFDI_EMISION " + idfactura);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "insertaCfdiEmision", exc.toString(), "ERROR ORA");
            System.out.println("Error en Insertar_CFD_EMISION: " + exc.toString());
        }
        return error;
    }

    public String insertaCfdiEmision2(BDUtil bdUtil, int pComprobante) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        sentencia = "{ call BDPKGCFD.Insertar_CFD_EMISION(? ) } ";
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto en CFDI_EMISION2 " + pComprobante);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "insertaCfdiEmision2", exc.toString(), "ERROR ORA");
            System.out.println("Error en Insertar_CFD_EMISION: " + exc.toString());
        }
        return error;
    }

    public String insertaCfdiEmisionNomina(BDUtil bdUtil, int pComprobante) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        sentencia = "{ call BDPKGCFD.Insertar_CFDI_EMISION_Nomina(? ) } ";
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto en CFDI_EMISION_NOMINA " + pComprobante);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "insertaCfdiEmisionNomina", exc.toString(), "ERROR ORA");
            System.out.println("Error en insertaCfdiEmisionNomina: " + exc.toString());
        }
        return error;
    }

    public String insertaCfdiCustomData(BDUtil bdUtil, ComprobanteDTO pComprobante) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        sentencia = "{ call BDPKGCFD.InsertarCFD_custom_data(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) } ";
        String idfactura = String.valueOf(pComprobante.getFolio()) + "-" + pComprobante.getFolioDoc();
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setString(1, idfactura);
            callStatement.setString(2, "");
            callStatement.setString(3, "");
            callStatement.setString(4, "");
            callStatement.setString(5, "");
            callStatement.setString(6, "");
            callStatement.setString(7, "");
            callStatement.setString(8, "");
            callStatement.setString(9, "");
            callStatement.setString(10, String.valueOf(pComprobante.getFolio()));
            callStatement.setString(11, "");
            callStatement.setString(12, pComprobante.getSubtipoDoc());
            callStatement.setString(13, "");
            callStatement.setString(14, "");
            callStatement.setString(15, pComprobante.getFechaTimbrado());
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto enm CFDI_CUSTOM_DATA " + idfactura);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "insertaCfdiCustomData", exc.toString(), "ERROR ORA");
            System.out.println("Error en Insertar_CFD_CUSTOM_DATA: " + exc.toString());
        }
        return error;
    }

    public String insertaCfdiCustomData2(BDUtil bdUtil, int pComprobante) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        sentencia = "{ call BDPKGCFD.InsertarCFD_custom_data(? ) } ";
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto en InsertarCFD_custom_data2 " + pComprobante);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "InsertarCFD_custom_data2", exc.toString(), "ERROR ORA");
            System.out.println("Error en InsertarCFD_custom_data2: " + exc.toString());
        }
        return error;
    }

    public String insertaCfdiCustomDataNomina(BDUtil bdUtil, int pComprobante) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        sentencia = "{ call BDPKGCFD.InsertarCFDI_custom_data_nom(? ) } ";
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto en CFDI_custom_data_nomina " + pComprobante);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "InsertarCFDI_custom_data_nom", exc.toString(), "ERROR ORA");
            System.out.println("Error en InsertarCFDI_custom_data_nom: " + exc.toString());
        }
        return error;
    }

    public void actualizarRutaPDF(BDUtil pbdUtil, String pUUID, String pRutaPDF, String pTipoDoc) {
        String vSentencia = "";
        vSentencia = pTipoDoc.equals("NM") ? "UPDATE cfdi_emision_nomina SET \trutaPDF = '" + pRutaPDF + "' " + "WHERE \tuuid = '" + pUUID + "' " : "UPDATE cfd_emision SET \trutaPDF = '" + pRutaPDF + "' " + "WHERE \tuuid = '" + pUUID + "' ";
        try {
            pbdUtil.ejecutaSentencia(vSentencia);
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("Error: No se pudo actualizar la ruta del PDF con el UUID - " + pUUID + "\n" + " Raz\u00f3n: " + e.toString());
        }
    }

    public ArrayList<CfdEmisionDTO> getCfdEmisionPDF(BDUtil pbdUtil, String pFechaPDF) {
        ArrayList<CfdEmisionDTO> lista = new ArrayList<CfdEmisionDTO>();
        BDResultados resultados = null;
        String query = "SELECT \tIDFACTURA\t  , SERIE\t\t,\tFOLIO,     \tRFCEMISOR\t  , NOMBREEMISOR,\tRFCRECEPTOR,     \tNOMBRERECEPTOR, ANOAPROB\t,\tNUMAPROB,     \tTOTAL\t\t  , IVA\t\t\t,\tSUBTOTAL,     \tto_char(FECHA_EMISION,'YYYY\\MM\\DD'),\tCANCELADO,RUTACFD,     \tCFD\t\t\t  \t, RUTAINTERPRETADO\t,\tINTERPRETADO,     \tARCHIVOFUENTE\t, FECHA_CANCELACION\t,\tTIPODOCUMENTO,     \tESTADO_PERSONALIZADO,\tESTADO_ENVIO,\tto_char(FECHA_CREACION,'YYYY\\MM\\DD'),     \tVERSION\t\t\t, UUID\t\t\t\t, UUID_RELACIONADO,     \tTIPO_RELACION\t, USO_CFDI\t\t\t,CONFIRMACION_PAC,     \tRUTAPDF FROM\t\tcfd_emision WHERE\tinstr(rutaCfd, '" + pFechaPDF + "', 1,1)  >  0 " + "AND \t\tinstr(rutaCFD, 'E:\\CFDConnect',1,1)>0";
        System.out.println("Query: " + query);
        try {
            resultados = pbdUtil.getResultadosQuery(query);
        }
        catch (Exception e) {
            System.out.println("Error en llenaCfdEmisionPDF" + e.toString());
        }
        int indice = 0;
        String[] renglonCFD_EMISION = new String[resultados.getCuentaColumnas()];
        CfdEmisionDTO vCfdEmisionDTO = null;
        int renglon = 0;
        while (renglon < resultados.getCuentaRenglones()) {
            indice = 0;
            vCfdEmisionDTO = new CfdEmisionDTO();
            renglonCFD_EMISION = resultados.getRenglon(renglon);
            vCfdEmisionDTO.setIDFACTURA(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setSERIE(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFOLIO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRFCEMISOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setNOMBREEMISOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRFCRECEPTOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setNOMBRERECEPTOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setANOAPROB(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setNUMAPROB(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setTOTAL(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setIVA(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setSUBTOTAL(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFECHA_EMISION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setCANCELADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRUTACFD(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setCFD(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRUTAINTERPRETADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setINTERPRETADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setARCHIVOFUENTE(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFECHA_CANCELACION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setTIPODOCUMENTO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setESTADO_PERSONALIZADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setESTADO_ENVIO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFECHA_CREACION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setVERSION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setUUID(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setUUID_RELACIONADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setTIPO_RELACION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setUSO_CFDI(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setCONFIRMACION_PAC(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRUTAPDF(renglonCFD_EMISION[indice++]);
            lista.add(vCfdEmisionDTO);
            ++renglon;
        }
        return lista;
    }

    public ArrayList<CfdEmisionDTO> getListadoCFDEmision(BDUtil pbdUtil, String pFechaCreacion) {
        ArrayList<CfdEmisionDTO> lista = new ArrayList<CfdEmisionDTO>();
        BDResultados resultados = null;
        String query = "SELECT \tIDFACTURA\t  , SERIE\t\t,\tFOLIO,     \tRFCEMISOR\t  , NOMBREEMISOR,\tRFCRECEPTOR,     \tNOMBRERECEPTOR, ANOAPROB\t,\tNUMAPROB,     \tTOTAL\t\t  , IVA\t\t\t,\tSUBTOTAL,     \tto_char(FECHA_EMISION,'YYYY\\MM\\DD'),\tCANCELADO,RUTACFD,     \tCFD\t\t\t  \t, RUTAINTERPRETADO\t,\tINTERPRETADO,     \tARCHIVOFUENTE\t, FECHA_CANCELACION\t,\tTIPODOCUMENTO,     \tESTADO_PERSONALIZADO,\tESTADO_ENVIO,\tto_char(FECHA_CREACION,'YYYY\\MM\\DD'),     \tVERSION\t\t\t, UUID\t\t\t\t, UUID_RELACIONADO,     \tTIPO_RELACION\t, USO_CFDI\t\t\t,CONFIRMACION_PAC,     \tRUTAPDF FROM\t\tcfd_emision WHERE\tto_char(fecha_creacion, 'YYYY') = '" + pFechaCreacion + "' " + "ORDER BY fecha_creacion ";
        try {
            resultados = pbdUtil.getResultadosQuery(query);
        }
        catch (Exception e) {
            System.out.println("Error en getListadoCFDEmision" + e.toString());
        }
        int indice = 0;
        String[] renglonCFD_EMISION = new String[resultados.getCuentaColumnas()];
        CfdEmisionDTO vCfdEmisionDTO = null;
        int renglon = 0;
        while (renglon < resultados.getCuentaRenglones()) {
            indice = 0;
            vCfdEmisionDTO = new CfdEmisionDTO();
            renglonCFD_EMISION = resultados.getRenglon(renglon);
            vCfdEmisionDTO.setIDFACTURA(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setSERIE(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFOLIO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRFCEMISOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setNOMBREEMISOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRFCRECEPTOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setNOMBRERECEPTOR(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setANOAPROB(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setNUMAPROB(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setTOTAL(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setIVA(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setSUBTOTAL(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFECHA_EMISION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setCANCELADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRUTACFD(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setCFD(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRUTAINTERPRETADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setINTERPRETADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setARCHIVOFUENTE(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFECHA_CANCELACION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setTIPODOCUMENTO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setESTADO_PERSONALIZADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setESTADO_ENVIO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setFECHA_CREACION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setVERSION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setUUID(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setUUID_RELACIONADO(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setTIPO_RELACION(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setUSO_CFDI(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setCONFIRMACION_PAC(renglonCFD_EMISION[indice++]);
            vCfdEmisionDTO.setRUTAPDF(renglonCFD_EMISION[indice++]);
            lista.add(vCfdEmisionDTO);
            ++renglon;
        }
        return lista;
    }

    public String insertaDoctoRelacionado(BDUtil bdUtil, String pFolioDoc) {
        CallableStatement callStatement = null;
        String error = "";
        String sentencia = "";
        int vCobro = Integer.valueOf(pFolioDoc.substring(1, 6));
        int vPartida = Integer.valueOf(pFolioDoc.substring(6, 9));
        sentencia = "{ call facturacion.insertaDoctoRelacionado(?, ? ) } ";
        try {
            callStatement = bdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, vCobro);
            callStatement.setInt(2, vPartida);
            callStatement.execute();
            bdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
            System.out.println("Se inserto en CFDConnect.DOCTOS_RELACIONADOS " + pFolioDoc);
        }
        catch (SQLException exc) {
            RegistraLOG.registrarLog(this.getClass().getName(), "insertarDoctoRelacionado", exc.toString(), "ERROR ORA");
            System.out.println("Error en insertarDoctoRelacionado: " + exc.toString());
        }
        return error;
    }

    public ArrayList<CfdEmisionDTO> getCFDISAComprobarEnElSAT(BDUtil bdUtil, String pCancelado, String pFechaInicial, String pFechaFinal) {
        ArrayList<CfdEmisionDTO> vlistaAVerificar;
        block20: {
            BDResultados resultados = null;
            Statement preparedStmt = null;
            vlistaAVerificar = new ArrayList<CfdEmisionDTO>();
            String pWhere = "WHERE to_char(fecha_emision, 'dd/mm/yy') LIKE to_char(sysdate-4, 'dd/mm/yy') || '%' ";
            if (pCancelado != null || pFechaInicial != null) {
                pWhere = "WHERE ";
                if (pCancelado != null) {
                    pWhere = String.valueOf(pWhere) + "cancelado = " + pCancelado + " ";
                }
                if (pFechaInicial != null && pFechaFinal != null) {
                    if (pCancelado != null) {
                        pWhere = String.valueOf(pWhere) + " AND ";
                    }
                    pWhere = String.valueOf(pWhere) + "fecha_emision BETWEEN trunc(to_date('" + pFechaInicial + "')) " + " AND     round(to_date('" + pFechaFinal + "')) ";
                } else if (pFechaInicial != null) {
                    if (pCancelado != null) {
                        pWhere = String.valueOf(pWhere) + " AND ";
                    }
                    pWhere = String.valueOf(pWhere) + "fecha_emision LIKE '" + pFechaInicial + "%'";
                }
            }
            pWhere = String.valueOf(pWhere) + " ORDER BY fecha_emision ASC";
            try {
                try {
                    String query = "SELECT rfcEmisor, rfcReceptor, total, \t\tuuid, idFactura, folio, \t\tto_char(fecha_emision, 'DAY dd/mm/yyyy') fecha  FROM   cfd_emision " + pWhere;
                    System.out.println("query VERIFICARCFDIsSAT:" + query);
                    resultados = bdUtil.getResultadosQuery(query);
                    String[] renglonCFD = new String[resultados.getCuentaColumnas()];
                    CfdEmisionDTO CFDEmisionDTO = null;
                    int indice = 0;
                    int renglon = 0;
                    while (renglon < resultados.getCuentaRenglones()) {
                        renglonCFD = resultados.getRenglon(renglon);
                        CFDEmisionDTO = new CfdEmisionDTO();
                        CFDEmisionDTO.setRFCEMISOR(renglonCFD[indice++]);
                        CFDEmisionDTO.setRFCRECEPTOR(renglonCFD[indice++]);
                        CFDEmisionDTO.setTOTAL(renglonCFD[indice++]);
                        CFDEmisionDTO.setUUID(renglonCFD[indice++]);
                        CFDEmisionDTO.setIDFACTURA(renglonCFD[indice++]);
                        CFDEmisionDTO.setFOLIO(renglonCFD[indice++]);
                        CFDEmisionDTO.setFECHA_EMISION(renglonCFD[indice++]);
                        vlistaAVerificar.add(CFDEmisionDTO);
                        indice = 0;
                        ++renglon;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error en leerComprobantesCancelar: " + e.toString());
                    if (preparedStmt == null) break block20;
                    try {
                        preparedStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (preparedStmt != null) {
                    try {
                        preparedStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return vlistaAVerificar;
    }

    public static ArrayList<CfdEmisionDTO> getCFDISAReenviarArchivos(BDUtil bdUtil, String pFolio, String pSerie) {
        ArrayList<CfdEmisionDTO> vlistaAVerificar;
        block13: {
            BDResultados resultados = null;
            Statement preparedStmt = null;
            vlistaAVerificar = new ArrayList<CfdEmisionDTO>();
            try {
                try {
                    String query = "SELECT cfde.NombreEmisor, cfde.rfcReceptor, nombreReceptor,  cfde.folio, cfde.serie, cfde.uuid,  cfde.rutaPDF, cfde.rutaCFD,  cl.correo FROM   cfd_emision cfde, clientes_datosFiscales cl WHERE cl.cliente = cfde.cliente AND  cfde.folio = '" + pFolio + "' " + "AND \tcfde.serie = '" + pSerie + "' ";
                    resultados = bdUtil.getResultadosQuery(query);
                    String[] renglonCFD = new String[resultados.getCuentaColumnas()];
                    CfdEmisionDTO CFDEmisionDTO = null;
                    int indice = 0;
                    int renglon = 0;
                    while (renglon < resultados.getCuentaRenglones()) {
                        renglonCFD = resultados.getRenglon(renglon);
                        CFDEmisionDTO = new CfdEmisionDTO();
                        CFDEmisionDTO.setNOMBREEMISOR(renglonCFD[indice++]);
                        CFDEmisionDTO.setRFCRECEPTOR(renglonCFD[indice++]);
                        CFDEmisionDTO.setNOMBRERECEPTOR(renglonCFD[indice++]);
                        CFDEmisionDTO.setFOLIO(renglonCFD[indice++]);
                        CFDEmisionDTO.setSERIE(renglonCFD[indice++]);
                        CFDEmisionDTO.setUUID(renglonCFD[indice++]);
                        CFDEmisionDTO.setRUTAPDF(renglonCFD[indice++]);
                        CFDEmisionDTO.setRUTAPDF(renglonCFD[indice++]);
                        CFDEmisionDTO.setCorreoReceptor(renglonCFD[indice++]);
                        vlistaAVerificar.add(CFDEmisionDTO);
                        indice = 0;
                        ++renglon;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error en leerComprobantesCancelar: " + e.toString());
                    if (preparedStmt == null) break block13;
                    try {
                        preparedStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                if (preparedStmt != null) {
                    try {
                        preparedStmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return vlistaAVerificar;
    }
}

