/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.lowagie.text.ExceptionConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dto.CfdConceptosDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.dto.MetadatosAprovechamientoDTO;
import siti.sinco.cfdi.dto.MetadatosAtraqueDTO;
import siti.sinco.cfdi.dto.MetadatosCesDTO;
import siti.sinco.cfdi.dto.MetadatosManiobrasDTO;
import siti.sinco.cfdi.dto.MetadatosMuellajeDTO;
import siti.sinco.cfdi.dto.MetadatosNCRDTO;
import siti.sinco.cfdi.dto.MetadatosPedimentoDTO;
import siti.sinco.cfdi.dto.MetadatosPuertoDTO;
import siti.sinco.cfdi.pdf.CeldasPDF;
import siti.sinco.cfdi.tools.CodigoQR;
import siti.sinco.cfdi.tools.Conversiones;
import siti.sinco.cfdi.tools.Utilerias;

public class CFDenPDFSitiFact
extends PdfPageEventHelper {
    protected PdfTemplate total;
    protected BaseFont helv;
    private ComprobanteDTO comprobante;
    private ConfiguracionDTO configuracion;
    private final int ACTIVA = 1;
    private final int CANCELADA = 0;
    private String nombrePDF;
    private String ruta;
    private String nombreCompleto;
    private MetadatosCesDTO dtoces;
    private MetadatosAprovechamientoDTO dtoAprovechamiento;
    private MetadatosPuertoDTO dtoPuerto;
    private MetadatosManiobrasDTO dtoManiobra;
    private MetadatosAtraqueDTO dtoAtraque;
    private MetadatosMuellajeDTO dtoMuellaje;
    private MetadatosPedimentoDTO dtoped;
    private MetadatosNCRDTO dtoncr;
    private static double IVA = 0.16;
    private String leyenda = "ESTE DOCUMENTO ES UNA REPRESENTACI\u00d3N IMPRESA DE UN CFDI";
    private String leyendaTest = "ESTE DOCUMENTO NO TIENE VALIDEZ FISCAL, ES UNA PRUEBA";

    public CFDenPDFSitiFact(ComprobanteDTO objComprobante, ConfiguracionDTO objConfiguracion) {
        this.comprobante = objComprobante;
        this.configuracion = objConfiguracion;
        System.out.println("SubtipoDoc Vale: " + this.comprobante.getSubtipoDoc());
        switch (this.comprobante.getSubtipoDoc()) {
            case "pto": {
                this.dtoPuerto = this.comprobante.getmetadatoPto();
                break;
            }
            case "apr": {
                this.dtoAprovechamiento = this.comprobante.getmetadatoApr();
                break;
            }
            case "atr": {
                this.dtoAtraque = this.comprobante.getmetadatoAtr();
                break;
            }
            case "ces": {
                this.dtoces = this.comprobante.getmetadatoCes();
                break;
            }
            case "man": {
                this.dtoManiobra = this.comprobante.getmetadatoMan();
                break;
            }
            case "mue": {
                this.dtoMuellaje = this.comprobante.getmetadatoMue();
                break;
            }
            case "ped": {
                this.dtoped = this.comprobante.getmetadatoPed();
                break;
            }
            case "ncr": {
                System.out.println("Fue nota de cr\u00e9dito: ");
                this.dtoncr = this.comprobante.getmetadosNcr();
                System.out.println("Valor Forma Pago: " + this.dtoncr.getFormaPago());
            }
        }
    }

    public CFDenPDFSitiFact() {
    }

    public String generarPDF(String modo, String sobreEscribe, String pRutaPDF) throws IOException, DocumentException {
        Document document = new Document(PageSize.A4, 10.0f, 10.0f, 10.0f, 10.0f);
        String ruta_archivo = "";
        String nombreArchivo = "";
        this.ruta = "";
        if (pRutaPDF == null) {
            nombreArchivo = ComprobantesDAO.creaNombreArchivo(this.comprobante.getComprobante());
            this.nombrePDF = "CFDi_" + nombreArchivo;
            this.ruta = String.valueOf(Utilerias.getRutaBase(this.comprobante, this.configuracion, 3)) + File.separator + "PDF";
            ruta_archivo = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".pdf";
        } else {
            String[] vRuta = pRutaPDF.replace("\\", "/").split("/");
            int i = 0;
            while (i < vRuta.length - 2) {
                ruta_archivo = i == 0 ? vRuta[i] : String.valueOf(ruta_archivo) + "\\" + vRuta[i];
                ++i;
            }
            this.ruta = String.valueOf(ruta_archivo) + "\\" + "PDF";
            nombreArchivo = vRuta[vRuta.length - 1].split("\\.")[0].replace("INT", "CFDi");
            ruta_archivo = String.valueOf(this.ruta) + "\\" + nombreArchivo + ".pdf";
            this.nombrePDF = nombreArchivo;
        }
        System.out.println(nombreArchivo);
        File rutaPDF = new File(this.ruta);
        File fichero = new File(ruta_archivo);
        System.out.println("ruta: " + ruta_archivo);
        if (!rutaPDF.exists()) {
            System.out.println("Se ha creado la ruta: " + this.ruta);
            rutaPDF.mkdirs();
        }
        if (fichero.exists()) {
            if (sobreEscribe.equals("SI")) {
                System.out.println("El archivo se va a sobreescribir.");
                FileUtils.forceDelete((File)fichero);
            } else {
                System.out.println("El archivo ya ha sido creado con anterioridad.");
            }
        }
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(ruta_archivo));
        writer.setPageEvent((PdfPageEvent)new CFDenPDFSitiFact());
        Rectangle rct = new Rectangle(0.0f, 0.0f, 520.0f, 750.0f);
        writer.setBoxSize("art", rct);
        Paragraph lineaVacia = new Paragraph(" ", new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
        if (modo.equals("TEST")) {
            this.leyenda = this.leyendaTest;
        }
        Paragraph leyendaDigital = new Paragraph(this.leyenda, new Font(Font.FontFamily.TIMES_ROMAN, 7.0f, 1));
        leyendaDigital.setAlignment(1);
        document.open();
        document.add((Element)lineaVacia);
        System.out.println("tablaDatosGenerales1");
        document.add((Element)this.tablaDatosGenerales1());
        document.add((Element)lineaVacia);
        System.out.println("tablaDatosGenerales2");
        document.add((Element)this.tablaDatosGenerales2());
        document.add((Element)lineaVacia);
        System.out.println("tablaDetalle");
        document.add((Element)this.tablaDetalle());
        System.out.println("tablasTotalesYRegimen");
        document.add((Element)this.tablasTotalesYRegimen());
        System.out.println("Despues tablasTotalesYRegimen");
        document.add((Element)lineaVacia);
        if (this.comprobante.getLeyendaPago() != null) {
            System.out.println("tablaLeyendapago");
            document.add((Element)this.tablaLeyendapago());
        }
        document.add((Element)lineaVacia);
        document.add((Element)this.tablaDatosExtra());
        document.add((Element)lineaVacia);
        document.add((Element)this.tablaDatosDigitales());
        if (this.comprobante.getStatus() == 0) {
            document.add((Element)this.tablaDatosDigitalesCanc());
        }
        document.add((Element)leyendaDigital);
        document.close();
        File rutaImagenQR = new File(this.nombreCompleto);
        if (rutaImagenQR.exists()) {
            FileUtils.forceDelete((File)rutaImagenQR);
        }
        return ruta_archivo;
    }

    public PdfPTable tablaDatosGenerales1() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaDatos = new PdfPTable(4);
        tablaDatos.setWidthPercentage(100.0f);
        tablaDatos.getDefaultCell().setBorder(0);
        System.out.println("tablaDatosGenerales1-2");
        CeldasPDF.celdaVacia(tablaDatos, 4);
        System.out.println("tablaDatosGenerales1-3");
        PdfPTable tablaTitulo = this.tablaTitulo();
        System.out.println("tablaDatosGenerales1-3a");
        PdfPTable tablaEmisor = this.tablaEmisor();
        System.out.println("tablaDatosGenerales1-4");
        PdfPCell celda = new PdfPCell(tablaTitulo);
        System.out.println("Poniendo borde");
        celda.setBorder(0);
        System.out.println("Poniendo colspan");
        celda.setColspan(4);
        System.out.println("Agregando celda");
        tablaDatos.addCell(celda);
        System.out.println("tablaDatosGenerales1-5");
        celda = new PdfPCell(tablaEmisor);
        celda.setBorder(0);
        celda.setColspan(4);
        tablaDatos.addCell(celda);
        System.out.println("tablaDatosGenerales1-6");
        return tablaDatos;
    }

    public PdfPTable tablaDatosGenerales2() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaDatos = new PdfPTable(4);
        tablaDatos.setWidthPercentage(100.0f);
        tablaDatos.getDefaultCell().setBorder(0);
        PdfPTable tablaExtra = new PdfPTable(10);
        tablaExtra.setWidthPercentage(100.0f);
        tablaExtra.getDefaultCell().setBorder(0);
        PdfPTable tablaReceptor = this.tablaReceptor();
        PdfPCell celda = new PdfPCell(tablaReceptor);
        celda.setBorder(0);
        celda.setColspan(3);
        tablaDatos.addCell(celda);
        System.out.println("tablaDatosGenerales2 Factura");
        PdfPTable tablaDatosFactura = this.tablaDatosFactura();
        celda = new PdfPCell();
        celda.setBorder(0);
        celda.setColspan(1);
        tablaExtra.addCell(celda);
        celda = new PdfPCell(tablaDatosFactura);
        celda.setBorder(0);
        celda.setColspan(9);
        tablaExtra.addCell(celda);
        celda = new PdfPCell(tablaExtra);
        celda.setBorder(0);
        celda.setColspan(10);
        tablaDatos.addCell(celda);
        return tablaDatos;
    }

    public PdfPTable tablaTitulo() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaTitulo = new PdfPTable(1);
        tablaTitulo.setWidthPercentage(100.0f);
        tablaTitulo.getDefaultCell().setBorder(0);
        if (this.comprobante.getStatus() == 1) {
            CeldasPDF.celdaTabla(tablaTitulo, this.comprobante.getNombreEmisor(), 1, 0, 0.0f, CeldasPDF.fontHeaderDoc, 1);
        } else if (this.comprobante.getStatus() == 0) {
            CeldasPDF.celdaTabla(tablaTitulo, String.valueOf(this.comprobante.getNombreEmisor()) + "\nFACTURA CANCELADA", 1, 0, 0.0f, CeldasPDF.fontHeaderDoc, 1);
        }
        return tablaTitulo;
    }

    public PdfPTable tablaEmisor() throws BadElementException, MalformedURLException, IOException {
        System.out.println("inicio tablaEmisor()");
        PdfPTable tablaEmisor = new PdfPTable(8);
        tablaEmisor.setWidthPercentage(100.0f);
        tablaEmisor.getDefaultCell().setBorder(0);
        Locale.setDefault(new Locale("es", "MX"));
        Image imagen = null;
        String nombrelogo = new String("/logo_asipona.jpg");
        if (this.comprobante.getNombreEmisor().toUpperCase().contains("INTEGRAL")) {
            nombrelogo = "/logo_api.jpg";
        }
        imagen = Image.getInstance((String)(String.valueOf(LeeConexion.path) + "/recursos/" + nombrelogo));
        imagen.scalePercent(45.0f);
        imagen.setAlignment(0);
        PdfPCell celda = new PdfPCell(imagen);
        celda.setColspan(2);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaEmisor.addCell(celda);
        String noExt = "";
        String noInt = "";
        String calle = "";
        String municipio = "";
        String estado = "";
        String pais = "";
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorEmisor(), "S/N");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorEmisor(), " ");
        calle = Utilerias.nvl(this.comprobante.getCalleEmisor(), " ");
        municipio = Utilerias.nvl(this.comprobante.getMunicipioEmisor(), " ");
        estado = Utilerias.nvl(this.comprobante.getEstadoEmisor(), " ");
        pais = Utilerias.nvl(this.comprobante.getPaisEmisor(), " ");
        System.out.println("Ruta logo: " + LeeConexion.path + "\\recursos\\" + this.comprobante.getEmpNum());
        Paragraph parrafDomicEmisor = new Paragraph("\nRFC: " + this.comprobante.getRfcEmisor(), CeldasPDF.fontContentBig);
        parrafDomicEmisor.add("\n" + calle + " " + noExt + " " + noInt);
        parrafDomicEmisor.add("\n" + municipio + ", " + estado + ", " + pais + ", " + this.comprobante.getCodigoPostalEmisor());
        parrafDomicEmisor.add("\nTEL: " + this.configuracion.getTelefonoEmisor());
        parrafDomicEmisor.add("\n" + this.configuracion.getEmailEmisor());
        parrafDomicEmisor.add("\n" + this.configuracion.getPagWebEmisor());
        parrafDomicEmisor.setAlignment(0);
        PdfPCell celda_emisor = new PdfPCell();
        celda_emisor.addElement((Element)parrafDomicEmisor);
        celda_emisor.setColspan(3);
        celda_emisor.setBorder(0);
        celda_emisor.setHorizontalAlignment(0);
        tablaEmisor.addCell(celda_emisor);
        System.out.println("A3");
        PdfPTable tablaBanco = this.tablaBancoEmisor();
        System.out.println("Linea 434");
        celda = new PdfPCell(tablaBanco);
        celda.setColspan(3);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaEmisor.addCell(celda);
        System.out.println("Fin tablaEmisor()");
        return tablaEmisor;
    }

    public PdfPTable tablaBancoEmisor() throws BadElementException, MalformedURLException, IOException {
        System.out.println("Inicio TablaBancoEmisor");
        PdfPTable tablaBanco = new PdfPTable(1);
        tablaBanco.setWidthPercentage(100.0f);
        tablaBanco.getDefaultCell().setBorder(0);
        PdfPTable aux = new PdfPTable(1);
        aux.setWidthPercentage(100.0f);
        aux.getDefaultCell().setBorder(0);
        PdfPTable aux2 = new PdfPTable(4);
        aux2.setWidthPercentage(100.0f);
        aux2.getDefaultCell().setBorder(0);
        String referenciaBancaria = new String("");
        switch (this.comprobante.getSubtipoDoc()) {
            case "pto": {
                referenciaBancaria = this.dtoPuerto.getReferenciaBancaria();
                break;
            }
            case "apr": {
                referenciaBancaria = this.dtoAprovechamiento.getReferenciaBancaria();
                break;
            }
            case "atr": {
                referenciaBancaria = this.dtoAtraque.getReferenciaBancaria();
                break;
            }
            case "ces": {
                System.out.println("getReferenciaBancaria: " + this.dtoces.getReferenciaBancaria());
                referenciaBancaria = this.dtoces.getReferenciaBancaria();
                break;
            }
            case "man": {
                referenciaBancaria = this.dtoManiobra.getReferenciaBancaria();
                break;
            }
            case "mue": {
                referenciaBancaria = this.dtoMuellaje.getReferenciaBancaria();
                break;
            }
            case "ped": {
                referenciaBancaria = this.dtoped.getReferenciaBancaria();
            }
        }
        System.out.println("BANCO:SANTANDER");
        CeldasPDF.celdaTabla(aux, "Banco: SANTANDER", 1, 0, 5.0f, CeldasPDF.fontHeaderDoc, 1);
        CeldasPDF.celdaVacia(aux, 1);
        System.out.println("CUENTA:");
        CeldasPDF.celdaTabla(aux2, "CUENTA: ", 1, 0, 2.0f, CeldasPDF.fontContentMidBold, 0);
        System.out.println("getCuenta()");
        CeldasPDF.celdaTabla(aux2, this.configuracion.getCuenta(), 3, 0, 2.0f, CeldasPDF.fontContentMid, 0);
        System.out.println("CLABE:");
        CeldasPDF.celdaTabla(aux2, "CLABE: ", 1, 0, 2.0f, CeldasPDF.fontContentMidBold, 0);
        System.out.println("getClabe");
        CeldasPDF.celdaTabla(aux2, this.configuracion.getClabe(), 3, 0, 2.0f, CeldasPDF.fontContentMid, 0);
        System.out.println("REFERENCIA:");
        CeldasPDF.celdaTabla(aux2, "REFERENCIA: ", 1, 0, 2.0f, CeldasPDF.fontContentMidBold, 0);
        System.out.println("referenciaBancaria");
        CeldasPDF.celdaTabla(aux2, referenciaBancaria, 3, 0, 2.0f, CeldasPDF.fontContentMidRojo, 0);
        System.out.println("PDFCEL(aux2)");
        PdfPCell celda = new PdfPCell(aux2);
        celda.setColspan(1);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        aux.addCell(celda);
        CeldasPDF.celdaVacia(tablaBanco, 1);
        System.out.println("PdfCell(aux)");
        celda = new PdfPCell(aux);
        celda.setColspan(1);
        celda.setBorderWidth(1.2f);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setHorizontalAlignment(1);
        tablaBanco.addCell(celda);
        System.out.println("FIN TablaBancoEmisor");
        return tablaBanco;
    }

    public PdfPTable tablaReceptor() {
        PdfPTable tablaReceptor = new PdfPTable(1);
        tablaReceptor.setWidthPercentage(100.0f);
        PdfPTable aux = new PdfPTable(20);
        aux.setWidthPercentage(100.0f);
        aux.getDefaultCell().setBorder(0);
        PdfPTable aux1 = new PdfPTable(1);
        aux1.setWidthPercentage(100.0f);
        aux1.getDefaultCell().setBorder(0);
        PdfPTable aux2 = new PdfPTable(1);
        aux2.setWidthPercentage(100.0f);
        aux2.getDefaultCell().setBorder(0);
        System.out.println("LLego a Tabla Receptor");
        String calle = "";
        String noExt = "";
        String noInt = "";
        String colonia = "";
        String cp = "";
        String municipio = "";
        String localidad = "";
        String estado = "";
        String pais = "";
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorReceptor(), " ");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorReceptor(), " ");
        calle = Utilerias.nvl(this.comprobante.getCalleReceptor(), " ");
        colonia = Utilerias.nvl(this.comprobante.getColoniaReceptor(), " ");
        localidad = Utilerias.nvl(this.comprobante.getLocalidadReceptor(), " ");
        municipio = Utilerias.nvl(this.comprobante.getMunicipioReceptor(), " ");
        if (!municipio.equals(" ")) {
            municipio = ", " + municipio;
        }
        estado = Utilerias.nvl(this.comprobante.getEstadoReceptor(), " ");
        pais = Utilerias.nvl(this.comprobante.getPaisReceptor(), " ");
        cp = Utilerias.nvl(this.comprobante.getCodigoPostalReceptor(), " ");
        System.out.println("Antes del Switch UsoCFDI");
        String usoCFDIDescr = new String("");
        switch (this.comprobante.getSubtipoDoc()) {
            case "pto": {
                usoCFDIDescr = this.dtoPuerto.getUsoCFDI();
                break;
            }
            case "apr": {
                usoCFDIDescr = this.dtoAprovechamiento.getUsoCFDI();
                break;
            }
            case "atr": {
                usoCFDIDescr = this.dtoAtraque.getUsoCFDI();
                break;
            }
            case "ces": {
                usoCFDIDescr = this.dtoces.getUsoCFDI();
                break;
            }
            case "man": {
                usoCFDIDescr = this.dtoManiobra.getUsoCFDI();
                break;
            }
            case "mue": {
                usoCFDIDescr = this.dtoMuellaje.getUsoCFDI();
                break;
            }
            case "ped": {
                usoCFDIDescr = this.dtoped.getUsoCFDI();
                break;
            }
            case "ncr": {
                System.out.println("Sacando el GETUSOCFDI: " + this.dtoncr.getUsoCFDI());
                usoCFDIDescr = this.dtoncr.getUsoCFDI();
            }
        }
        System.out.println("Antes de Datos del Cliente");
        CeldasPDF.celdaTabla(aux1, "CLIENTE", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(aux2, ": " + this.comprobante.getNombreReceptor(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        if (this.comprobante.getVersion().equals("4.0")) {
            CeldasPDF.celdaTabla(aux1, "REG. FISCAL", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
            CeldasPDF.celdaTabla(aux2, ": " + this.comprobante.getRegimenReceptor(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        } else {
            CeldasPDF.celdaTabla(aux1, " ", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
            CeldasPDF.celdaTabla(aux2, " ", 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        }
        CeldasPDF.celdaTabla(aux1, "RFC", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(aux2, ": " + this.comprobante.getRfcReceptor(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        CeldasPDF.celdaTabla(aux1, "DIRECCION", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(aux2, ": " + calle + " " + noExt + " " + noInt, 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        CeldasPDF.celdaTabla(aux1, "COLONIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(aux2, ": " + colonia + "     CP:" + cp, 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        CeldasPDF.celdaTabla(aux1, "CIUDAD", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(aux2, ": " + localidad + municipio + ", " + estado, 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        CeldasPDF.celdaTabla(aux1, "PAIS", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(aux2, ": " + pais, 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        switch (this.comprobante.getSubtipoDoc()) {
            case "pto": {
                CeldasPDF.celdaTabla(aux1, "AGENCIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, ": " + this.dtoPuerto.getClaveNaviera() + " " + this.dtoPuerto.getAgenteNaviero(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "apr": {
                CeldasPDF.celdaTabla(aux1, "AGENCIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, ": ", 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "atr": {
                CeldasPDF.celdaTabla(aux1, "AGENCIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, ": " + this.dtoAtraque.getClaveNaviera() + " " + this.dtoAtraque.getAgenteNaviero(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "ces": {
                CeldasPDF.celdaTabla(aux1, " ", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, " ", 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "man": {
                CeldasPDF.celdaTabla(aux1, "AGENCIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, ": " + this.dtoManiobra.getClaveNaviera() + " " + this.dtoManiobra.getAgenteNaviero(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "mue": {
                CeldasPDF.celdaTabla(aux1, "AGENCIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, ": " + this.dtoMuellaje.getClaveNaviera() + " " + this.dtoMuellaje.getAgenteNaviero(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "ped": {
                CeldasPDF.celdaTabla(aux1, "AGENCIA", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
                CeldasPDF.celdaTabla(aux2, ": " + this.dtoped.getClaveAgenteAduanal() + " " + this.dtoped.getAgenteAduanal(), 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
            }
        }
        System.out.println("Antes de uso CFDI");
        if (usoCFDIDescr != null) {
            CeldasPDF.celdaTabla(aux1, "USO CFDI", 1, 0, 14.0f, CeldasPDF.fontContentBig, 0);
            CeldasPDF.celdaTabla(aux2, ": " + usoCFDIDescr, 1, 0, 14.0f, CeldasPDF.fontDatos, 0);
        }
        PdfPCell celda = new PdfPCell(aux1);
        celda.setColspan(3);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        aux.addCell(celda);
        celda = new PdfPCell(aux2);
        celda.setColspan(17);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        aux.addCell(celda);
        celda = new PdfPCell(aux);
        celda.setColspan(1);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.2f);
        celda.setHorizontalAlignment(1);
        tablaReceptor.addCell(celda);
        return tablaReceptor;
    }

    public PdfPTable tablaDatosFactura() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaDerecha = new PdfPTable(2);
        tablaDerecha.setWidthPercentage(85.0f);
        tablaDerecha.getDefaultCell().setBorder(0);
        String hrs = this.comprobante.getFecha().toString().substring(11, 19);
        String str = this.comprobante.getFecha().toString().substring(0, 10);
        String a\u00f1o = str.substring(0, 4);
        String mes = str.substring(5, 7);
        String dia = str.substring(8, 10);
        String municipio = Utilerias.nvl(this.comprobante.getMunicipioEmisor(), " ");
        String estado = Utilerias.nvl(this.comprobante.getEstadoEmisor(), " ");
        String fechaFinal = String.valueOf(a\u00f1o) + "-" + mes + "-" + dia + "T" + hrs;
        String folioFact = "FOLIO FACTURA";
        if (this.comprobante.getSubtipoDoc().equals("ncr")) {
            folioFact = "FOLIO NOTA";
        }
        String tipoDeComprobante = "INGRESO";
        if (this.comprobante.getTipodecomprobante().equals("E")) {
            tipoDeComprobante = "EGRESO";
        }
        CeldasPDF.celdaTabla(tablaDerecha, tipoDeComprobante, 2, 0, 2.0f, CeldasPDF.fontContentMidBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, folioFact, 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaDerecha, String.valueOf(this.comprobante.getFolioDoc()), 2, 0, 2.0f, CeldasPDF.fontContentMid, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "FOLIO FISCAL", 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getUUID(), 2, 0, 20.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "FECHA EXPEDICI\u00d3N", 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaDerecha, fechaFinal, 2, 0, 2.0f, CeldasPDF.fontContentMid, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "LUGAR EXPEDICI\u00d3N", 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaDerecha, String.valueOf(municipio) + ", " + estado, 2, 0, 2.0f, CeldasPDF.fontContentMid, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "NO. CERTIFICADO EMISOR", 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaDerecha, this.configuracion.getNoCertificado(), 2, 0, 2.0f, CeldasPDF.fontContentMid, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "FOLIO INTERNO " + this.comprobante.getFolio(), 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        return tablaDerecha;
    }

    public PdfPTable tablaDetalle() {
        PdfPTable tablaDetalle = new PdfPTable(11);
        tablaDetalle.setWidthPercentage(100.0f);
        PdfPTable tablaTitulo = this.tablaEncabezadoDetalle();
        PdfPCell celda = new PdfPCell(tablaTitulo);
        celda.setBorder(0);
        celda.setColspan(11);
        tablaDetalle.addCell(celda);
        PdfPTable detalles = this.tablaDetallesPedido();
        celda = new PdfPCell(detalles);
        celda.setMinimumHeight(220.0f);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.2f);
        celda.setColspan(11);
        tablaDetalle.addCell(celda);
        return tablaDetalle;
    }

    public PdfPTable tablaEncabezadoDetalle() {
        PdfPTable tablaEncabezado = new PdfPTable(11);
        tablaEncabezado.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaEncabezado, "CANTIDAD/UNIDAD", 2, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "DESCRIPCION DEL SERVICIO", 6, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "PRECIO", 1, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "IVA", 1, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "IMPORTE", 1, 2, 2.0f, CeldasPDF.fontHeader, 1);
        return tablaEncabezado;
    }

    public PdfPTable tablaDetallesPedido() {
        PdfPTable tblCantUni = new PdfPTable(2);
        tblCantUni.setWidthPercentage(100.0f);
        PdfPTable tblServicio = new PdfPTable(1);
        tblServicio.setWidthPercentage(100.0f);
        PdfPTable tblPrecio = new PdfPTable(1);
        tblPrecio.setWidthPercentage(100.0f);
        PdfPTable tblIva = new PdfPTable(1);
        tblIva.setWidthPercentage(100.0f);
        PdfPTable tblImporte = new PdfPTable(1);
        tblImporte.setWidthPercentage(100.0f);
        int renglon = 0;
        while (renglon < this.comprobante.conceptos.size()) {
            CfdConceptosDTO concepto = this.comprobante.conceptos.elementAt(renglon);
            String unidad = "";
            String iva = "";
            String precio = "";
            String importe = "";
            unidad = Utilerias.nvl(concepto.getUnidad(), "-");
            Double ivad = new Double(concepto.getImporte()) * IVA;
            iva = Utilerias.nvl(concepto.getImporteTrasladado().replace(",", ""), String.format("%.2f", ivad));
            Double preciod = new Double(concepto.getValorUnitario());
            precio = String.format("%,.2f", preciod);
            Double imported = new Double(concepto.getImporte());
            importe = String.format("%,.2f", imported);
            ivad = new Double(iva);
            iva = String.format("%,.2f", ivad);
            System.out.println("1");
            CeldasPDF.celdaTabla(tblCantUni, concepto.getCantidad().toString(), 1, 0, 2.0f, CeldasPDF.fontDatos, 2);
            CeldasPDF.celdaTabla(tblCantUni, unidad, 1, 0, 2.0f, CeldasPDF.fontDatos, 1);
            CeldasPDF.celdaTabla(tblCantUni, "\n ", 1, 0, 2.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tblCantUni, "\n ", 1, 0, 2.0f, CeldasPDF.fontDatos, 0);
            Paragraph claveunidadSat = new Paragraph();
            claveunidadSat.setFont(CeldasPDF.fontDatos);
            claveunidadSat.add((Element)new Chunk(" Clave Unidad SAT:", CeldasPDF.fontDataBold));
            claveunidadSat.add((Element)new Chunk(concepto.getClaveSatUnidades(), CeldasPDF.fontDatos));
            claveunidadSat.add((Element)new Chunk(" Clave Producto SAT: ", CeldasPDF.fontDataBold));
            claveunidadSat.add((Element)new Chunk(concepto.getClaveSatProdServ(), CeldasPDF.fontDatos));
            CeldasPDF.celdaTabla(tblServicio, claveunidadSat, 2, 0, 2.0f, 0);
            CeldasPDF.celdaTabla(tblServicio, concepto.getDescripcion(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tblServicio, "\n", 1, 0, 2.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tblPrecio, precio, 1, 0, 2.0f, CeldasPDF.fontDatos, 2);
            CeldasPDF.celdaTabla(tblPrecio, "\n ", 1, 0, 2.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tblIva, iva, 1, 0, 2.0f, CeldasPDF.fontDatos, 2);
            CeldasPDF.celdaTabla(tblIva, "\n ", 1, 0, 2.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tblImporte, importe, 2, 0, 2.0f, CeldasPDF.fontDatos, 2);
            CeldasPDF.celdaTabla(tblImporte, "\n ", 1, 0, 2.0f, CeldasPDF.fontDatos, 0);
            ++renglon;
        }
        switch (this.comprobante.getSubtipoDoc()) {
            case "pto": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoPuerto.getObservaciones(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, String.valueOf(this.dtoPuerto.getTRB()) + "         " + this.dtoPuerto.getBuque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoPuerto.getFecha_Zarpe(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Bandera: " + this.dtoPuerto.getBandera(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, String.valueOf(this.dtoPuerto.getFecha_Arribo()) + "         " + this.dtoPuerto.getIdBuque_Factura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "apr": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoAprovechamiento.getObservaciones(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoAprovechamiento.getFactura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "atr": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoAtraque.getObservaciones(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Estadia" + this.dtoAtraque.getEstadia() + "          " + this.dtoAtraque.getBuque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Mal Tpo" + this.dtoAtraque.getMaltpo() + "     " + this.dtoAtraque.getEslora_atraque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Bandera:  " + this.dtoAtraque.geBandera() + "     " + this.dtoAtraque.getIdbuque_fact(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoAtraque.getTrb_desatraque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "ces": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoces.getContrato(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoces.getObservaciones(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoces.getConcesion_factura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "man": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoManiobra.getObservaciones(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoManiobra.getBuque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "ID VIAJE: " + this.dtoManiobra.getViaje(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, String.valueOf(this.dtoManiobra.getEslora()) + "   " + this.dtoManiobra.getTRB() + "      " + this.dtoManiobra.getSolicitud() + "      " + this.dtoManiobra.getFactura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Bandera: " + this.dtoManiobra.getBandera(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "mue": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoMuellaje.getDetfactura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Buque: " + this.dtoMuellaje.getIdbuque() + "    " + this.dtoMuellaje.getBuque() + "  " + this.dtoMuellaje.getIdbuquefactura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoMuellaje.getFechaAtraque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, String.valueOf(this.dtoMuellaje.getCantidad()) + "  Clase: " + this.dtoMuellaje.getClase(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoMuellaje.getConocimiento(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoMuellaje.getPeso(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoMuellaje.getMarca(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                break;
            }
            case "ped": {
                CeldasPDF.celdaTabla(tblServicio, this.dtoped.getDetFactura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoped.getPedimentos(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "Buque: " + this.dtoped.getBuque(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "\n", 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, this.dtoped.getFactura(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
                CeldasPDF.celdaTabla(tblServicio, "ID Viaje: " + this.dtoped.getViaje(), 5, 0, 2.0f, CeldasPDF.fontDatos, 0);
            }
        }
        PdfPTable detalles = new PdfPTable(11);
        PdfPCell celda = new PdfPCell(tblCantUni);
        celda.setColspan(2);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setHorizontalAlignment(1);
        detalles.addCell(celda);
        celda = new PdfPCell(tblServicio);
        celda.setColspan(6);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.2f);
        celda.setHorizontalAlignment(1);
        detalles.addCell(celda);
        celda = new PdfPCell(tblPrecio);
        celda.setColspan(1);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.2f);
        celda.setHorizontalAlignment(1);
        detalles.addCell(celda);
        celda = new PdfPCell(tblIva);
        celda.setColspan(1);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.2f);
        celda.setHorizontalAlignment(1);
        detalles.addCell(celda);
        celda = new PdfPCell(tblImporte);
        celda.setColspan(1);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.2f);
        celda.setHorizontalAlignment(1);
        detalles.addCell(celda);
        return detalles;
    }

    public PdfPTable tablasTotalesYRegimen() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaTYR = new PdfPTable(6);
        tablaTYR.setWidthPercentage(100.0f);
        tablaTYR.setHorizontalAlignment(1);
        tablaTYR.getDefaultCell().setBorder(0);
        System.out.println("tablaInfoPago");
        PdfPTable infoPago = this.tablaInfoPago();
        PdfPCell celda = new PdfPCell(infoPago);
        celda.setColspan(4);
        celda.setHorizontalAlignment(0);
        celda.setBorder(0);
        tablaTYR.addCell(celda);
        System.out.println("tablaTotales");
        PdfPTable total = this.tablaTotales();
        System.out.println("Despues tablaTotales");
        celda = new PdfPCell(total);
        celda.setColspan(2);
        celda.setHorizontalAlignment(0);
        celda.setBorder(0);
        tablaTYR.addCell(celda);
        return tablaTYR;
    }

    private String MayusculaPrimeraLetra(String frase) {
        System.out.println("FRASE:" + frase);
        String palabra = "";
        String salida = "";
        if (frase.equals(" ")) {
            salida = " ";
        } else {
            StringTokenizer st = new StringTokenizer(frase);
            while (st.hasMoreTokens()) {
                palabra = st.nextToken();
                if (palabra.length() > 5) {
                    palabra = String.valueOf(palabra.substring(0, 1).toUpperCase()) + palabra.substring(1).toLowerCase();
                }
                if (palabra.length() <= 2) {
                    palabra = palabra.toLowerCase();
                }
                palabra = palabra.replace("Mazatlan", "Mazatl\u00e1n");
                palabra = palabra.replace("Administracion", "Administraci\u00f3n");
                salida = String.valueOf(salida) + palabra + " ";
            }
        }
        return salida.substring(0, salida.length() - 1);
    }

    public PdfPTable tablaInfoPago() throws BadElementException, MalformedURLException, IOException {
        Paragraph lineaVacia = new Paragraph(" ", new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
        PdfPTable tablaInfoPago = new PdfPTable(1);
        tablaInfoPago.setWidthPercentage(100.0f);
        PdfPTable tablaRegimen = new PdfPTable(1);
        tablaRegimen.setWidthPercentage(100.0f);
        PdfPTable tablaPago = new PdfPTable(1);
        tablaPago.setWidthPercentage(100.0f);
        String MetodoPagoDescr = new String("");
        String FormaPagoDescr = new String("");
        String RegimenFiscal = new String("");
        switch (this.comprobante.getSubtipoDoc()) {
            case "pto": {
                MetodoPagoDescr = this.dtoPuerto.getMetodoPago();
                FormaPagoDescr = this.dtoPuerto.getFormaPago();
                RegimenFiscal = this.dtoPuerto.getRegimenFiscal();
                break;
            }
            case "apr": {
                MetodoPagoDescr = this.dtoAprovechamiento.getMetodoPago();
                FormaPagoDescr = this.dtoAprovechamiento.getFormaPago();
                RegimenFiscal = this.dtoAprovechamiento.getRegimenFiscal();
                break;
            }
            case "atr": {
                MetodoPagoDescr = this.dtoAtraque.getMetodoPago();
                FormaPagoDescr = this.dtoAtraque.getFormaPago();
                RegimenFiscal = this.dtoAtraque.getRegimenFiscal();
                break;
            }
            case "ces": {
                MetodoPagoDescr = this.dtoces.getMetodoPago();
                FormaPagoDescr = this.dtoces.getFormaPago();
                RegimenFiscal = this.dtoces.getRegimenFiscal();
                break;
            }
            case "man": {
                MetodoPagoDescr = this.dtoManiobra.getMetodoPago();
                FormaPagoDescr = this.dtoManiobra.getFormaPago();
                RegimenFiscal = this.dtoManiobra.getRegimenFiscal();
                break;
            }
            case "mue": {
                MetodoPagoDescr = this.dtoMuellaje.getMetodoPago();
                FormaPagoDescr = this.dtoMuellaje.getFormaPago();
                RegimenFiscal = this.dtoMuellaje.getRegimenFiscal();
                break;
            }
            case "ped": {
                MetodoPagoDescr = this.dtoped.getMetodoPago();
                FormaPagoDescr = this.dtoped.getFormaPago();
                RegimenFiscal = this.dtoped.getRegimenFiscal();
                break;
            }
            case "ncr": {
                MetodoPagoDescr = this.dtoncr.getMetodoPago();
                FormaPagoDescr = this.dtoncr.getFormaPago();
                RegimenFiscal = this.dtoncr.getRegimenFiscal();
            }
        }
        Paragraph informacionPago = null;
        if (RegimenFiscal == null) {
            informacionPago = new Paragraph("   Lugar y Fecha de Certificaci\u00f3n: " + this.configuracion.getLugarCertificacion() + " " + this.comprobante.getFechaTimbrado(), CeldasPDF.fontContentMid);
        } else {
            informacionPago = new Paragraph("   R\u00e9gimen Fiscal: " + RegimenFiscal, CeldasPDF.fontContentMid);
            informacionPago.add("\n   Lugar y Fecha de Certificaci\u00f3n: " + this.configuracion.getLugarCertificacion() + " " + this.comprobante.getFechaTimbrado());
        }
        informacionPago.add("\n   M\u00e9todo de Pago: " + MetodoPagoDescr);
        String formaDePago = String.format("%-100s", "   Forma de Pago: " + FormaPagoDescr);
        informacionPago.add("\n" + formaDePago + "Versi\u00f3n de CFDI: " + this.comprobante.getVersion());
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)informacionPago);
        celda.setBorder(0);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        tablaPago.addCell(celda);
        String str = this.comprobante.getFecha().toString().substring(0, 10);
        String a\u00f1o = str.substring(0, 4);
        String mes = str.substring(5, 7);
        String dia = str.substring(8, 10);
        System.out.println("Comprobante: " + this.comprobante.getComprobante() + " Municipio:" + this.comprobante.getMunicipioEmisor() + " Estado:" + this.comprobante.getEstadoEmisor());
        Paragraph p1 = new Paragraph(String.valueOf(this.MayusculaPrimeraLetra(this.comprobante.getMunicipioEmisor())) + ", " + this.MayusculaPrimeraLetra(this.comprobante.getEstadoEmisor()) + " a " + dia + " de " + mes + " de " + a\u00f1o + ". Debo y Pagar\u00e9 incondicionalmente a la orden de la " + this.MayusculaPrimeraLetra(this.comprobante.getNombreEmisor()) + " la cantidad de $ " + this.comprobante.getTotal() + " misma que pagar\u00e9 en esta plaza en sus oficinas en sitio en el interior " + "del Recinto Fiscal en este Puerto. En caso de mora, el inter\u00e9s lo cubrir\u00e9 en t\u00e9rminos " + "de los art\u00edculos 3\u00b0, 4\u00b0, 17-A,20,20 Bis y 21 del CODIGO FISCAL DE LA FEDERACI\u00d3N.", CeldasPDF.fontContentSmall);
        System.out.println("Termino de hacer el paragraph");
        celda = new PdfPCell();
        celda.setBorder(0);
        celda.addElement((Element)p1);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        tablaRegimen.addCell(celda);
        celda = new PdfPCell(tablaPago);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaInfoPago.addCell(celda);
        celda = new PdfPCell((Phrase)lineaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaInfoPago.addCell(celda);
        celda = new PdfPCell(tablaRegimen);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaInfoPago.addCell(celda);
        return tablaInfoPago;
    }

    public PdfPTable tablaTotales() {
        PdfPTable tablaTotalesL = new PdfPTable(9);
        tablaTotalesL.setWidthPercentage(100.0f);
        tablaTotalesL.setHorizontalAlignment(1);
        tablaTotalesL.getDefaultCell().setBorder(0);
        PdfPTable tablaTotales = new PdfPTable(1);
        tablaTotales.setWidthPercentage(34.0f);
        tablaTotales.setHorizontalAlignment(2);
        tablaTotales.getDefaultCell().setBorder(0);
        PdfPTable tablaTotales2 = new PdfPTable(1);
        tablaTotales2.setWidthPercentage(34.0f);
        tablaTotales2.setHorizontalAlignment(2);
        String descuento = "";
        String impuestos = "";
        String subTotal = "";
        String importe = "";
        String pDescuento = "";
        String total = "";
        Double imported = new Double(Utilerias.nvl(this.comprobante.getSubtotal(), "0").replace(",", ""));
        importe = String.format("%,.2f", imported);
        Double descuentod = new Double(Utilerias.nvl(this.comprobante.getDescuento(), "0").replace(",", ""));
        descuento = String.format("%,.2f", descuentod);
        Double subTotald = new Double(Utilerias.nvl(this.comprobante.getSubtotal(), "0").replace(",", ""));
        subTotal = String.format("%,.2f", subTotald - descuentod);
        Double impuestosd = new Double(Utilerias.nvl(this.comprobante.getTotalImpuestosTrasladados(), "0").replace(",", ""));
        impuestos = String.format("%,.2f", impuestosd);
        Double totald = new Double(Utilerias.nvl(this.comprobante.getTotal(), "0").replace(",", ""));
        total = String.format("%,.2f", totald);
        CeldasPDF.celdaTabla(tablaTotales, "IMPORTE", 1, 0, 18.0f, CeldasPDF.fontTitTotales, 0);
        CeldasPDF.celdaTabla(tablaTotales2, String.valueOf(importe), 1, 0, 18.0f, CeldasPDF.fontDatosBig, 2);
        if (this.comprobante.getSubtipoDoc().equals("ncr")) {
            CeldasPDF.celdaTabla(tablaTotales, " ", 1, 0, 18.0f, CeldasPDF.fontTitTotales, 0);
            CeldasPDF.celdaTabla(tablaTotales2, " ", 1, 0, 18.0f, CeldasPDF.fontDatosBig, 2);
        } else {
            CeldasPDF.celdaTabla(tablaTotales, "DESCUENTO " + pDescuento + " %", 1, 0, 18.0f, CeldasPDF.fontTitTotales, 0);
            CeldasPDF.celdaTabla(tablaTotales2, descuento, 1, 0, 18.0f, CeldasPDF.fontDatosBig, 2);
        }
        CeldasPDF.celdaTabla(tablaTotales, "SUB-TOTAL", 1, 0, 18.0f, CeldasPDF.fontTitTotales, 0);
        CeldasPDF.celdaTabla(tablaTotales2, subTotal, 1, 0, 18.0f, CeldasPDF.fontDatosBig, 2);
        CeldasPDF.celdaTabla(tablaTotales, "I.V.A 16%", 1, 0, 18.0f, CeldasPDF.fontTitTotales, 0);
        CeldasPDF.celdaTabla(tablaTotales2, impuestos, 1, 0, 18.0f, CeldasPDF.fontDatosBig, 2);
        CeldasPDF.celdaTabla(tablaTotales, "TOTAL", 1, 0, 18.0f, CeldasPDF.fontTitTotales, 0);
        CeldasPDF.celdaTabla(tablaTotales2, total, 1, 0, 18.0f, CeldasPDF.fontDatosBig, 2);
        CeldasPDF.celdaVacia(tablaTotalesL, 1);
        PdfPCell celdaS = new PdfPCell(tablaTotales);
        celdaS.setColspan(4);
        celdaS.setBorderColor(BaseColor.BLUE);
        tablaTotalesL.addCell(celdaS);
        celdaS = new PdfPCell(tablaTotales2);
        celdaS.setColspan(4);
        celdaS.setBorderColor(BaseColor.BLUE);
        tablaTotalesL.addCell(celdaS);
        return tablaTotalesL;
    }

    public PdfPTable tablaProveedor() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaProveedor = new PdfPTable(1);
        tablaProveedor.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaProveedor, "Proveedor: " + this.comprobante.getNumProv(), 1, 0, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaProveedor, "", 1, 0, 2.0f, CeldasPDF.fontTitHeader, 1);
        return tablaProveedor;
    }

    public PdfPTable tablaLeyendapago() throws BadElementException, MalformedURLException, IOException {
        PdfPTable miTabla = new PdfPTable(1);
        miTabla.setWidthPercentage(100.0f);
        Paragraph p1 = new Paragraph(this.comprobante.getLeyendaPago(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f, 1));
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)p1);
        celda.setColspan(1);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        miTabla.addCell(celda);
        return miTabla;
    }

    public PdfPTable tablaDatosExtra() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(4);
        tabla.setWidthPercentage(100.0f);
        tabla.getDefaultCell().setBorder(0);
        PdfPTable tablaAux = new PdfPTable(10);
        tablaAux.setWidthPercentage(100.0f);
        tablaAux.getDefaultCell().setBorder(0);
        PdfPTable tablaIzquierda = new PdfPTable(1);
        tablaIzquierda.setWidthPercentage(100.0f);
        tablaIzquierda.getDefaultCell().setBorder(0);
        CeldasPDF.celdaTabla(tablaIzquierda, "", 1, 0, 2.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaIzquierda, "CANTIDAD CON LETRA: " + this.comprobante.getTotalEnLetra(), 1, 2, 2.0f, CeldasPDF.fontContentBig, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, "", 1, 0, 2.0f, CeldasPDF.fontTitBold, 1);
        PdfPCell celda = new PdfPCell();
        celda.setBorder(0);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        tablaAux.addCell(celda);
        PdfPTable tablaDerecha = this.tablaCertificadoSat();
        celda = new PdfPCell(tablaDerecha);
        celda.setBorder(0);
        celda.setColspan(9);
        celda.setHorizontalAlignment(1);
        tablaAux.addCell(celda);
        CeldasPDF.celdaTabla(tabla, "ESTA FACTURA SI NO ES LIQUIDADA AL DIA SIGUIENTE HABIL CAUSARA INTERESES DE ACUERDO A LA TASA DE INTERES INTERBANCARIO PROMEDIO (TIIP) MAS EL 50% Y SE COMPUTARA A PARTIR DE LA FECHA DE CERTIFICACI\u00d3N", 4, 0, 2.0f, CeldasPDF.fontData, 1);
        CeldasPDF.celdaTabla(tabla, "", 4, 0, 2.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaIzquierda);
        celda.setBorder(0);
        celda.setColspan(3);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
        celda = new PdfPCell(tablaAux);
        celda.setBorder(0);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
        return tabla;
    }

    public PdfPTable tablaCertificadoSat() {
        PdfPTable tablaCertificado = new PdfPTable(1);
        tablaCertificado.setWidthPercentage(100.0f);
        tablaCertificado.getDefaultCell().setBorder(0);
        CeldasPDF.celdaTabla(tablaCertificado, "NO. CERTIFICADO DEL SAT", 1, 2, 2.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaCertificado, this.comprobante.getNoCertificadoSAT(), 1, 0, 2.0f, CeldasPDF.fontContentMid, 1);
        return tablaCertificado;
    }

    public PdfPTable tablaDatosDigitales() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(4);
        tabla.setWidthPercentage(100.0f);
        tabla.getDefaultCell().setBorder(0);
        PdfPTable tablaAux = new PdfPTable(10);
        tablaAux.setWidthPercentage(100.0f);
        tablaAux.getDefaultCell().setBorder(0);
        PdfPTable tablaIzquierda = new PdfPTable(1);
        tablaIzquierda.setWidthPercentage(100.0f);
        tablaIzquierda.getDefaultCell().setBorder(0);
        CeldasPDF.celdaTabla(tablaAux, "", 10, 0, 2.0f, CeldasPDF.fontTitBold, 1);
        PdfPCell celda = new PdfPCell();
        celda.setBorder(0);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        tablaAux.addCell(celda);
        String URLServicio = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx";
        this.nombreCompleto = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".png";
        String datosQR = String.valueOf(URLServicio) + "?&id=" + this.comprobante.getUUID() + "&re=" + this.comprobante.getRfcEmisor() + "&rr=" + this.comprobante.getRfcReceptor() + "&tt=" + Conversiones.quitarFormatoImporte(this.comprobante.getTotal()) + "&fe=" + this.comprobante.getSello().substring(this.comprobante.getSello().length() - 8);
        CodigoQR qr = new CodigoQR();
        qr.creaImagen(datosQR, this.nombreCompleto);
        Image imagen = null;
        imagen = Image.getInstance((String)this.nombreCompleto);
        imagen.setAlignment(1);
        celda = new PdfPCell();
        celda.addElement((Element)imagen);
        celda.setColspan(10);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        tablaAux.addCell(celda);
        Paragraph titulo = new Paragraph("SELLO DIGITAL CFD", CeldasPDF.fontContentSmallBold);
        titulo.setAlignment(0);
        titulo.setSpacingBefore(0.0f);
        Paragraph cadena = new Paragraph(this.comprobante.getSello(), CeldasPDF.fontData);
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        celda.setHorizontalAlignment(0);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.5f);
        celda.setVerticalAlignment(4);
        celda.setColspan(1);
        tablaIzquierda.addCell(celda);
        titulo = new Paragraph("SELLO DIGITAL SAT", CeldasPDF.fontContentSmallBold);
        titulo.setSpacingBefore(0.0f);
        titulo.setAlignment(0);
        cadena = new Paragraph(this.comprobante.getSelloSAT(), CeldasPDF.fontData);
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        celda.setHorizontalAlignment(0);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.5f);
        celda.setVerticalAlignment(4);
        celda.setColspan(1);
        tablaIzquierda.addCell(celda);
        titulo = new Paragraph("CADENA ORIGINAL DEL COMPLEMENTO DE CERTIFICACION DIGITAL DEL SAT", CeldasPDF.fontContentSmallBold);
        titulo.setAlignment(0);
        titulo.setSpacingBefore(0.0f);
        cadena = new Paragraph(this.comprobante.getCadenaOriginalSAT(), CeldasPDF.fontData);
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        celda.setHorizontalAlignment(0);
        celda.setBorderColor(BaseColor.BLUE);
        celda.setBorderWidth(1.5f);
        celda.setVerticalAlignment(4);
        celda.setColspan(1);
        tablaIzquierda.addCell(celda);
        celda = new PdfPCell(tablaIzquierda);
        celda.setColspan(3);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        celda.setVerticalAlignment(4);
        tabla.addCell(celda);
        celda = new PdfPCell(tablaAux);
        celda.setColspan(4);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
        return tabla;
    }

    public PdfPTable tablaDatosDigitalesCanc() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(28);
        tabla.setWidthPercentage(100.0f);
        PdfPCell celda = new PdfPCell();
        celda.setColspan(21);
        Paragraph p = null;
        if (this.comprobante.getStatus() == 0) {
            p = new Paragraph("Cadena de Cancelaci\u00f3n:", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
            p.setAlignment(0);
            celda.addElement((Element)p);
            p = new Paragraph(this.comprobante.getCancelaTexto(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
            p.setAlignment(0);
            celda.addElement((Element)p);
        }
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tabla.addCell(celda);
        celda = new PdfPCell();
        celda.setColspan(7);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
        return tabla;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.total.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        try {
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(((Object)((Object)this)).getClass().getName(), "onOpenDocument", e.toString(), "ERROR JAVA");
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        String text = "";
        float textBase = document.bottom() - 4.0f;
        float textSize = this.helv.getWidthPoint(text, 4.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 4.0f);
        float adjust = this.helv.getWidthPoint("0", 4.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.helv, 4.0f);
        this.total.setTextMatrix(0.0f, 0.0f);
        this.total.showText(String.valueOf(writer.getPageNumber() - 1));
        this.total.endText();
    }

    public static String espacios(int numEspacios) {
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < numEspacios) {
            str.append(" ");
            ++i;
        }
        return str.toString();
    }

    public static String getNombreDeMes(String pNumeroDeMes) {
        String vNombre = "";
        switch (pNumeroDeMes) {
            case "01": {
                vNombre = "enero";
                break;
            }
            case "02": {
                vNombre = "febrero";
                break;
            }
            case "03": {
                vNombre = "marzo";
                break;
            }
            case "04": {
                vNombre = "abril";
                break;
            }
            case "05": {
                vNombre = "mayo";
                break;
            }
            case "06": {
                vNombre = "junio";
                break;
            }
            case "07": {
                vNombre = "julio";
                break;
            }
            case "08": {
                vNombre = "agosto";
                break;
            }
            case "09": {
                vNombre = "septiembre";
                break;
            }
            case "10": {
                vNombre = "octubre";
                break;
            }
            case "11": {
                vNombre = "noviembre";
                break;
            }
            case "12": {
                vNombre = "diciembre";
            }
        }
        return vNombre;
    }
}

