/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.lowagie.text.ExceptionConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dto.ComplementoNominaDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.dto.MetadatosNominaDTO;
import siti.sinco.cfdi.dto.Percepcion_DeduccionDTO;
import siti.sinco.cfdi.pdf.CeldasPDF;
import siti.sinco.cfdi.tools.CodigoQR;
import siti.sinco.cfdi.tools.Conversiones;
import siti.sinco.cfdi.tools.Utilerias;

public class CFDenPDFSitiRecibo
extends PdfPageEventHelper {
    private ComprobanteDTO comprobante;
    private ConfiguracionDTO configuracion;
    private String nombrePDF;
    private String ruta;
    private String nombreCompleto;
    private MetadatosNominaDTO dtonom;
    protected PdfTemplate total;
    protected BaseFont helv;
    ComplementoNominaDTO complementoNomina;
    private Double pergravado;
    private Double perexento;
    private Double dedgravado;
    private Double dedexento;
    private BaseColor gristenue = new BaseColor(211, 211, 211);
    private String leyenda = "Este documento es una representaci\u00f3n gr\u00e1fica de un CFDI";

    public CFDenPDFSitiRecibo(ComprobanteDTO objComprobante, ConfiguracionDTO objConfiguracion) {
        this.comprobante = objComprobante;
        this.configuracion = objConfiguracion;
    }

    public CFDenPDFSitiRecibo() {
    }

    public String generarPDF(String modo, String sobreEscribe, String pRutaPDF) throws IOException, DocumentException {
        System.out.println("NM");
        this.dtonom = this.comprobante.getmetadatosNom();
        Locale.setDefault(new Locale("es", "MX"));
        Document document = new Document(PageSize.LETTER, 18.0f, 18.0f, 18.0f, 18.0f);
        this.ruta = "";
        String ruta_archivo = "";
        if (pRutaPDF != null) {
            String[] vRuta = pRutaPDF.replace("\\", "/").split("/");
            String vRutaPDF = "";
            int i = 0;
            while (i < vRuta.length - 2) {
                this.ruta = i == 0 ? vRuta[i] : String.valueOf(this.ruta) + "\\" + vRuta[i];
                ++i;
            }
            this.ruta = String.valueOf(this.ruta) + "\\" + "PDF";
            this.nombrePDF = vRuta[vRuta.length - 1].replace(".xml", "").replace(".txt", "").replace("INT", "CFDi");
            ruta_archivo = String.valueOf(this.ruta) + "\\" + this.nombrePDF + ".pdf";
        } else {
            this.nombrePDF = ComprobantesDAO.creaNombreArchivo(this.comprobante.getComprobante());
            this.ruta = String.valueOf(Utilerias.getRutaBase(this.comprobante, this.configuracion, 3)) + File.separator + "PDF";
            ruta_archivo = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".pdf";
        }
        File rutaPDF = new File(this.ruta);
        File fichero = new File(ruta_archivo);
        System.out.println("ruta: " + ruta_archivo);
        if (!rutaPDF.exists()) {
            System.out.println("Se ha creado la ruta: " + this.ruta);
            rutaPDF.mkdirs();
        }
        if (fichero.exists()) {
            if (sobreEscribe.equals("SI")) {
                System.out.println("El archivo se va a sobreescribir.");
                FileUtils.forceDelete((File)fichero);
            } else {
                System.out.println("El archivo ya existe y no se puede sobreescribir.");
            }
        }
        if (!fichero.exists()) {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(ruta_archivo));
            writer.setPageEvent((PdfPageEvent)new CFDenPDFSitiRecibo());
            Paragraph lineaVacia = new Paragraph(" ", new Font(Font.FontFamily.TIMES_ROMAN, 2.0f));
            Paragraph leyendaDigital = new Paragraph(" ", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("_______________________________________________________");
            leyendaDigital.add("\n");
            leyendaDigital.add("Firma del Empleado");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            leyendaDigital.add("\n");
            if (modo.equals("TEST")) {
                this.leyenda = String.valueOf(this.leyenda) + "\n ESTE DOCUMENTO NO TIENE VALIDEZ FISCAL PUES ES UNA PRUEBA";
            }
            leyendaDigital.add(" " + this.leyenda + " ");
            leyendaDigital.setAlignment(1);
            this.complementoNomina = this.comprobante.getComplementoNom();
            document.open();
            System.out.println("Agregando datos");
            document.add((Element)this.tablaLogo());
            document.add((Element)this.tablaReceptor());
            document.add((Element)this.tablaReceptor1());
            document.add((Element)this.tablaReceptor2());
            document.add((Element)this.tablaReceptor3());
            document.add((Element)this.tablaReceptor3a());
            document.add((Element)this.tablaReceptor4());
            document.add((Element)this.tablaReceptor5());
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaPerDedTitulo());
            document.add((Element)this.tablaDetallePerDed());
            document.add((Element)this.tablaTotalesPerDed());
            System.out.println("Antes de agrega una linea vacia");
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaFormaMetPago());
            System.out.println("Despu\u00e9s de tablaFormaMetPago");
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            System.out.println("Despu\u00e9s de LineasVacias");
            document.add((Element)this.tablaDatosDigitales());
            document.add((Element)this.tablaLeyendaDigital(leyendaDigital));
            System.out.println("Despu\u00e9s de la leyendaDigital");
            document.close();
            File rutaImagenQR = new File(this.nombreCompleto);
            if (rutaImagenQR.exists()) {
                System.out.println("Agrega QR");
                FileUtils.forceDelete((File)rutaImagenQR);
            }
            System.out.println("Termino de crear el PDF");
        }
        return ruta_archivo;
    }

    public PdfPTable tablaLogo() throws MalformedURLException, IOException, DocumentException {
        PdfPTable tablaLogo = new PdfPTable(5);
        tablaLogo.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{78.0f, 16.0f, 235.0f, 16.0f, 125.0f};
        tablaLogo.setTotalWidth(columnWidths);
        PdfPTable tablaVacia = new PdfPTable(1);
        tablaVacia.setWidthPercentage(90.0f);
        PdfPTable tablaDerecha = new PdfPTable(1);
        tablaDerecha.setWidthPercentage(90.0f);
        tablaDerecha.getDefaultCell().setBorder(0);
        tablaLogo.getDefaultCell().setBorder(0);
        Image imagen = null;
        String nombrelogo = new String("/logo_asipona.jpg");
        if (this.comprobante.getNombreEmisor().toUpperCase().contains("INTEGRAL")) {
            nombrelogo = "/logo_api.jpg";
        }
        imagen = Image.getInstance((String)(String.valueOf(LeeConexion.path) + "/recursos/" + nombrelogo));
        imagen.scalePercent(35.0f);
        imagen.setAlignment(0);
        PdfPCell celda = new PdfPCell(imagen);
        celda.setColspan(1);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaLogo.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "   ", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaLogo.addCell(celda);
        String registroPatronal = this.complementoNomina.getRegistroPatronal();
        Paragraph parrafNombreEmisor = new Paragraph(this.comprobante.getNombreEmisor(), CeldasPDF.fontContentMidBold);
        parrafNombreEmisor.add("\n" + this.comprobante.getRfcEmisor() + " / Registro Patronal: " + registroPatronal);
        parrafNombreEmisor.setAlignment(1);
        String noExt = "";
        String noInt = "";
        String colonia = "";
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorEmisor(), "S/N");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorEmisor(), "");
        colonia = Utilerias.nvl(this.comprobante.getColoniaEmisor(), "");
        Paragraph parrafDomicEmisor = new Paragraph(String.valueOf(this.comprobante.getCalleEmisor()) + " " + noExt + " " + noInt + " " + colonia, CeldasPDF.fontContentSmall);
        parrafDomicEmisor.add("\n" + this.comprobante.getMunicipioEmisor() + " C.P." + this.comprobante.getCodigoPostalEmisor() + ", " + this.comprobante.getPaisEmisor() + ", " + this.comprobante.getEstadoEmisor());
        if (this.comprobante.getRegimen() != null) {
            parrafDomicEmisor.add("\nR\u00e9gimen Fiscal:  " + this.comprobante.getRegimen());
        }
        parrafDomicEmisor.setAlignment(1);
        celda = new PdfPCell();
        celda.addElement((Element)parrafNombreEmisor);
        celda.addElement((Element)parrafDomicEmisor);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaLogo.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "   ", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaLogo.addCell(celda);
        CeldasPDF.celdaTabla(tablaDerecha, "RECIBO DE N\u00d3MINA", 2, 0, 0.0f, CeldasPDF.fontHeaderDoc, 1);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaLogo.addCell(celda);
        return tablaLogo;
    }

    public PdfPTable tablaReceptor() throws DocumentException {
        PdfPTable tablaReceptor = new PdfPTable(6);
        tablaReceptor.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{80.0f, 70.0f, 136.0f, 47.0f, 47.0f, 94.0f};
        tablaReceptor.setTotalWidth(columnWidths);
        String extraordinaria = "E";
        String tipoDocumento = "Recibo de n\u00f3mina";
        String tipoNomina = "Ordinaria";
        if (this.complementoNomina.getTipoNomina().equals("E")) {
            tipoNomina = "Extraordinaria";
        }
        CeldasPDF.celdaTabla(tablaReceptor, "Tipo de documento", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Tipo de n\u00f3mina", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Folio Fiscal", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Serie", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Folio", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Lugar de Expedici\u00f3n", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, tipoDocumento, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, tipoNomina, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getUUID(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getSerie(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getFolioDoc(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getLugarExpedicion(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        return tablaReceptor;
    }

    public PdfPTable tablaReceptor1() throws DocumentException {
        PdfPTable tablaReceptor = null;
        float[] columnWidths = null;
        if (this.comprobante.getVersion().equals("4.0")) {
            tablaReceptor = new PdfPTable(5);
            columnWidths = new float[]{80.0f, 70.0f, 136.0f, 94.0f, 94.0f};
        } else {
            tablaReceptor = new PdfPTable(4);
            columnWidths = new float[]{80.0f, 70.0f, 136.0f, 188.0f};
        }
        tablaReceptor.setWidthPercentage(90.0f);
        tablaReceptor.setTotalWidth(columnWidths);
        String periodoPagar = String.valueOf(this.complementoNomina.getFechaInicialPago()) + " a " + this.complementoNomina.getFechaFinalPago();
        CeldasPDF.celdaTabla(tablaReceptor, "D\u00edas Pagados", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Periodo a Pagar", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Fecha de Emisi\u00f3n del Recibo", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Fecha de Certificaci\u00f3n", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        if (this.comprobante.getVersion().equals("4.0")) {
            CeldasPDF.celdaTabla(tablaReceptor, "C.P. Receptor", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        }
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getNumDiasPagados(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, periodoPagar, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getFecha(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getFechaTimbrado(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        if (this.comprobante.getVersion().equals("4.0")) {
            CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getCodigoPostalReceptor(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        }
        return tablaReceptor;
    }

    public PdfPTable tablaReceptor2() throws DocumentException {
        PdfPTable tablaReceptor = null;
        float[] columnWidths = null;
        if (this.comprobante.getVersion().equals("4.0")) {
            tablaReceptor = new PdfPTable(4);
            columnWidths = new float[]{80.0f, 179.0f, 121.0f, 94.0f};
        } else {
            tablaReceptor = new PdfPTable(3);
            columnWidths = new float[]{80.0f, 197.0f, 194.0f};
        }
        tablaReceptor.setWidthPercentage(90.0f);
        tablaReceptor.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tablaReceptor, "No de certificado emisor", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "No de certificado del SAT", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Proveedor de servicios de emisi\u00f3n CFDIs", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        if (this.comprobante.getVersion().equals("4.0")) {
            CeldasPDF.celdaTabla(tablaReceptor, "R\u00e9gimen Fiscal del Receptor", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        }
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getNocertificado(), 1, 3, 0.0f, CeldasPDF.fontContentSmaller, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getNoCertificadoSAT(), 1, 1, 0.0f, CeldasPDF.fontContentSmaller, 1);
        CeldasPDF.celdaTabla(tablaReceptor, String.valueOf(this.configuracion.getNombreCertificador()) + " " + this.comprobante.getRfcProvCertif(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        if (this.comprobante.getVersion().equals("4.0")) {
            CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getRegimenReceptor(), 1, 1, 0.0f, CeldasPDF.fontContentSmaller, 1);
        }
        return tablaReceptor;
    }

    public PdfPTable tablaReceptor3() throws DocumentException {
        PdfPTable tablaReceptor = new PdfPTable(4);
        tablaReceptor.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{171.0f, 86.0f, 128.0f, 85.0f};
        tablaReceptor.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tablaReceptor, "Nombre Completo", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "RFC", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "CURP", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Clave Entidad Federativa", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getNombreReceptor(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.comprobante.getRfcReceptor(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getCurp(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getClaveEntFed(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        return tablaReceptor;
    }

    public PdfPTable tablaReceptor3a() throws DocumentException {
        PdfPTable tablaReceptor = new PdfPTable(5);
        tablaReceptor.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{47.0f, 124.0f, 86.0f, 128.0f, 85.0f};
        tablaReceptor.setTotalWidth(columnWidths);
        String riesgoPuesto = Integer.toString(this.complementoNomina.getRiesgoPuesto());
        CeldasPDF.celdaTabla(tablaReceptor, "Sindicalizado", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Departamento", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Riesgo Puesto", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Puesto", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Fecha de Ingreso", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getSindicalizado(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getDepartamento(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, riesgoPuesto, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getPuesto(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getFechaInicioRelLaboral(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        return tablaReceptor;
    }

    public PdfPTable tablaReceptor4() throws DocumentException {
        PdfPTable tablaReceptor = new PdfPTable(8);
        tablaReceptor.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{80.0f, 70.0f, 80.0f, 80.0f, 40.0f, 40.0f, 40.0f, 40.0f};
        tablaReceptor.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tablaReceptor, "No de Empleado", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "No de Seguro Social", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Salario Base Cotizaci\u00f3n", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Salario Diario Integrado", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Periodicidad Pago", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Jornada", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Antig\u00fcedad", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, "Tipo Contrato", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getNumEmpleado(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getNumSeguridadSocial(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getSalarioBaseCotApor(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getSalarioDiarioIntegrado(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getPeriodicidadPago(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getTipoJornada(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getAntiguedad(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getTipoContrato(), 1, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        return tablaReceptor;
    }

    public PdfPTable tablaReceptor5() throws DocumentException {
        PdfPTable tablaReceptor = new PdfPTable(4);
        tablaReceptor.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{80.0f, 150.0f, 80.0f, 160.0f};
        tablaReceptor.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tablaReceptor, "Banco:", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getBanco(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaReceptor, "Clabe bancaria", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaReceptor, this.complementoNomina.getClabe(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 0);
        return tablaReceptor;
    }

    public PdfPTable tablaPerDedTitulo() throws DocumentException {
        PdfPTable tablaPerDed = new PdfPTable(2);
        tablaPerDed.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{235.0f, 235.0f};
        tablaPerDed.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tablaPerDed, "PERCEPCIONES", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaPerDed, "DEDUCCIONES", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        return tablaPerDed;
    }

    public PdfPTable tablaDetallePerDed() throws DocumentException {
        PdfPTable tablaPerDed = new PdfPTable(2);
        tablaPerDed.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{235.0f, 235.0f};
        tablaPerDed.setTotalWidth(columnWidths);
        PdfPTable tablaPercepciones = new PdfPTable(3);
        tablaPercepciones.setWidthPercentage(90.0f);
        PdfPTable tablaDeducciones = new PdfPTable(3);
        tablaDeducciones.setWidthPercentage(90.0f);
        columnWidths = new float[]{20.0f, 145.0f, 70.0f};
        tablaPercepciones.setTotalWidth(columnWidths);
        tablaDeducciones.setTotalWidth(columnWidths);
        int numRenglonesPercep = 0;
        ArrayList<Percepcion_DeduccionDTO> lista_percepciones = null;
        numRenglonesPercep = this.comprobante.getComplementoNom().getLstPercepciones().size();
        System.out.println("Numero percepciones = " + numRenglonesPercep);
        lista_percepciones = this.comprobante.getComplementoNom().getLstPercepciones();
        double monto = new Double(0.0);
        String claveSAT = "";
        String concepto = "";
        String montostr = "";
        CeldasPDF.celdaTabla(tablaPercepciones, "SAT", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaPercepciones, "Concepto", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaPercepciones, "Importe", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        System.out.println("Inicio FOR");
        int renglon = 0;
        while (renglon < numRenglonesPercep) {
            concepto = String.valueOf(lista_percepciones.get(renglon).getClave()) + " " + lista_percepciones.get(renglon).getConcepto();
            System.out.println("concepto:" + concepto);
            claveSAT = lista_percepciones.get(renglon).getTipo();
            System.out.println("claveSat");
            String esOtroPago = lista_percepciones.get(renglon).getOtrosPagos();
            System.out.println("EsOtroPago");
            if (esOtroPago.equals("1")) {
                concepto = "Otro Pago Tipo: " + lista_percepciones.get(renglon).getTipo() + " " + lista_percepciones.get(renglon).getClave() + " Concepto: " + lista_percepciones.get(renglon).getConcepto();
                System.out.println("otro pago tipo: ");
            }
            System.out.println("ImporteGravEx:" + lista_percepciones.get(renglon).getImporteGravExen());
            monto = new Double(lista_percepciones.get(renglon).getImporteGravExen().replace(",", ""));
            System.out.println("monto:" + String.valueOf(monto));
            montostr = String.format("$ %,.2f", monto);
            System.out.println("montostr");
            System.out.println("Asignando en PDF");
            CeldasPDF.celdaTabla(tablaPercepciones, claveSAT, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaPercepciones, concepto, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaPercepciones, montostr, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 2);
            ++renglon;
        }
        System.out.println("Inicio de FOR espacios");
        int renblancos = 20;
        while (renblancos > numRenglonesPercep) {
            CeldasPDF.celdaTabla(tablaPercepciones, " ", 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaPercepciones, " ", 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaPercepciones, " ", 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            renblancos -= 2;
        }
        PdfPCell celda = new PdfPCell(tablaPercepciones);
        celda.setColspan(1);
        celda.setBorder(8);
        celda.setBorder(4);
        tablaPerDed.addCell(celda);
        int numRenglonesDeduc = 0;
        ArrayList<Percepcion_DeduccionDTO> lista_deducciones = null;
        numRenglonesDeduc = this.comprobante.getComplementoNom().getDeducciones().size();
        System.out.println("Numero deducciones=" + numRenglonesDeduc);
        lista_deducciones = this.comprobante.getComplementoNom().getDeducciones();
        claveSAT = "";
        concepto = "";
        montostr = "";
        CeldasPDF.celdaTabla(tablaDeducciones, "SAT", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaDeducciones, "Concepto", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        CeldasPDF.celdaTabla(tablaDeducciones, "Importe", CeldasPDF.fontContentSmallBold, this.gristenue, 1, 1);
        int renglon2 = 0;
        while (renglon2 < numRenglonesDeduc) {
            concepto = String.valueOf(lista_deducciones.get(renglon2).getClave()) + " " + lista_deducciones.get(renglon2).getConcepto();
            claveSAT = lista_deducciones.get(renglon2).getTipo();
            monto = new Double(lista_deducciones.get(renglon2).getImporteGravExen().replace(",", ""));
            montostr = String.format("$ %,.2f", monto);
            CeldasPDF.celdaTabla(tablaDeducciones, claveSAT, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaDeducciones, concepto, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaDeducciones, montostr, 1, 1, 0.0f, CeldasPDF.fontContentSmall, 2);
            ++renglon2;
        }
        if (numRenglonesDeduc == 0) {
            CeldasPDF.celdaTabla(tablaDeducciones, " ", 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaDeducciones, " ", 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tablaDeducciones, " ", 1, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
        }
        PdfPCell celdaderecha = new PdfPCell(tablaDeducciones);
        celdaderecha.setColspan(1);
        celdaderecha.setBorder(8);
        celdaderecha.setBorder(4);
        celdaderecha.setHorizontalAlignment(0);
        tablaPerDed.addCell(celdaderecha);
        return tablaPerDed;
    }

    public PdfPTable tablaTotalesPerDed() throws DocumentException {
        PdfPTable tablaTotalPerDed = new PdfPTable(4);
        tablaTotalPerDed.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{155.0f, 80.0f, 155.0f, 80.0f};
        tablaTotalPerDed.setTotalWidth(columnWidths);
        double totalpercepciones = new Double(this.complementoNomina.getTotalPercepciones().replace(",", ""));
        String totalpercepcionesstr = String.format("$ %,.2f", totalpercepciones);
        double totaldeducciones = new Double(this.complementoNomina.getTotalDeducciones().replace(",", ""));
        String totaldeduccionesstr = String.format("$ %,.2f", totaldeducciones);
        double totalOtrosPagos = new Double(this.complementoNomina.getPercepcionOtrosPagos().replace(",", ""));
        double subtotal = totalpercepciones + totalOtrosPagos;
        String subtotalstr = String.format("$ %,.2f", subtotal);
        CeldasPDF.celdaTabla(tablaTotalPerDed, " ", 4, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
        CeldasPDF.celdaTabla(tablaTotalPerDed, "TOTAL DE PERCEPCIONES:", CeldasPDF.fontContentSmallBold, this.gristenue, 0, 1);
        CeldasPDF.celdaTabla(tablaTotalPerDed, totalpercepcionesstr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
        CeldasPDF.celdaTabla(tablaTotalPerDed, "TOTAL DE DEDUCCIONES:", CeldasPDF.fontContentSmallBold, this.gristenue, 0, 1);
        CeldasPDF.celdaTabla(tablaTotalPerDed, totaldeduccionesstr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
        double total = new Double(this.comprobante.getTotal().replace(",", ""));
        String totalstr = String.format("$ %,.2f", total);
        CeldasPDF.celdaTabla(tablaTotalPerDed, "SUBTOTAL:", CeldasPDF.fontContentSmallBold, this.gristenue, 0, 1);
        CeldasPDF.celdaTabla(tablaTotalPerDed, subtotalstr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
        CeldasPDF.celdaTabla(tablaTotalPerDed, "TOTAL A PAGAR:", CeldasPDF.fontContentSmallBold, this.gristenue, 0, 1);
        CeldasPDF.celdaTabla(tablaTotalPerDed, totalstr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
        CeldasPDF.celdaTabla(tablaTotalPerDed, "TOTAL EN LETRA:", CeldasPDF.fontContentSmallBold, this.gristenue, 0, 1);
        CeldasPDF.celdaTabla(tablaTotalPerDed, this.comprobante.getTotalEnLetra(), 3, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        return tablaTotalPerDed;
    }

    public PdfPTable tablaFormaMetPago() throws DocumentException {
        PdfPTable tablaTotalPerDed = new PdfPTable(1);
        tablaTotalPerDed.setWidthPercentage(90.0f);
        String formaDePago = String.valueOf(this.dtonom.getFormaPago()) + "-";
        if (this.comprobante.getVersion().equals("4.0")) {
            formaDePago = "";
        }
        CeldasPDF.celdaTabla(tablaTotalPerDed, String.valueOf(formaDePago) + this.dtonom.getMetodoPago(), 1, 0, 0.0f, CeldasPDF.fontContentSmall, 0);
        return tablaTotalPerDed;
    }

    public PdfPTable tablaDatosDigitales() throws MalformedURLException, IOException, DocumentException {
        PdfPTable tabla = new PdfPTable(2);
        tabla.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{120.0f, 350.0f};
        tabla.setTotalWidth(columnWidths);
        tabla.getDefaultCell().setBorder(0);
        String URLServicio = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx";
        PdfPTable tablaIzquierda = new PdfPTable(1);
        tablaIzquierda.setWidthPercentage(90.0f);
        columnWidths = new float[]{120.0f};
        tablaIzquierda.setTotalWidth(columnWidths);
        tablaIzquierda.getDefaultCell().setBorder(0);
        PdfPTable tablaDerecha = new PdfPTable(1);
        tablaDerecha.setWidthPercentage(90.0f);
        columnWidths = new float[]{350.0f};
        tablaDerecha.setTotalWidth(columnWidths);
        this.nombreCompleto = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".png";
        String datosQR = String.valueOf(URLServicio) + "?Id=" + this.comprobante.getUUID() + "&Re=" + this.comprobante.getRfcEmisor() + "&Rr=" + this.comprobante.getRfcReceptor() + "&Tt=" + Conversiones.quitarFormatoImporte(this.comprobante.getTotal()) + "&Fe=" + this.comprobante.getSello().substring(this.comprobante.getSello().length() - 8);
        CodigoQR qr = new CodigoQR();
        qr.creaImagen(datosQR, this.nombreCompleto);
        Image imagen = null;
        imagen = Image.getInstance((String)this.nombreCompleto);
        imagen.setAlignment(0);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)imagen);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        celda.setVerticalAlignment(6);
        celda.setBorder(0);
        tablaIzquierda.addCell(celda);
        Paragraph titulo = new Paragraph("CADENA ORIGINAL DEL COMPLEMENTO DE CERTIFICACION DEL SAT", new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1));
        titulo.setAlignment(0);
        Paragraph cadena = new Paragraph(this.comprobante.getCadenaOriginalSAT(), new Font(Font.FontFamily.TIMES_ROMAN, 4.0f));
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        celda.setBorder(15);
        tablaDerecha.addCell(celda);
        titulo = new Paragraph("SELLO DIGITAL DEL CFDI", new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1));
        titulo.setAlignment(0);
        cadena = new Paragraph(this.comprobante.getSello(), new Font(Font.FontFamily.TIMES_ROMAN, 4.0f));
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        celda.setBorder(15);
        tablaDerecha.addCell(celda);
        titulo = new Paragraph("SELLO DEL SAT", new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1));
        titulo.setAlignment(0);
        cadena = new Paragraph(this.comprobante.getSelloSAT(), new Font(Font.FontFamily.TIMES_ROMAN, 4.0f));
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.setBorder(15);
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        tablaDerecha.addCell(celda);
        tabla.addCell(tablaIzquierda);
        tabla.addCell(tablaDerecha);
        return tabla;
    }

    public PdfPTable tablaLeyendaDigital(Paragraph leyendadigital) throws MalformedURLException, IOException, DocumentException {
        PdfPTable tablaAbajo = new PdfPTable(1);
        float[] columnWidths = new float[]{120.0f, 350.0f};
        tablaAbajo.setWidthPercentage(90.0f);
        columnWidths = new float[]{470.0f};
        tablaAbajo.setTotalWidth(columnWidths);
        PdfPCell celda = new PdfPCell();
        celda = new PdfPCell();
        celda.addElement((Element)leyendadigital);
        celda.setBorder(0);
        celda.setVerticalAlignment(6);
        tablaAbajo.addCell(celda);
        return tablaAbajo;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.total.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        try {
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(((Object)((Object)this)).getClass().getName(), "onOpenDocument", e.toString(), "ERROR JAVA");
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        String text = "";
        float textBase = document.bottom() - 4.0f;
        float textSize = this.helv.getWidthPoint(text, 4.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 4.0f);
        float adjust = this.helv.getWidthPoint("0", 4.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.right() - adjust, textBase);
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.helv, 4.0f);
        this.total.setTextMatrix(0.0f, 0.0f);
        this.total.showText(String.valueOf(writer.getPageNumber() - 1));
        this.total.endText();
    }

    public static String espacios(int numEspacios) {
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < numEspacios) {
            str.append(" ");
            ++i;
        }
        return str.toString();
    }
}

