/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;

public class CeldasPDF {
    public static final int SIN_BORDE = 0;
    public static final int CON_BORDE = 1;
    public static final int BORDE_AZUL = 2;
    public static final int TODO_BORDER = 3;
    public static final int SIN_ENCABEZADO = 0;
    public static final int CON_ENCABEZADO = 1;
    public static final int SIN_FONDO = 0;
    public static final int CON_FONDO_ROJO = 1;
    public static final int CON_FONDO_GRIS = 2;
    public static final int CON_FONDO_GRIS2 = 3;
    public static final int CON_FONDO_AV = 4;
    public static final int DOCHEADER = 10;
    public static final int LETRAHEADER = 8;
    public static final int LETRABIG = 8;
    public static final int LETRAMID = 7;
    public static final int LETRASMALL = 6;
    public static final int LETRASMALLER = 5;
    public static final int LETRATINY = 4;
    public static final int LETRATIT = 6;
    public static final int LETRADET = 6;
    public static final Font fontTitHeader = new Font(Font.FontFamily.TIMES_ROMAN, 8.0f, 1);
    public static final Font fontTit = new Font(Font.FontFamily.TIMES_ROMAN, 6.0f);
    public static final Font fontTitBold = new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1);
    public static final Font fontTitBold2 = new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1);
    public static final Font fontDetalle = FontFactory.getFont((String)"TIMES_ROMAN", (float)6.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontDetalleCou = FontFactory.getFont((String)"COURIER", (float)6.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontHeaderDoc = FontFactory.getFont((String)"Arial", (float)10.0f, (int)1, (BaseColor)BaseColor.BLACK);
    public static final Font fontHeader = FontFactory.getFont((String)"Arial", (float)8.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontHeaderSmall = FontFactory.getFont((String)"Arial", (float)6.0f, (int)1, (BaseColor)BaseColor.RED);
    public static final Font fontHeaderSmall2 = FontFactory.getFont((String)"Arial", (float)6.0f, (int)1, (BaseColor)BaseColor.WHITE);
    public static final Font fontHeaderSmall3 = FontFactory.getFont((String)"Arial", (float)6.0f, (int)1, (BaseColor)BaseColor.WHITE);
    public static final Font fontTotales = FontFactory.getFont((String)"Courier", (float)6.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontHeaderTipo = FontFactory.getFont((String)"Courier", (float)6.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentBig = FontFactory.getFont((String)"Arial", (float)8.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentMid = FontFactory.getFont((String)"Arial", (float)7.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentSmall = FontFactory.getFont((String)"Arial", (float)6.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentSmaller = FontFactory.getFont((String)"Arial", (float)5.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentTiny = FontFactory.getFont((String)"Arial", (float)4.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentBigBold = FontFactory.getFont((String)"Arial", (float)8.0f, (int)1, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentMidBold = FontFactory.getFont((String)"Arial", (float)7.0f, (int)1, (BaseColor)BaseColor.BLACK);
    public static final Font fontContentSmallBold = FontFactory.getFont((String)"Arial", (float)6.0f, (int)1, (BaseColor)BaseColor.BLACK);
    public static final Font fontTitTotales = FontFactory.getFont((String)"Arial", (float)8.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontDatosBig = FontFactory.getFont((String)"Arial", (float)8.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontDatos = FontFactory.getFont((String)"Arial", (float)7.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontDataBold = FontFactory.getFont((String)"Arial", (float)7.0f, (int)1, (BaseColor)BaseColor.BLACK);
    public static final Font fontData = FontFactory.getFont((String)"Arial", (float)5.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontPie = FontFactory.getFont((String)"TIMES_ROMAN", (float)6.0f, (int)0, (BaseColor)BaseColor.BLACK);
    public static final Font fontPieBold = FontFactory.getFont((String)"TIMES_ROMAN", (float)6.0f, (int)1, (BaseColor)BaseColor.BLACK);
    public static final Font fontHeader2 = FontFactory.getFont((String)"Arial", (float)6.0f, (int)1, (BaseColor)BaseColor.WHITE);
    public static final Font fontHeader3 = new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1, BaseColor.WHITE);
    public static final Font fontContentMidBoldCourier = new Font(Font.FontFamily.COURIER, 6.0f, 1, BaseColor.BLACK);
    public static final Font fontContentMidRojo = FontFactory.getFont((String)"Arial", (float)7.0f, (int)0, (BaseColor)BaseColor.RED);

    public static void celdaVacia(PdfPTable tabla, int ancho) {
        PdfPCell celda = new PdfPCell((Phrase)new Paragraph(" ", fontContentMid));
        celda.setBorder(0);
        celda.setColspan(ancho);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
    }

    public static void celdaTabla(PdfPTable tabla, Paragraph texto, int ancho, int borde, float altura, int alineacion) {
        PdfPCell celda = new PdfPCell((Phrase)new Paragraph((Phrase)texto));
        celda.setMinimumHeight(altura);
        switch (borde) {
            case 0: {
                celda.setBorder(0);
                break;
            }
            case 2: {
                celda.setBorderColor(BaseColor.BLUE);
                break;
            }
            case 1: {
                celda.setBorder(15);
                celda.setBorderColor(BaseColor.BLACK);
                break;
            }
        }
        celda.setColspan(ancho);
        celda.setHorizontalAlignment(alineacion);
        tabla.addCell(celda);
    }

    public static void celdaTabla(PdfPTable tabla, String texto, int ancho, int borde, float altura, Font font, int alineacion) {
        PdfPCell celda = new PdfPCell((Phrase)new Paragraph(texto, font));
        celda.setMinimumHeight(altura);
        switch (borde) {
            case 0: {
                celda.setBorder(0);
                break;
            }
            case 2: {
                celda.setBorderColor(BaseColor.BLUE);
                break;
            }
            case 1: {
                celda.setBorder(4);
                celda.setBorder(8);
                break;
            }
            case 3: {
                celda.setBorder(15);
                break;
            }
        }
        celda.setColspan(ancho);
        celda.setHorizontalAlignment(alineacion);
        tabla.addCell(celda);
    }

    public static void celdaTabla(PdfPTable tabla, String textoTitulo, Font fontTitulo, String textoDescripcion, Font fontDescripcion, int ancho, int borde, int alineacion) {
        PdfPCell celda = new PdfPCell();
        Paragraph paragraphTitulo = new Paragraph(textoTitulo, fontTitulo);
        Paragraph paragraphDescripcion = new Paragraph(textoDescripcion, fontDescripcion);
        celda.addElement((Element)paragraphTitulo);
        celda.addElement((Element)paragraphDescripcion);
        if (borde == 0) {
            celda.setBorder(0);
        }
        celda.setColspan(ancho);
        celda.setHorizontalAlignment(alineacion);
        tabla.addCell(celda);
    }

    public static void celdaTabla(PdfPTable tabla, String texto, Font fonttexto, BaseColor codigobg, int alineacion, int colapso, int borde) {
        PdfPCell celda = new PdfPCell();
        Paragraph parrafo = new Paragraph(texto, fonttexto);
        celda.addElement((Element)parrafo);
        parrafo.setAlignment(alineacion);
        celda.setColspan(colapso);
        celda.setBackgroundColor(codigobg);
        celda.setBorder(borde);
        celda.setBorderColor(BaseColor.BLUE);
        tabla.addCell(celda);
    }

    public static void celdaTabla(PdfPTable tabla, String texto, BaseColor codigobg, int alineacion, int colapso, BaseColor colorb, Font fonttexto) {
        PdfPCell celda = new PdfPCell();
        Paragraph parrafo = new Paragraph(texto, fonttexto);
        celda.addElement((Element)parrafo);
        parrafo.setAlignment(alineacion);
        celda.setColspan(colapso);
        celda.setBackgroundColor(codigobg);
        celda.setBorderColor(colorb);
        tabla.addCell(celda);
    }

    public static void celdaTabla(PdfPTable tabla, String texto, Font fonttexto, BaseColor codigobg, int alineacion, int colapso) {
        PdfPCell celda = new PdfPCell();
        Paragraph parrafo = new Paragraph(texto, fonttexto);
        celda.addElement((Element)parrafo);
        parrafo.setAlignment(alineacion);
        celda.setColspan(colapso);
        celda.setBackgroundColor(codigobg);
        tabla.addCell(celda);
    }

    public static void celdaDetalle(PdfPTable tabla, String texto, int ancho, int borde, Font font, int alineacion) {
        PdfPCell celda = new PdfPCell((Phrase)new Paragraph(texto, font));
        celda.setColspan(ancho);
        celda.setHorizontalAlignment(alineacion);
        celda.setPaddingTop(0.0f);
        celda.setPaddingBottom(2.0f);
        celda.setBorder(borde);
        tabla.addCell(celda);
    }
}

