/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPrintPage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class PdfImprimible {
    private File pdf;

    public PdfImprimible() {
    }

    public PdfImprimible(String ruta) {
        this(new File(ruta));
    }

    public PdfImprimible(File pdf) {
        this.pdf = pdf;
    }

    public void imprimir(int tipoConfiguracion) throws Exception {
        boolean imprime = false;
        FileChannel canal = new FileInputStream(this.pdf).getChannel();
        MappedByteBuffer bufer = canal.map(FileChannel.MapMode.READ_ONLY, 0L, canal.size());
        PDFFile archivoPdf = new PDFFile((ByteBuffer)bufer);
        PDFPrintPage paginas = new PDFPrintPage(archivoPdf);
        PrinterJob trabajo = PrinterJob.getPrinterJob();
        trabajo.setJobName(this.pdf.getName());
        Paper papel = new Paper();
        papel.setImageableArea(0.0, 0.0, papel.getWidth(), papel.getHeight());
        PageFormat formatoPaginas = PrinterJob.getPrinterJob().defaultPage();
        formatoPaginas.setPaper(papel);
        switch (tipoConfiguracion) {
            case 0: {
                imprime = true;
                break;
            }
            case 1: {
                formatoPaginas = PrinterJob.getPrinterJob().pageDialog(formatoPaginas);
                imprime = trabajo.printDialog();
                break;
            }
            case 2: {
                imprime = trabajo.printDialog();
            }
        }
        if (imprime) {
            formatoPaginas = trabajo.validatePage(formatoPaginas);
            Book libro = new Book();
            libro.append((Printable)paginas, formatoPaginas, archivoPdf.getNumPages());
            trabajo.setPageable(libro);
            trabajo.print();
        }
    }

    public File getPdf() {
        return this.pdf;
    }

    public void setPdf(File pdf) {
        this.pdf = pdf;
    }

    public void setPdf(String pdf) {
        this.setPdf(pdf);
    }
}

