/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.test;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.pdf.PDFBuilder;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class testPDF {
    private int empNum;
    private int numComprobante;
    private ConfiguracionDTO configuracion;
    private ComprobanteDTO comprobante;
    public String path;
    public String modo;
    private int preview;
    public String tipoDoc;
    public int envios;
    public int cierraConexion;
    private BDUtil bdUtil;
    public static String certificado;

    public testPDF(int empNum, int numComprobante, String path, String mail, BDUtil bdUtil, int cierraConexion, String modo, String tipoDoc, int envios, int preview, String pNombrePDF) {
        this.empNum = empNum;
        this.numComprobante = numComprobante;
        this.path = path;
        this.bdUtil = bdUtil;
        this.cierraConexion = cierraConexion;
        this.modo = modo;
        this.tipoDoc = tipoDoc;
        this.envios = envios;
        this.preview = preview;
        String vNombrePDF = pNombrePDF;
        if (pNombrePDF != null) {
            vNombrePDF = pNombrePDF.replace(".txt", "").replace(".xml", "");
        }
        this.generaPDF(vNombrePDF);
    }

    public static void main(String[] args) throws IOException, DocumentException, GeneralSecurityException {
        System.out.println(String.valueOf(args[0]) + " " + args[8]);
        LeeConexion.path = args[1];
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
            System.out.println("Se establecio conexion");
        }
        catch (Exception exception) {
            // empty catch block
        }
        new testPDF(Integer.parseInt(args[0]), Integer.parseInt(args[8]), args[1], args[2], bdUtil, Integer.parseInt(args[3]), args[4], args[5], Integer.parseInt(args[6]), Integer.parseInt(args[7]), args[9]);
    }

    private void generaPDF(String pNombrePDF) {
        String nombreArchivo = "";
        this.configuracion = new ConfiguracionDTO();
        this.comprobante = new ComprobanteDTO(this.numComprobante);
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        ComprobantesDAO comprobantesDAO = null;
        configDAO.llenarConfiguracion(this.bdUtil, this.configuracion, this.empNum);
        comprobantesDAO = new ComprobantesDAO(this.configuracion.getRutaSalidaTimbre());
        comprobantesDAO.llenarComprobante(this.bdUtil, this.comprobante);
        System.out.println("Tipo documento: " + this.tipoDoc + " Modo " + this.modo);
        PDFBuilder builder = new PDFBuilder(this.comprobante, this.configuracion, this.tipoDoc, this.modo, this.preview, "SI");
        nombreArchivo = builder.creaPDF(pNombrePDF);
        CfdEmisionDAO pCfdEmision = new CfdEmisionDAO();
        pCfdEmision.actualizarRutaPDF(this.bdUtil, this.comprobante.getUUID(), nombreArchivo, this.tipoDoc);
        System.out.println("nombreArchivo PDF creado: " + nombreArchivo);
        if (this.cierraConexion == 1) {
            this.bdUtil.cerrarConexion();
        }
        System.out.println("termino de generar PDF");
    }

    private void enviarCorreoNomina(String nombreArchivo, String correo) {
        if (correo != null && !correo.equals("@") && this.comprobante.getUUID() != null) {
            EnvioCorreo email = new EnvioCorreo(this.bdUtil, this.configuracion);
            String subject = "Recibo de la nomina " + this.comprobante.getFolioDoc() + "-" + this.comprobante.getNombreReceptor();
            if (this.modo.equals("TEST")) {
                subject = "TEST " + subject;
            }
            String mensajeCorreo = "Estimado colaborador,\n\nSERVICIOS INTEGRADOS EN TECNOLOGIA DE INFORMACION emiti\u00ef\u00bf\u00bd para Usted un Comprobante Fiscal Digital por Internet.\n\nRecibo " + this.comprobante.getFolioDoc() + "\n" + "Factura electr\u00ef\u00bf\u00bdnica " + this.comprobante.getUUID() + "\n\n" + "Este correo y todos los archivos transmitidos son confidenciales y dirigidos a la persona especificada.\n\n" + "Si recibi\u00ef\u00bf\u00bd este correo por error o los datos de facturaci\u00ef\u00bf\u00bdn no coinciden, favor de notificarlo a:\n\n" + "\n" + "Se envia archivo electronico de CFDI conforme a lo se\u00ef\u00bf\u00bdalado por el LISR\n" + "NO RESPONDER AL PRESENTE, ES S\u00ef\u00bf\u00bdLO INFORMATIVO\n\n";
            System.out.println(String.valueOf(correo) + " " + nombreArchivo + " " + this.comprobante.getTipoDoc());
            email.generarCorreoFactura(correo, nombreArchivo, mensajeCorreo, subject, this.envios, this.comprobante.getVersion(), this.comprobante.getTipoDoc(), this.comprobante.getFolioDoc());
        }
    }
}

