/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.ParametroCFDConnectDAO;
import siti.sinco.cfdi.dto.CfdEmisionDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;

public class EnvioCorreo {
    private ConfiguracionDTO configuracion;
    private Properties props;
    private BDUtil bdUtil;

    public EnvioCorreo(BDUtil bdUtil, ConfiguracionDTO configuracion) {
        this.bdUtil = bdUtil;
        this.configuracion = configuracion;
    }

    public void setConfigCorreo() {
        this.props = new Properties();
        this.props.setProperty("mail.smtp.starttls.enable", "true");
        this.props.setProperty("mail.smtp.ssl.trust", this.configuracion.getIpServidorCorreo());
        this.props.setProperty("mail.smtp.user", this.configuracion.getEmailOrigen());
        this.props.setProperty("mail.smtp.password", this.configuracion.getPassEmailOrigen());
        this.props.setProperty("mail.smtp.port", this.configuracion.getPuertoServidorCorreo());
        this.props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
        this.props.setProperty("mail.smtp.auth", "true");
    }

    public void generarCorreoFactura(String mail, String nombreArchivo, String mensaje, String asunto, int noArchivos, String versionCFD, String tipoDoc, String folioDoc) {
        try {
            this.setConfigCorreo();
            Session session = Session.getDefaultInstance((Properties)this.props, null);
            MimeBodyPart texto = new MimeBodyPart();
            texto.setText(mensaje);
            MimeBodyPart adjunto = new MimeBodyPart();
            MimeBodyPart adjunto2 = null;
            if (noArchivos == 2) {
                adjunto2 = new MimeBodyPart();
            }
            if (!nombreArchivo.equals("")) {
                String nombreCompletoPDF = String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaPdf(tipoDoc) + File.separator + nombreArchivo + ".pdf";
                String nombreCompletoXML = "";
                nombreCompletoXML = versionCFD.equals("3.2") || versionCFD.equals("3.3") ? String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaTimbre(tipoDoc, folioDoc) + File.separator + "SIGN_" + nombreArchivo + ".xml" : String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaTimbre(tipoDoc, folioDoc) + File.separator + nombreArchivo + ".xml";
                System.out.println("nombreCompletoXML" + nombreCompletoXML);
                if (noArchivos == 0) {
                    adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoPDF)));
                    adjunto.setFileName(String.valueOf(nombreArchivo) + ".pdf");
                } else if (noArchivos == 1) {
                    adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoXML)));
                    adjunto.setFileName(String.valueOf(nombreArchivo) + ".xml");
                }
                if (noArchivos == 2) {
                    adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoPDF)));
                    adjunto.setFileName(String.valueOf(nombreArchivo) + ".pdf");
                    adjunto2.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoXML)));
                    adjunto2.setFileName(String.valueOf(nombreArchivo) + ".xml");
                }
            }
            MimeMultipart multiParte = new MimeMultipart();
            multiParte.addBodyPart((BodyPart)texto);
            if (!nombreArchivo.equals("")) {
                multiParte.addBodyPart((BodyPart)adjunto);
                if (noArchivos == 2) {
                    multiParte.addBodyPart((BodyPart)adjunto2);
                }
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.configuracion.getEmailOrigen()));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mail));
            message.setSubject(asunto);
            message.setContent((Multipart)multiParte);
            Transport t = session.getTransport("smtp");
            t.connect(this.configuracion.getEmailOrigen(), this.configuracion.getPassEmailOrigen());
            t.sendMessage((Message)message, message.getAllRecipients());
            t.close();
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "generarCorreoFactura", e.toString(), "ERROR JAVA");
        }
    }

    public void enviarCorreoNomina(ComprobanteDTO comprobante, String nombreArchivo, String correo, String modo) {
        if (correo != null && !correo.equals("@") && comprobante.getUUID() != null) {
            String subject = "Recibo de la nomina " + comprobante.getFolioDoc() + "-" + comprobante.getNombreReceptor();
            if (modo.equals("TEST")) {
                subject = "TEST " + subject;
            }
            String mensajeCorreo = "Estimado colaborador,\n\nSERVICIOS INTEGRADOS EN TECNOLOGIA DE INFORMACION emiti\u00f3 para Usted un Comprobante Fiscal Digital por Internet.\n\nRecibo " + comprobante.getFolioDoc() + "\n" + "Factura electr\u00f3nica " + comprobante.getUUID() + "\n\n" + "Este correo y todos los archivos transmitidos son confidenciales y dirigidos a la persona especificada.\n\n" + "Si recibi\u00f3 este correo por error o los datos de facturaci\u00f3n no coinciden, favor de notificarlo a:\n\n" + "Se envia archivo electronico de CFDI conforme a lo se\u00f1alado por el LISR\n" + "NO RESPONDER AL PRESENTE, ES S\u00d3LO INFORMATIVO\n\n";
            System.out.println(String.valueOf(correo) + " " + nombreArchivo + " " + comprobante.getTipoDoc());
            this.generarCorreoFactura(correo, nombreArchivo, mensajeCorreo, subject, 0, comprobante.getVersion(), comprobante.getTipoDoc(), comprobante.getFolioDoc());
        }
    }

    public void enviarCorreoGenerico(String mail, String nombreCompletoArchivo, String mensaje, String asunto) {
        try {
            this.setConfigCorreo();
            Session session = Session.getDefaultInstance((Properties)this.props, null);
            MimeBodyPart texto = new MimeBodyPart();
            texto.setText(mensaje);
            MimeBodyPart adjunto = new MimeBodyPart();
            if (!nombreCompletoArchivo.equals("")) {
                adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoArchivo)));
                adjunto.setFileName(nombreCompletoArchivo);
            }
            MimeMultipart multiParte = new MimeMultipart();
            multiParte.addBodyPart((BodyPart)texto);
            if (!nombreCompletoArchivo.equals("")) {
                multiParte.addBodyPart((BodyPart)adjunto);
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.configuracion.getEmailOrigen()));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mail));
            message.setSubject(asunto);
            message.setContent((Multipart)multiParte);
            Transport t = session.getTransport("smtp");
            t.connect(this.configuracion.getEmailOrigen(), this.configuracion.getPassEmailOrigen());
            t.sendMessage((Message)message, message.getAllRecipients());
            t.close();
            System.out.println("Se envio correo a " + mail);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "enviarCorreoGenerico", e.toString(), "ERROR JAVA");
        }
    }

    public void enviarCorreoGenerico2(String[] mails, String nombreCompletoArchivo, String mensaje, String asunto, String pNombreEmisor) {
        try {
            this.setConfigCorreo();
            Session session = Session.getDefaultInstance((Properties)this.props, null);
            MimeBodyPart texto = new MimeBodyPart();
            texto.setText(mensaje);
            MimeBodyPart html = new MimeBodyPart();
            String htmlS = "<!DOCTYPE html><html lang='es'>    <head>        <meta charset='UTF-8'>        <meta http-equiv='X-UA-Compatible' content='IE=edge'>        <meta name='viewport' content='width=device-width, initial-scale=1.0'>        <title>SI-TI Emails</title>        <style type='text/css'>        *{            font-family: Helvetica,Verdana, sans-serif,Arial;        }        p{            padding-left: 15px;            padding-right: 15px;        }        .normalizar{            padding-left: 5%;        }        .centrarV{            display: flex;            align-items: center;        }        </style>    </head>    <body style=\"background-color:#D6DBDF; padding-top:50px; padding-bottom:50px;\">        <table align='center' style='text-align:center; width: 90%; box-shadow: 0px 0px 5px 2px #888888; background-color: white; border-radius: 10px; padding-top: 20px; padding-bottom: 20px; '>            <tr>                <td>                    <div style='display: flex; align-items: center; justify-content:first baseline; padding-left: 5%;'>                        <img src='https://mediport.puertomazatlan.com.mx/Imagenes/LogoAPIMazLogin1.jpg' width='75px' height='75px' style='border-radius: 10px;'>                        <h3>" + pNombreEmisor + "</h3>" + "                    </div>" + "                </td>" + "            </tr>" + "            <tr>                <td align='center' width= '90%' valign='center' style='text-align: center;'><div style='background-color: gray; width: 100%; height: 3px; border-radius: 10px; '></div></td>            </tr>" + "            <tr>" + "                <td>" + "                    <div class='normalizar'>" + mensaje + "                    </div>" + "                </td>" + "            </tr>" + "            <tr>                <td align='center' width= '90%' valign='center' style='text-align: center;'><div style='background-color: gray; width: 100%; height: 3px; border-radius: 10px; '></div></td>            </tr>" + "        </table>" + "    </body>" + "</html>";
            html.setContent((Object)htmlS, "text/html; charset=utf-8");
            MimeMultipart multipart = new MimeMultipart("related");
            multipart.addBodyPart((BodyPart)html);
            if (!nombreCompletoArchivo.equals("")) {
                String[] listaArchivos = nombreCompletoArchivo.split(";");
                int numArchivos = listaArchivos.length;
                int i = 0;
                while (i < numArchivos) {
                    File archivoF = new File(listaArchivos[i]);
                    if (archivoF.exists()) {
                        MimeBodyPart archivoM = new MimeBodyPart();
                        archivoM.setDataHandler(new DataHandler((DataSource)new FileDataSource(archivoF.getAbsolutePath())));
                        archivoM.setFileName(archivoF.getName());
                        multipart.addBodyPart((BodyPart)archivoM);
                    }
                    ++i;
                }
                multipart.setSubType("mixed");
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.configuracion.getEmailOrigen()));
            message.setSubject(asunto);
            message.setContent((Multipart)multipart);
            int i = 0;
            while (i < mails.length) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mails[i]));
                System.out.println(mails[i]);
                ++i;
            }
            Transport t = session.getTransport("smtp");
            t.connect(this.configuracion.getIpServidorCorreo(), this.configuracion.getEmailOrigen(), this.configuracion.getPassEmailOrigen());
            t.sendMessage((Message)message, message.getAllRecipients());
            t.close();
            System.out.println("\u00a1Se ha enviado el correo de forma exitosa!");
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "enviarCorreoGenerico2", e.toString(), "ERROR JAVA");
        }
    }

    public void enviaCorreoCancelacion(String mensaje, String destinatarios, String pNombreEmisor) {
        String archivo = "";
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "NOTIFICACIONES MAIL");
        String[] destinatariosArray = null;
        destinatariosArray = destinatarios.isEmpty() ? parametro.obtenparametro(this.bdUtil, "mail.recipients_siti", "NOTIFICACIONES MAIL").split(";") : destinatarios.split(";");
        System.out.println("Enviando correo a " + destinatarios);
        envio.enviarCorreoGenerico2(destinatariosArray, archivo, mensaje, subject, pNombreEmisor);
    }

    public void enviarCorreo(String pDestinatarios, String pAsunto, String pMensaje, String pArchivos, String pNombreEmisor) {
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "NOTIFICACIONES MAIL");
        String[] destinatariosArray = null;
        destinatariosArray = pDestinatarios.isEmpty() ? parametro.obtenparametro(this.bdUtil, "mail.recipients_siti", "NOTIFICACIONES MAIL").split(";") : pDestinatarios.split(";");
        String vArchivos = "";
        if (!pArchivos.isEmpty()) {
            vArchivos = pArchivos;
        }
        System.out.println("Enviando correo a " + pDestinatarios);
        envio.enviarCorreoGenerico2(destinatariosArray, vArchivos, pMensaje, String.valueOf(subject) + " | " + pAsunto, pNombreEmisor);
    }

    public void enviarCorreoMONITOR(String pDestinatarios, String pAsunto, String pMensaje, String pArchivos, String pNombreEmisor) {
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "NOTIFICACIONES MAIL");
        String[] destinatariosArray = null;
        if (pDestinatarios.isEmpty()) {
            destinatariosArray = pAsunto.toUpperCase().contains("DETUVO") || pAsunto.toUpperCase().contains("PROCESO") || pAsunto.toUpperCase().contains("INEXISTENTES") ? parametro.obtenparametro(this.bdUtil, "mail.recipients_monitor", "NOTIFICACIONES MAIL").split(";") : pDestinatarios.split(";");
        }
        String vArchivos = "";
        if (!pArchivos.isEmpty()) {
            vArchivos = pArchivos;
        }
        System.out.println("Enviando correo a " + pDestinatarios);
        envio.enviarCorreoGenerico2(destinatariosArray, vArchivos, pMensaje, String.valueOf(subject) + " | " + pAsunto, pNombreEmisor);
    }

    public static void reenvio(String pFolio, String pSerie) {
        BDUtil bdUtil = new BDUtil();
        int vTipoEnvio = 2;
        try {
            bdUtil.setConexion();
            ConfiguracionDTO configuracionDTO = new ConfiguracionDTO();
            ConfiguracionDAO configDAO = new ConfiguracionDAO();
            configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
            ArrayList<Object> listaAComprobar = new ArrayList();
            listaAComprobar = CfdEmisionDAO.getCFDISAReenviarArchivos(bdUtil, pFolio, pSerie);
            for (CfdEmisionDTO cfdEmisionDTO : listaAComprobar) {
                String vArchivos = "";
                String vSubmensaje = "";
                if (cfdEmisionDTO.getSERIE().toUpperCase().equals("N")) {
                    vSubmensaje = " la nota de cr\u00e9dito ";
                } else if (cfdEmisionDTO.getSERIE().toUpperCase().equals("F")) {
                    vSubmensaje = " la factura ";
                } else if (cfdEmisionDTO.getSERIE().toUpperCase().equals("C")) {
                    vSubmensaje = " el complemento de pago ";
                }
                String vMensaje = "<h3>" + cfdEmisionDTO.getRFCRECEPTOR() + " - " + cfdEmisionDTO.getNOMBRERECEPTOR() + "</h3>" + "<p>Se ha timbrado " + vSubmensaje + " <b>" + cfdEmisionDTO.getFOLIO() + "</b>" + " y ha obtenido el folio fiscal: <br><b>" + cfdEmisionDTO.getUUID().toUpperCase() + "</b></br>" + "</p><br>";
                if (vTipoEnvio != 3) {
                    switch (vTipoEnvio) {
                        case 0: {
                            vArchivos = EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTAPDF());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF relacionado</p>";
                            break;
                        }
                        case 1: {
                            vArchivos = EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTACFD());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el CFDI relacionado</p>";
                            break;
                        }
                        case 2: {
                            vArchivos = String.valueOf(EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTAPDF())) + ";" + EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTACFD());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF y el CFDI relacionado</p>";
                        }
                    }
                }
                System.out.println("Archivos: " + vArchivos);
                EnvioCorreo correo = new EnvioCorreo(bdUtil, configuracionDTO);
                correo.enviarCorreo(cfdEmisionDTO.getCorreoReceptor(), "TIMBRADO", vMensaje, vArchivos, cfdEmisionDTO.getNOMBREEMISOR());
                System.out.println("\u00c9XITO. Se reenvi\u00f3 de forma exitosa el correo de folio: " + pFolio + " de serie: " + pSerie);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println("ERROR. NO se pudo reenviar el correo a " + pFolio + " de serie:" + pSerie + ". Favor de intentarlo mas tarde.");
        }
    }

    public static String nvlArchivo(String pArchivo) {
        String vValor = "";
        if (pArchivo != null) {
            vValor = pArchivo;
        }
        return vValor;
    }
}

