/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.contaElec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import siti.sinco.contaElec.CreaArchivo;
import siti.sinco.contaElec.Utilerias;
import siti.sinco.contaElec.dto.CabeceraContablesDTO;
import siti.sinco.contaElec.dto.ContablesDTO;

public class ContablesXml {
    public ArrayList<ContablesDTO> obtenerListaTXT(String pRutaLista) {
        String vLinea = "";
        File vRutaLista = new File(pRutaLista);
        ArrayList<ContablesDTO> listaCuentas = new ArrayList<ContablesDTO>();
        if (vRutaLista.exists()) {
            if (vRutaLista.isFile()) {
                BufferedReader br = null;
                try {
                    try {
                        FileReader fr = new FileReader(pRutaLista);
                        br = new BufferedReader(fr);
                        vLinea = br.readLine();
                        String vLineaAux = null;
                        String vDescrip = null;
                        int comillaInicial = 0;
                        int comillaFinal = 0;
                        ContablesDTO contablesDTO = new ContablesDTO();
                        while (vLinea != null) {
                            if (!(vLinea.length() <= 1 || vLinea.contains("Codigo agrupador") && vLinea.contains("contanaturaleza"))) {
                                if (vLinea.contains("\"")) {
                                    comillaInicial = vLinea.indexOf(",\"");
                                    vLineaAux = vLinea.substring(comillaInicial + 1, vLinea.length());
                                    comillaFinal = vLineaAux.indexOf("\",");
                                    vDescrip = vLinea.substring(comillaInicial + 2, comillaInicial + 1 + comillaFinal).replace(",", "");
                                    vLinea = String.valueOf(vLinea.substring(0, comillaInicial)) + "," + vDescrip + "," + vLinea.substring(comillaInicial + 2 + comillaFinal + 1, vLinea.length());
                                }
                                System.out.println(vLinea);
                                if (vLinea.split(",").length == 6) {
                                    contablesDTO = new ContablesDTO();
                                    String[] vDatos = vLinea.split(",");
                                    contablesDTO.setCodAgrup(vDatos[0]);
                                    contablesDTO.setNumCta(vDatos[1]);
                                    contablesDTO.setDescripcion(vDatos[2]);
                                    contablesDTO.setSubCtaDe(vDatos[3]);
                                    contablesDTO.setNivel(Integer.parseInt(vDatos[4]));
                                    contablesDTO.setNatur(vDatos[5]);
                                    listaCuentas.add(contablesDTO);
                                }
                            }
                            vLinea = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Ocurri\u00f3 un error a la hora de leer el archivo: " + vLinea + e.toString());
                        try {
                            if (br != null) {
                                br.close();
                            }
                        }
                        catch (Exception e2) {
                            System.out.println("Sucedi\u00f3 un error al intentar el archivo: " + vLinea + e2.getMessage());
                        }
                    }
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Sucedi\u00f3 un error al intentar el archivo: " + vLinea + e.getMessage());
                    }
                }
                return listaCuentas;
            }
            System.out.println("La ruta de la lista no existe.");
        }
        return listaCuentas;
    }

    public void generaXML(String pRutaDestino, String pRutaTXT, String pRFC, String pVersion, String pEjercicio, String pPeriodo) {
        CabeceraContablesDTO cabeceraDto = new CabeceraContablesDTO();
        String sufijoCuentas = "CT";
        cabeceraDto.setAnio(pEjercicio);
        cabeceraDto.setMes(pPeriodo);
        cabeceraDto.setRfc(pRFC);
        cabeceraDto.setVersion(pVersion);
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Namespace catalogo = Namespace.getNamespace((String)"catalogocuentas", (String)"http://www.sat.gob.mx/esquemas/ContabilidadE/1_3/CatalogoCuentas");
        Element elementoRaiz = new Element("Catalogo", catalogo);
        elementoRaiz.setAttribute("schemaLocation", "http://www.sat.gob.mx/esquemas/ContabilidadE/1_3/CatalogoCuentas http://www.sat.gob.mx/esquemas/ContabilidadE/1_3/CatalogoCuentas/CatalogoCuentas_1_3.xsd", xsi);
        elementoRaiz.setAttribute("Version", cabeceraDto.getVersion());
        elementoRaiz.setAttribute("RFC", cabeceraDto.getRfc());
        elementoRaiz.setAttribute("Mes", cabeceraDto.getMes());
        elementoRaiz.setAttribute("Anio", cabeceraDto.getAnio());
        ArrayList<ContablesDTO> listaContables = this.obtenerListaTXT(pRutaTXT);
        cabeceraDto.setListaContables(listaContables);
        ContablesDTO cuentaDto = new ContablesDTO();
        int renglon = 0;
        while (renglon < listaContables.size()) {
            cuentaDto = listaContables.get(renglon);
            Element ctaElem = new Element("Ctas", catalogo);
            ctaElem.setAttribute("Natur", cuentaDto.getNatur());
            ctaElem.setAttribute("Nivel", String.valueOf(cuentaDto.getNivel()));
            Utilerias.setElementoOpcional("SubCtaDe", cuentaDto.getSubCtaDe(), ctaElem);
            ctaElem.setAttribute("NumCta", cuentaDto.getNumCta());
            ctaElem.setAttribute("CodAgrup", cuentaDto.getCodAgrup());
            ctaElem.setAttribute("Desc", cuentaDto.getDescripcion());
            elementoRaiz.addContent((Content)ctaElem);
            ++renglon;
        }
        String[] aux = pRutaTXT.replace("\\", "/").split("/");
        String vNombreArchivo = aux[aux.length - 1];
        new CreaArchivo().creaXml(pRutaDestino, elementoRaiz, cabeceraDto, sufijoCuentas, vNombreArchivo);
    }
}

