/*
 * Decompiled with CFR 0.152.
 */
package siti.conexion;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import siti.conexion.BDResultados;
import siti.conexion.DriverUtil;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;

public class BDUtil {
    public Connection connection;
    public Statement statement;
    public ResultSet resultSet;
    public CallableStatement callStatement;
    public String Modo;

    public void setConexion() throws ClassNotFoundException, SQLException {
        try {
            LeeConexion lc = new LeeConexion();
            lc.leerConexion();
            String URL2 = DriverUtil.makeURL(lc.host, lc.puerto, lc.baseDatos, 1);
            Class.forName(DriverUtil.getDriver(1));
            this.connection = DriverManager.getConnection(URL2, lc.usuario, lc.password);
            this.Modo = lc.host.equals("172.16.250.205") ? "PROD" : "TEST";
        }
        catch (ClassNotFoundException e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "setConexion", e.toString(), "ERROR JAVA");
            throw new ClassNotFoundException();
        }
        catch (SQLException e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "setConexion", e.toString(), "ERROR ORA");
            e.printStackTrace();
            throw new SQLException();
        }
    }

    public Connection getConexion() {
        return this.connection;
    }

    public void cerrarConexion() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "cerrarConexion", e.toString(), "ERROR ORA");
        }
        this.connection = null;
    }

    public BDResultados getResultadosQuery(String query) throws SQLException {
        DatabaseMetaData dbMetaData = this.connection.getMetaData();
        String productName = dbMetaData.getDatabaseProductName();
        String productVersion = dbMetaData.getDatabaseProductVersion();
        this.statement = this.connection.createStatement();
        this.resultSet = this.statement.executeQuery(query);
        ResultSetMetaData resultsMetaData = this.resultSet.getMetaData();
        int cuentaColumnas = resultsMetaData.getColumnCount();
        String[] nombresColumnas = new String[cuentaColumnas];
        int i = 1;
        while (i < cuentaColumnas + 1) {
            nombresColumnas[i - 1] = resultsMetaData.getColumnName(i).trim();
            ++i;
        }
        BDResultados bdResultados = new BDResultados(this.connection, productName, productVersion, cuentaColumnas, nombresColumnas);
        while (this.resultSet.next()) {
            String[] renglon = new String[cuentaColumnas];
            int i2 = 1;
            while (i2 < cuentaColumnas + 1) {
                String entry = this.resultSet.getString(i2);
                if (entry != null) {
                    entry = entry.trim();
                }
                renglon[i2 - 1] = entry;
                ++i2;
            }
            bdResultados.agregaRenglon(renglon);
        }
        this.statement.close();
        this.resultSet.close();
        this.statement = null;
        this.resultSet = null;
        return bdResultados;
    }

    public int ejecutaSentencia(String sentencia) throws SQLException {
        int numRegistros = 0;
        this.statement = this.connection.createStatement();
        numRegistros = this.statement.executeUpdate(sentencia);
        this.statement.close();
        this.statement = null;
        return numRegistros;
    }

    public void ejecutaProcedure(String sentencia, ArrayList<String> parametros) throws SQLException {
        this.callStatement = this.connection.prepareCall(sentencia);
        int cont = 0;
        Iterator<String> i = parametros.iterator();
        while (i.hasNext()) {
            this.callStatement.setString(++cont, i.next().toString());
        }
        this.callStatement.execute();
    }
}

