/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextArea;
import org.datacontract.schemas._2004._07.Sat_Cfdi_Negocio_ConsultaCfdi_Servicio.Acuse;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.sinco.cfdi.dao.CfdiCanceladosDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.ParametroCFDConnectDAO;
import siti.sinco.cfdi.dto.CFDICanceladosDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.CfdiCliente;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class VerificaCancelacionSAT
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String modo;

    public VerificaCancelacionSAT(JTextArea pTextArea, int numHoras, int empNum, String modo) {
        this.textArea = pTextArea;
        this.intervalo = numHoras * 3600 * 1000;
        this.empNum = empNum;
        this.modo = modo;
        this.start();
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        String mensajeInterfaz = "Se detendra el proceso en el siguiente ciclo";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        ConfiguracionDTO configuracionDTO = null;
        String mensajeInterfaz = "";
        try {
            bdUtil.setConexion();
        }
        catch (Exception e) {
            System.out.println("No se estableci\u00f3 la conexi\u00f3n.");
        }
        try {
            this.proc = bdUtil.connection.prepareCall("{ call registraHorasMonitor(?)}");
            this.proc.setInt(1, 2);
        }
        catch (SQLException e) {
            mensajeInterfaz = "Error en registrar el procedimiento" + e.getMessage();
            EscritorInterfaz.escribeEnTextArea(this.textArea, "Error en registrar el procedimiento" + e.getMessage());
            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "ERROR ORA");
        }
        configuracionDTO = new ConfiguracionDTO();
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
        CFDICanceladosDTO cfdiCanceladoDTO = new CFDICanceladosDTO();
        CfdiCanceladosDAO canceladosDAO = new CfdiCanceladosDAO();
        CfdiCliente cfdiCliente = new CfdiCliente();
        Acuse acuse = null;
        EnvioCorreo envioCorreo = new EnvioCorreo(bdUtil, configuracionDTO);
        String expresion = "";
        while (this.bandera == 1) {
            EscritorInterfaz.escribeEnTextArea(this.textArea, "proceso activado " + Fecha.generaFecha());
            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
            try {
                mensajeInterfaz = "Iniciando consulta ante el SAT " + Fecha.horaEjecucion();
                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                ArrayList<CFDICanceladosDTO> lista = canceladosDAO.obtenerComprobantesAVerificarSAT(bdUtil, "CA");
                Iterator<CFDICanceladosDTO> itera = lista.iterator();
                ArrayList<String> listaVigentes = new ArrayList<String>();
                ArrayList<String> listaCancelados = new ArrayList<String>();
                ArrayList<String> listaOtros = new ArrayList<String>();
                String mensajeGen = "";
                int total = lista.size();
                int porcentaje = 0;
                while (itera.hasNext()) {
                    cfdiCanceladoDTO = itera.next();
                    expresion = "re=" + cfdiCanceladoDTO.getRfcEmisor() + "&rr=" + cfdiCanceladoDTO.getRfcReceptor() + "&tt=" + cfdiCanceladoDTO.getTotal() + "&id=" + cfdiCanceladoDTO.getUuid();
                    acuse = cfdiCliente.consultaServicioCancelacionSAT(expresion);
                    mensajeGen = String.valueOf(acuse.getEstado()) + "\t Factura:" + cfdiCanceladoDTO.getFactura() + "\t Folio:" + cfdiCanceladoDTO.getFolio() + "\t UUID:" + cfdiCanceladoDTO.getUuid();
                    if (acuse.getEstado().contains("Cancelado")) {
                        listaCancelados.add(mensajeGen);
                    } else if (acuse.getEstado().contains("Vigente")) {
                        listaVigentes.add(mensajeGen);
                        String mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Verificaci\u00f3n de cancelaci\u00f3n</h3><p>El sistema puso el comprobante con status <b>CANCELADO</b> pero ante el SAT est\u00e1 vigente.</p><div style=\"padding:0% 10%;\"><p><b>RFC Emisor</b>.....:  " + cfdiCanceladoDTO.getRfcEmisor() + "<br>" + "<b>RFC Receptor</b>.:  " + cfdiCanceladoDTO.getRfcReceptor() + "<br>" + "<b>Total</b>...............:  " + cfdiCanceladoDTO.getTotal() + "<br>" + "<b>UUID</b>...............:  " + cfdiCanceladoDTO.getUuid().toUpperCase() + "</p>" + "</div>" + "<p>NOTA: La cancelaci\u00f3n puede reflejarse en unas horas, por lo que este correo es puramente informativo.</p>" + "</div>";
                        String vAsunto = " Verificaci\u00f3n de cancelaci\u00f3n SAT - " + cfdiCanceladoDTO.getFolio();
                        String vRutasArchivo = "";
                        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
                        String destinatarios = parametro.obtenparametro(bdUtil, "mail.recipients_monitor", "NOTIFICACIONES MAIL");
                        envioCorreo.enviarCorreo(destinatarios, vAsunto, mensajeCorreo, vRutasArchivo, cfdiCanceladoDTO.getNombreEmisor());
                    } else {
                        listaOtros.add(mensajeGen);
                    }
                    mensajeInterfaz = String.valueOf(++porcentaje) + "/" + total + ". Factura consultada: " + cfdiCanceladoDTO.getFactura();
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                }
                lista = null;
                itera = null;
                mensajeInterfaz = "";
                int i = 0;
                while (i < listaVigentes.size()) {
                    mensajeInterfaz = String.valueOf(mensajeInterfaz) + (String)listaVigentes.get(i) + "\n ";
                    ++i;
                }
                i = 0;
                while (i < listaCancelados.size()) {
                    mensajeInterfaz = String.valueOf(mensajeInterfaz) + (String)listaCancelados.get(i) + "\n ";
                    ++i;
                }
                i = 0;
                while (i < listaOtros.size()) {
                    mensajeInterfaz = String.valueOf(mensajeInterfaz) + (String)listaOtros.get(i) + "\n ";
                    ++i;
                }
                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                mensajeInterfaz = "--- Ultima consulta ante el SAT " + Fecha.horaEjecucion();
                System.out.println(mensajeInterfaz);
                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                Thread.currentThread();
                Thread.sleep(this.intervalo);
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.toString());
            }
        }
        mensajeInterfaz = "PROCESO TERMINADO";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }
}

