/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import siti.sinco.cfdi.dto.CfdImpuestosDTO;
import siti.sinco.cfdi.dto.ComplementoPagoDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.DoctoRelacionadoPagoDTO;
import siti.sinco.cfdi.dto.Sat_ComplementoPagoTotalesDTO;
import siti.sinco.cfdi.tools.EscribeSalidaProcesos;

public class PagoDAO {
    private ComprobanteDTO comprobante;

    public PagoDAO(ComprobanteDTO comprobante) {
        this.comprobante = comprobante;
    }

    public void leerComplementoPago(Connection conexion, String where) throws Exception {
        String vPaso = "";
        String query = "SELECT comprobante, pagoNum, versionNum, \t\tfechaPago, formaDePagoP, monedaP, \t\ttipoCambioP, monto, numOperacion, \t\trfcEmisorCtaOrd, nomBancoOrdExt, ctaOrdenante, \t\trfcEmisorCtaBen, ctaBeneficiario, emis_recep, bancoreceptor FROM   SAT_COMPLEMENTOPAGO " + where + " " + "ORDER BY pagoNum";
        EscribeSalidaProcesos.Log("SELECT de leerComplementoPago: " + query);
        PreparedStatement ps = conexion.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        ComplementoPagoDTO pago = null;
        try {
            try {
                while (rs.next()) {
                    pago = new ComplementoPagoDTO();
                    pago.setComprobante(rs.getInt("comprobante"));
                    pago.setPagoNum(rs.getInt("pagoNum"));
                    pago.setVersionPago(rs.getString("versionNum"));
                    pago.setFechaPago(rs.getString("fechaPago"));
                    pago.setFormaDePagoP(rs.getString("formaDePagoP"));
                    pago.setMonedaP(rs.getString("monedaP"));
                    pago.setTipoCambioP(rs.getString("tipoCambioP"));
                    pago.setMonto(rs.getString("monto"));
                    pago.setNumOperacion(rs.getString("numOperacion"));
                    pago.setRfcEmisorCtaOrd(rs.getString("rfcEmisorCtaOrd"));
                    pago.setNomBancoOrdExt(rs.getString("nomBancoOrdExt"));
                    pago.setCtaOrdenante(rs.getString("ctaOrdenante"));
                    pago.setRfcEmisorCtaBen(rs.getString("rfcEmisorCtaBen"));
                    pago.setCtaBeneficiario(rs.getString("ctaBeneficiario"));
                    pago.setEmisRecep(rs.getString("emis_recep"));
                    pago.setBancoReceptor(rs.getString("bancoreceptor"));
                    if (this.comprobante.getVersion().equals("4.0")) {
                        Sat_ComplementoPagoTotalesDTO totales = null;
                        vPaso = "Obteniendo TOTALES";
                        String queryTotales = "SELECT COMPROBANTE\t\t\t\t , TOTALRETENCIONESIVA\t\t\t, TOTALRETENCIONESISR, TOTALRETENCIONESIEPS\t\t , TOTALTRASLADOSBASEIVA16\t\t, TOTALTRASLADOSIMPUESTOIVA16, TOTALTRASLADOSBASEIVA8\t , TOTALTRASLADOSIMPUESTOIVA8\t, TOTALTRASLADOSBASEIVA0, TOTALTRASLADOSIMPUESTOIVA0, TOTALTRASLADOSBASEIVAEXENTO\t, MONTOTOTALPAGOS FROM sat_complementoPagoTotales " + where;
                        vPaso = "EJECUTANTO SELECT TOTALES";
                        PreparedStatement vPS = conexion.prepareStatement(queryTotales);
                        vPaso = "TERMINO DE HACER EL SELECT";
                        ResultSet vRS = vPS.executeQuery();
                        vPaso = "GUARDA LOS RESULTADOS";
                        while (vRS.next()) {
                            totales = new Sat_ComplementoPagoTotalesDTO();
                            totales.setComprobante(vRS.getString("COMPROBANTE"));
                            totales.setTotalRetencionesIVA(vRS.getString("TOTALRETENCIONESIVA"));
                            totales.setTotalRetencionesISR(vRS.getString("TOTALRETENCIONESISR"));
                            totales.setTotalRetencionesIEPS(vRS.getString("TOTALRETENCIONESIEPS"));
                            totales.setTotalTrasladosBaseIVA16(vRS.getString("TOTALTRASLADOSBASEIVA16"));
                            totales.setTotalTrasladosImpuestoIVA16(vRS.getString("TOTALTRASLADOSIMPUESTOIVA16"));
                            totales.setTotalTrasladosBaseIVA8(vRS.getString("TOTALTRASLADOSBASEIVA8"));
                            totales.setTotalTrasladosImpuestoIVA8(vRS.getString("TOTALTRASLADOSIMPUESTOIVA8"));
                            totales.setTotalTrasladosBaseIVA0(vRS.getString("TOTALTRASLADOSBASEIVA0"));
                            totales.setTotalTrasladosImpuestoIVA0(vRS.getString("TOTALTRASLADOSIMPUESTOIVA0"));
                            totales.setTotalTrasladosBaseIVAExento(vRS.getString("TOTALTRASLADOSBASEIVAEXENTO"));
                            totales.setMontoTotalPagos(vRS.getString("MONTOTOTALPAGOS"));
                        }
                        vPS.close();
                        vRS.close();
                        vPS = null;
                        vRS = null;
                        vPaso = "TERMINO DE RECORRER RESULTADOS";
                        pago.setTotales(totales);
                    }
                    this.comprobante.agregaComplementoPago(pago);
                    vPaso = "Termino de agregar e complemento de pago";
                    String queryDocto = "SELECT sdr.comprobante, sdr.pagoNum, sdr.doctoNum, \t\tsdr.idDocumento, sdr.folio, sdr.monedaDR, \t\tsdr.tipoCambioDR, sdr.metodoDePagoDR, sdr.numParcialidad, \t\tsdr.impSaldoAnt, sdr.impPagado, sdr.impSaldoInsoluto,        sdr.emis_recep, sdr.empnum, sdr.succlave,        sdr.pagonumprov, sdr.detpagnum, sdr.serie, to_number(replace(nvl(C.totalImpuestosTrasladados, '0'), ',', '')) as iva FROM   SAT_doctosRelacionadosPagos sdr, comprobantes c " + where.replace("comprobante", "sdr.comprobante") + " " + "AND sdr.pagoNum = " + pago.getPagoNum() + " " + "AND sdr.idDocumento = c.UUID";
                    vPaso = "Peparandose para el query de DOCTO";
                    PreparedStatement ps2 = conexion.prepareStatement(queryDocto);
                    vPaso = "Ejecutar\u00e1 el query";
                    ResultSet rs2 = ps2.executeQuery();
                    vPaso = "Guarda resultado de query DOCTO";
                    ArrayList<DoctoRelacionadoPagoDTO> listaDocto = new ArrayList<DoctoRelacionadoPagoDTO>();
                    while (rs2.next()) {
                        DoctoRelacionadoPagoDTO docto = new DoctoRelacionadoPagoDTO();
                        docto.setComprobante(rs2.getInt("comprobante"));
                        docto.setPagoNum(rs2.getInt("pagoNum"));
                        docto.setDoctoNum(rs2.getInt("doctoNum"));
                        docto.setIdDocumento(rs2.getString("idDocumento"));
                        docto.setFolio(rs2.getString("folio"));
                        docto.setMonedaDR(rs2.getString("monedaDR"));
                        docto.setTipoCambioDR(rs2.getString("tipoCambioDR"));
                        docto.setMetodoDePagoDR(rs2.getString("metodoDePagoDR"));
                        docto.setNumParcialidad(rs2.getString("numParcialidad"));
                        docto.setImpSaldoAnt(rs2.getString("impSaldoAnt"));
                        docto.setImpPagado(rs2.getString("impPagado"));
                        docto.setImpSaldoInsoluto(rs2.getString("impSaldoInsoluto"));
                        docto.setEmisRecep(rs2.getString("emis_recep"));
                        docto.setEmpNum(rs2.getInt("empnum"));
                        docto.setSucClave(rs2.getString("succlave"));
                        docto.setPagoNumProv(rs2.getInt("pagonumprov"));
                        docto.setDetPagNum(rs2.getInt("detpagnum"));
                        docto.setSerie(rs2.getString("serie"));
                        vPaso = "ASIGN\u00d3 SERIE ";
                        docto.setIva(rs2.getInt("IVA"));
                        vPaso = "ASIGN\u00d3 IVA";
                        if (docto.getIva() > 0) {
                            docto.setObjetoImpDR("02");
                        } else {
                            docto.setObjetoImpDR("01");
                        }
                        vPaso = "Verificando si es la 4.0 |" + this.comprobante.getVersion() + " - " + docto.getObjetoImpDR() + " - " + pago.getVersionPago();
                        if (this.comprobante.getVersion().equals("4.0") && docto.getObjetoImpDR().equals("02") && pago.getVersionPago().equals("2.0")) {
                            vPaso = "impuestosTrasladados1";
                            docto.setListaImpuestosTrasladados(PagoDAO.getListaImpuesto(conexion, docto.getIdDocumento(), "T", docto));
                            vPaso = "impuestosRetenidos1";
                            docto.setListaImpuestosRetenidos(PagoDAO.getListaImpuesto(conexion, docto.getIdDocumento(), "R", docto));
                            vPaso = "FINALIZO 4.0";
                        }
                        listaDocto.add(docto);
                    }
                    pago.setLstDoctoRelacPago(listaDocto);
                    if (ps2 != null) {
                        ps2.close();
                        ps2 = null;
                    }
                    if (rs2 == null) continue;
                    rs2.close();
                    rs2 = null;
                }
            }
            catch (SQLException sqlEx) {
                System.out.println("Error en DOCTOS: " + vPaso + ". " + sqlEx.toString());
                EscribeSalidaProcesos.Log(String.valueOf(this.getClass().getCanonicalName()) + ": PASO:" + vPaso + ": Error en leerComplementoPago. " + sqlEx);
                throw new Exception(String.valueOf(this.getClass().getCanonicalName()) + ": PASO:" + vPaso + ": Error en leerComplementoPago. " + sqlEx);
            }
            catch (Exception ex) {
                System.out.println("ERROR EN EL PASO: " + vPaso + ". ");
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
                ps = null;
            }
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
    }

    public static ArrayList<CfdImpuestosDTO> getListaImpuesto(Connection pConexion, String pUUID, String pTipoImpuesto, DoctoRelacionadoPagoDTO pDoctoRelacionado) throws Exception {
        ArrayList<CfdImpuestosDTO> listaImpuesto = null;
        String query = "SELECT comprobante, REPLACE(tipoImpuesto, ',', '') tipoImpuesto, REPLACE(base, ',','')       base, REPLACE(impuesto, ',','')   impuesto, REPLACE(tipoFactor, ',','') tipoFactor, REPLACE(tasaCuota, ',','')  tasaCuota, REPLACE(importe, ',','')    importe FROM sat_cfdimpuestosAgrupados WHERE comprobante = (SELECT comprobante FROM comprobantes WHERE uuid = '" + pUUID + "') " + "AND tipoImpuesto = '" + pTipoImpuesto + "' ";
        System.out.println("SELECT DE SAT_CFDIMPUESTOS: " + query);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = pConexion.prepareStatement(query);
            rs = ps.executeQuery();
            CfdImpuestosDTO impuesto = null;
            listaImpuesto = new ArrayList<CfdImpuestosDTO>();
            int i = 0;
            Double vTasaOCuota = 0.0;
            while (rs.next()) {
                impuesto = new CfdImpuestosDTO();
                vTasaOCuota = Double.parseDouble(rs.getString("tasaCuota"));
                String vImporte = String.format("%.2f", (double)Float.valueOf(pDoctoRelacionado.getImpPagado()).floatValue() / (1.0 + vTasaOCuota) * vTasaOCuota);
                String vBase = String.format("%.2f", Float.valueOf(Float.valueOf(pDoctoRelacionado.getImpPagado()).floatValue() - Float.valueOf(vImporte).floatValue()));
                impuesto.setComprobante(rs.getInt("comprobante"));
                impuesto.setTipoImpuesto(rs.getString("tipoImpuesto"));
                impuesto.setBase(vBase);
                impuesto.setImpuesto(rs.getString("impuesto"));
                impuesto.setTipoFactor(rs.getString("tipoFactor"));
                impuesto.setTasaCuota(rs.getString("tasaCuota"));
                impuesto.setImporte(vImporte);
                listaImpuesto.add(impuesto);
                ++i;
            }
            ps.close();
            rs.close();
            ps = null;
            rs = null;
        }
        catch (SQLException sqlEx) {
            EscribeSalidaProcesos.Log("PAGODAO: Error en leerImpuestos. " + sqlEx);
            throw new Exception("PAGODAO: Error en leerImpuestos. " + sqlEx);
        }
        return listaImpuesto;
    }
}

