/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.lowagie.text.ExceptionConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dto.CfdConceptosDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ComprobanteRelacDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.dto.DoctoRelacionadoPagoDTO;
import siti.sinco.cfdi.dto.MetadatosCobDTO;
import siti.sinco.cfdi.pdf.CFDenPDFSitiFact;
import siti.sinco.cfdi.pdf.CeldasPDF;
import siti.sinco.cfdi.tools.CodigoQR;
import siti.sinco.cfdi.tools.Conversiones;
import siti.sinco.cfdi.tools.Utilerias;

public class CFDenPDFSitiPago
extends PdfPageEventHelper {
    protected PdfTemplate total;
    protected BaseFont helv;
    private ComprobanteDTO comprobante;
    private ConfiguracionDTO configuracion;
    private final int ACTIVA = 1;
    private final int CANCELADA = 0;
    private String nombrePDF;
    private String ruta;
    private String nombreCompleto;
    private MetadatosCobDTO dtopago;
    private String leyenda = "Este documento es una representaci\u00f3n impresa de un CFDI versi\u00f3n 3.3";

    public CFDenPDFSitiPago(ComprobanteDTO objComprobante, ConfiguracionDTO objConfiguracion) {
        this.comprobante = objComprobante;
        this.configuracion = objConfiguracion;
    }

    public CFDenPDFSitiPago() {
    }

    public String generarPDF(String modo, String sobreEscribe, String pRutaPDF) throws IOException, DocumentException {
        System.out.println("CB");
        this.dtopago = this.comprobante.getmetadatoCob();
        Locale.setDefault(new Locale("es", "MX"));
        Document document = new Document(PageSize.LETTER, 10.0f, 20.0f, 10.0f, 20.0f);
        if (pRutaPDF != null) {
            String[] vRuta = pRutaPDF.replace("\\", "/").split("/");
            this.ruta = "";
            int i = 0;
            while (i < vRuta.length - 2) {
                this.ruta = i == 0 ? vRuta[i] : String.valueOf(this.ruta) + "\\" + vRuta[i];
                ++i;
            }
            this.ruta = String.valueOf(this.ruta) + "\\" + "PDF";
            this.nombrePDF = vRuta[vRuta.length - 1].replace(".txt", "").replace(".xml", "").replace("INT", "CFDi");
        } else {
            this.nombrePDF = "CFDi_" + ComprobantesDAO.creaNombreArchivo(this.comprobante.getComprobante());
            this.ruta = String.valueOf(Utilerias.getRutaBase(this.comprobante, this.configuracion, 3)) + File.separator + "PDF";
        }
        File rutaPDF = new File(this.ruta);
        String ruta_archivo = "";
        if (this.comprobante.getStatus() == 1) {
            ruta_archivo = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".pdf";
        } else if (this.comprobante.getStatus() == 0) {
            ruta_archivo = String.valueOf(this.ruta) + File.separator + this.nombrePDF + "_cancel.pdf";
        }
        File fichero = new File(ruta_archivo);
        System.out.println("ruta: " + ruta_archivo);
        if (!rutaPDF.exists()) {
            System.out.println("Se ha creado la ruta: " + this.ruta);
            rutaPDF.mkdirs();
        }
        if (fichero.exists()) {
            if (sobreEscribe.equals("SI")) {
                System.out.println("El archivo se va a sobreescribir.");
                FileUtils.forceDelete((File)fichero);
            } else {
                System.out.println("El archivo ya existe y no se puede sobreescribir.");
            }
        }
        if (!fichero.exists()) {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(ruta_archivo));
            writer.setPageEvent((PdfPageEvent)new CFDenPDFSitiFact());
            Rectangle rct = new Rectangle(36.0f, 54.0f, 559.0f, 788.0f);
            writer.setBoxSize("art", rct);
            Paragraph lineaVacia = new Paragraph(" ", new Font(Font.FontFamily.TIMES_ROMAN, 2.0f));
            if (modo.equals("TEST")) {
                this.leyenda = String.valueOf(this.leyenda) + "\n ESTE DOCUMENTO NO TIENE VALIDEZ FISCAL PUES ES UNA PRUEBA";
            }
            Paragraph leyendaDigital = new Paragraph(this.leyenda, new Font(Font.FontFamily.TIMES_ROMAN, 6.0f, 1));
            leyendaDigital.setAlignment(1);
            document.open();
            System.out.println("Se inicia la generaci\u00f3n de tablas en el PDF");
            document.add((Element)this.tablaLogo());
            document.add((Element)this.tablaEmisor());
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaReceptor());
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaConceptosEncabezado());
            document.add((Element)this.tablaConceptosDatos());
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaDoctosRelac());
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaComplEncabezado());
            int numcomplementos = this.comprobante.getComplementosPago().size();
            if (numcomplementos > 0) {
                document.add((Element)this.tablaComplDatos(0));
            }
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaComplEncabezado2());
            document.add((Element)this.tablaComplDatos2(0));
            document.add((Element)lineaVacia);
            if (this.comprobante.getLeyendaPago() != null) {
                document.add((Element)this.tablaLeyendapago());
            }
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaDatosDigitales(leyendaDigital));
            if (this.comprobante.getStatus() == 0) {
                document.add((Element)this.tablaDatosDigitalesCanc());
            }
            document.close();
            File rutaImagenQR = new File(this.nombreCompleto);
            if (rutaImagenQR.exists()) {
                FileUtils.forceDelete((File)rutaImagenQR);
            }
        }
        return ruta_archivo;
    }

    public PdfPTable tablaLogo() throws MalformedURLException, IOException, DocumentException {
        PdfPTable tablaLogo = new PdfPTable(4);
        tablaLogo.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{150.0f, 150.0f, 18.0f, 150.0f};
        tablaLogo.setTotalWidth(columnWidths);
        tablaLogo.getDefaultCell().setBorder(0);
        PdfPTable tablaVacia = new PdfPTable(1);
        tablaVacia.setWidthPercentage(90.0f);
        Image imagen = null;
        String nombrelogo = new String("/logo_asipona.jpg");
        if (this.configuracion.getFechalogo().compareTo(this.comprobante.getFecha()) >= 0) {
            nombrelogo = "/logo_api.jpg";
        }
        imagen = Image.getInstance((String)(String.valueOf(LeeConexion.path) + "/recursos/" + nombrelogo));
        imagen.scalePercent(40.0f);
        imagen.setAlignment(1);
        PdfPCell celda = new PdfPCell(imagen);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        tablaLogo.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "   \n", 1, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(3);
        tablaLogo.addCell(celda);
        return tablaLogo;
    }

    public PdfPTable tablaEmisor() throws MalformedURLException, IOException, DocumentException {
        PdfPTable tablaEmisor = new PdfPTable(4);
        float[] columnWidths = new float[]{150.0f, 150.0f, 18.0f, 150.0f};
        tablaEmisor.setTotalWidth(columnWidths);
        PdfPTable tablaVacia = new PdfPTable(1);
        tablaVacia.setWidthPercentage(90.0f);
        tablaEmisor.setWidthPercentage(90.0f);
        Paragraph parrafNombreEmisor = new Paragraph(this.comprobante.getNombreEmisor(), CeldasPDF.fontContentMid);
        parrafNombreEmisor.add("\n" + this.comprobante.getRfcEmisor());
        parrafNombreEmisor.setAlignment(1);
        String noExt = "";
        String noInt = "";
        String colonia = "";
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorEmisor(), "S/N");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorEmisor(), "");
        colonia = Utilerias.nvl(this.comprobante.getColoniaEmisor(), "");
        Paragraph parrafDomicEmisor = new Paragraph(String.valueOf(this.comprobante.getCalleEmisor()) + " " + noExt + " " + noInt + " " + colonia, CeldasPDF.fontContentSmall);
        parrafDomicEmisor.add("\n" + this.comprobante.getMunicipioEmisor() + ", " + this.comprobante.getEstadoEmisor() + ", " + this.comprobante.getPaisEmisor() + ", " + this.comprobante.getCodigoPostalEmisor());
        parrafDomicEmisor.add("\nLugar Expedicion: " + this.comprobante.getLugarExpedicion());
        parrafDomicEmisor.setAlignment(1);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)parrafNombreEmisor);
        celda.addElement((Element)parrafDomicEmisor);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaEmisor.addCell(celda);
        PdfPTable tablaDerecha = new PdfPTable(2);
        tablaDerecha.setWidthPercentage(90.0f);
        CeldasPDF.celdaTabla(tablaDerecha, "Folio Fiscal - Versi\u00f3n 3.3 ", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 1, 2);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getUUID(), 2, 0, 0.0f, CeldasPDF.fontContentSmall, 1);
        Paragraph SerieyFolio = new Paragraph();
        SerieyFolio.setFont(CeldasPDF.fontDatos);
        SerieyFolio.add((Element)new Chunk("Serie:  ", CeldasPDF.fontDataBold));
        SerieyFolio.add((Element)new Chunk(this.comprobante.getSerie(), CeldasPDF.fontDatos));
        CeldasPDF.celdaTabla(tablaDerecha, SerieyFolio, 1, 1, 2.0f, 1);
        SerieyFolio = new Paragraph();
        SerieyFolio.add((Element)new Chunk("      Folio:  ", CeldasPDF.fontDataBold));
        SerieyFolio.add((Element)new Chunk(this.comprobante.getFolioDoc(), CeldasPDF.fontDatos));
        CeldasPDF.celdaTabla(tablaDerecha, SerieyFolio, 1, 1, 2.0f, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "N\u00famero de Certificado del Emisor", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 1, 2);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getNocertificado(), 2, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "Fecha y Hora de Emisi\u00f3n", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 1, 2);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getFecha(), 2, 1, 0.0f, CeldasPDF.fontContentSmall, 1);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorderColor(BaseColor.DARK_GRAY);
        celda.setBorderWidth(0.8f);
        celda.setBorder(30);
        tablaEmisor.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "   \n", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaEmisor.addCell(celda);
        PdfPTable tablaDerecha2 = new PdfPTable(1);
        tablaDerecha.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaDerecha2, " Tipo de Comprobante P -", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaDerecha2, "Fecha y Hora de Certificaci\u00f3n", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaDerecha2, this.comprobante.getFechaTimbrado(), 1, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha2, "Proveedor de Certificaci\u00f3n de CFDI", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaDerecha2, this.configuracion.getNombreCertificador(), 1, 0, 0.0f, CeldasPDF.fontContentMid, 1);
        CeldasPDF.celdaTabla(tablaDerecha2, "RFC: " + this.comprobante.getRfcProvCertif(), 1, 0, 0.0f, CeldasPDF.fontContentMid, 1);
        CeldasPDF.celdaTabla(tablaDerecha2, "N\u00famero Certificado del SAT: " + this.comprobante.getNoCertificadoSAT(), 2, 0, 0.0f, CeldasPDF.fontContentSmall, 1);
        celda = new PdfPCell(tablaDerecha2);
        celda.setBorder(0);
        celda.setBorderColor(BaseColor.DARK_GRAY);
        celda.setBorderWidth(0.8f);
        celda.setBorder(30);
        tablaEmisor.addCell(celda);
        return tablaEmisor;
    }

    public PdfPTable tablaReceptor() throws DocumentException {
        PdfPTable tablaReceptor = new PdfPTable(3);
        tablaReceptor.setWidthPercentage(90.0f);
        float[] columnWidths = new float[]{225.0f, 18.0f, 225.0f};
        tablaReceptor.setTotalWidth(columnWidths);
        PdfPTable tablaIzquierda = new PdfPTable(1);
        tablaIzquierda.setWidthPercentage(90.0f);
        PdfPTable tablaDerecha = new PdfPTable(1);
        tablaDerecha.setWidthPercentage(90.0f);
        PdfPTable tablaVacia = new PdfPTable(1);
        tablaVacia.setWidthPercentage(90.0f);
        String nombre = "";
        String calle = "";
        String noExt = "";
        String noInt = "";
        String colonia = "";
        String cp = "";
        String municipio = "";
        String estado = "";
        nombre = Utilerias.nvl(this.comprobante.getNombreReceptor(), "");
        calle = Utilerias.nvl(this.comprobante.getCalleReceptor(), "");
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorReceptor(), "");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorReceptor(), "");
        if (this.comprobante.getColoniaReceptor() != null) {
            colonia = String.valueOf(this.comprobante.getColoniaReceptor()) + ", ";
        }
        if (this.comprobante.getLocalidadReceptor() != null) {
            colonia = String.valueOf(colonia) + this.comprobante.getLocalidadReceptor();
        }
        if (this.comprobante.getCodigoPostalReceptor() != null) {
            cp = "C.P. " + this.comprobante.getCodigoPostalReceptor();
        }
        municipio = Utilerias.nvl(this.comprobante.getMunicipioReceptor(), "");
        if (this.comprobante.getEstadoReceptor() != null) {
            estado = ", " + this.comprobante.getEstadoReceptor() + ", " + this.comprobante.getPaisReceptor();
        }
        CeldasPDF.celdaTabla(tablaIzquierda, " Nombre del Cliente", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 0, 1);
        CeldasPDF.celdaTabla(tablaIzquierda, nombre, 2, 1, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, " RFC del Cliente", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 0, 1);
        Paragraph rfcusocfdi = new Paragraph();
        rfcusocfdi.add((Element)new Chunk(this.comprobante.getRfcReceptor(), CeldasPDF.fontDatos));
        String usoCFDIDescr = new String("");
        usoCFDIDescr = this.dtopago.getUsoCfdi();
        rfcusocfdi.setFont(CeldasPDF.fontDatos);
        rfcusocfdi.add((Element)new Chunk("                   USO CFDI: ", CeldasPDF.fontDataBold));
        rfcusocfdi.add((Element)new Chunk(usoCFDIDescr, CeldasPDF.fontDatos));
        CeldasPDF.celdaTabla(tablaIzquierda, rfcusocfdi, 2, 0, 2.0f, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        PdfPCell celda = new PdfPCell();
        celda = new PdfPCell(tablaIzquierda);
        celda.setBorderColor(BaseColor.DARK_GRAY);
        celda.setBorderWidth(0.8f);
        celda.setBorder(30);
        celda.setColspan(1);
        tablaReceptor.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "   \n", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaReceptor.addCell(celda);
        CeldasPDF.celdaTabla(tablaDerecha, " Direcci\u00f3n del Cliente", CeldasPDF.fontContentSmallBold, BaseColor.GRAY, 0, 1);
        Paragraph p2 = new Paragraph("\n" + calle + " " + noExt + " " + noInt, CeldasPDF.fontDatos);
        p2.add("\n" + colonia);
        p2.add("\n" + municipio + "   " + estado + "  " + cp);
        p2.setAlignment(0);
        CeldasPDF.celdaTabla(tablaDerecha, p2, 2, 0, 2.0f, 0);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorderColor(BaseColor.DARK_GRAY);
        celda.setBorderWidth(0.8f);
        celda.setBorder(30);
        celda.setColspan(1);
        tablaReceptor.addCell(celda);
        return tablaReceptor;
    }

    public PdfPTable tablaConceptosEncabezado() throws DocumentException {
        PdfPTable tablaEncabezado = new PdfPTable(6);
        tablaEncabezado.setWidthPercentage(85.0f);
        float[] columnWidths = new float[]{60.0f, 180.0f, 45.0f, 45.0f, 60.0f, 60.0f};
        tablaEncabezado.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tablaEncabezado, "CLAVE PRODUCTO", BaseColor.GRAY, 1, 1, BaseColor.LIGHT_GRAY, CeldasPDF.fontHeaderSmall3);
        CeldasPDF.celdaTabla(tablaEncabezado, "DESCRIPCION", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaEncabezado, "CLAVE UNIDAD", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaEncabezado, "CANTIDAD", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaEncabezado, "PRECIO UNITARIO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaEncabezado, "IMPORTE TOTAL", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        return tablaEncabezado;
    }

    public PdfPTable tablaConceptosDatos() throws DocumentException {
        PdfPTable tabla = new PdfPTable(6);
        tabla.setWidthPercentage(85.0f);
        float[] columnWidths = new float[]{60.0f, 180.0f, 45.0f, 45.0f, 60.0f, 60.0f};
        tabla.setTotalWidth(columnWidths);
        int renglon = 0;
        while (renglon < this.comprobante.conceptos.size()) {
            CfdConceptosDTO concepto = this.comprobante.conceptos.elementAt(renglon);
            String unidad = "";
            String precio = "";
            String importe = "";
            unidad = Utilerias.nvl(concepto.getClaveSatUnidades(), " ");
            Double preciod = new Double(concepto.getValorUnitario().replace(",", ""));
            precio = String.format("%,.2f", preciod);
            Double imported = new Double(concepto.getImporte().replace(",", ""));
            importe = String.format("%,.2f", imported);
            CeldasPDF.celdaTabla(tabla, concepto.getClaveSatProdServ(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, concepto.getDescripcion(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 0);
            CeldasPDF.celdaTabla(tabla, unidad, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, concepto.getCantidad(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, precio, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
            CeldasPDF.celdaTabla(tabla, importe, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
            ++renglon;
        }
        return tabla;
    }

    public PdfPTable tablaDoctosRelac() throws DocumentException {
        PdfPTable tabla = new PdfPTable(3);
        tabla.setWidthPercentage(85.0f);
        float[] columnWidths = new float[]{300.0f, 20.0f, 130.0f};
        tabla.setTotalWidth(columnWidths);
        PdfPTable tablaIzquierda = new PdfPTable(2);
        tablaIzquierda.setWidthPercentage(90.0f);
        PdfPTable tablaDerecha = new PdfPTable(2);
        tablaDerecha.setWidthPercentage(90.0f);
        PdfPTable tablaVacia = new PdfPTable(1);
        tablaVacia.setWidthPercentage(90.0f);
        String cfdirelac = "";
        String tiporelac = "";
        String claveconfirm = "";
        int total = this.comprobante.relaciones.size();
        if (total > 0) {
            ComprobanteRelacDTO relac = this.comprobante.relaciones.elementAt(0);
            cfdirelac = relac.getUUID();
            tiporelac = relac.getTipoRelacion();
        }
        CeldasPDF.celdaTabla(tablaIzquierda, "CFDI RELACIONADO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, "TIPO DE RELACION", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, cfdirelac, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, tiporelac, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, "CLAVE DE CONFIRMACION", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, "MONEDA", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, claveconfirm, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaIzquierda, this.comprobante.getMoneda(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        PdfPCell celda = new PdfPCell();
        celda = new PdfPCell(tablaIzquierda);
        celda.setBorderColor(BaseColor.DARK_GRAY);
        celda.setBorderWidth(0.8f);
        celda.setBorder(30);
        tabla.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "   \n", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tabla.addCell(celda);
        double subtotal = new Double(this.comprobante.getSubtotal().replace(",", ""));
        double totalrel = new Double(this.comprobante.getTotal().replace(",", ""));
        String subtotalstr = String.format("$ %,.2f", subtotal);
        String totalstr = String.format("$ %,.2f", totalrel);
        CeldasPDF.celdaTabla(tablaDerecha, "TOTALES", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 2);
        CeldasPDF.celdaTabla(tablaDerecha, "SUBTOTAL", 1, 0, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaDerecha, subtotalstr, 1, 0, 0.0f, CeldasPDF.fontContentSmall, 2);
        CeldasPDF.celdaTabla(tablaDerecha, " ", 2, 0, 0.0f, CeldasPDF.fontContentSmall, 0);
        CeldasPDF.celdaTabla(tablaDerecha, "TOTAL", 1, 0, 0.0f, CeldasPDF.fontContentSmallBold, 0);
        CeldasPDF.celdaTabla(tablaDerecha, totalstr, 1, 0, 0.0f, CeldasPDF.fontContentSmall, 2);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorderColor(BaseColor.DARK_GRAY);
        celda.setBorderWidth(0.8f);
        celda.setBorder(30);
        celda.setColspan(1);
        tabla.addCell(celda);
        return tabla;
    }

    public PdfPTable tablaComplEncabezado() throws DocumentException {
        PdfPTable tabla = new PdfPTable(8);
        tabla.setWidthPercentage(85.0f);
        float[] columnWidths = new float[]{52.0f, 70.0f, 35.0f, 52.0f, 52.0f, 70.0f, 70.0f, 52.0f};
        tabla.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tabla, "INFORMACION DE PAGOS", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 8, 0);
        CeldasPDF.celdaTabla(tabla, " ", CeldasPDF.fontContentSmaller, BaseColor.WHITE, 0, 8, 0);
        CeldasPDF.celdaTabla(tabla, "FECHA DE PAGO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "FORMA DE PAGO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "MONEDA", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "BANCO BENEFICIARIO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "CTA. BENEFICIARIO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "BANCO ORDENANTE", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "CTA. ORDENANTE", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "MONTO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        return tabla;
    }

    public PdfPTable tablaComplEncabezado2() throws DocumentException {
        PdfPTable tabla = new PdfPTable(10);
        tabla.setWidthPercentage(80.0f);
        float[] columnWidths = new float[]{42.0f, 35.0f, 85.0f, 30.0f, 32.0f, 32.0f, 35.0f, 35.0f, 35.0f, 35.0f};
        tabla.setTotalWidth(columnWidths);
        CeldasPDF.celdaTabla(tabla, "Documentos Relacionados", CeldasPDF.fontContentMidBold, BaseColor.WHITE, 0, 10, 0);
        CeldasPDF.celdaTabla(tabla, "NUMERO PARCIALIDAD", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "METODO PAGO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "UUID", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "SERIE", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "FOLIO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "MONEDA", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "TIPO CAMBIO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "SALDO ANTERIOR", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "IMPORTE PAGADO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        CeldasPDF.celdaTabla(tabla, "SALDO INSOLUTO", CeldasPDF.fontHeaderSmall3, BaseColor.GRAY, 1, 1, 0);
        return tabla;
    }

    public PdfPTable tablaComplDatos(int numPago) throws DocumentException {
        PdfPTable tabla = new PdfPTable(8);
        tabla.setWidthPercentage(85.0f);
        float[] columnWidths = new float[]{52.0f, 70.0f, 35.0f, 52.0f, 52.0f, 70.0f, 70.0f, 52.0f};
        tabla.setTotalWidth(columnWidths);
        String formadePago = this.dtopago.getFormaPago();
        double montopago = new Double(this.comprobante.getComplementosPago().get(numPago).getMonto());
        String montopagostr = String.format("%,.2f", montopago);
        CeldasPDF.celdaTabla(tabla, this.comprobante.getComplementosPago().get(numPago).getFechaPago(), 1, 3, 0.0f, CeldasPDF.fontContentSmaller, 0);
        CeldasPDF.celdaTabla(tabla, formadePago, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tabla, this.comprobante.getComplementosPago().get(numPago).getMonedaP(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tabla, this.comprobante.getComplementosPago().get(numPago).getBancoReceptor(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tabla, this.comprobante.getComplementosPago().get(numPago).getCtaBeneficiario(), 1, 3, 0.0f, CeldasPDF.fontContentSmaller, 1);
        CeldasPDF.celdaTabla(tabla, this.comprobante.getComplementosPago().get(numPago).getNomBancoOrdExt(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tabla, this.comprobante.getComplementosPago().get(numPago).getCtaOrdenante(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
        CeldasPDF.celdaTabla(tabla, montopagostr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
        return tabla;
    }

    public PdfPTable tablaComplDatos2(int numPago) throws DocumentException {
        PdfPTable tabla = new PdfPTable(10);
        tabla.setWidthPercentage(80.0f);
        float[] columnWidths = new float[]{42.0f, 35.0f, 85.0f, 30.0f, 32.0f, 32.0f, 35.0f, 35.0f, 35.0f, 35.0f};
        tabla.setTotalWidth(columnWidths);
        System.out.println("Con el pago num: " + numPago);
        int probando = this.comprobante.getComplementosPago().get(0).getLstDoctoRelacPago().size();
        System.out.println("probando: " + probando);
        int cantdoctosrelac = this.comprobante.getComplementosPago().get(numPago).getLstDoctoRelacPago().size();
        System.out.println("Renglones encontrados en ComplDatos2 " + cantdoctosrelac + " Con el pago num: " + numPago);
        int renglon = 0;
        while (renglon < cantdoctosrelac) {
            DoctoRelacionadoPagoDTO doctorelac = this.comprobante.getComplementosPago().get(numPago).getLstDoctoRelacPago().get(renglon);
            CeldasPDF.celdaTabla(tabla, doctorelac.getNumParcialidad(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
            CeldasPDF.celdaTabla(tabla, doctorelac.getMetodoDePagoDR(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, doctorelac.getIdDocumento(), 1, 3, 0.0f, CeldasPDF.fontContentSmaller, 1);
            CeldasPDF.celdaTabla(tabla, doctorelac.getSerie(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, doctorelac.getFolio(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, doctorelac.getMonedaDR(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            CeldasPDF.celdaTabla(tabla, doctorelac.getTipoCambioDR(), 1, 3, 0.0f, CeldasPDF.fontContentSmall, 1);
            double saldoAnterior = new Double(doctorelac.getImpSaldoAnt().replace(",", ""));
            double saldoPagado = new Double(doctorelac.getImpPagado().replace(",", ""));
            double saldoInsoluto = new Double(doctorelac.getImpSaldoInsoluto().replace(",", ""));
            String saldoAnteriorstr = String.format("%,.2f", saldoAnterior);
            String saldoPagadostr = String.format("%,.2f", saldoPagado);
            String saldoInsolutostr = String.format("%,.2f", saldoInsoluto);
            CeldasPDF.celdaTabla(tabla, saldoAnteriorstr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
            CeldasPDF.celdaTabla(tabla, saldoPagadostr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
            CeldasPDF.celdaTabla(tabla, saldoInsolutostr, 1, 3, 0.0f, CeldasPDF.fontContentSmall, 2);
            ++renglon;
        }
        return tabla;
    }

    public PdfPTable tablaUUIDsEncabezado() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(49);
        tabla.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tabla, "Id del documento", 15, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Folio", 4, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "M\u00e9todo de pago", 4, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Num. Parcialidad", 5, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Saldo Anterior", 5, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Importe Pagado", 5, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Saldo Insoluto", 4, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Moneda", 4, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        CeldasPDF.celdaTabla(tabla, "Tipo de Cambio", 3, 1, 1.0f, CeldasPDF.fontHeaderSmall3, 1);
        return tabla;
    }

    public PdfPTable tablaUUIDsDatos(int numPago) throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(49);
        tabla.setWidthPercentage(100.0f);
        String idDocumento = "";
        String folio = "";
        String monedaDR = "";
        String tipoCambioDR = "";
        String metodoPagoDR = "";
        String numParcialidad = "";
        String impSaldoAnt = "";
        String impPagado = "";
        String impSaldoinsoluto = "";
        Iterator<DoctoRelacionadoPagoDTO> iteraDocRelac = null;
        iteraDocRelac = this.comprobante.getComplementosPago().get(numPago).getLstDoctoRelacPago().iterator();
        while (iteraDocRelac.hasNext()) {
            DoctoRelacionadoPagoDTO doctoRelacPago = new DoctoRelacionadoPagoDTO();
            doctoRelacPago = iteraDocRelac.next();
            idDocumento = doctoRelacPago.getIdDocumento();
            folio = doctoRelacPago.getFolio();
            monedaDR = doctoRelacPago.getMonedaDR();
            if (doctoRelacPago.getTipoCambioDR() != null) {
                tipoCambioDR = doctoRelacPago.getTipoCambioDR();
            }
            metodoPagoDR = doctoRelacPago.getMetodoDePagoDR();
            numParcialidad = doctoRelacPago.getNumParcialidad();
            impSaldoAnt = doctoRelacPago.getImpSaldoAnt();
            impPagado = doctoRelacPago.getImpPagado();
            impSaldoinsoluto = doctoRelacPago.getImpSaldoInsoluto();
            CeldasPDF.celdaTabla(tabla, idDocumento, 15, 1, 0.0f, CeldasPDF.fontDetalleCou, 0);
            CeldasPDF.celdaTabla(tabla, folio, 4, 1, 0.0f, CeldasPDF.fontDetalle, 1);
            CeldasPDF.celdaTabla(tabla, metodoPagoDR, 4, 1, 0.0f, CeldasPDF.fontDetalle, 1);
            CeldasPDF.celdaTabla(tabla, numParcialidad, 5, 1, 0.0f, CeldasPDF.fontDetalle, 1);
            CeldasPDF.celdaTabla(tabla, impSaldoAnt, 5, 1, 0.0f, CeldasPDF.fontDetalle, 2);
            CeldasPDF.celdaTabla(tabla, impPagado, 5, 1, 0.0f, CeldasPDF.fontDetalle, 2);
            CeldasPDF.celdaTabla(tabla, impSaldoinsoluto, 4, 1, 0.0f, CeldasPDF.fontDetalle, 2);
            CeldasPDF.celdaTabla(tabla, monedaDR, 4, 1, 0.0f, CeldasPDF.fontDetalle, 1);
            CeldasPDF.celdaTabla(tabla, tipoCambioDR, 3, 1, 0.0f, CeldasPDF.fontDetalle, 2);
        }
        return tabla;
    }

    public PdfPTable tablaProveedor() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaProveedor = new PdfPTable(1);
        tablaProveedor.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaProveedor, "Proveedor: 6001012329", 1, 0, 0.0f, CeldasPDF.fontTitHeader, 1);
        CeldasPDF.celdaTabla(tablaProveedor, "", 1, 0, 0.0f, CeldasPDF.fontTitHeader, 1);
        return tablaProveedor;
    }

    public PdfPTable tablaLeyendapago() throws BadElementException, MalformedURLException, IOException {
        PdfPTable miTabla = new PdfPTable(1);
        miTabla.setWidthPercentage(100.0f);
        Paragraph p1 = new Paragraph(this.comprobante.getLeyendaPago(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f, 1));
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)p1);
        celda.setColspan(1);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        miTabla.addCell(celda);
        return miTabla;
    }

    public PdfPTable tablaDatosDigitales(Paragraph leyendadigital) throws MalformedURLException, IOException, DocumentException {
        PdfPTable tabla = new PdfPTable(2);
        tabla.setWidthPercentage(95.0f);
        float[] columnWidths = new float[]{120.0f, 350.0f};
        tabla.setTotalWidth(columnWidths);
        String URLServicio = "https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx";
        tabla.getDefaultCell().setBorder(0);
        PdfPTable tablaIzquierda = new PdfPTable(1);
        tablaIzquierda.setWidthPercentage(90.0f);
        columnWidths = new float[]{120.0f};
        tablaIzquierda.setTotalWidth(columnWidths);
        PdfPTable tablaDerecha = new PdfPTable(1);
        tablaDerecha.setWidthPercentage(90.0f);
        columnWidths = new float[]{350.0f};
        tablaDerecha.setTotalWidth(columnWidths);
        this.nombreCompleto = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".png";
        String datosQR = String.valueOf(URLServicio) + "?Id=" + this.comprobante.getUUID() + "&Re=" + this.comprobante.getRfcEmisor() + "&Rr=" + this.comprobante.getRfcReceptor() + "&Tt=" + Conversiones.quitarFormatoImporte(this.comprobante.getTotal()) + "&Fe=" + this.comprobante.getSello().substring(this.comprobante.getSello().length() - 8);
        CodigoQR qr = new CodigoQR();
        qr.creaImagen(datosQR, this.nombreCompleto);
        Image imagen = null;
        imagen = Image.getInstance((String)this.nombreCompleto);
        imagen.setAlignment(0);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)imagen);
        celda.setColspan(1);
        celda.setHorizontalAlignment(1);
        celda.setBorder(0);
        celda.setVerticalAlignment(6);
        tablaIzquierda.addCell(celda);
        Paragraph titulo = new Paragraph("Cadena original del Complemento de Certificaci\u00f3n del SAT", new Font(Font.FontFamily.TIMES_ROMAN, 7.0f, 1));
        titulo.setAlignment(0);
        Paragraph cadena = new Paragraph(this.comprobante.getCadenaOriginalSAT(), new Font(Font.FontFamily.TIMES_ROMAN, 5.0f));
        cadena.setAlignment(0);
        celda = new PdfPCell();
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        Paragraph lineablanco = new Paragraph("  ", new Font(Font.FontFamily.TIMES_ROMAN, 7.0f, 1));
        celda.addElement((Element)lineablanco);
        titulo = new Paragraph("Sello digital del emisor", new Font(Font.FontFamily.TIMES_ROMAN, 7.0f, 1));
        titulo.setAlignment(0);
        cadena = new Paragraph(this.comprobante.getSello(), new Font(Font.FontFamily.TIMES_ROMAN, 5.0f));
        cadena.setAlignment(0);
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        lineablanco = new Paragraph("  ", new Font(Font.FontFamily.TIMES_ROMAN, 7.0f, 1));
        celda.addElement((Element)lineablanco);
        titulo = new Paragraph("Sello digital del SAT", new Font(Font.FontFamily.TIMES_ROMAN, 7.0f, 1));
        titulo.setAlignment(0);
        cadena = new Paragraph(this.comprobante.getSelloSAT(), new Font(Font.FontFamily.TIMES_ROMAN, 5.0f));
        cadena.setAlignment(0);
        celda.addElement((Element)titulo);
        celda.addElement((Element)cadena);
        celda.addElement((Element)leyendadigital);
        celda.setBorder(0);
        celda.setVerticalAlignment(6);
        tablaDerecha.addCell(celda);
        tabla.addCell(tablaIzquierda);
        tabla.addCell(tablaDerecha);
        tabla.setExtendLastRow(true);
        return tabla;
    }

    public PdfPTable tablaDatosDigitalesCanc() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(28);
        tabla.setWidthPercentage(100.0f);
        PdfPCell celda = new PdfPCell();
        celda.setColspan(7);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
        celda = new PdfPCell();
        celda.setColspan(21);
        Paragraph p = null;
        if (this.comprobante.getStatus() == 0) {
            p = new Paragraph("Cadena de Cancelaci\u00f3n:", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
            p.setAlignment(0);
            celda.addElement((Element)p);
            p = new Paragraph(this.comprobante.getCancelaTexto(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
            p.setAlignment(0);
            celda.addElement((Element)p);
        }
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tabla.addCell(celda);
        return tabla;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.total.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        try {
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(((Object)((Object)this)).getClass().getName(), "onOpenDocument", e.toString(), "ERROR JAVA");
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        String text = "Pag. " + writer.getPageNumber() + " de ";
        float textBase = document.bottom() - 4.0f;
        float textSize = this.helv.getWidthPoint(text, 4.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 4.0f);
        float adjust = this.helv.getWidthPoint("0", 4.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.right() - adjust, textBase);
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.helv, 4.0f);
        this.total.setTextMatrix(0.0f, 0.0f);
        this.total.showText(String.valueOf(writer.getPageNumber() - 1));
        this.total.endText();
    }

    public static String espacios(int numEspacios) {
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < numEspacios) {
            str.append(" ");
            ++i;
        }
        return str.toString();
    }
}

