/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.test;

import java.io.File;
import java.util.ArrayList;
import siti.conexion.BDUtil;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dto.CfdEmisionDTO;

public class VerificaImportados {
    public static void main(String[] args) {
        String pFecha = "2016";
        String carpeta = "\\\\172.16.250.10\\CFDConnect\\emision\\boveda\\API940722EI2\\" + pFecha.replace("-", "\\");
        carpeta = "\\\\172.16.250.10\\cfdi_asipona\\emision\\boveda\\" + pFecha.replace("-", "\\");
        System.out.println(carpeta);
        boolean verificarArchivosTabla = true;
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
        }
        catch (Exception e) {
            System.out.println("Fallo en la conexi\u00f3n");
        }
        ArrayList<CfdEmisionDTO> listado = new ArrayList();
        CfdEmisionDAO cfdEmisionDAO = new CfdEmisionDAO();
        listado = cfdEmisionDAO.getListadoCFDEmision(bdUtil, pFecha);
        if (verificarArchivosTabla) {
            VerificaImportados.corroborarArchivosEnLaTabla(listado);
        } else {
            File carpetaABuscar = new File(carpeta);
            File[] listadoInterno = carpetaABuscar.listFiles();
            int i = 0;
            while (i < listadoInterno.length) {
                System.out.println("Carpeta: " + listadoInterno[i].getName());
                VerificaImportados.verificarArchivosSubidos(listadoInterno[i].getAbsolutePath(), listado);
                ++i;
            }
        }
        System.out.println("\nTermin\u00f3 el programa");
    }

    public static void verificarArchivosSubidos(String RutaArchivoABuscar, ArrayList<CfdEmisionDTO> listado) {
        File aux = new File(RutaArchivoABuscar);
        String archivoNoInsertado = "";
        int contador = 0;
        boolean existe = false;
        if (aux.isDirectory()) {
            File[] hijos = aux.listFiles();
            String vRutaCFD = "";
            String vRutaINT = "";
            String vRutaPDF = "";
            String vRuta = "";
            int i = 0;
            while (i < hijos.length) {
                if (hijos[i].isDirectory()) {
                    VerificaImportados.verificarArchivosSubidos(hijos[i].getAbsolutePath(), listado);
                } else {
                    existe = false;
                    vRuta = hijos[i].getAbsoluteFile().toString();
                    int j = 0;
                    while (j < listado.size()) {
                        vRutaCFD = listado.get(j).getRUTACFD().replace("E:", "\\\\172.16.250.10");
                        vRutaINT = listado.get(j).getRUTAINTERPRETADO().replace("E:", "\\\\172.16.250.10");
                        if (vRuta.contains("\\CFDI\\") && vRutaCFD.contains("\\CFDI\\") && !existe) {
                            archivoNoInsertado = hijos[i].getAbsoluteFile().toString();
                            if (vRuta.equals(vRutaCFD) && !existe) {
                                archivoNoInsertado = "";
                                existe = true;
                                break;
                            }
                        }
                        if (vRuta.contains("\\INTERPRETADO\\") && vRutaINT.contains("\\INTERPRETADO\\") && !existe) {
                            archivoNoInsertado = hijos[i].getAbsoluteFile().toString();
                            if (vRuta.equals(vRutaINT) && !existe) {
                                archivoNoInsertado = "";
                                existe = true;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (!existe && !archivoNoInsertado.isEmpty()) {
                        System.out.println(archivoNoInsertado);
                        ++contador;
                    }
                }
                ++i;
            }
        } else {
            System.out.println("Algo askjaksdnjasd");
        }
        if (contador > 0) {
            System.out.println("Archivos inexistentes: " + contador);
        }
    }

    public static void corroborarArchivosEnLaTabla(ArrayList<CfdEmisionDTO> listado) {
        File vRutaCFD = null;
        Object vRutaINT = null;
        File vRutaPDF = null;
        String vRutaCFDS = "";
        String vRutaINTS = "";
        String vRutaPDFS = "";
        boolean contadorT = false;
        int contadorCFD = 0;
        int contadorINT = 0;
        int contadorPDF = 0;
        String vIDFactura = "";
        System.out.println("Buscando archivos inexistentes registrados en cfd_emision.\n");
        ArrayList<String> vCFDs = new ArrayList<String>();
        ArrayList vINTs = new ArrayList();
        ArrayList<String> vPDFs = new ArrayList<String>();
        int i = 0;
        while (i < listado.size()) {
            vIDFactura = listado.get(i).getIDFACTURA();
            vRutaCFDS = listado.get(i).getRUTACFD();
            vRutaINTS = listado.get(i).getRUTAINTERPRETADO();
            vRutaPDFS = listado.get(i).getRUTAPDF();
            if (vRutaCFDS != null) {
                vRutaCFD = new File(vRutaCFDS.replace("E:", "\\\\172.16.250.10"));
                if (!vRutaCFD.exists()) {
                    vCFDs.add(vIDFactura + " \t " + vRutaCFDS.replace("E:", "\\\\172.16.250.10"));
                    ++contadorCFD;
                }
            } else {
                System.out.println("No tiene CFD la factura:" + vIDFactura + " Fecha emision:" + listado.get(i).getFECHA_EMISION());
                ++contadorCFD;
            }
            if (vRutaPDFS != null) {
                vRutaPDF = new File(vRutaPDFS.replace("E:", "\\\\172.16.250.10"));
                if (!vRutaPDF.exists()) {
                    vPDFs.add(vIDFactura + " \t " + vRutaPDFS + " \t " + " " + vRutaINTS.replace("E:\\CFDConnect\\emision\\boveda\\API940722EI2", "\\\\172.16.250.10\\cfdi_asipona\\emision\\boveda"));
                    ++contadorPDF;
                }
            } else {
                System.out.println("No tiene PDF la factura: " + vIDFactura + " Fecha emision:" + listado.get(i).getFECHA_EMISION() + " INTERPRETADO: " + vRutaINTS.replace("E:\\CFDConnect\\emision\\boveda\\API940722EI2", "\\\\172.16.250.10\\cfdi_asipona\\emision\\boveda"));
                ++contadorPDF;
            }
            ++i;
        }
        System.out.println("\n-------CFD INEXISTENES REGISTRADOS EN LA BD---");
        i = 0;
        while (i < vCFDs.size()) {
            System.out.println((String)vCFDs.get(i));
            ++i;
        }
        System.out.println("\n-------PDF INEXISTENES REGISTRADOS EN LA BD---");
        i = 0;
        while (i < vPDFs.size()) {
            System.out.println((String)vPDFs.get(i));
            ++i;
        }
        System.out.println("\nTermin\u00f3 la busqueda de archivos inexistentes.\nCFD inexistentes: " + contadorCFD + "\nINT inexistentes: " + contadorINT + "\nPDF inexistentes: " + contadorPDF + "\nTotal de archivos inexistentes:" + (contadorCFD + contadorINT + contadorPDF));
    }
}

