/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.test;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.LogcfdDAO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.ArchivoXml;
import siti.sinco.cfdi.tools.CfdiCliente;
import siti.sinco.cfdi.tools.CfdiExceptionPac;
import siti.sinco.cfdi.tools.NodoComplemento;

public class testTimbrarXmlDigibox {
    private int empNum;
    private int numComprobante;
    private ConfiguracionDTO configuracion;
    private ComprobanteDTO comprobante;
    public String path;
    private String mail;
    public String modo;
    private int preview;
    public String tipoDoc;
    public int envios;
    public int cierraConexion;
    private BDUtil bdUtil;
    public static String certificado;

    public testTimbrarXmlDigibox(int empNum, int numComprobante, String path, String mail, BDUtil bdUtil, int cierraConexion, String modo, String tipoDoc, int envios, int preview) throws GeneralSecurityException {
        this.empNum = empNum;
        this.numComprobante = numComprobante;
        this.path = path;
        this.mail = mail;
        this.bdUtil = bdUtil;
        this.cierraConexion = cierraConexion;
        this.modo = modo;
        this.tipoDoc = tipoDoc;
        this.envios = envios;
        this.preview = preview;
        this.cfdUtilGeneraCFD();
    }

    public static void main(String[] args) throws IOException, DocumentException, GeneralSecurityException {
        System.out.println(String.valueOf(args[0]) + " " + args[8]);
        LeeConexion.path = args[1];
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
            System.out.println("Se establecio conexion");
        }
        catch (Exception exception) {
            // empty catch block
        }
        new testTimbrarXmlDigibox(Integer.parseInt(args[0]), Integer.parseInt(args[8]), args[1], args[2], bdUtil, Integer.parseInt(args[3]), args[4], args[5], Integer.parseInt(args[6]), Integer.parseInt(args[7]));
    }

    private void cfdUtilGeneraCFD() {
        this.configuracion = new ConfiguracionDTO();
        this.comprobante = new ComprobanteDTO(this.numComprobante);
        LogcfdDAO log = new LogcfdDAO();
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        configDAO.llenarConfiguracion(this.bdUtil, this.configuracion, this.empNum);
        ComprobantesDAO comprobantesDAO = new ComprobantesDAO(this.configuracion.getRutaSalidaTimbre());
        comprobantesDAO.llenarComprobante(this.bdUtil, this.comprobante);
        ArchivoXml xmlFile = new ArchivoXml();
        NodoComplemento nodoTimbreFiscal = new NodoComplemento();
        try {
            String xmlString = xmlFile.XmlToArray("C:\\SITI\\APIMAZ\\CFDI\\emision\\nuevo4.2212489_BFE030305D39_20211110pto.xml");
            String xmlTimbrado = null;
            System.out.println(" xmlString: " + xmlString);
            CfdiCliente cfdiCliente = new CfdiCliente();
            try {
                xmlTimbrado = cfdiCliente.getTimbreCfdi(this.configuracion.getUsuarioPac(), this.configuracion.getPassPac(), xmlString, this.modo, this.comprobante.getTipoDoc());
                System.out.println(" xmlTimbrado: " + xmlTimbrado);
                if (xmlTimbrado != null) {
                    nodoTimbreFiscal = cfdiCliente.leerNodo(0, xmlTimbrado);
                    comprobantesDAO.actualizaComprobante(this.bdUtil, this.comprobante, 1, nodoTimbreFiscal);
                    System.out.println("actualizaComprobante: ");
                    this.comprobante.setVersionTFD(nodoTimbreFiscal.getVersion());
                    this.comprobante.setUUID(nodoTimbreFiscal.getUUID());
                    this.comprobante.setFechaTimbrado(nodoTimbreFiscal.getFechaTimbrado());
                    this.comprobante.setNoCertificadoSAT(nodoTimbreFiscal.getNoCertificadoSAT());
                    this.comprobante.setSelloSAT(nodoTimbreFiscal.getSelloSAT());
                    this.comprobante.setRfcProvCertif(nodoTimbreFiscal.getRfcProvCertif());
                    log.actualizaLogError(this.bdUtil, this.comprobante.getComprobante());
                    log.insertaLogError(this.bdUtil, this.comprobante.getComprobante(), "", "", "", "TIMBRADO");
                }
            }
            catch (CfdiExceptionPac e) {
                System.out.println("El formato es incorrecto 1: " + e.getCod() + ", " + e.getText() + ", " + e.getTextCode());
                log.insertaLogError(this.bdUtil, this.comprobante.getComprobante(), e.getCod(), e.getText(), e.getTextCode(), "ERROR");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

