/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import com.digibox.WsAutenticacionLocator;
import com.digibox.WsAutenticacionSoapStub;
import com.digibox.WsCancelacionLocator;
import com.digibox.WsCancelacionSoapStub;
import com.digibox.WsTimbradoLocator;
import com.digibox.WsTimbradoSoapStub;
import java.io.ByteArrayInputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.datacontract.schemas._2004._07.Sat_Cfdi_Negocio_ConsultaCfdi_Servicio.Acuse;
import org.tempuri.ConsultaCFDIServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import siti.sinco.cfdi.dao.LogcfdDAO;
import siti.sinco.cfdi.dto.CFDICanceladosDTO;
import siti.sinco.cfdi.tools.ArchivoXml;
import siti.sinco.cfdi.tools.CfdiExceptionPac;
import siti.sinco.cfdi.tools.CfdiExceptionSiti;
import siti.sinco.cfdi.tools.EscribeSalidaProcesos;
import siti.sinco.cfdi.tools.NodoComplemento;

public class CfdiCliente {
    public ArchivoXml timbre;

    public CfdiCliente(String in_archivoxml) {
        this.timbre = new ArchivoXml(in_archivoxml);
    }

    public CfdiCliente() {
        this.timbre = new ArchivoXml();
    }

    public String autenticar(String usuario, String pass, String modo) throws Exception {
        String tokenAutorizacion;
        block8: {
            tokenAutorizacion = null;
            String vPaso = "[CFDICliente.autenticar] 1";
            WsAutenticacionLocator autenticaClient = new WsAutenticacionLocator();
            try {
                vPaso = "[CFDICliente.autenticar] 2";
                if (modo.equals("PROD")) {
                    vPaso = "[CFDICliente.autenticar] 2b";
                    System.out.println("Autenticando en modo PROD");
                    try {
                        vPaso = "[CFDICliente.autenticar] 3b";
                        WsAutenticacionSoapStub servicio = new WsAutenticacionSoapStub(new URL("https://timbrado.digibox.com.mx/Autenticacion/wsAutenticacion.asmx"), autenticaClient);
                        System.out.println("Se contacto el servicio de autenticar en modo PROD");
                        try {
                            vPaso = "[CFDICliente.autenticar] 4b";
                            tokenAutorizacion = servicio.autenticarBasico(usuario, pass);
                            System.out.println("Se obtuvo respuesta del Server de DIGIBOX en mod PROD y el token es: " + tokenAutorizacion);
                            EscribeSalidaProcesos.Log("Se obtuvo respuesta del Server de DIGIBOX en mod PROD");
                            break block8;
                        }
                        catch (Exception e) {
                            System.out.println("\n||| Error a la hora de obtener el TOKEN DE AUTORIZACION:" + e.toString());
                            throw new CfdiExceptionSiti(100, "Imposible obtener el token: " + e.toString(), "No se pudo obtener el token de autorizaci\u00f3n para timbrar: " + e.toString());
                        }
                    }
                    catch (Exception e) {
                        System.out.println("[EXCEPCION] Error a la hora de consumir el WEB SERVICE:" + e.toString());
                        throw new CfdiExceptionSiti(100, "Imposible autenticar: " + e.toString(), "Error a la hora de consumir el WEB SERVICE: " + e.toString());
                    }
                }
                if (modo.equals("TEST")) {
                    vPaso = "[CFDICliente.autenticar] 2c";
                    System.out.println("Autenticando en modo TEST");
                    WsAutenticacionSoapStub servicio = new WsAutenticacionSoapStub(new URL("http://testtimbrado.digibox.com.mx/Autenticacion/wsAutenticacion.asmx"), autenticaClient);
                    vPaso = "[CFDICliente.autenticar] 3c";
                    tokenAutorizacion = servicio.autenticarBasico(usuario, pass);
                    System.out.println("Se obtuvo respuesta al autenticar del Server de DIGIBOX en modo TEST y el token es: " + tokenAutorizacion);
                }
            }
            catch (Exception e) {
                System.out.println("Error autenticar Paso:" + vPaso + " - " + e);
                throw e;
            }
        }
        return tokenAutorizacion;
    }

    public String getTimbreCfdi(String usuario, String pass, String xmlFile, String modo, String tipoDoc) throws Exception {
        String xmlFile_timbrado = null;
        String token = null;
        LogcfdDAO log = new LogcfdDAO();
        try {
            token = this.autenticar(usuario, pass, modo);
        }
        catch (Exception e) {
            token = null;
            System.out.println("No se pudo obtener el token de autorizaci\u00f3n.");
            throw e;
        }
        if (token != null) {
            WsTimbradoLocator timbraClient = new WsTimbradoLocator();
            try {
                if (tipoDoc.equals("FC") || tipoDoc.equals("CB") || tipoDoc.equals("NM")) {
                    if (modo.equals("PROD")) {
                        System.out.println("Timbrando MODO_PROD");
                        WsTimbradoSoapStub servicio = new WsTimbradoSoapStub(new URL("https://timbrado.digibox.com.mx/Timbrado/wsTimbrado.asmx"), timbraClient);
                        xmlFile_timbrado = servicio.timbrarXML(xmlFile, token);
                        System.out.println("Se obtuvo respuesta del Server de DIGIBOX en mod PROD");
                        EscribeSalidaProcesos.Log("Se obtuvo respuesta del Server de DIGIBOX en mod PROD");
                    } else if (modo.equals("TEST")) {
                        System.out.println("Timbrando MODO_TEST");
                        WsTimbradoSoapStub servicio = new WsTimbradoSoapStub(new URL("http://testtimbrado.digibox.com.mx/Timbrado/wsTimbrado.asmx"), timbraClient);
                        xmlFile_timbrado = servicio.timbrarXML(xmlFile, token);
                        System.out.println("Se obtuvo respuesta del Server de DIGIBOX en mod TEST");
                    }
                }
            }
            catch (Exception e) {
                CfdiExceptionPac CFDIe = new CfdiExceptionPac(e);
                System.out.println("CodigoError: " + CFDIe.getCod());
                System.out.println("TextoError: " + CFDIe.getText());
                System.out.println("ExplicacionError: " + CFDIe.getTextCode());
                System.out.println("e");
                if (CFDIe.getText() != null) {
                    if (CFDIe.getText().isEmpty()) {
                        CFDIe.setText(e.toString());
                    }
                } else {
                    CFDIe.setText(e.toString());
                }
                EscribeSalidaProcesos.Log("getCod()=" + CFDIe.getCod() + "\n" + "getText()=" + CFDIe.getText() + "\n" + "getTextCode()=" + CFDIe.getTextCode());
                throw CFDIe;
            }
        }
        return xmlFile_timbrado;
    }

    public String cancelarCFDICSD(String usuarioPAC, String passPAC, String CSDCer, String CSDKey, String passKey, CFDICanceladosDTO cfdicanceladoDto, String modo) throws Exception {
        String token = "";
        String xmlFile_cancelado = "";
        String[] UUIDs = new String[]{cfdicanceladoDto.getUuid()};
        WsCancelacionSoapStub servicio = null;
        String vURL = "";
        token = this.autenticar(usuarioPAC, passPAC, modo);
        WsCancelacionLocator cancelaLocator = new WsCancelacionLocator();
        if (modo.equals("PROD")) {
            System.out.println("Cancelando MODO_PROD..........");
            vURL = "https://timbrado.digibox.com.mx/Cancelacion/wsCancelacion.asmx";
            servicio = new WsCancelacionSoapStub(new URL(vURL), cancelaLocator);
            System.out.println("1");
        } else if (modo.equals("TEST")) {
            System.out.println("Cancelando MODO_TEST..........");
            vURL = "http://digibox2t.cloudapp.net/Cancelacion/wsCancelacion.asmx";
            servicio = new WsCancelacionSoapStub(new URL(vURL), cancelaLocator);
        }
        System.out.println("CER " + CSDCer + "\n" + "KEY " + CSDKey + "\n" + "PSS " + passKey + "\n" + "RFC " + cfdicanceladoDto.getRfcEmisor() + "\n" + "UUID " + UUIDs[0] + "\n" + "UUIDS " + cfdicanceladoDto.getUuid_sustitucion() + "\n" + "ClaveSATCancelacion " + cfdicanceladoDto.getClavesatcancelacion());
        xmlFile_cancelado = servicio.cancelarCSDV2(CSDCer, CSDKey, passKey, cfdicanceladoDto.getRfcEmisor(), UUIDs, cfdicanceladoDto.getUuid_sustitucion(), cfdicanceladoDto.getClavesatcancelacion(), token);
        System.out.println("XML DEVUELTO DE LA CANCELACI\u00d3N: " + xmlFile_cancelado);
        return xmlFile_cancelado;
    }

    public String cancelarCFDIPEMV2(String pusuarioPAC, String ppassPAC, String pCerPEM, String pKeyPEM, String prfcEmisor, String pUUID, String pmodo) throws Exception {
        String vURL = "";
        String vtoken = "";
        String xmlFile_cancelado = "";
        String[] vUUIDs = new String[]{pUUID};
        WsCancelacionSoapStub servicio = null;
        vtoken = this.autenticar(pusuarioPAC, ppassPAC, pmodo);
        WsCancelacionLocator cancelaLocator = new WsCancelacionLocator();
        System.out.println("pmodo=" + pmodo);
        if (pmodo.equals("PROD")) {
            System.out.println("Cancelando MODO_PROD..........");
        } else if (pmodo.equals("TEST")) {
            System.out.println("Cancelando MODO_TEST..........");
            vURL = "http://digibox2t.cloudapp.net/Cancelacion/wsCancelacion.asmx";
            servicio = new WsCancelacionSoapStub(new URL(vURL), cancelaLocator);
        }
        System.out.println("contacto a cancelando");
        return xmlFile_cancelado;
    }

    public Acuse consultaServicioCancelacionSAT(String pExpresion) {
        Acuse acuse = null;
        QName qname = new QName("ConsultaCFDIService");
        String wsldLoc = "http://tempuri.org/";
        try {
            ConsultaCFDIServiceLocator locator = new ConsultaCFDIServiceLocator();
            acuse = locator.getBasicHttpBinding_IConsultaCFDIService().consulta(pExpresion);
        }
        catch (Exception e) {
            System.out.println("Error:" + e.toString());
        }
        return acuse;
    }

    public NodoComplemento leerNodo(int tipo_archivo, String archivoTimbrado) throws Exception {
        NodoComplemento nodocomplemento = new NodoComplemento();
        byte[] xml = archivoTimbrado.getBytes();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(xml));
            Element raiz = doc.getDocumentElement();
            Element timbre = doc.getDocumentElement();
            NodeList hijosRaiz = raiz.getChildNodes();
            if (tipo_archivo == 0) {
                nodocomplemento = this.getAtributosTimbre(timbre);
            }
            if (tipo_archivo == 1) {
                nodocomplemento = this.getNodosHijos(hijosRaiz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodocomplemento;
    }

    public NodoComplemento getAtributosTimbre(Node nodo_timbreFiscal) {
        NodoComplemento nodo_obj = null;
        if (nodo_timbreFiscal instanceof Element && nodo_timbreFiscal.getNodeName().equals("tfd:TimbreFiscalDigital")) {
            nodo_obj = new NodoComplemento();
            nodo_obj.setSelloSAT(nodo_timbreFiscal.getAttributes().getNamedItem("SelloSAT").getTextContent());
            nodo_obj.setNoCertificadoSAT(nodo_timbreFiscal.getAttributes().getNamedItem("NoCertificadoSAT").getTextContent());
            nodo_obj.setSelloCFD(nodo_timbreFiscal.getAttributes().getNamedItem("SelloCFD").getTextContent());
            nodo_obj.setRfcProvCertif(nodo_timbreFiscal.getAttributes().getNamedItem("RfcProvCertif").getTextContent());
            nodo_obj.setFechaTimbrado(nodo_timbreFiscal.getAttributes().getNamedItem("FechaTimbrado").getTextContent());
            nodo_obj.setUUID(nodo_timbreFiscal.getAttributes().getNamedItem("UUID").getTextContent());
            System.out.println("UUID:" + nodo_timbreFiscal.getAttributes().getNamedItem("UUID").getTextContent());
            nodo_obj.setVersion(nodo_timbreFiscal.getAttributes().getNamedItem("Version").getTextContent());
        }
        return nodo_obj;
    }

    public NodoComplemento getNodosHijos(NodeList nodos_hijosRaiz) {
        NodoComplemento nodo_obj = null;
        int i = 0;
        while (i < nodos_hijosRaiz.getLength()) {
            Node nodo = nodos_hijosRaiz.item(i);
            if ((nodo.getNodeName().equals("cfdi:Complemento") || nodo.getNodeName().equals("retenciones:Complemento")) && nodo instanceof Element) {
                Element complemento = (Element)nodo;
                nodo_obj = this.getAtributos(complemento.getChildNodes());
            }
            ++i;
        }
        return nodo_obj;
    }

    public NodoComplemento getAtributos(NodeList nodos_hijosRaiz) {
        NodoComplemento nodo_obj = null;
        int i = 0;
        while (i < nodos_hijosRaiz.getLength()) {
            Node nodo = nodos_hijosRaiz.item(i);
            if (nodo instanceof Element && nodo.getNodeName().equals("tfd:TimbreFiscalDigital")) {
                nodo_obj = new NodoComplemento();
                nodo_obj.setSelloCFD(nodo.getAttributes().getNamedItem("SelloCFD").getTextContent());
                nodo_obj.setFechaTimbrado(nodo.getAttributes().getNamedItem("FechaTimbrado").getTextContent());
                System.out.println("UUID=" + nodo.getAttributes().getNamedItem("UUID").getTextContent());
                nodo_obj.setUUID(nodo.getAttributes().getNamedItem("UUID").getTextContent());
                nodo_obj.setNoCertificadoSAT(nodo.getAttributes().getNamedItem("NoCertificadoSAT").getTextContent());
                nodo_obj.setVersion(nodo.getAttributes().getNamedItem("Version").getTextContent());
                nodo_obj.setSelloSAT(nodo.getAttributes().getNamedItem("SelloSAT").getTextContent());
                nodo_obj.setRfcProvCertif(nodo.getAttributes().getNamedItem("RfcProvCertif").getTextContent());
            }
            ++i;
        }
        return nodo_obj;
    }
}

