/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.datacontract.schemas._2004._07.Sat_Cfdi_Negocio_ConsultaCfdi_Servicio.Acuse;
import org.tempuri.ConsultaCFDIServiceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import siti.conexion.BDUtil;

public class ImportaFacturaProv {
    public ImportaFacturaProv() {
    }

    public static void main(String[] args) {
        System.out.println("Num de par\u00e1metros: " + args.length);
        if (args.length == 10) {
            if (args[2].equals("1")) {
                ImportaFacturaProv importaFacturaProv = new ImportaFacturaProv(args[0], args[1], true, args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
            } else if (args[2].equals("0")) {
                ImportaFacturaProv importaFacturaProv = new ImportaFacturaProv(args[0], args[1], false, args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
            } else {
                System.out.println("|---Error: Tercer parametro debe ser 0 Carpeta o 1 Archivo: " + args[2] + "-");
            }
        } else {
            System.out.println("Parametros: RutaOrigen RutaDestino 0/1(Carpeta/Archivo) Pedido RFCEmisor RFCReceptor RutaPDF Total Factura [O | E | V](tipoFactura) Fecha(YYYY\\MM\\DD)");
        }
    }

    public ImportaFacturaProv(String pRutaOrigen, String pRutaDestino, boolean pIsArchivo, String pPedido, String pRFCEmisor, String pRFCReceptor, String pRutaPDF, String pTotal, String pFactura, String pFecha) {
        ImportaFacturaProv.leerCarpetaOArchivo(pRutaOrigen, pRutaDestino, pIsArchivo, pPedido, pRFCEmisor, pRFCReceptor, pRutaPDF, pTotal, pFactura, pFecha);
    }

    public static Node getNodoDe(Document pFactura, String pNombreNodo) {
        Node vNodo = pFactura.getElementsByTagName(pNombreNodo).item(0);
        if (vNodo == null) {
            System.out.println("---Error: No existe el nodo '" + pNombreNodo + "'.");
        }
        return vNodo;
    }

    public static Node getNodoHijoDe(Node pNodoPadre, String pNodoHijo) {
        Node vNodoR = null;
        if (pNodoPadre != null) {
            Element vElement = (Element)pNodoPadre;
            NodeList vHijos = vElement.getElementsByTagName(pNodoHijo);
            if (vHijos != null) {
                int i = 0;
                while (i < vHijos.getLength()) {
                    if (vHijos.item(i).getNodeType() == 1 && vHijos.item(i).getParentNode() == pNodoPadre) {
                        vNodoR = vHijos.item(i);
                    }
                    ++i;
                }
            } else {
                System.out.println("--- Nodo '" + pNodoHijo + "' no existe.");
            }
        }
        return vNodoR;
    }

    public static String getAtributo(Node pNodo, String pAtributo) {
        String vValor = null;
        if (pNodo != null) {
            int vLongitud = pNodo.getAttributes().getLength();
            if (vLongitud > 0) {
                NamedNodeMap vAtributos = pNodo.getAttributes();
                int i = 0;
                while (i < vLongitud) {
                    if (vAtributos.item(i).getNodeName().toUpperCase().equals(pAtributo.toUpperCase())) {
                        vValor = vAtributos.item(i).getNodeValue();
                        break;
                    }
                    ++i;
                }
            } else {
                System.out.println("--- No contiene atributos el nodo: '" + pNodo.getNodeName() + "'");
            }
        }
        return vValor;
    }

    public static String getContenidoDe(Node pNodo, String pEtiqueta) {
        String vValor = null;
        Element vElement = (Element)pNodo;
        Node vNodo = vElement.getElementsByTagName(pEtiqueta).item(0);
        if (vNodo != null) {
            vValor = vElement.getElementsByTagName(pEtiqueta).item(0).getTextContent();
        } else {
            System.out.println("Etiqueta: " + pEtiqueta + " | No existe.");
        }
        return vValor;
    }

    public static Document facturaNormalizada(String pRutaFactura) {
        Document vFactura = null;
        try {
            File vFFactura = new File(pRutaFactura);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            vFactura = db.parse(vFFactura);
            vFactura.getDocumentElement().normalize();
        }
        catch (Exception e) {
            System.out.println("|---Error:No se pudo normalizar la FACTURA: \n\t" + pRutaFactura + "\n\terror: " + e.toString());
        }
        return vFactura;
    }

    public static void importarA(String pRutaDestino, String pRutaArchivo, String pExtensionAVerificar) {
        String vDestinoFinal = "";
        String[] auxRuta = pRutaDestino.replace("\\\\", "\\").replace("\\", "/").split("/");
        int i = 0;
        while (i < auxRuta.length - 1) {
            vDestinoFinal = String.valueOf(vDestinoFinal) + "\\" + auxRuta[i];
            ++i;
        }
        try {
            if (pRutaArchivo.contains("." + pExtensionAVerificar)) {
                File vArchivoOrigen = new File(pRutaArchivo);
                if (vArchivoOrigen.exists()) {
                    File vDestino = new File(vDestinoFinal);
                    if (!vDestino.exists()) {
                        vDestino.mkdirs();
                        System.out.println("Se cre\u00f3 la carpeta para guardar el archivo");
                    }
                    Path vPathOrigen = Paths.get(pRutaArchivo, new String[0]);
                    Path vPathDestino = Paths.get(pRutaDestino, new String[0]);
                    System.out.println("Origen:" + pRutaArchivo);
                    System.out.println("Destino:" + pRutaDestino);
                    Files.copy(vPathOrigen, vPathDestino, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("\u00a1Se copi\u00f3 de forma exitosa! " + auxRuta[auxRuta.length - 1]);
                } else {
                    System.out.println("No se pudo mover el archivo: " + auxRuta[auxRuta.length - 1] + " ya que no existe.");
                }
            } else {
                System.out.println("No se movi\u00f3:" + pRutaArchivo + " ya que no coincide con la extensi\u00f3n ." + pExtensionAVerificar);
            }
        }
        catch (Exception e) {
            System.out.println("|---Error: No se pudo mover : " + auxRuta[auxRuta.length - 1] + "\n\tError: " + e.toString());
        }
    }

    public static Acuse comprobarFactura(String pRfcEmisor, String pRfcReceptor, String pTotal, String pId) {
        String vExpresion = "re=" + pRfcEmisor + "&rr=" + pRfcReceptor + "&tt=" + pTotal + "&id=" + pId;
        System.out.println("Cadena enviada: " + vExpresion);
        Acuse vAcuse = null;
        try {
            ConsultaCFDIServiceLocator locator = new ConsultaCFDIServiceLocator();
            long inicio = System.currentTimeMillis();
            vAcuse = locator.getBasicHttpBinding_IConsultaCFDIService().consulta(vExpresion);
            long fin = System.currentTimeMillis() - inicio;
            System.out.println("El servidor ha tardado en responder:" + (double)(fin / 1000L) + " segundos ( " + fin + " milisegundos ).");
        }
        catch (Exception e) {
            System.out.println("|---Error: No se pudo contactar al SAT: " + e.toString());
        }
        return vAcuse;
    }

    public static void actualizarFactura(BDUtil pbdUtil, String pFolioInterno, String pESTATUSTIMBRADO, String pRESPUESTAPAC, String pUUID) {
        String vUUID = pUUID;
        if (vUUID == null) {
            vUUID = "";
        }
        String query = "UPDATE inventario.facturas SET \testatustimbrado = '" + pESTATUSTIMBRADO + "', " + "\t\trespuestapac = '" + pRESPUESTAPAC + "', " + "\t\tuuid = '" + vUUID + "' " + "WHERE \tempresa = 1 " + "AND\tfactura = " + pFolioInterno;
        try {
            pbdUtil.ejecutaSentencia(query);
            pbdUtil.connection.commit();
            System.out.println("Se actualiz\u00f3 la factura: " + pFolioInterno);
        }
        catch (Exception e) {
            System.out.println("No se pudo actualizar la factura: " + pFolioInterno + " Error:" + e.toString());
        }
    }

    public static String insertarFacturaValida(BDUtil pbdUtil, ArrayList<String> pDatos) {
        String vMensaje = "ERROR";
        String linea = "210";
        CallableStatement callable = null;
        linea = "212";
        String query = "{ call insertarcfd_recepcion(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )}";
        try {
            callable = pbdUtil.connection.prepareCall(query);
            int vIndice = 1;
            int vIndice2 = 0;
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            linea = "287";
            String cfdS = pDatos.get(vIndice2++);
            linea = "296";
            if (cfdS.length() > 32768) {
                cfdS = " ";
            }
            StringReader cfd = new StringReader(cfdS);
            linea = "298";
            callable.setCharacterStream(vIndice++, (Reader)cfd, cfdS.length());
            System.out.println("agregando valores");
            linea = "299";
            callable.execute();
            linea = "300";
            pbdUtil.connection.commit();
            vMensaje = "EXITO";
        }
        catch (SQLException sqle) {
            int codigoError = sqle.getErrorCode();
            switch (codigoError) {
                case 20001: {
                    System.out.println("Mensaje devuelto por ORACLE: " + sqle.getErrorCode() + " Mensaje: " + sqle.getMessage().split(":")[1]);
                    vMensaje = "El UUID ya fue insertado con anterioridad.CFD_RECEPCION";
                    break;
                }
                case 20002: {
                    vMensaje = "El UUID ya fue recibido con anterioridad.DOCTO_RECIB";
                    break;
                }
                default: {
                    vMensaje = String.valueOf(sqle.getMessage()) + " | " + sqle.getCause();
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("|---Error Java:  linea " + linea + " No se pudo guardar en CFD_RECEPCION: " + e.toString());
            vMensaje = e.toString();
        }
        if (callable != null) {
            try {
                callable.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callable = null;
        }
        return vMensaje;
    }

    public static String insertarFacturaInvalida(BDUtil pbdUtil, ArrayList<String> pDatos) {
        String vMensaje = "ERROR";
        String linea = "210";
        CallableStatement callable = null;
        linea = "212";
        String query = "{ call insertarcfd_recepcion_invalido(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
        try {
            callable = pbdUtil.connection.prepareCall(query);
            int vIndice = 1;
            int vIndice2 = 0;
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            callable.setString(vIndice++, pDatos.get(vIndice2++));
            linea = "443";
            String cfdS = pDatos.get(vIndice2++);
            linea = "446";
            StringReader cfd = new StringReader(cfdS);
            linea = "448";
            callable.setCharacterStream(vIndice++, (Reader)cfd, cfdS.length());
            linea = "451";
            callable.execute();
            pbdUtil.connection.commit();
            vMensaje = "EXITO";
        }
        catch (Exception e) {
            System.out.println("|---Error:  linea " + linea + " No se pudo guardar en CFD_RECEPCION_INVALIDO: " + e.toString());
            vMensaje = e.toString();
        }
        if (callable != null) {
            try {
                callable.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callable = null;
        }
        return vMensaje;
    }

    public static void insertarCFDRecepcionError(BDUtil pbdUtil, String pFolio, String pError) {
        String query = "INSERT INTO cfd_recepcion_error (idfactura,descripcion, id) VALUES('" + pFolio + "', '" + pError + "', seq_cfd_recepcion_error.nextVal)";
        try {
            pbdUtil.ejecutaSentencia(query);
            pbdUtil.connection.commit();
            System.out.println("Se inserto en CFD_RECEPCION_ERROR: " + pFolio);
        }
        catch (Exception e) {
            System.out.println("|---Error: No se pudo guardar en CFD_RECEPCION_ERROR: " + e.toString());
        }
    }

    public static String getContenidoXML(String pRutaXML) {
        String vValor = "";
        if (!pRutaXML.isEmpty()) {
            File vArchivoXML = new File(pRutaXML);
            if (vArchivoXML.exists()) {
                try {
                    String str;
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vArchivoXML), "UTF-8"));
                    while ((str = in.readLine()) != null) {
                        vValor = String.valueOf(vValor) + str;
                    }
                    vValor = vValor.replaceAll("\\s{2,}", " ");
                    in.close();
                }
                catch (Exception e) {
                    System.out.println("|---Error: Algo sali\u00f3 mal a la hora de leer el archivo." + e.toString());
                }
            } else {
                System.out.println("|---Error: El archivo" + pRutaXML + " no existe.");
            }
        } else {
            System.out.println("|---Error: La ruta ingresada est\u00e1 vac\u00eda.");
        }
        return vValor;
    }

    public static String decodifica_tipoDeComprobante(String pTipoDeComprobante) {
        String vTipoDeComprobante = "";
        switch (pTipoDeComprobante) {
            case "I": {
                vTipoDeComprobante = "ingreso";
                break;
            }
            case "N": {
                vTipoDeComprobante = "nomina";
                break;
            }
            case "E": {
                vTipoDeComprobante = "egreso";
                break;
            }
            case "P": {
                vTipoDeComprobante = "pago";
            }
        }
        return vTipoDeComprobante;
    }

    public static String verifica_estructura(Node[] pNodos_a_comprobar) {
        String vMensaje = "";
        Node[] nodeArray = pNodos_a_comprobar;
        int n = pNodos_a_comprobar.length;
        int n2 = 0;
        while (n2 < n) {
            Node nodo = nodeArray[n2];
            if (nodo == null) {
                vMensaje = "ERROR:La estructura del XML es incorrecta, revise que exista el nodo comprobante, emisor, receptor y complemento.";
                break;
            }
            ++n2;
        }
        return vMensaje;
    }

    public static void leerFactura(BDUtil pbdUtil, String pRutaXML, String pRutaDestino, String pPedido, String pRFCEmisor, String pRFCReceptor, String pRutaPDF, String pTotal, String pFactura, String pFechaRecepcion) {
        String vMensajeGeneral = "";
        String[] auxNombreXML = pRutaXML.replace("\\", "/").split("/");
        String[] auxNombrePDF = pRutaPDF.replace("\\", "/").split("/");
        Document vFactura = ImportaFacturaProv.facturaNormalizada(pRutaXML);
        Acuse vRespuesta = null;
        ArrayList<String> vDatos = new ArrayList<String>();
        Node vComprobante = ImportaFacturaProv.getNodoDe(vFactura, "cfdi:Comprobante");
        Node vEmisor = ImportaFacturaProv.getNodoDe(vFactura, "cfdi:Emisor");
        Node vReceptor = ImportaFacturaProv.getNodoDe(vFactura, "cfdi:Receptor");
        Node vComplemento = ImportaFacturaProv.getNodoDe(vFactura, "cfdi:Complemento");
        Node vTimbreFiscal = ImportaFacturaProv.getNodoHijoDe(vComplemento, "tfd:TimbreFiscalDigital");
        Node vImpuestos = ImportaFacturaProv.getNodoHijoDe(vComprobante, "cfdi:Impuestos");
        Node vcfdiRelaciona2 = ImportaFacturaProv.getNodoHijoDe(vComprobante, "cfdi:CfdiRelacionados");
        Node vcfdiRelacion = ImportaFacturaProv.getNodoHijoDe(vcfdiRelaciona2, "cfdi:CfdiRelacionado");
        String vRFCEmisor = ImportaFacturaProv.getAtributo(vEmisor, "rfc");
        String vRFCReceptor = ImportaFacturaProv.getAtributo(vReceptor, "rfc");
        String vTotal = ImportaFacturaProv.getAtributo(vComprobante, "total");
        String vId = ImportaFacturaProv.getAtributo(vTimbreFiscal, "UUID");
        String vFecha = ImportaFacturaProv.getAtributo(vComprobante, "fecha");
        String vIdFactura = String.valueOf(pPedido) + "-";
        vIdFactura = pPedido.startsWith("V") ? String.valueOf(vIdFactura) + vId : String.valueOf(vIdFactura) + pFactura;
        Node[] vEstructura = new Node[]{vComprobante, vEmisor, vReceptor, vComplemento};
        vMensajeGeneral = ImportaFacturaProv.verifica_estructura(vEstructura);
        if (vMensajeGeneral.isEmpty()) {
            if (pRFCEmisor.toUpperCase().equals(vRFCEmisor.toUpperCase())) {
                if (pRFCReceptor.toUpperCase().equals(vRFCReceptor.toUpperCase())) {
                    Node impuestosLocales;
                    Node aerolineas;
                    Node otrosCargos;
                    String vRutaDestinoCFD = null;
                    String vRutaDestinoPDF = null;
                    vRespuesta = ImportaFacturaProv.comprobarFactura(vRFCEmisor, vRFCReceptor, vTotal, vId);
                    System.out.println("Validacion EFOS\t: " + vRespuesta.getValidacionEFOS() + "\nCodigo Status\t: " + vRespuesta.getCodigoEstatus() + "\nEstado\t\t: " + vRespuesta.getEstado() + "\nEstatus cancel\t: " + vRespuesta.getEstatusCancelacion());
                    String vRutaBase = pRutaDestino.replace("\\", "/");
                    if (!vRutaBase.endsWith("/")) {
                        vRutaBase = String.valueOf(vRutaBase) + "/";
                    }
                    String vMensajePAC = vRespuesta.getCodigoEstatus();
                    int vEstadoValidacion = 0;
                    boolean encontrado = false;
                    int vCancelado = 0;
                    String vFechaRecepcion = pFechaRecepcion.replace("\\", "/");
                    if (vMensajePAC.startsWith("S")) {
                        vEstadoValidacion = 1;
                        vCancelado = vRespuesta.getEstado().equals("Vigente") ? 0 : 1;
                        String[] auxFecha = vFecha.split("T");
                        if (pFechaRecepcion.equals("FECHACOMPROBANTE")) {
                            vFechaRecepcion = auxFecha[0].replace("-", "/");
                        }
                        vRutaBase = String.valueOf(vRutaBase) + vFechaRecepcion + "/" + pPedido + "_" + vId.substring(0, 8);
                        vRutaDestinoCFD = String.valueOf(vRutaBase) + ".xml";
                        vRutaDestinoPDF = String.valueOf(vRutaBase) + ".pdf";
                        encontrado = true;
                    } else {
                        vEstadoValidacion = 0;
                        vCancelado = 0;
                        vRutaBase = String.valueOf(vRutaBase) + "errores/" + pPedido + "_" + vId.substring(0, 8);
                        vRutaDestinoCFD = String.valueOf(vRutaBase) + ".xml";
                        vRutaDestinoPDF = String.valueOf(vRutaBase) + ".pdf";
                        vMensajePAC = vMensajePAC.contains("601") ? "Revise el RFC del Emisor, del Receptor y el Total. " : (vMensajePAC.contains("602") ? "Revise el UUID. " : "Cadena enviada:re=" + vRFCEmisor + "&rr=" + vRFCReceptor + "&tt=" + vTotal + "&id=" + vId);
                        vMensajePAC = String.valueOf(vMensajePAC) + vRespuesta.getCodigoEstatus();
                        encontrado = false;
                    }
                    vRutaDestinoCFD = vRutaDestinoCFD.replace("/", "\\");
                    vRutaDestinoPDF = vRutaDestinoPDF.replace("/", "\\");
                    String TipoDeComprobante = ImportaFacturaProv.getAtributo(vComprobante, "TipoDeComprobante").toUpperCase();
                    TipoDeComprobante = ImportaFacturaProv.decodifica_tipoDeComprobante(TipoDeComprobante);
                    Double vOtrosImpuestos1 = 0.0;
                    if (ImportaFacturaProv.getAtributo(vImpuestos, "TotalImpuestosRetenidos") != null) {
                        vOtrosImpuestos1 = vOtrosImpuestos1 + Double.valueOf(ImportaFacturaProv.getAtributo(vImpuestos, "TotalImpuestosRetenidos"));
                    }
                    if (ImportaFacturaProv.getAtributo(otrosCargos = ImportaFacturaProv.getNodoHijoDe(aerolineas = ImportaFacturaProv.getNodoHijoDe(vComplemento, "aerolineas:Aerolineas"), "aerolineas:OtrosCargos"), "TotalCargos") != null) {
                        vOtrosImpuestos1 = vOtrosImpuestos1 + Double.valueOf(ImportaFacturaProv.getAtributo(otrosCargos, "TotalCargos"));
                    }
                    if (ImportaFacturaProv.getAtributo(impuestosLocales = ImportaFacturaProv.getNodoHijoDe(vComplemento, "implocal:ImpuestosLocales"), "TotaldeTraslados") != null) {
                        vOtrosImpuestos1 = vOtrosImpuestos1 + Double.valueOf(ImportaFacturaProv.getAtributo(impuestosLocales, "TotaldeTraslados"));
                    }
                    String otrosImpuestos1 = String.valueOf(vOtrosImpuestos1);
                    float iva = 0.0f;
                    if (vImpuestos != null) {
                        NodeList vImpuestosList = vImpuestos.getChildNodes();
                        int vImpuestosLong = vImpuestosList.getLength();
                        int i = 0;
                        while (i < vImpuestosLong) {
                            if (vImpuestosList.item(i).getNodeType() == 1) {
                                NodeList vSubLista = vImpuestosList.item(i).getChildNodes();
                                int vSubListaLong = vSubLista.getLength();
                                Node impuesto = null;
                                int j = 0;
                                while (j < vSubListaLong) {
                                    if (vSubLista.item(j).getNodeType() == 1 && ImportaFacturaProv.getAtributo(impuesto = vSubLista.item(j), "Impuesto").equals("002") && ImportaFacturaProv.getAtributo(impuesto, "Importe") != null) {
                                        iva += Float.valueOf(ImportaFacturaProv.getAtributo(impuesto, "Importe")).floatValue();
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        System.out.println("Termino de obtener el IVA");
                    }
                    System.out.println("--\n" + iva + "\n--");
                    String fechaEmision = ImportaFacturaProv.getAtributo(vComprobante, "Fecha").replace("T", " ").replace("-", "/");
                    String[] aux = fechaEmision.split(" ");
                    String[] aux2 = aux[0].split("/");
                    fechaEmision = String.valueOf(aux2[2]) + "/" + aux2[1] + "/" + aux2[0].substring(2, 4) + " " + aux[1];
                    double vSubtotal = 0.0;
                    if (ImportaFacturaProv.getAtributo(vComprobante, "SubTotal") != null) {
                        vSubtotal = Double.valueOf(ImportaFacturaProv.getAtributo(vComprobante, "SubTotal"));
                    }
                    if (ImportaFacturaProv.getAtributo(vComprobante, "Descuento") != null) {
                        vSubtotal -= Double.valueOf(ImportaFacturaProv.getAtributo(vComprobante, "Descuento")).doubleValue();
                    }
                    vDatos.add(vIdFactura);
                    vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "Serie"));
                    vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "Folio"));
                    vDatos.add(vRFCEmisor);
                    vDatos.add(ImportaFacturaProv.getAtributo(vEmisor, "Nombre"));
                    vDatos.add(vRFCReceptor);
                    vDatos.add(ImportaFacturaProv.getAtributo(vReceptor, "Nombre"));
                    vDatos.add(null);
                    vDatos.add(null);
                    vDatos.add(TipoDeComprobante);
                    vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "Total"));
                    vDatos.add(String.valueOf(iva));
                    vDatos.add(String.valueOf(vSubtotal));
                    vDatos.add(fechaEmision);
                    vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "FECHA_CANCELACION"));
                    vDatos.add(String.valueOf(vCancelado));
                    vDatos.add(vRutaDestinoCFD);
                    if (encontrado) {
                        vDatos.add(String.valueOf(vEstadoValidacion));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "TIPO_COMPRA"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vTimbreFiscal, "UUID"));
                        vDatos.add(pFactura);
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "RUTA_PROVEEDOR_PDF"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "FECHA_VENCIMIENTO"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "INTENTO_CAN"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "USUARIO"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "SOLICITA_CANCELACION"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vReceptor, "UsoCFDI"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "MetodoPago"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "FormaPago"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "TIPO_CAMBIO"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "Moneda"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vcfdiRelacion, "UUID"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "TIPO_RELACION"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "TIPO_CFD"));
                        vDatos.add(ImportaFacturaProv.getAtributo(vComprobante, "MENSAJE_VALIDACION"));
                        vDatos.add(vRutaDestinoPDF);
                        vDatos.add(otrosImpuestos1);
                        vDatos.add(vFechaRecepcion.replace("\\", "/"));
                    }
                    String vContenidoXML = ImportaFacturaProv.getContenidoXML(pRutaXML);
                    vDatos.add(vContenidoXML);
                    String vMensajeInsercion = null;
                    String vEstatusValidacionSat = "ERROR";
                    String vUUID = null;
                    if (encontrado) {
                        vMensajeInsercion = ImportaFacturaProv.insertarFacturaValida(pbdUtil, vDatos);
                        if (vMensajeInsercion.equals("EXITO")) {
                            vEstatusValidacionSat = "EXITO";
                            vUUID = ImportaFacturaProv.getAtributo(vTimbreFiscal, "UUID");
                            System.out.println("--------------\n    EXITO\n--------------");
                        } else {
                            System.out.println("--------------\n    EXITO CON ERROR EN LA INSERCCION\n--------------");
                            vMensajePAC = vMensajeInsercion;
                        }
                    } else {
                        vMensajeInsercion = ImportaFacturaProv.insertarFacturaInvalida(pbdUtil, vDatos);
                        System.out.println("--------------\n    NO ENCONTRADO\n--------------");
                        if (!vMensajeInsercion.equals("EXITO")) {
                            vMensajePAC = vMensajeInsercion;
                        }
                    }
                    ImportaFacturaProv.importarA(vRutaDestinoCFD, pRutaXML, "xml");
                    ImportaFacturaProv.importarA(vRutaDestinoPDF, pRutaPDF, "pdf");
                    vMensajeGeneral = String.valueOf(vEstatusValidacionSat) + ": " + vMensajePAC;
                } else {
                    vMensajeGeneral = "ERROR:El RFC del XML(" + vRFCReceptor + ") no coincide con el del RFC receptor (" + pRFCReceptor + ") Archivo:" + auxNombreXML[auxNombreXML.length - 1];
                }
            } else {
                vMensajeGeneral = "ERROR:El RFC del XML(" + vRFCEmisor + ") no coincide con el RFC del provedor(" + pRFCEmisor + ") Archivo:" + auxNombreXML[auxNombreXML.length - 1];
            }
        }
        System.out.println(vMensajeGeneral);
        ImportaFacturaProv.insertarCFDRecepcionError(pbdUtil, vIdFactura, vMensajeGeneral);
    }

    public static void leerCarpetaOArchivo(String pRutaOrigen, String pRutaDestino, boolean pIsArchivo, String pPedido, String pRFCEmisor, String pRFCReceptor, String pRutaPDF, String pTotal, String pFactura, String pFechaRecepcion) {
        if (!pRutaOrigen.isEmpty() && !pRutaDestino.isEmpty()) {
            File vRutaOrigen = new File(pRutaOrigen);
            File vRutaDestino = new File(pRutaDestino);
            if (vRutaOrigen.exists()) {
                if (vRutaDestino.exists() && vRutaDestino.isDirectory()) {
                    BDUtil bdUtil = new BDUtil();
                    try {
                        bdUtil.setConexion();
                        if (pIsArchivo) {
                            ImportaFacturaProv.leerFactura(bdUtil, pRutaOrigen, pRutaDestino, pPedido, pRFCEmisor, pRFCReceptor, pRutaPDF, pTotal, pFactura, pFechaRecepcion);
                        } else if (vRutaOrigen.isDirectory()) {
                            File[] vListaArchivos = vRutaOrigen.listFiles();
                            int i = 0;
                            while (i < vListaArchivos.length) {
                                String vRutaElemento = vListaArchivos[i].getAbsolutePath();
                                if (vRutaElemento.toUpperCase().endsWith(".XML")) {
                                    System.out.println(vRutaElemento);
                                    ImportaFacturaProv.leerFactura(bdUtil, pRutaOrigen, pRutaDestino, pPedido, pRFCEmisor, pRFCReceptor, pRutaPDF, pTotal, pFactura, pFechaRecepcion);
                                }
                                ++i;
                            }
                            System.out.println("En " + pRutaOrigen + " se leyeron " + vListaArchivos.length + " Archivos/Carpetas.");
                        } else {
                            System.out.println("Seleccione 'Archivo' para poder importar la Factura.");
                        }
                        bdUtil.cerrarConexion();
                    }
                    catch (Exception e) {
                        ImportaFacturaProv.insertarCFDRecepcionError(bdUtil, pPedido, e.getMessage());
                        System.out.println("Sucedi\u00f3 un error: " + e.toString());
                    }
                } else {
                    System.out.println("La carpeta de DESTINO NO existe. " + pRutaDestino);
                }
            } else {
                System.out.println("La carpeta o archivo de ORIGEN NO existe." + pRutaOrigen);
            }
        } else {
            System.out.println("Alguna ruta viene vacia. Par\u00e1metros: RutaOrigen RutaDestino EsArchivo(true/false)");
        }
    }
}

