/*
 * Decompiled with CFR 0.152.
 */
package siti.conexion;

import java.sql.Connection;
import java.util.Vector;

public class BDResultados {
    private Connection connection;
    private String nombreProducto;
    private String versionProducto;
    private int cuentaColumnas;
    private String[] nombresColumnas;
    private String[] renglonDeDatos;
    private Vector<String[]> resultadosQuery;

    public BDResultados(Connection connection, String nombreProducto, String versionProducto, int cuentaColumnas, String[] nombresColumnas) {
        this.connection = connection;
        this.nombreProducto = nombreProducto;
        this.versionProducto = versionProducto;
        this.cuentaColumnas = cuentaColumnas;
        this.nombresColumnas = nombresColumnas;
        this.renglonDeDatos = new String[cuentaColumnas];
        this.setResultadosQuery(new Vector<String[]>());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getNombreProducto() {
        return this.nombreProducto;
    }

    public String getVersionProducto() {
        return this.versionProducto;
    }

    public int getCuentaColumnas() {
        return this.cuentaColumnas;
    }

    public String[] getNombresColumnas() {
        return this.nombresColumnas;
    }

    public String[] getRenglonDeDatos() {
        return this.renglonDeDatos;
    }

    public int getCuentaRenglones() {
        return this.getResultadosQuery().size();
    }

    public String[] getRenglon(int index) {
        return this.getResultadosQuery().elementAt(index);
    }

    public void agregaRenglon(String[] renglon) {
        this.getResultadosQuery().addElement(renglon);
    }

    public String toHTMLTable(String headingColor) {
        StringBuffer buffer = new StringBuffer("<TABLE BORDER=1>\n");
        if (headingColor != null) {
            buffer.append("  <TR BGCOLOR=\"" + headingColor + "\">\n    ");
        } else {
            buffer.append("  <TR>\n    ");
        }
        int col = 0;
        while (col < this.getCuentaColumnas()) {
            buffer.append("<TH>" + this.nombresColumnas[col]);
            ++col;
        }
        int renglon = 0;
        while (renglon < this.getCuentaRenglones()) {
            buffer.append("\n  <TR>\n    ");
            String[] rowData = this.getRenglon(renglon);
            int col2 = 0;
            while (col2 < this.getCuentaColumnas()) {
                buffer.append("<TD>" + rowData[col2]);
                ++col2;
            }
            ++renglon;
        }
        buffer.append("\n</TABLE>");
        return buffer.toString();
    }

    public Vector<String[]> getResultadosQuery() {
        return this.resultadosQuery;
    }

    public void setResultadosQuery(Vector<String[]> resultadosQuery) {
        this.resultadosQuery = resultadosQuery;
    }
}

