/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextArea;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.CorreosAEnviarDAO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.dto.CorreosAEnviarDTO;

public class EnviaCorreo
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String modo;

    public EnviaCorreo(JTextArea pTextArea, int numSegundos, int empNum, String modo) {
        this.textArea = pTextArea;
        this.intervalo = numSegundos * 1000;
        this.empNum = empNum;
        this.modo = modo;
        this.start();
    }

    public String agregaParametro(String pComando, String pValor) {
        return pValor != null ? String.valueOf(pComando) + " \"" + pValor.replace("\"", "'") + "\"" : "";
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        ConfiguracionDTO configuracionDTO = null;
        try {
            bdUtil.setConexion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        configuracionDTO = new ConfiguracionDTO();
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
        CorreosAEnviarDTO correoTemp = new CorreosAEnviarDTO();
        String mensajeInterfaz = "";
        String vTipoCorreo = "";
        while (this.bandera == 1) {
            try {
                EscritorInterfaz.escribeEnTextArea(this.textArea, "proceso activado " + Fecha.generaFecha());
                ArrayList<CorreosAEnviarDTO> lista = CorreosAEnviarDAO.getCorreosAEnviar(bdUtil);
                Iterator<CorreosAEnviarDTO> itera = lista.iterator();
                String vComando = "";
                while (itera.hasNext()) {
                    correoTemp = itera.next();
                    vTipoCorreo = correoTemp.getTipoCorreo().toUpperCase();
                    try {
                        EscritorInterfaz.escribeEnTextArea(this.textArea, "Enviando correo " + Fecha.generaFecha() + " - " + vTipoCorreo);
                        if (vTipoCorreo.equals("CREACIONSOLICITUDMESAAPOYO")) {
                            vComando = correoTemp.getRutaBAT();
                            vComando = this.agregaParametro(vComando, correoTemp.getClave());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro1());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro2());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro3());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro4());
                        } else if (vTipoCorreo.equals("TIMBRADOFACTURACION")) {
                            vComando = correoTemp.getRutaBAT();
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro1());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro2());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro3());
                        } else if (vTipoCorreo.equals("TIMBRADONOMINA")) {
                            vComando = correoTemp.getRutaBAT();
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro1());
                            vComando = this.agregaParametro(vComando, correoTemp.getParametro2());
                        }
                        CorreosAEnviarDAO.LOG_EnvioCorreo(bdUtil, correoTemp, null, "POR ENVIAR", vComando, null, null);
                        EscritorInterfaz.escribeEnTextArea(this.textArea, vComando);
                        if (this.ejecutaComando(vComando)) {
                            CorreosAEnviarDAO.LOG_EnvioCorreo(bdUtil, correoTemp, null, "ENVIADO", vComando, null, null);
                            CorreosAEnviarDAO.ActualizarEstatusEnvioCorreo(bdUtil, correoTemp, 1);
                            EscritorInterfaz.escribeEnTextArea(this.textArea, "Se termin\u00f3 de enviar el correo " + Fecha.generaFecha() + " - " + vTipoCorreo);
                            continue;
                        }
                        CorreosAEnviarDAO.LOG_EnvioCorreo(bdUtil, correoTemp, null, "NO ENVIADO", vComando, null, null);
                        CorreosAEnviarDAO.ActualizarEstatusEnvioCorreo(bdUtil, correoTemp, -1);
                        EscritorInterfaz.escribeEnTextArea(this.textArea, "No se pudo enviar el correo " + Fecha.generaFecha() + " - " + vTipoCorreo);
                    }
                    catch (Exception errorEnvioCorreo) {
                        CorreosAEnviarDAO.LOG_EnvioCorreo(bdUtil, correoTemp, null, "NO ENVIADO", vComando, null, null);
                        CorreosAEnviarDAO.ActualizarEstatusEnvioCorreo(bdUtil, correoTemp, -1);
                        Thread.currentThread();
                        Thread.sleep(this.intervalo);
                    }
                }
                Thread.currentThread();
                Thread.sleep(this.intervalo);
            }
            catch (Exception error) {
                System.out.println("ERROR EN LA PESTANA: " + error.toString());
            }
        }
        mensajeInterfaz = "PROCESO TERMINADO";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        String mensajeInterfaz = "Se detendra el proceso en el siguiente ciclo";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }

    public boolean ejecutaComando(String vComando) {
        boolean ejecucionExitosa = false;
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", vComando);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                System.out.println("Comando ejecutado correctamente");
                ejecucionExitosa = true;
            } else {
                System.out.println("Hubo un error al ejecutar el comando");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return ejecucionExitosa;
    }
}

