/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextArea;
import org.datacontract.schemas._2004._07.Sat_Cfdi_Negocio_ConsultaCfdi_Servicio.Acuse;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.monitoring.RegistraActivo;
import siti.sinco.cfdi.dao.CfdiCanceladosDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dto.CFDICanceladosDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.CfdiCliente;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class VerificaCancelacion
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String modo;

    public VerificaCancelacion(JTextArea pTextArea, int numMinutos, int empNum, String modo) {
        this.textArea = pTextArea;
        this.intervalo = numMinutos * 60 * 1000;
        this.empNum = empNum;
        this.modo = modo;
        this.start();
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfiguracionDTO configDTO = new ConfiguracionDTO();
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        configDAO.llenarConfiguracion(bdUtil, configDTO, this.empNum);
        CFDICanceladosDTO canceladoDTO2 = new CFDICanceladosDTO();
        CfdiCanceladosDAO canceladosDAO = new CfdiCanceladosDAO();
        CfdiCliente cfdiCliente = new CfdiCliente();
        String expresion = "";
        EnvioCorreo envioCorreo = new EnvioCorreo(bdUtil, configDTO);
        Acuse acuse = null;
        String respuestaPAC = "";
        String mensajeInterfaz = "";
        String mensajeCorreo = "";
        String vTipoDocumento = "";
        RegistraActivo registraActivo = new RegistraActivo();
        try {
            this.proc = bdUtil.connection.prepareCall("{ call registraHorasMonitor(?)}");
            this.proc.setInt(1, 3);
        }
        catch (SQLException e) {
            mensajeInterfaz = "Error en registrar el procedimiento" + e.getMessage();
            EscritorInterfaz.escribeEnTextArea(this.textArea, "Error en registrar el procedimiento" + e.getMessage());
            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "ERROR ORA");
        }
        while (this.bandera == 1) {
            try {
                EscritorInterfaz.escribeEnTextArea(this.textArea, "proceso activado " + Fecha.generaFecha());
                System.out.println("Ultima verificacion de CFDIs mandados a cancelar:" + Fecha.horaEjecucion());
                ArrayList<CFDICanceladosDTO> lista = canceladosDAO.leerComprobantesCancelar(bdUtil, "PR");
                for (CFDICanceladosDTO canceladoDTO2 : lista) {
                    mensajeInterfaz = "Se consulta el estado de cancelacion ante el SAT del UUDI " + canceladoDTO2.getUuid() + ".";
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    switch (canceladoDTO2.getTipoDocumemnto().toUpperCase()) {
                        case "FC": {
                            vTipoDocumento = "La factura";
                            break;
                        }
                        case "CB": {
                            vTipoDocumento = "El complemento de pago";
                            break;
                        }
                        case "NM": {
                            vTipoDocumento = "La n\u00f3mina";
                        }
                    }
                    expresion = "re=" + canceladoDTO2.getRfcEmisor() + "&rr=" + canceladoDTO2.getRfcReceptor() + "&tt=" + canceladoDTO2.getTotal() + "&id=" + canceladoDTO2.getUuid();
                    acuse = cfdiCliente.consultaServicioCancelacionSAT(expresion);
                    mensajeInterfaz = "El estado de cancelacion ante el SAT del UUDI " + canceladoDTO2.getUuid() + " es \n" + " Codigo Status=" + acuse.getCodigoEstatus() + " \n " + " Es Cancelable=" + acuse.getEsCancelable() + " \n " + " Estado=" + acuse.getEstado() + " \n " + " Estatus Cancelacion=" + acuse.getEstatusCancelacion();
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    if (acuse.getCodigoEstatus().startsWith("S")) {
                        if (acuse.getEstado().equals("Vigente")) {
                            String vAsunto;
                            if (acuse.getEstatusCancelacion().contains("Solicitud rechazada")) {
                                mensajeInterfaz = "La cancelacion fue rechazada ante el SAT con el UUDI " + canceladoDTO2.getUuid() + ".";
                                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                                canceladosDAO.actualizaEstadoCancelado(bdUtil, canceladoDTO2.getUuid(), "SR", "NA");
                                canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, canceladoDTO2.getFolio());
                                mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Cancelaci\u00f3n rechazada</h3><div style=\"padding:0% 5%;\"><p>" + vTipoDocumento + " era cancelable con aceptaci\u00f3n y la solicitud fue rechazada. Factura (<b>" + canceladoDTO2.getFactura() + "</b>) con folio <b>" + canceladoDTO2.getFolio() + "</b> y <br> UUID: <b>" + canceladoDTO2.getUuid() + "</b>. </p>" + "</div>" + "</div>";
                                vAsunto = "Cancelaci\u00f3n con aceptaci\u00f3n rechazada - " + canceladoDTO2.getFolio();
                                envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", canceladoDTO2.getNombreEmisor());
                                continue;
                            }
                            if (acuse.getEsCancelable().equals("No cancelable") && canceladoDTO2.getClavesatcancelacion().equals("01")) {
                                canceladosDAO.actualizaEstadoCancelado(bdUtil, canceladoDTO2.getUuid(), "PC", "NA");
                                continue;
                            }
                            if (acuse.getEsCancelable().equals("Cancelable con aceptaci\u00f3n")) {
                                if (!canceladoDTO2.getEnviarCorreo()) continue;
                                canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, canceladoDTO2.getFolio());
                                mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Cancelaci\u00f3n con aceptaci\u00f3n pendiente</h3><div style=\"padding:0% 5%;\"><p>" + vTipoDocumento + " a\u00fan continua pendiente por cancelar. " + "<br>" + vTipoDocumento + " (<b>" + canceladoDTO2.getFactura() + "</b>) con folio <b>" + canceladoDTO2.getFolio() + "</b> y UUID: <b>" + canceladoDTO2.getUuid() + "</b>." + "<br>Seguiremos al pendiente. </p>" + "</div>" + "</div>";
                                vAsunto = "Cancelaci\u00f3n con aceptaci\u00f3n pendiente - " + canceladoDTO2.getFolio();
                                envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", canceladoDTO2.getNombreEmisor());
                                continue;
                            }
                            if (!acuse.getEsCancelable().equals("No cancelable")) continue;
                            canceladosDAO.actualizaEstadoCancelado(bdUtil, canceladoDTO2.getUuid(), "NC", "CC");
                            canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, canceladoDTO2.getFolio());
                            mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>No cancelable</h3><div style=\"padding:0% 5%;\"><p>" + vTipoDocumento + " estaba como <b>Cancelable con aceptaci\u00f3n</b>, sin embargo,el SAT la cambi\u00f3 a <b>No cancelable</b>." + "<br>" + vTipoDocumento + " (<b>" + canceladoDTO2.getFactura() + "</b>) con folio <b>" + canceladoDTO2.getFolio() + "</b> y UUID: <b>" + canceladoDTO2.getUuid() + "</b>." + "</p>" + "</div>" + "</div>";
                            vAsunto = "No cancelable - " + canceladoDTO2.getFolio();
                            envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", canceladoDTO2.getNombreEmisor());
                            continue;
                        }
                        String vParrafo = "";
                        if (canceladoDTO2.getStatusTipo().equals("CS")) {
                            mensajeInterfaz = "El UUID que estaba pendiente de cancelacion ya fue cancelado exitosamente" + acuse.getEstado();
                            vParrafo = "<p>El UUID ya fue cancelado por el SAT. <br>";
                        } else {
                            mensajeInterfaz = "El UUID que estaba pendiente de cancelacion ya fue cancelado exitosamente" + acuse.getEstado();
                            vParrafo = "<p>El UUID que estaba pendiente de cancelaci\u00f3n ya fue cancelado. <br>";
                        }
                        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                        canceladosDAO.actualizaEstadoCancelado(bdUtil, canceladoDTO2.getUuid(), "CA", "NA");
                        canceladosDAO.actualizaFechaCancelacion(bdUtil, canceladoDTO2.getUuid(), canceladoDTO2.getFolio());
                        canceladosDAO.ActualizarFechaEnvioCorreoFACTURACION(bdUtil, canceladoDTO2.getFolio());
                        mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Cancelaci\u00f3n con aceptaci\u00f3n exitosa</h3><div style=\"padding:0% 5%;\">" + vParrafo + vTipoDocumento + " (<b>" + canceladoDTO2.getFactura() + "</b>) con folio <b>" + canceladoDTO2.getFolio() + "</b>. <br>Con el UUID: <b>" + canceladoDTO2.getUuid() + "</b></p>" + "</div>" + "</div>";
                        String vAsunto = "Cancelaci\u00f3n con aceptaci\u00f3n exitosa - " + canceladoDTO2.getFolio();
                        envioCorreo.enviarCorreo("", vAsunto, mensajeCorreo, "", canceladoDTO2.getNombreEmisor());
                        canceladosDAO.actualizaCFdEmisionCancelado(bdUtil, canceladoDTO2.getFolio(), canceladoDTO2.getUuid());
                        continue;
                    }
                    mensajeInterfaz = "El PAC ha respondido " + acuse.getCodigoEstatus();
                    EscritorInterfaz.escribeEnTextArea(this.textArea, "El PAC ha respondido " + acuse.getCodigoEstatus());
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                }
                lista = null;
                Iterator<CFDICanceladosDTO> itera = null;
                registraActivo.ejecutaProc(bdUtil, this.proc, this.textArea);
                Thread.currentThread();
                Thread.sleep(this.intervalo);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.intervalo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mensajeInterfaz = "Error en run de RevisaLog:" + e.toString();
                EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
            }
        }
        EscritorInterfaz.escribeEnTextArea(this.textArea, "PROCESO TERMINADO");
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        EscritorInterfaz.escribeEnTextArea(this.textArea, "Se detendra el proceso en el siguiente ciclo");
    }
}

