/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.awt.Toolkit;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JTextArea;
import siti.conexion.BDResultados;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class VerificaEjecucionProcesos
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String modo;

    public VerificaEjecucionProcesos(JTextArea pTextArea, int numSegundos, int empNum, String modo) {
        this.textArea = pTextArea;
        this.intervalo = numSegundos * 60 * 1000;
        this.empNum = empNum;
        this.modo = modo;
        this.start();
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        String mensajeInterfaz = "Se detendra el proceso en el siguiente ciclo";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BDResultados resultados = null;
        ConfiguracionDTO configuracionDTO = null;
        configuracionDTO = new ConfiguracionDTO();
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
        String vNombreEmpresa = "ADMINISTRACION DEL SISTEMA PORTUARIO NACIONAL MAZATL\u00c1N";
        String mensajeInterfaz = "";
        EnvioCorreo envioCorreo = new EnvioCorreo(bdUtil, configuracionDTO);
        String query = "SELECT IDPROCESO, trunc(24*60*(sysdate - to_date(fecha, 'DD/MM/YYYY HH24:MI:SS'))) as \"MINUTOS\", DESCRIPCION\t\t\t\tFROM horasmonitor";
        while (this.bandera == 1) {
            block21: {
                EscritorInterfaz.escribeEnTextArea(this.textArea, "proceso activado " + Fecha.generaFecha());
                RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                try {
                    resultados = bdUtil.getResultadosQuery(query);
                }
                catch (Exception e) {
                    System.out.println("Sucedi\u00f3 un error al verificar la ejecutci\u00f3n:");
                }
                if (resultados == null) break block21;
                String[] renglonResultado = new String[resultados.getCuentaColumnas()];
                int renglon = 0;
                while (renglon < resultados.getCuentaRenglones()) {
                    renglonResultado = resultados.getRenglon(renglon);
                    mensajeInterfaz = " ID: " + renglonResultado[0] + " Proceso: " + String.format("%-50s", renglonResultado[2]) + "No se ha ejecutado durante " + String.format("%03d", Integer.valueOf(renglonResultado[1])) + " minutos";
                    EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                    switch (renglonResultado[0]) {
                        case "1": {
                            if (Integer.parseInt(renglonResultado[1]) < 5) break;
                            Toolkit.getDefaultToolkit().beep();
                            mensajeInterfaz = "\tNo se est\u00e1 ejecutando " + renglonResultado[2];
                            EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                            String mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>PROCESO DETENIDO</h3><div style=\"padding:0% 10%;\"><p>El sistema ha detectado que el proceso de <b>TIMBRADO</b> se ha detenido.</p><p>Favor de revisar.</p></div></div>";
                            String vAsunto = " Proceso de TIMRBADO se detuvo";
                            String vRutasArchivo = "";
                            envioCorreo.enviarCorreoMONITOR("", vAsunto, mensajeCorreo, vRutasArchivo, vNombreEmpresa);
                            break;
                        }
                        case "2": {
                            if (Integer.parseInt(renglonResultado[1]) < 10) break;
                            Toolkit.getDefaultToolkit().beep();
                            mensajeInterfaz = "\tNo se est\u00e1 ejecutando " + renglonResultado[2];
                            EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                            String mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>PROCESO DETENIDO</h3><div style=\"padding:0% 10%;\"><p>El sistema ha detectado que el proceso de <b>CANCELACI\u00d3N</b> se ha detenido.</p><p>Favor de revisar.</p></div></div>";
                            String vAsunto = " Proceso de CANCELACI\u00d3N se detuvo";
                            String vRutasArchivo = "";
                            envioCorreo.enviarCorreoMONITOR("", vAsunto, mensajeCorreo, vRutasArchivo, vNombreEmpresa);
                            break;
                        }
                        case "3": {
                            if (Integer.parseInt(renglonResultado[1]) < 420) break;
                            Toolkit.getDefaultToolkit().beep();
                            mensajeInterfaz = "\tNo se est\u00e1 ejecutando " + renglonResultado[2];
                            EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
                            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
                            String mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>PROCESO DETENIDO</h3><div style=\"padding:0% 10%;\"><p>El sistema ha detectado que el proceso <b>VERIFICACDOR DE CANCELACI\u00d3N</b> se ha detenido.</p><p>Favor de revisar.</p></div></div>";
                            String vAsunto = " Proceso de VERIFICACI\u00d3N DE CANCELADOS se detuvo";
                            String vRutasArchivo = "";
                            envioCorreo.enviarCorreoMONITOR("", vAsunto, mensajeCorreo, vRutasArchivo, vNombreEmpresa);
                        }
                    }
                    ++renglon;
                }
            }
            mensajeInterfaz = "--- Ultima verificaci\u00f3n de que los procesos se ejecutaron " + Fecha.horaEjecucion();
            System.out.println(mensajeInterfaz);
            EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
            Thread.currentThread();
            try {
                Thread.sleep(this.intervalo);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getUltimaFechaEjecucion() {
        return String.valueOf(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:MM:ss").format(LocalDateTime.now()));
    }
}

