/*
 * Decompiled with CFR 0.152.
 */
package siti.monitoring;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.JTextArea;
import org.datacontract.schemas._2004._07.Sat_Cfdi_Negocio_ConsultaCfdi_Servicio.Acuse;
import siti.conexion.BDUtil;
import siti.excepciones.RegistraLOG;
import siti.monitoring.EscritorInterfaz;
import siti.monitoring.Fecha;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dto.CfdEmisionDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.CfdiCliente;
import siti.sinco.cfdi.tools.EnvioCorreo;

public class VerificaFacturasExistentes
extends Thread {
    private Connection connection = null;
    private CallableStatement proc = null;
    private JTextArea textArea = new JTextArea();
    private int bandera = 1;
    private int intervalo = 0;
    private int empNum;
    public String modo;

    public VerificaFacturasExistentes(JTextArea pTextArea, int numHoras, int empNum, String modo) {
        this.textArea = pTextArea;
        this.intervalo = numHoras * 3600 * 1000;
        this.empNum = empNum;
        this.modo = modo;
        this.start();
    }

    public void setBandera(int valor) {
        this.bandera = valor;
        String mensajeInterfaz = "Se detendra el proceso en el siguiente ciclo";
        EscritorInterfaz.escribeEnTextArea(this.textArea, mensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", mensajeInterfaz, "INFO USER");
    }

    public static String getUltimaFechaEjecucion() {
        return String.valueOf(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:MM:ss").format(LocalDateTime.now()));
    }

    /*
     * WARNING - void declaration
     */
    public void proceso(BDUtil pBDUtil) {
        CfdEmisionDAO CFDEmision = new CfdEmisionDAO();
        ArrayList<Object> listaAComprobar = new ArrayList();
        CfdiCliente cfdiCliente = new CfdiCliente();
        Acuse acuse = null;
        listaAComprobar = CFDEmision.getCFDISAComprobarEnElSAT(pBDUtil, null, null, null);
        ArrayList<CfdEmisionDTO> listaInexistentes = new ArrayList<CfdEmisionDTO>();
        String vMensajeInterfaz = "";
        int vSegundos = 60;
        int vMinutos = 5;
        int vHoras = 1;
        int vTiempoEspera = vSegundos * vMinutos * vHoras;
        String vExpresion = "";
        String vFechaRevision = " ";
        int vContador = 0;
        int vTotalesVerificados = 0;
        int vTotalAVerificar = listaAComprobar.size();
        boolean seguirBucle = true;
        EscritorInterfaz.escribeEnTextArea(this.textArea, "\nproceso activado " + Fecha.generaFecha());
        RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
        vMensajeInterfaz = "Se van a verificar :" + vTotalAVerificar + " CFDI's. Fecha de ejecuci\u00f3n:" + VerificaFacturasExistentes.getUltimaFechaEjecucion();
        EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
        for (CfdEmisionDTO cfdEmisionDTO : listaAComprobar) {
            vExpresion = "re=" + cfdEmisionDTO.getRFCEMISOR() + "&rr=" + cfdEmisionDTO.getRFCRECEPTOR() + "&tt=" + cfdEmisionDTO.getTOTAL() + "&id=" + cfdEmisionDTO.getUUID();
            seguirBucle = true;
            while (seguirBucle) {
                try {
                    acuse = cfdiCliente.consultaServicioCancelacionSAT(vExpresion);
                    seguirBucle = false;
                }
                catch (Exception e1) {
                    vMensajeInterfaz = "Ocurrio un error (se volver\u00e1 a consultar en 10 segundos) al consultar con el SAT: " + e1.toString();
                    EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
                    RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception e2) {
                        System.out.println("Ocurrio un error: " + e2.toString());
                    }
                }
            }
            ++vContador;
            ++vTotalesVerificados;
            if (!acuse.getCodigoEstatus().startsWith("S")) {
                --vTotalesVerificados;
                listaInexistentes.add(cfdEmisionDTO);
            } else {
                if (cfdEmisionDTO.getFECHA_EMISION() != null && vFechaRevision.equals(" ")) {
                    vFechaRevision = cfdEmisionDTO.getFECHA_EMISION();
                }
                vMensajeInterfaz = "CFD[" + String.format("%7s", String.valueOf(vTotalesVerificados)) + "/" + String.format("%5s", String.valueOf(vTotalAVerificar)) + "] " + String.format("%15s", cfdEmisionDTO.getIDFACTURA()) + " " + String.format("%15s", cfdEmisionDTO.getFOLIO()) + " " + acuse.getCodigoEstatus();
                EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
                RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
            }
            if (vContador != 100) continue;
            vMensajeInterfaz = "Se han verificado: " + vTotalesVerificados + " Descansando durante: " + vTiempoEspera;
            EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
            vContador = 0;
            try {
                Thread.sleep(1000 * vTiempoEspera);
            }
            catch (Exception e1) {
                // empty catch block
            }
            vMensajeInterfaz = "la verificaci\u00f3n continuar\u00e1...";
            EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
        }
        vMensajeInterfaz = "--- Termin\u00f3 de verificar ante el SAT las facturas del " + vFechaRevision + "---";
        EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
        RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
        if (listaInexistentes.size() == 0) {
            vMensajeInterfaz = "TODAS LAS FACTURAS EXISTEN EN EL SISTEMA DEL SAT";
            EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
        } else {
            void var18_21;
            String string = "";
            vContador = 1;
            for (CfdEmisionDTO vCFD : listaInexistentes) {
                vMensajeInterfaz = String.valueOf(String.format("%2s", String.valueOf(++vContador))) + String.format("%15s", vCFD.getIDFACTURA()) + " " + String.format("%15s", vCFD.getFOLIO()) + vCFD.getUUID() + String.format("%10s", vCFD.getTOTAL()) + "(" + vCFD.getRFCEMISOR() + ") " + vCFD.getNOMBREEMISOR();
                String string2 = String.valueOf(var18_21) + vMensajeInterfaz + "\n";
            }
            vMensajeInterfaz = var18_21;
            EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
            vMensajeInterfaz = String.valueOf(String.format("%17s", "IDFACTURA")) + " " + String.format("%15s", "Folio");
            EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
            vMensajeInterfaz = "CFD's inexistentes en el SAT:";
            EscritorInterfaz.escribeEnTextArea(this.textArea, vMensajeInterfaz);
            RegistraLOG.registrarLog(this.getClass().getName(), "run", vMensajeInterfaz, "INFO USER");
            ConfiguracionDTO configuracionDTO = null;
            configuracionDTO = new ConfiguracionDTO();
            ConfiguracionDAO configDAO = new ConfiguracionDAO();
            configDAO.llenarConfiguracion(pBDUtil, configuracionDTO, 1);
            String vNombreEmpresa = "ADMINISTRACION DEL SISTEMA PORTUARIO NACIONAL MAZATL\u00c1N";
            EnvioCorreo envioCorreo = new EnvioCorreo(pBDUtil, configuracionDTO);
            String mensajeCorreo = "<div style=\" padding:5% 10%; text-align: left; \"><h3>Facturas no registradas en el SAT</h3><div style=\"padding:0% 10%;\"><p>El sistema ha detectado que algunas facturas no se encuentran registradas ante el SAT. Sin embargo, al hacer e proceso completo de timbrado, el PAC devolvi\u00f3 un FOLIO FISCAL.</p><p>Favor de revisar el siguiente listado:</p><p>" + (String)var18_21 + "</p>" + "</div>" + "</div>";
            String vAsunto = " Facturas inexistentes en el SAT";
            String vRutasArchivo = "";
            envioCorreo.enviarCorreoMONITOR("", vAsunto, mensajeCorreo, "", vNombreEmpresa);
        }
    }

    @Override
    public void run() {
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
        }
        catch (Exception exception) {}
        while (this.bandera == 1) {
            this.proceso(bdUtil);
            Thread.currentThread();
            try {
                Thread.sleep(this.intervalo);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

