/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi;

import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.CorreosAEnviarDAO;
import siti.sinco.cfdi.dao.LogcfdDAO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.dto.CorreosAEnviarDTO;
import siti.sinco.cfdi.pdf.PDFBuilder;
import siti.sinco.cfdi.tools.CFDUtil;

public class CFD {
    private int empNum;
    private int numComprobante;
    private ConfiguracionDTO configuracion;
    private ComprobanteDTO comprobante;
    public String path;
    private String mail;
    public String modo;
    private int preview;
    public String tipoDoc;
    public int envios;
    public int cierraConexion;
    private BDUtil bdUtil;
    public static String certificado;

    public CFD(int empNum, int numComprobante, String path, String mail, BDUtil bdUtil, int cierraConexion, String modo, String tipoDoc, int envios, int preview) {
        this.empNum = empNum;
        this.numComprobante = numComprobante;
        this.path = path;
        this.mail = mail;
        this.bdUtil = bdUtil;
        this.cierraConexion = cierraConexion;
        this.modo = modo;
        this.tipoDoc = tipoDoc;
        this.envios = envios;
        this.preview = preview;
    }

    public static void main(String[] args) throws IOException, DocumentException, GeneralSecurityException {
        System.out.println("[CFD] Empresa=" + args[0] + " Comprobante=" + args[8]);
        LeeConexion.path = args[1];
        BDUtil bdUtil = new BDUtil();
        try {
            bdUtil.setConexion();
            System.out.println("[CFD] Se establecio conexion");
        }
        catch (Exception e) {
            System.out.println("[CFD] Error al conectarse: " + e.toString());
        }
        CFD cfd = new CFD(Integer.parseInt(args[0]), Integer.parseInt(args[8]), args[1], args[2], bdUtil, Integer.parseInt(args[3]), args[4], args[5], Integer.parseInt(args[6]), Integer.parseInt(args[7]));
        cfd.generaCFD();
    }

    public String generaCFD() {
        LeeConexion.path = this.path;
        String nombreArchivo = "";
        String vPaso = "";
        String UUID = "";
        this.configuracion = new ConfiguracionDTO();
        this.comprobante = new ComprobanteDTO(this.numComprobante);
        ConfiguracionDAO configDAO = new ConfiguracionDAO();
        ComprobantesDAO comprobantesDAO = null;
        configDAO.llenarConfiguracion(this.bdUtil, this.configuracion, this.empNum);
        comprobantesDAO = new ComprobantesDAO(this.configuracion.getRutaSalidaTimbre());
        comprobantesDAO.llenarComprobante(this.bdUtil, this.comprobante);
        vPaso = "01 - llenado de configuraci\u00f3n y comprobante";
        CFDUtil cfdiUtil = new CFDUtil(this.bdUtil, this.comprobante, this.configuracion, this.empNum);
        try {
            vPaso = "02 - Generando el XML";
            cfdiUtil.generaCFD(this.bdUtil, this.modo, this.tipoDoc, this.preview);
            if (this.comprobante.getUUID() != null) {
                vPaso = "03 - Generando el PDF, sin embargo, si se timbr\u00f3.";
                PDFBuilder builder = new PDFBuilder(this.comprobante, this.configuracion, this.tipoDoc, this.modo, this.preview, "NO");
                nombreArchivo = builder.creaPDF(null);
                CfdEmisionDAO vCfdEmision = new CfdEmisionDAO();
                vCfdEmision.actualizarRutaPDF(this.bdUtil, this.comprobante.getUUID(), nombreArchivo, this.tipoDoc);
                this.comprobante.setRutaPDF(nombreArchivo);
                if (!this.comprobante.getCorreoReceptor().equals("@")) {
                    System.out.println("[CFD] Se agregar\u00e1 al listado de correos a enviar");
                    CorreosAEnviarDTO correo = new CorreosAEnviarDTO();
                    correo.setClave(this.comprobante.getFolioDoc());
                    correo.setEstatus("0");
                    correo.setDestino(null);
                    if (!this.comprobante.getTipoDoc().equals("NM")) {
                        correo.setRutaBAT("C:\\Mediport_Fuentes\\PORTAL_CFDI\\tablero-portal-cfdi\\Jar\\ReenvioDeCorreo.jar");
                        correo.setTipoCorreo("TIMBRADOFACTURACION");
                        correo.setParametro1(this.comprobante.getFolioDoc());
                        correo.setParametro2(this.comprobante.getSerie());
                        correo.setParametro3("false");
                    } else {
                        correo.setRutaBAT("C:\\Mediport_Fuentes\\PORTAL_CFDI\\tablero-portal-cfdi\\Jar\\ReenvioDeCorreoNomina.jar");
                        correo.setTipoCorreo("TIMBRADONOMINA");
                        correo.setParametro1(this.comprobante.getFolioDoc());
                        correo.setParametro2("false");
                    }
                    CorreosAEnviarDAO.InsertarEnvioCorreo(this.bdUtil, correo);
                    System.out.println("[CFD] Se termin\u00f3 de agregar al listado de correos a enviar");
                    UUID = this.comprobante.getUUID();
                }
            }
        }
        catch (Exception e) {
            System.out.println("[CFD] Error en el paso:" + vPaso + " " + e.toString());
            LogcfdDAO log = new LogcfdDAO();
            log.actualizaLogError(this.bdUtil, this.comprobante.getComprobante(), "002", "Error al generar archivos", e.toString(), "ERROR");
        }
        if (this.cierraConexion == 1) {
            this.bdUtil.cerrarConexion();
        }
        return UUID;
    }

    public int getEnvios() {
        return this.envios;
    }

    public String toString() {
        return String.valueOf(this.empNum) + " " + this.numComprobante + " " + this.path + " " + this.mail + " " + this.cierraConexion + " " + this.modo + " " + this.tipoDoc + " " + this.envios + " " + this.preview;
    }
}

