/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.NodoAdenda;
import siti.sinco.cfdi.complementos.ComplementoNominaXML;
import siti.sinco.cfdi.complementos.ComplementoPagoXML;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dto.AtributoAdenda;
import siti.sinco.cfdi.dto.CfdConceptosDTO;
import siti.sinco.cfdi.dto.ComplementoNominaDTO;
import siti.sinco.cfdi.dto.ComplementoPagoDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ComprobanteRelacDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.Conversiones;
import siti.sinco.cfdi.tools.Utilerias;

public class CFDenXML {
    private ComprobanteDTO comprobante;
    private ConfiguracionDTO configuracion;
    private NodoAdenda nodoAdenda = null;
    private int Timbrado;
    private String tipoDocumento;
    private String rutaBaseXML = "";
    private String nombreArchivoXML = "";
    private Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private Namespace cfdi;
    private Namespace retenciones = Namespace.getNamespace((String)"retenciones", (String)"http://www.sat.gob.mx/esquemas/retencionpago/1");
    private Namespace tfd = Namespace.getNamespace((String)"tfd", (String)"http://www.sat.gob.mx/TimbreFiscalDigital");
    private Namespace ns_nomina = Namespace.getNamespace((String)"nomina12", (String)"http://www.sat.gob.mx/nomina12");
    private Namespace ns_pago;
    private Namespace ns_dividendo = Namespace.getNamespace((String)"dividendos", (String)"http://www.sat.gob.mx/esquemas/retencionpago/1/dividendos");
    private Element datosGral;

    public CFDenXML(ComprobanteDTO comprobante, ConfiguracionDTO configuracion, int conTimbrado, String tipodoc) {
        this.comprobante = comprobante;
        this.configuracion = configuracion;
        this.Timbrado = conTimbrado;
        this.tipoDocumento = tipodoc;
    }

    public String getRutaBaseXml() {
        return this.rutaBaseXML;
    }

    public String generarXML(String selloDigital, int tipo) {
        String nombreArchivoXML = "";
        String rutaXML = "";
        String prefijo = "";
        String prefijoTipo = "";
        String subCarpeta = "";
        String sufijo = "";
        Element complemento = null;
        this.rutaBaseXML = Utilerias.getRutaBase(this.comprobante, this.configuracion, tipo);
        String nombrePrincipal = ComprobantesDAO.creaNombreArchivo(this.comprobante.getComprobante());
        if (tipo == 0) {
            subCarpeta = "ORIGINAL";
            prefijoTipo = "";
        } else if (tipo == 1) {
            subCarpeta = "CFDI";
            prefijoTipo = "CFDi_";
        } else if (tipo == 2) {
            subCarpeta = "INTERPRETADO";
            prefijoTipo = "INT_";
        }
        rutaXML = String.valueOf(this.rutaBaseXML) + File.separator + subCarpeta;
        nombreArchivoXML = String.valueOf(rutaXML) + File.separator + prefijoTipo + nombrePrincipal + ".xml";
        System.out.println("[CFDenXML] RutaSalidaXML=    " + rutaXML);
        System.out.println("[CFDenXML] NombreArchivoXML= " + nombreArchivoXML);
        File carpetas = new File(rutaXML);
        if (!carpetas.exists()) {
            carpetas.mkdirs();
        }
        File fichero = null;
        fichero = new File(nombreArchivoXML);
        try {
            if (fichero.exists()) {
                Path origen = FileSystems.getDefault().getPath(nombreArchivoXML, new String[0]);
                Files.delete(origen);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (!fichero.exists()) {
            Document doc = null;
            CfdConceptosDTO concepto = null;
            String schemaLocation = "";
            if (this.comprobante.getVersion().equals("3.3")) {
                this.cfdi = Namespace.getNamespace((String)"cfdi", (String)"http://www.sat.gob.mx/cfd/3");
                schemaLocation = "http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd";
                this.ns_pago = Namespace.getNamespace((String)"pago10", (String)"http://www.sat.gob.mx/Pagos");
            } else if (this.comprobante.getVersion().equals("4.0")) {
                this.cfdi = Namespace.getNamespace((String)"cfdi", (String)"http://www.sat.gob.mx/cfd/4");
                schemaLocation = "http://www.sat.gob.mx/cfd/4 http://www.sat.gob.mx/sitio_internet/cfd/4/cfdv40.xsd";
                this.ns_pago = Namespace.getNamespace((String)"pago20", (String)"http://www.sat.gob.mx/Pagos20");
            }
            this.datosGral = new Element("Comprobante", this.cfdi);
            ComplementoNominaDTO complementoNomina = null;
            ArrayList<ComplementoPagoDTO> complementosPago = null;
            if (this.tipoDocumento.equals("NM")) {
                this.datosGral.addNamespaceDeclaration(this.ns_nomina);
                complementoNomina = this.comprobante.getComplementoNom();
                schemaLocation = String.valueOf(schemaLocation) + " http://www.sat.gob.mx/nomina12 ";
                schemaLocation = String.valueOf(schemaLocation) + "http://www.sat.gob.mx/sitio_internet/cfd/nomina/nomina12.xsd";
            } else if (this.tipoDocumento.equals("CB")) {
                this.datosGral.addNamespaceDeclaration(this.ns_pago);
                complementosPago = this.comprobante.getComplementosPago();
                if (this.comprobante.getVersion().equals("4.0")) {
                    schemaLocation = String.valueOf(schemaLocation) + " http://www.sat.gob.mx/Pagos20 ";
                    schemaLocation = String.valueOf(schemaLocation) + "http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos20.xsd";
                } else {
                    schemaLocation = String.valueOf(schemaLocation) + " http://www.sat.gob.mx/Pagos ";
                    schemaLocation = String.valueOf(schemaLocation) + "http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos10.xsd";
                }
            }
            System.out.println("[CFDenXML] Inicia generacion de XML");
            this.datosGral.setAttribute("schemaLocation", schemaLocation, this.xsi);
            if (!this.tipoDocumento.equals("DV")) {
                this.datosGral.setAttribute("Version", this.comprobante.getVersion());
                if (this.comprobante.getSerie() != null) {
                    this.datosGral.setAttribute("Serie", this.comprobante.getSerie());
                }
                if (this.comprobante.getFolioDoc() != null) {
                    this.datosGral.setAttribute("Folio", this.comprobante.getFolioDoc());
                }
                this.datosGral.setAttribute("Fecha", this.comprobante.getFecha());
                this.datosGral.setAttribute("Sello", selloDigital);
                if (this.comprobante.getFormaDePago() != null) {
                    this.datosGral.setAttribute("FormaPago", this.comprobante.getFormaDePago());
                }
                this.datosGral.setAttribute("NoCertificado", this.configuracion.getNoCertificado());
                this.datosGral.setAttribute("Certificado", this.comprobante.getCertificado());
                if (this.comprobante.getCondicionesDePago() != null) {
                    this.datosGral.setAttribute("CondicionesDePago", this.comprobante.getCondicionesDePago());
                }
                this.datosGral.setAttribute("SubTotal", Conversiones.quitarFormatoImporte(this.comprobante.getSubtotal()));
                if (this.comprobante.getDescuento() != null && !this.comprobante.getTipoDoc().equals("CB") && (this.comprobante.getTipoDoc().equals("NM") && !this.comprobante.getDescuento().equals("0.00") || this.comprobante.getTipoDoc().equals("FC"))) {
                    this.datosGral.setAttribute("Descuento", Conversiones.quitarFormatoImporte(this.comprobante.getDescuento()));
                }
                this.datosGral.setAttribute("Moneda", this.comprobante.getMoneda());
                if (this.comprobante.getTipoCambio() != null) {
                    this.datosGral.setAttribute("TipoCambio", this.comprobante.getTipoCambio());
                }
                this.datosGral.setAttribute("Total", Conversiones.quitarFormatoImporte(this.comprobante.getTotal()));
                this.datosGral.setAttribute("TipoDeComprobante", this.comprobante.getTipodecomprobante());
                if (this.comprobante.getVersion().equals("4.0")) {
                    this.datosGral.setAttribute("Exportacion", this.comprobante.getExportacion());
                }
                if (this.comprobante.getMetodoDePago() != null) {
                    this.datosGral.setAttribute("MetodoPago", this.comprobante.getMetodoDePago());
                }
                if (this.comprobante.getLugarExpedicion() != null) {
                    this.datosGral.setAttribute("LugarExpedicion", this.comprobante.getLugarExpedicion());
                }
                if (this.comprobante.relaciones.size() > 0) {
                    Element relacionados = new Element("CfdiRelacionados", this.cfdi);
                    ComprobanteRelacDTO relacionDto = null;
                    int renglon = 0;
                    while (renglon < this.comprobante.relaciones.size()) {
                        relacionDto = this.comprobante.relaciones.elementAt(renglon);
                        if (renglon == 0) {
                            relacionados.setAttribute("TipoRelacion", relacionDto.getTipoRelacion());
                        }
                        Element relacion = new Element("CfdiRelacionado", this.cfdi);
                        relacion.setAttribute("UUID", relacionDto.getUUID());
                        relacionados.addContent((Content)relacion);
                        ++renglon;
                    }
                    this.datosGral.addContent((Content)relacionados);
                }
                if (this.comprobante.getVersion().equals("4.0") && this.comprobante.getRfcReceptor().startsWith("XAXX") && !this.comprobante.getTipoDoc().equals("CB")) {
                    Element informacionGlobal = new Element("InformacionGlobal", this.cfdi);
                    informacionGlobal.setAttribute("Periodicidad", this.comprobante.getPeriodicidad());
                    informacionGlobal.setAttribute("Meses", this.comprobante.getMeses());
                    informacionGlobal.setAttribute("A\u00f1o", this.comprobante.getAnios());
                    this.datosGral.addContent((Content)informacionGlobal);
                }
                System.out.println("[CFDenXML] Emisor");
                Element emisor = new Element("Emisor", this.cfdi);
                emisor.setAttribute("Rfc", this.comprobante.getRfcEmisor());
                emisor.setAttribute("Nombre", this.comprobante.getNombreEmisor());
                emisor.setAttribute("RegimenFiscal", this.comprobante.getClaveRegimen());
                System.out.println("[CFDenXML] Receptor");
                Element receptor = new Element("Receptor", this.cfdi);
                receptor.setAttribute("Rfc", this.comprobante.getRfcReceptor());
                if (this.comprobante.getNombreReceptor() != null) {
                    receptor.setAttribute("Nombre", this.comprobante.getNombreReceptor());
                }
                if (this.comprobante.getVersion().equals("4.0")) {
                    receptor.setAttribute("DomicilioFiscalReceptor", this.comprobante.getCodigoPostalReceptor());
                    receptor.setAttribute("RegimenFiscalReceptor", this.comprobante.getClaveRegimenReceptor());
                }
                receptor.setAttribute("UsoCFDI", this.comprobante.getUsoCFDI());
                System.out.println("[CFDenXML] Conceptos");
                Element conceptosT = null;
                conceptosT = new Element("Conceptos", this.cfdi);
                int renglon = 0;
                while (renglon < this.comprobante.conceptos.size()) {
                    concepto = this.comprobante.conceptos.elementAt(renglon);
                    Element datosConceptos = new Element("Concepto", this.cfdi);
                    datosConceptos.setAttribute("ClaveProdServ", concepto.getClaveSatProdServ());
                    if (concepto.getNoIdentificacion() != null) {
                        datosConceptos.setAttribute("NoIdentificacion", concepto.getNoIdentificacion());
                    }
                    datosConceptos.setAttribute("Cantidad", concepto.getCantidad().toString());
                    datosConceptos.setAttribute("ClaveUnidad", concepto.getClaveSatUnidades());
                    datosConceptos.setAttribute("Descripcion", concepto.getDescripcion());
                    datosConceptos.setAttribute("ValorUnitario", Conversiones.quitarFormatoImporte(concepto.getValorUnitario()));
                    datosConceptos.setAttribute("Importe", Conversiones.quitarFormatoImporte(concepto.getImporte()));
                    if (concepto.getDescuento() != null && this.comprobante.getTipoDoc().equals("NM") && !this.comprobante.getDescuento().equals("0.00") || this.comprobante.getTipoDoc().equals("FC")) {
                        datosConceptos.setAttribute("Descuento", concepto.getDescuento());
                    }
                    if (this.comprobante.getVersion().equals("4.0")) {
                        if (concepto.getLstTraslados().size() > 0 || concepto.getLstRetenciones().size() > 0) {
                            datosConceptos.setAttribute("ObjetoImp", "02");
                        } else {
                            datosConceptos.setAttribute("ObjetoImp", "01");
                        }
                    }
                    System.out.println("[CFDenXML] Impuestos por concepto");
                    if (this.tipoDocumento.equals("FC") || this.tipoDocumento.equals("NC")) {
                        Element impuestosXConcep = new Element("Impuestos", this.cfdi);
                        String etiqTrasladoXConcep = "Traslados";
                        String etiqTrasladoDetXConcep = "Traslado";
                        Element tipoTrasladoXConcep = new Element(etiqTrasladoXConcep, this.cfdi);
                        if (concepto.getLstTraslados().size() > 0) {
                            int renglonImpuesto = 0;
                            while (renglonImpuesto < concepto.getLstTraslados().size()) {
                                Element tipoTrasladoDetXConcep = new Element(etiqTrasladoDetXConcep, this.cfdi);
                                tipoTrasladoDetXConcep.setAttribute("Base", Conversiones.quitarFormatoImporte(concepto.getLstTraslados().get(renglonImpuesto).getBase()));
                                tipoTrasladoDetXConcep.setAttribute("Impuesto", concepto.getLstTraslados().get(renglonImpuesto).getImpuesto());
                                tipoTrasladoDetXConcep.setAttribute("TipoFactor", concepto.getLstTraslados().get(renglonImpuesto).getTipoFactor());
                                tipoTrasladoDetXConcep.setAttribute("TasaOCuota", concepto.getLstTraslados().get(renglonImpuesto).getTasaCuota());
                                tipoTrasladoDetXConcep.setAttribute("Importe", Conversiones.quitarFormatoImporte(concepto.getLstTraslados().get(renglonImpuesto).getImporte()));
                                tipoTrasladoXConcep.addContent((Content)tipoTrasladoDetXConcep);
                                ++renglonImpuesto;
                            }
                            impuestosXConcep.addContent((Content)tipoTrasladoXConcep);
                        }
                        if (concepto.getLstRetenciones().size() > 0) {
                            String etiqRetencionXConcep = "Retenciones";
                            String etiqRetencionDetXConcep = "Retencion";
                            Element tipoRetencionXConcep = new Element(etiqRetencionXConcep, this.cfdi);
                            int renglonImpuesto = 0;
                            while (renglonImpuesto < concepto.getLstRetenciones().size()) {
                                Element tipoRetencionDetXConcep = new Element(etiqRetencionDetXConcep, this.cfdi);
                                tipoRetencionDetXConcep.setAttribute("Base", Conversiones.quitarFormatoImporte(concepto.getLstRetenciones().get(renglonImpuesto).getBase()));
                                tipoRetencionDetXConcep.setAttribute("Impuesto", concepto.getLstRetenciones().get(renglonImpuesto).getImpuesto());
                                tipoRetencionDetXConcep.setAttribute("TipoFactor", concepto.getLstRetenciones().get(renglonImpuesto).getTipoFactor());
                                tipoRetencionDetXConcep.setAttribute("TasaOCuota", concepto.getLstRetenciones().get(renglonImpuesto).getTasaCuota());
                                tipoRetencionDetXConcep.setAttribute("Importe", Conversiones.quitarFormatoImporte(concepto.getLstRetenciones().get(renglonImpuesto).getImporte()));
                                tipoRetencionXConcep.addContent((Content)tipoRetencionDetXConcep);
                                ++renglonImpuesto;
                            }
                            impuestosXConcep.addContent((Content)tipoRetencionXConcep);
                        }
                        if (concepto.getLstTraslados().size() > 0 || concepto.getLstRetenciones().size() > 0) {
                            datosConceptos.addContent((Content)impuestosXConcep);
                        }
                    }
                    conceptosT.addContent((Content)datosConceptos);
                    ++renglon;
                }
                int numImpuestosInexistentes = 0;
                System.out.println("[CFDenXML] Impuestos");
                Element impuestos = new Element("Impuestos", this.cfdi);
                if (this.tipoDocumento.equals("FC") || this.tipoDocumento.equals("NC")) {
                    String atributoTraslados = "";
                    String atributoRetenidos = "";
                    String etiqTipoImpuesto = "";
                    String etiqTipoImpuestoDet = "";
                    atributoRetenidos = "TotalImpuestosRetenidos";
                    atributoTraslados = "TotalImpuestosTrasladados";
                    System.out.println("[CFDenXML] Total de impuestos Retenidos:" + this.comprobante.getTotalImpuestosRetenidos());
                    if (this.comprobante.getTotalImpuestosRetenidos() != null) {
                        impuestos.setAttribute(atributoRetenidos, Conversiones.quitarFormatoImporte(this.comprobante.getTotalImpuestosRetenidos()));
                    } else {
                        ++numImpuestosInexistentes;
                    }
                    System.out.println("[CFDenXML] Total de impuestos Trasladados:" + this.comprobante.getTotalImpuestosTrasladados());
                    if (this.comprobante.getTotalImpuestosTrasladados() != null) {
                        impuestos.setAttribute(atributoTraslados, Conversiones.quitarFormatoImporte(this.comprobante.getTotalImpuestosTrasladados()));
                    } else {
                        ++numImpuestosInexistentes;
                    }
                    System.out.println("[CFDenXML] Total de impuestos retenidos:" + this.comprobante.getTotalImpuestosRetenidos());
                    if (this.comprobante.getTotalImpuestosRetenidos() != null) {
                        etiqTipoImpuesto = "Retenciones";
                        etiqTipoImpuestoDet = "Retencion";
                        Element impuestoRetenidoAgrupado = new Element(etiqTipoImpuesto, this.cfdi);
                        int renglon2 = 0;
                        while (renglon2 < concepto.getLstRetencionesAgrupadas().size()) {
                            Element impuestoRetenidoAgrupadoDet = new Element(etiqTipoImpuestoDet, this.cfdi);
                            if (concepto.getLstRetencionesAgrupadas().size() > 0) {
                                impuestoRetenidoAgrupadoDet.setAttribute("Impuesto", concepto.getLstRetencionesAgrupadas().get(renglon2).getImpuesto());
                                impuestoRetenidoAgrupadoDet.setAttribute("Importe", Conversiones.quitarFormatoImporte(concepto.getLstRetencionesAgrupadas().get(renglon2).getImporte()));
                                impuestoRetenidoAgrupado.addContent((Content)impuestoRetenidoAgrupadoDet);
                            }
                            ++renglon2;
                        }
                        impuestos.addContent((Content)impuestoRetenidoAgrupado);
                    }
                    System.out.println("[CFDenXML] total impuestos trasladados");
                    if (this.comprobante.getTotalImpuestosTrasladados() != null && (concepto.getTasaTrasladado() != null || concepto.getImporte() != null)) {
                        etiqTipoImpuesto = "Traslados";
                        etiqTipoImpuestoDet = "Traslado";
                        Element impuestoTrasladoAgrupado = new Element(etiqTipoImpuesto, this.cfdi);
                        int renglon3 = 0;
                        while (renglon3 < concepto.getLstTrasladosAgrupados().size()) {
                            Element impuestoTrasladadoAgrupadoDet = new Element(etiqTipoImpuestoDet, this.cfdi);
                            if (this.comprobante.getVersion().equals("4.0")) {
                                impuestoTrasladadoAgrupadoDet.setAttribute("Base", concepto.getLstTrasladosAgrupados().get(renglon3).getBase());
                            }
                            impuestoTrasladadoAgrupadoDet.setAttribute("Impuesto", concepto.getLstTrasladosAgrupados().get(renglon3).getImpuesto());
                            impuestoTrasladadoAgrupadoDet.setAttribute("TipoFactor", concepto.getLstTrasladosAgrupados().get(renglon3).getTipoFactor());
                            impuestoTrasladadoAgrupadoDet.setAttribute("TasaOCuota", concepto.getLstTrasladosAgrupados().get(renglon3).getTasaCuota());
                            impuestoTrasladadoAgrupadoDet.setAttribute("Importe", Conversiones.quitarFormatoImporte(concepto.getLstTrasladosAgrupados().get(renglon3).getImporte()));
                            impuestoTrasladoAgrupado.addContent((Content)impuestoTrasladadoAgrupadoDet);
                            ++renglon3;
                        }
                        impuestos.addContent((Content)impuestoTrasladoAgrupado);
                    }
                }
                this.datosGral.addContent((Content)emisor);
                this.datosGral.addContent((Content)receptor);
                this.datosGral.addContent((Content)conceptosT);
                if ((this.tipoDocumento.equals("FC") || this.tipoDocumento.equals("NC")) && numImpuestosInexistentes < 2) {
                    this.datosGral.addContent((Content)impuestos);
                }
                if (this.tipoDocumento.equals("NM")) {
                    System.out.println("[CFDenXML] Complemento NM INICIO");
                    ComplementoNominaXML complNominaXML = new ComplementoNominaXML(complementoNomina, this.cfdi, this.ns_nomina);
                    complemento = complNominaXML.creaComplementoNomina(this.comprobante);
                }
                if (this.tipoDocumento.equals("CB")) {
                    ComplementoPagoXML complPagoXML = new ComplementoPagoXML(complementosPago, this.cfdi, this.ns_pago);
                    System.out.println("[CFDenXML] Complemento CB");
                    complemento = complPagoXML.creaComplementoPago(this.comprobante);
                }
            }
            if (this.Timbrado == 1 || this.Timbrado == 2) {
                if (!this.tipoDocumento.equals("CB") && !this.tipoDocumento.equals("NM")) {
                    complemento = new Element("Complemento", this.cfdi);
                }
                Element TimbreFiscalDigital = new Element("TimbreFiscalDigital", this.tfd);
                TimbreFiscalDigital.setAttribute("Version", this.comprobante.getVersionTFD());
                TimbreFiscalDigital.setAttribute("schemaLocation", "http://www.sat.gob.mx/TimbreFiscalDigital http://www.sat.gob.mx/sitio_internet/cfd/TimbreFiscalDigital/TimbreFiscalDigitalv11.xsd", this.xsi);
                TimbreFiscalDigital.setAttribute("UUID", this.comprobante.getUUID());
                TimbreFiscalDigital.setAttribute("FechaTimbrado", this.comprobante.getFechaTimbrado());
                TimbreFiscalDigital.setAttribute("SelloCFD", this.comprobante.getSello());
                TimbreFiscalDigital.setAttribute("NoCertificadoSAT", this.comprobante.getNoCertificadoSAT());
                TimbreFiscalDigital.setAttribute("SelloSAT", this.comprobante.getSelloSAT());
                TimbreFiscalDigital.setAttribute("RfcProvCertif", this.comprobante.getRfcProvCertif());
                complemento.addContent((Content)TimbreFiscalDigital);
                this.datosGral.addContent((Content)complemento);
            } else if (this.tipoDocumento.equals("CB") || this.tipoDocumento.equals("NM")) {
                this.datosGral.addContent(complemento);
            }
            if (this.Timbrado == 2) {
                System.out.println("[CFDenXML] Agregando metadatos");
                Element metadato = new Element("Metadata");
                try {
                    metadato = this.generaNodoMetadatos(this.comprobante);
                }
                catch (Exception receptor) {
                    // empty catch block
                }
                this.datosGral.addContent((Content)metadato);
            }
            doc = new Document(this.datosGral);
            try {
                Format format = Format.getPrettyFormat();
                format.setEncoding("utf-8");
                format.setTextMode(Format.TextMode.NORMALIZE);
                XMLOutputter out = new XMLOutputter(format);
                FileOutputStream file = new FileOutputStream(nombreArchivoXML);
                file.write(239);
                file.write(187);
                file.write(191);
                out.output(doc, (OutputStream)file);
                file.flush();
                file.close();
                System.out.println("[CFDenXML] Se creo el XML...");
            }
            catch (Exception e) {
                RegistraLOG.registrarLog(this.getClass().getName(), "generarXML", e.toString(), "ERROR JAVA");
            }
        }
        return nombreArchivoXML;
    }

    public void agregaNodo(Vector nodos, NodoAdenda nodoActual, Element elementoActual, int iteraciones) {
        Namespace factura = Namespace.getNamespace((String)this.comprobante.getAdenda().getTipo(), (String)this.comprobante.getAdenda().getNamespace().toString());
        Element elementoHijo = null;
        NodoAdenda nodoHijo = null;
        int renglon = 0;
        while (renglon < nodos.size()) {
            if (((NodoAdenda)nodos.elementAt(renglon)).getNodoPadre() != null && nodoActual == (nodoHijo = ((NodoAdenda)nodos.elementAt(renglon)).getNodoPadre())) {
                elementoHijo = new Element(((NodoAdenda)nodos.elementAt(renglon)).getNombre(), factura);
                int r = 0;
                while (r < ((NodoAdenda)nodos.elementAt((int)renglon)).atributos.size()) {
                    elementoHijo.setAttribute(((AtributoAdenda)((NodoAdenda)nodos.elementAt((int)renglon)).atributos.elementAt(r)).getNombre(), ((AtributoAdenda)((NodoAdenda)nodos.elementAt((int)renglon)).atributos.elementAt(r)).getValor());
                    ++r;
                }
                elementoActual.addContent((Content)elementoHijo);
                this.agregaNodo(nodos, (NodoAdenda)nodos.elementAt(renglon), elementoHijo, iteraciones);
            }
            ++renglon;
        }
    }

    private Element generaNodoMetadatos(ComprobanteDTO comprobante) throws ParserConfigurationException {
        String tipoarch;
        Element meta = null;
        switch (tipoarch = comprobante.getSubtipoDoc()) {
            case "atr": {
                meta = this.nodometaAtr(comprobante);
            }
        }
        return meta;
    }

    private Element nodometaAtr(ComprobanteDTO comprobante) {
        Element metaatr = new Element("Metadata");
        Element metaid = new Element("ID");
        Element metabuque = new Element("BUQUE");
        Element metacvnaviera = new Element("CV_NAVIERA");
        Element metaagentenav = new Element("AGENTE_NAVIERO");
        Element metafatraque = new Element("F_ATRAQUE");
        Element metafentrega = new Element("F_ENTREGA");
        Element metativa = new Element("T_IVA");
        Element metafoliosip = new Element("FOLIO_SIP");
        Element metatipofact = new Element("TIPO_FACT");
        Element metacomplemento = new Element("Complemento");
        Element metahostimpresora = new Element("HOST_IMPRESORA");
        Element metanombreimpresora = new Element("NOMBRE_IMPRESORA");
        Element metanocopias = new Element("NO.COPIAS");
        Element metaleyendarfc = new Element("LEYENDA_RFC");
        Element metareferenciabancaria = new Element("REFERENCIA_BANCARIA");
        Element metacuentabancaria = new Element("CUENTA_BANCARIA");
        Element metaregimenfiscal = new Element("REGIMEN_FISCAL");
        Element metametodopago = new Element("METODO_PAGO");
        Element metaformapago = new Element("FORMA_PAGO");
        Element metausocfdi = new Element("USO_CFDI");
        Element metatiporelacion = new Element("TIPO_RELACION");
        Element metaemisor = new Element("Emisor");
        Element metareceptor = new Element("Receptor");
        Element metadomicilioEmisor = new Element("Domicilio");
        Element metadomicilioReceptor = new Element("Domicilio");
        metabuque.addContent(comprobante.getmetadatoAtr().getBuque());
        metacvnaviera.addContent(comprobante.getmetadatoAtr().getClaveNaviera());
        metaagentenav.addContent(comprobante.getmetadatoAtr().getAgenteNaviero());
        metafatraque.addContent(comprobante.getmetadatoAtr().getFechaAtraque());
        metafentrega.addContent(comprobante.getmetadatoAtr().getFechaEntrega());
        metativa.addContent(comprobante.getmetadatoAtr().getTasaIva());
        metafoliosip.addContent(comprobante.getmetadatoAtr().getFolioSip());
        metatipofact.addContent(comprobante.getmetadatoAtr().getTipoFactura());
        metahostimpresora.addContent(comprobante.getmetadatoAtr().getHostImpresora());
        metanombreimpresora.addContent(comprobante.getmetadatoAtr().getNombreImpresora());
        metanocopias.addContent(Integer.toString(comprobante.getmetadatoAtr().getNoCopias()));
        metaleyendarfc.addContent(comprobante.getmetadatoAtr().getLeyendaRFC());
        metareferenciabancaria.addContent(comprobante.getmetadatoAtr().getReferenciaBancaria());
        metaregimenfiscal.addContent(comprobante.getmetadatoAtr().getRegimenFiscal());
        metametodopago.addContent(comprobante.getmetadatoAtr().getMetodoPago());
        metaformapago.addContent(comprobante.getmetadatoAtr().getFormaPago());
        metausocfdi.addContent(comprobante.getmetadatoAtr().getUsoCFDI());
        metatiporelacion.addContent(comprobante.getmetadatoAtr().getTipoRelacion());
        metacuentabancaria.addContent(comprobante.getmetadatoAtr().getCuentaBancaria());
        metadomicilioEmisor.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilioEmisor.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilioEmisor.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilioEmisor.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilioEmisor.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilioEmisor.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilioEmisor.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilioEmisor.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilioEmisor.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.addContent((Content)metadomicilioEmisor);
        metadomicilioReceptor.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilioReceptor.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilioReceptor.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilioReceptor.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilioReceptor.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilioReceptor.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilioReceptor.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilioReceptor.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilioReceptor.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.addContent((Content)metadomicilioReceptor);
        metaatr.addContent((Content)metaid);
        metaatr.addContent((Content)metabuque);
        metaatr.addContent((Content)metacvnaviera);
        metaatr.addContent((Content)metaagentenav);
        metaatr.addContent((Content)metafatraque);
        metaatr.addContent((Content)metafentrega);
        metaatr.addContent((Content)metativa);
        metaatr.addContent((Content)metafoliosip);
        metaatr.addContent((Content)metatipofact);
        metaatr.addContent((Content)metacomplemento);
        metaatr.addContent((Content)metahostimpresora);
        metaatr.addContent((Content)metanombreimpresora);
        metaatr.addContent((Content)metanocopias);
        metaatr.addContent((Content)metaleyendarfc);
        metaatr.addContent((Content)metareferenciabancaria);
        metaatr.addContent((Content)metacuentabancaria);
        metaatr.addContent((Content)metaregimenfiscal);
        metaatr.addContent((Content)metametodopago);
        metaatr.addContent((Content)metaformapago);
        metaatr.addContent((Content)metausocfdi);
        metaatr.addContent((Content)metatiporelacion);
        metaatr.addContent((Content)metaemisor);
        metaatr.addContent((Content)metareceptor);
        return metaatr;
    }

    public void generaAddenda() {
        Namespace factura = Namespace.getNamespace((String)this.comprobante.getAdenda().getTipo(), (String)this.comprobante.getAdenda().getNamespace().toString());
        Element addendaXML = null;
        Element nodoPadre = null;
        if (this.comprobante.getAdenda() != null) {
            addendaXML = new Element("Addenda", this.cfdi);
            nodoPadre = new Element("Factura", factura);
            int r = 0;
            while (r < this.comprobante.getAdenda().nodos.elementAt((int)0).atributos.size()) {
                nodoPadre.setAttribute(((AtributoAdenda)this.comprobante.getAdenda().nodos.elementAt((int)0).atributos.elementAt(r)).getNombre(), ((AtributoAdenda)this.comprobante.getAdenda().nodos.elementAt((int)0).atributos.elementAt(r)).getValor());
                ++r;
            }
            addendaXML.addContent((Content)nodoPadre);
            this.agregaNodo(this.comprobante.getAdenda().nodos, this.comprobante.getAdenda().nodos.elementAt(0), nodoPadre, 0);
            this.datosGral.addContent((Content)addendaXML);
        }
    }

    public int getTimbrado() {
        return this.Timbrado;
    }

    public void setTimbrado(int timbrado) {
        this.Timbrado = timbrado;
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }
}

