/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi;

import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import siti.conexion.BDUtil;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.ManejadorArchivos;
import siti.sinco.cfdi.tools.Utilerias;

public class ImportaXMLPIS {
    public static void leerCarpeta(BDUtil bdUtil, String pPathCarpeta, String modo, int niveles) throws ParserConfigurationException, SAXException {
        boolean vComprobante = false;
        String nombreArchivo = "";
        boolean numArchivos = false;
        if (!pPathCarpeta.isEmpty()) {
            File pCarpeta = new File(pPathCarpeta);
            if (pCarpeta.exists() && pCarpeta.isDirectory()) {
                System.out.println("Leyendo archivos de la carpeta: " + pPathCarpeta);
                File[] pArchivosEncontrados = pCarpeta.listFiles();
                int x = 0;
                while (x < pArchivosEncontrados.length) {
                    if (pArchivosEncontrados[x].isDirectory() && niveles == 2 && !pArchivosEncontrados[x].getName().toUpperCase().contains("PROCESADOS")) {
                        ImportaXMLPIS.leerCarpeta(bdUtil, pArchivosEncontrados[x].getAbsolutePath(), modo, niveles - 1);
                    }
                    if ((nombreArchivo = pArchivosEncontrados[x].getName().toUpperCase()).endsWith(".XML")) {
                        System.out.println("archivo a listar: " + nombreArchivo);
                        System.out.println("archivo a analizar: " + pArchivosEncontrados[x].getName());
                    }
                    ++x;
                }
                System.out.println("Se terminaron de leer los archivos de la carpeta:\n\t" + pPathCarpeta);
            } else {
                System.out.println("Favor de revisar el nombre de la carpeta, no existe.");
            }
        } else {
            System.out.println("No has seleccionado una carpeta.");
        }
    }

    public static int leerArchivoXML(BDUtil bdUtil, String pPathArchivo, String pSerie, String pNumFactura) throws ParserConfigurationException, SAXException {
        int vComprobante;
        block6: {
            vComprobante = 0;
            ComprobanteDTO comprobanteDTO = new ComprobanteDTO(0);
            if (!pPathArchivo.isEmpty()) {
                try {
                    File file = new File(pPathArchivo);
                    if (file.exists()) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document documentoXML = db.parse(file);
                        documentoXML.getDocumentElement().normalize();
                        System.out.println("Archivo: " + file.getName());
                        comprobanteDTO = ImportaXMLPIS.subirComprobante(bdUtil, documentoXML, pPathArchivo, pSerie, pNumFactura);
                        System.out.println("----- COMPROBANTE:" + comprobanteDTO.getComprobante());
                        if (comprobanteDTO.getComprobante() > 0) {
                            System.out.println("Insertando en CFD_EMISION");
                            CfdEmisionDAO vCfd_emision = new CfdEmisionDAO();
                            vCfd_emision.insertaCfdi_emision(bdUtil, comprobanteDTO.getComprobante());
                            System.out.println("Creando archivo");
                            String nombreArchivoNuevo = ComprobantesDAO.creaNombreArchivo(comprobanteDTO.getComprobante());
                            System.out.println("Moviendo el archivo a procesados...");
                            ConfiguracionDTO vConfig = new ConfiguracionDTO();
                            ConfiguracionDAO vConfigDAO = new ConfiguracionDAO();
                            vConfigDAO.llenarConfiguracion(bdUtil, vConfig, 1);
                            File vArchivo = new File(pPathArchivo);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\\MM\\dd");
                            String subcarpeta = comprobanteDTO.getFecha().replace("-", "\\").replaceFirst("[T][^T]+$", "");
                            String vPathArchivo = String.valueOf(vArchivo.getParent()) + File.separator;
                            String vCarpetaDestino = String.valueOf(vConfig.getRutaSalidaXml()) + File.separator + subcarpeta + File.separator;
                            String vNombreArchivo = vArchivo.getName().replaceFirst("[.][^.]+$", "");
                            ManejadorArchivos.copiarArchivoConDiferenteNombre(String.valueOf(vPathArchivo) + vNombreArchivo + ".xml", String.valueOf(vCarpetaDestino) + "CFDI", "PIS_" + nombreArchivoNuevo);
                            ManejadorArchivos.copiarArchivoConDiferenteNombre(String.valueOf(vPathArchivo) + vNombreArchivo + ".pdf", String.valueOf(vCarpetaDestino) + "PDF", "PIS_" + nombreArchivoNuevo);
                        }
                        break block6;
                    }
                    System.out.print("Error: No existe el archivo indicado.");
                    vComprobante = -1;
                }
                catch (IOException e) {
                    System.out.println("Error: No se pudo abrir el archivo :" + e);
                    vComprobante = -1;
                }
            } else {
                System.out.println("Error: La ruta al archivo: " + pPathArchivo + " no es v\u00e1lida.");
                vComprobante = -1;
            }
        }
        System.out.println("Se termin\u00f3 de leer el archivo " + pPathArchivo);
        return vComprobante;
    }

    public static String getAtributo(Node pNodo, String pAtributo) {
        String vValor = null;
        if (pNodo != null) {
            int vLongitud = pNodo.getAttributes().getLength();
            if (vLongitud > 0) {
                NamedNodeMap vAtributos = pNodo.getAttributes();
                int i = 0;
                while (i < vLongitud) {
                    if (vAtributos.item(i).getNodeName().toUpperCase().equals(pAtributo.toUpperCase())) {
                        vValor = vAtributos.item(i).getNodeValue();
                        break;
                    }
                    ++i;
                }
                if (vValor == null) {
                    System.out.println("No se encontr\u00f3 el atributo: " + pAtributo + " en el nodo:" + pNodo.getNodeName());
                }
            } else {
                System.out.println("--- No contiene atributos el nodo: '" + pNodo.getNodeName() + "'");
            }
        }
        return vValor;
    }

    public static String getAtributoDe(Document pXML, String pEtiqueta, String pAtributo) {
        Node vNodoHijo = pXML.getElementsByTagName(pEtiqueta).item(0);
        String vValor = "";
        if (vNodoHijo != null) {
            vValor = ImportaXMLPIS.getAtributo(vNodoHijo, pAtributo);
        } else {
            System.out.println("--- No existe el nodo: '" + pEtiqueta + "'");
            vValor = null;
        }
        return vValor;
    }

    public static String getContenidoDe(Node pNodo, String pEtiqueta) {
        String vValor = null;
        Element vElement = (Element)pNodo;
        Node vNodo = vElement.getElementsByTagName(pEtiqueta).item(0);
        if (vNodo != null) {
            vValor = vElement.getElementsByTagName(pEtiqueta).item(0).getTextContent();
            System.out.println("Nodo: " + pNodo.getNodeName() + " Valor: " + vValor);
        } else {
            System.out.println("Etiqueta: " + pEtiqueta + " | No existe.");
        }
        return vValor;
    }

    public static Node getNodoDe(Document pXML, String pNodo) {
        Node vNodo = pXML.getElementsByTagName(pNodo).item(0);
        if (vNodo == null) {
            System.out.println("---Error: No existe el nodo '" + pNodo + "'.");
        }
        return vNodo;
    }

    public static String getAtributoHijoDe(Document pXML, String pNodoPadre, String pNodoHijo, String pAtributo) {
        String vValor = "";
        Node vNodoPadre = pXML.getElementsByTagName(pNodoPadre).item(0);
        if (vNodoPadre != null) {
            Element vElement = (Element)vNodoPadre;
            NodeList vListaNodosHijos = vElement.getElementsByTagName(pNodoHijo);
            Node vNodoHijo = null;
            int i = 0;
            while (i < vListaNodosHijos.getLength()) {
                if (vListaNodosHijos.item(i).getNodeType() == 1 && vListaNodosHijos.item(i).getParentNode() == vNodoPadre) {
                    vNodoHijo = vListaNodosHijos.item(i);
                }
                ++i;
            }
            if (vNodoHijo != null) {
                vValor = ImportaXMLPIS.getAtributo(vNodoHijo, pAtributo);
            } else {
                System.out.println("--- Etiqueta: " + pAtributo + " | No existe.");
                vValor = null;
            }
        } else {
            vValor = null;
        }
        return vValor;
    }

    public static Node getNodoHijoDe(Node pNodoPadre, String pNodoHijo) {
        Node vNodoR = null;
        if (pNodoPadre != null) {
            Element vElement = (Element)pNodoPadre;
            if (vElement.getElementsByTagName(pNodoHijo).item(0) != null) {
                vNodoR = vElement.getElementsByTagName(pNodoHijo).item(0);
            } else {
                System.out.println("--- Nodo '" + pNodoHijo + "' no existe.");
            }
        }
        return vNodoR;
    }

    public static Node getNodoNietoDe(Node pNodoAbuelo, String pNodoPadre, String pNodoNieto) {
        Node vPadre = null;
        Node vNodoR = null;
        Element vDescendenciaAbuelo = (Element)pNodoAbuelo;
        if (vDescendenciaAbuelo.getElementsByTagName(pNodoPadre).item(0) != null) {
            vPadre = vDescendenciaAbuelo.getElementsByTagName(pNodoPadre).item(0);
            vNodoR = ImportaXMLPIS.getNodoHijoDe(vPadre, pNodoNieto);
        } else {
            System.out.println("--- Nodo padre no existe.");
        }
        return vNodoR;
    }

    public static ComprobanteDTO subirComprobante(BDUtil pbdUtil, Document pDocumentoXML, String pPathArchivo, String pSerie, String pNumFactura) {
        ComprobanteDTO comprobanteDTO;
        block36: {
            CallableStatement callStatement = null;
            comprobanteDTO = new ComprobanteDTO(0);
            Node vComprobante = ImportaXMLPIS.getNodoDe(pDocumentoXML, "cfdi:Comprobante");
            String vTipoDoc = pSerie;
            String vSerie = ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Serie");
            String vSubTipoDoc = "";
            int vNumComprobante = 0;
            String paso = "0";
            System.out.println("SubtipoDoc:" + vSubTipoDoc);
            if (vTipoDoc.equals("FC") || vTipoDoc.equals("F") || vTipoDoc.equals("N")) {
                vTipoDoc = "FC";
                vSerie = "F";
                vSubTipoDoc = ImportaXMLPIS.getDescConcepto(vComprobante);
            } else if (vTipoDoc.equals("NC")) {
                vSubTipoDoc = "ncr";
            } else if (vTipoDoc.equals("NM")) {
                vSubTipoDoc = "nom";
            } else if (vTipoDoc.equals("CB")) {
                vSubTipoDoc = "cob";
            }
            String sentencia = "";
            sentencia = "{ call verifica_elimina_compr_import( ?, ?, ? ) }";
            try {
                String vfolio = ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio");
                callStatement = pbdUtil.connection.prepareCall(sentencia);
                callStatement.setString(1, vTipoDoc);
                callStatement.setString(2, vfolio);
                callStatement.registerOutParameter(3, 4);
                callStatement.execute();
                vNumComprobante = callStatement.getInt(3);
                comprobanteDTO.setComprobante(vNumComprobante);
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception e) {
                System.out.println("Error en verifica_elimina_compr_import=" + e.toString());
            }
            if (comprobanteDTO.getComprobante() < 0) {
                sentencia = "{ call bdPkgCfd.insertarComprobantes(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) }";
                try {
                    try {
                        paso = "100";
                        callStatement = pbdUtil.connection.prepareCall(sentencia);
                        paso = "200";
                        callStatement.setInt(1, 1);
                        callStatement.setString(2, "API");
                        callStatement.setString(3, vTipoDoc);
                        callStatement.setString(4, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio"));
                        callStatement.setString(5, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Version"));
                        callStatement.setString(6, vSerie);
                        paso = "210";
                        if (vSubTipoDoc.equals("cob")) {
                            if (ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio").length() > 6) {
                                callStatement.setInt(7, Integer.parseInt(pNumFactura));
                            } else {
                                callStatement.setInt(7, Integer.parseInt(pNumFactura));
                            }
                        } else {
                            callStatement.setInt(7, Integer.parseInt(pNumFactura));
                        }
                        paso = "220";
                        callStatement.setString(8, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Fecha"));
                        comprobanteDTO.setFecha(ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Fecha"));
                        callStatement.setString(9, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Sello"));
                        callStatement.setString(10, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "noAprobacion"));
                        callStatement.setString(11, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "anoAprobacion"));
                        callStatement.setString(12, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "FormaPago"));
                        callStatement.setString(13, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "NoCertificado"));
                        paso = "230";
                        callStatement.setString(14, null);
                        callStatement.setString(15, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "SubTotal"));
                        paso = "231";
                        String vDescuento = ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Descuento");
                        if (vDescuento == null) {
                            callStatement.setString(16, vDescuento);
                        } else {
                            callStatement.setString(16, String.format("%,.2f", Float.valueOf(Float.parseFloat(vDescuento.replaceAll(",", "")))));
                        }
                        paso = "232";
                        callStatement.setString(17, null);
                        callStatement.setString(18, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Total"));
                        callStatement.setString(19, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "MetodoPago"));
                        callStatement.setString(20, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "TipoDeComprobante"));
                        paso = "240";
                        callStatement.setString(21, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Emisor", "Rfc"));
                        callStatement.setString(22, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Emisor", "Nombre"));
                        String pAuxCalle = ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "calle");
                        callStatement.setString(23, ImportaXMLPIS.nvl(pAuxCalle, "INT. RECINTO FISCAL"));
                        callStatement.setString(24, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "noExterior"), "S/N"));
                        callStatement.setString(25, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "noInterior"));
                        callStatement.setString(26, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "colonia"), "CENTRO"));
                        callStatement.setString(27, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "localidad"), "MAZATLAN"));
                        callStatement.setString(28, null);
                        String vDomicilioEmisor = ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "municipio");
                        callStatement.setString(29, ImportaXMLPIS.nvl(vDomicilioEmisor, "MAZATLAN"));
                        String vEstadoEmisor = ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "estado");
                        callStatement.setString(30, ImportaXMLPIS.nvl(vEstadoEmisor, "SINALOA"));
                        String vPaisEmisor = ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "pais");
                        callStatement.setString(31, ImportaXMLPIS.nvl(vPaisEmisor, "M\u00c9XICO"));
                        String vCodigoPostalEmisor = ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "codigoPostal");
                        callStatement.setString(32, ImportaXMLPIS.nvl(vCodigoPostalEmisor, "82000"));
                        callStatement.setString(33, null);
                        callStatement.setString(34, null);
                        callStatement.setString(35, null);
                        callStatement.setString(36, null);
                        callStatement.setString(37, null);
                        callStatement.setString(38, null);
                        callStatement.setString(39, null);
                        callStatement.setString(40, null);
                        callStatement.setString(41, null);
                        callStatement.setString(42, null);
                        paso = "RECEPTOR";
                        Node vReceptor = ImportaXMLPIS.getNodoHijoSiExiste(ImportaXMLPIS.getNodoSiEsNull(vComprobante, "Receptor", "cfdi:Receptor"), "Domicilio");
                        callStatement.setString(43, ImportaXMLPIS.getAtributoSiEsNull(vReceptor, "Rfc", "Rfc"));
                        callStatement.setString(44, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Receptor", "Nombre"));
                        callStatement.setString(45, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "calle"));
                        callStatement.setString(46, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "noExterior"));
                        callStatement.setString(47, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "noInterior"));
                        callStatement.setString(48, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "colonia"));
                        callStatement.setString(49, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "localidad"));
                        callStatement.setString(50, null);
                        callStatement.setString(51, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "municipio"));
                        callStatement.setString(52, ImportaXMLPIS.getAtributoSiEsNull(vReceptor, "estado", "Estado"));
                        String vPaisReceptor = ImportaXMLPIS.getAtributoSiEsNull(vReceptor, "pais", "Pais");
                        if (vPaisReceptor == null) {
                            vPaisReceptor = " ";
                        }
                        callStatement.setString(53, vPaisReceptor);
                        callStatement.setString(54, ImportaXMLPIS.getAtributoSiEsNull(vReceptor, "Receptor", "DomicilioFiscalReceptor"));
                        callStatement.setString(55, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "cfdi:Comprobante", "cfdi:Impuestos", "TotalImpuestosTrasladados"));
                        callStatement.setString(56, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "Complemento", "conLetra"));
                        callStatement.setInt(57, 1);
                        callStatement.setString(58, null);
                        callStatement.setString(59, null);
                        callStatement.setString(60, null);
                        callStatement.setInt(61, 0);
                        callStatement.setString(62, null);
                        callStatement.setString(63, null);
                        callStatement.setString(64, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Moneda"));
                        callStatement.setString(65, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "LugarExpedicion"));
                        callStatement.setString(66, null);
                        callStatement.setString(67, null);
                        callStatement.setString(68, null);
                        callStatement.setString(69, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "Version"));
                        callStatement.setString(70, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "UUID"));
                        callStatement.setString(71, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "FechaTimbrado"));
                        callStatement.setString(72, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "NoCertificadoSAT"));
                        callStatement.setString(73, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "SelloSAT"));
                        callStatement.setString(74, null);
                        callStatement.setString(75, null);
                        callStatement.setString(76, null);
                        callStatement.setString(77, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "MetodoPago"));
                        callStatement.setString(78, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "cfdi:Complemento", "tfd:TimbreFiscalDigital", "Version"));
                        callStatement.setString(79, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "cfdi:Complemento", "tfd:TimbreFiscalDigital", "Version"));
                        callStatement.setString(80, null);
                        callStatement.setString(81, ImportaXMLPIS.getAtributoSiEsNull(vReceptor, "UsoCFDI", "UsoCFDI"));
                        callStatement.setString(82, null);
                        callStatement.setString(83, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "MetodoPago"));
                        callStatement.setString(84, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "RfcProvCertif"));
                        callStatement.setString(85, null);
                        callStatement.setString(86, ImportaXMLPIS.getAtributoHijoDe(pDocumentoXML, "cfdi:Comprobante", "cfdi:Impuestos", "TotalImpuestosRetenidos"));
                        callStatement.setString(87, vSubTipoDoc);
                        paso = "300";
                        callStatement.setString(88, ImportaXMLPIS.getAtributoDe(pDocumentoXML, "cfdi:Receptor", "RegimenFiscalReceptor"));
                        callStatement.registerOutParameter(89, 4);
                        paso = "400";
                        callStatement.execute();
                        paso = "500";
                        vNumComprobante = callStatement.getInt(89);
                        comprobanteDTO.setComprobante(vNumComprobante);
                        System.out.println("--NUMERO DE COMPROBANTE:" + comprobanteDTO.getComprobante());
                        if (!vSubTipoDoc.equals("nom")) {
                            paso = "600";
                            ImportaXMLPIS.subirConceptos(pbdUtil, pDocumentoXML, comprobanteDTO.getComprobante());
                            paso = "700";
                            ImportaXMLPIS.subirImpuestos(pbdUtil, pDocumentoXML, comprobanteDTO.getComprobante());
                            paso = "800";
                            ImportaXMLPIS.subirComprobantesRelac(pbdUtil, pDocumentoXML, comprobanteDTO.getComprobante());
                            paso = "900";
                            if (vSubTipoDoc.equals("cob")) {
                                ImportaXMLPIS.subirComplementoPago(pbdUtil, pDocumentoXML, comprobanteDTO.getComprobante());
                            }
                        } else {
                            paso = "520";
                            paso = "521";
                            ImportaXMLPIS.getComplementoDeNomina(pbdUtil, vComprobante, comprobanteDTO.getComprobante());
                            paso = "522";
                        }
                        ImportaXMLPIS.registrarLog(pbdUtil, comprobanteDTO.getComprobante(), pPathArchivo);
                        paso = "1200";
                        pbdUtil.connection.commit();
                        callStatement.close();
                        callStatement = null;
                    }
                    catch (Exception e) {
                        System.out.println("Error: al insertar en la BD COMPROBANTES. Paso: " + paso + " " + e.toString());
                        vNumComprobante = 0;
                        comprobanteDTO.setComprobante(0);
                        if (callStatement == null) break block36;
                        try {
                            callStatement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        callStatement = null;
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    if (callStatement != null) {
                        try {
                            callStatement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        callStatement = null;
                    }
                    throw throwable;
                }
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            } else if (vTipoDoc.equals("NC") || vTipoDoc.equals("FC")) {
                System.out.println("La factura ya habia sido importada, s\u00f3lo se subir\u00e1 el concepto");
                vNumComprobante = 0;
                comprobanteDTO.setComprobante(0);
            } else {
                vNumComprobante = -1;
                comprobanteDTO.setComprobante(-1);
            }
        }
        System.out.println("Termin\u00f3 ImportarXML");
        return comprobanteDTO;
    }

    public static void subirConceptos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        Statement callStatement = null;
        Node vConceptos = pDocumentoXML.getElementsByTagName("cfdi:Conceptos").item(0);
        Node vComprobante = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        Node vHijo = null;
        String paso = "0";
        String sentencia = "{ call bdPkgCfd.Insertar_SATCFDCONCEPTOS(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) }";
        if (vConceptos != null) {
            try {
                NodeList vListaConceptos = vConceptos.getChildNodes();
                int longitud = vListaConceptos.getLength();
                int vNumConcepto = 0;
                int vNumImpuesto = 0;
                String vTipoImp = "";
                int i = 0;
                while (i < longitud) {
                    vHijo = vListaConceptos.item(i);
                    if (vHijo.getNodeType() == 1) {
                        ++vNumConcepto;
                        Node vImpuestos = ImportaXMLPIS.getNodoHijoDe(vListaConceptos.item(i), "cfdi:Impuestos");
                        if (vImpuestos != null) {
                            NodeList vListaImpuestos = vImpuestos.getChildNodes();
                            int vLongitudListaImpuestos = vListaImpuestos.getLength();
                            vNumImpuesto = 0;
                            int j = 0;
                            while (j < vLongitudListaImpuestos) {
                                if (vListaImpuestos.item(j).getNodeType() == 1) {
                                    ++vNumImpuesto;
                                    Node vTipoImpuesto = null;
                                    if (vListaImpuestos.item(j).getNodeName().toUpperCase().contains("CFDI:TRASLADOS")) {
                                        vTipoImpuesto = ImportaXMLPIS.getNodoHijoDe(vListaImpuestos.item(j), "cfdi:Traslado");
                                        vTipoImp = "T";
                                    } else {
                                        vTipoImpuesto = ImportaXMLPIS.getNodoHijoDe(vListaImpuestos.item(j), "cfdi:Retencion");
                                        vTipoImp = "R";
                                    }
                                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                                    callStatement.setInt(1, vNumConcepto);
                                    callStatement.setString(2, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "Cantidad"));
                                    callStatement.setString(3, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "Unidad"));
                                    callStatement.setString(4, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "NoIdentificacion"));
                                    callStatement.setString(5, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "Descripcion"));
                                    callStatement.setString(6, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "ValorUnitario"));
                                    callStatement.setString(7, String.format("%.2f", Float.valueOf(Float.parseFloat(ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "Importe").replaceAll(",", "")))));
                                    callStatement.setString(8, ImportaXMLPIS.getAtributo(vTipoImpuesto, "Impuesto"));
                                    callStatement.setString(9, ImportaXMLPIS.getAtributo(vTipoImpuesto, "TasaOCuota"));
                                    callStatement.setString(10, ImportaXMLPIS.getAtributo(vTipoImpuesto, "Importe"));
                                    callStatement.setString(11, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "ClaveProdServ"));
                                    callStatement.setString(12, ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "ClaveUnidad"));
                                    String vDescuento = ImportaXMLPIS.getAtributo(vListaConceptos.item(i), "Descuento");
                                    vDescuento = vDescuento == null ? "0" : vDescuento.replaceAll(",", "");
                                    callStatement.setString(13, String.format("%.2f", Float.valueOf(Float.parseFloat(vDescuento))));
                                    callStatement.setString(14, ImportaXMLPIS.getAtributo(vTipoImpuesto, "Base"));
                                    callStatement.setString(15, ImportaXMLPIS.getAtributo(vTipoImpuesto, "TipoFactor"));
                                    callStatement.setInt(16, pComprobante);
                                    callStatement.execute();
                                    callStatement.close();
                                    callStatement = null;
                                    ImportaXMLPIS.subirImpuesto(pbdUtil, vTipoImpuesto, pComprobante, vNumConcepto, vNumImpuesto, vTipoImp);
                                }
                                ++j;
                            }
                        }
                        if (vHijo.getNodeName().toUpperCase().equals("CFDI:CONCEPTO") && vImpuestos == null) {
                            Node vImpuestos32 = ImportaXMLPIS.getNodoHijoDe(vComprobante, "cfdi:Impuestos");
                            callStatement = pbdUtil.connection.prepareCall(sentencia);
                            callStatement.setInt(1, vNumConcepto);
                            callStatement.setString(2, ImportaXMLPIS.getAtributo(vHijo, "cantidad"));
                            callStatement.setString(3, ImportaXMLPIS.getAtributo(vHijo, "unidad"));
                            callStatement.setString(4, ImportaXMLPIS.getAtributo(vHijo, "NoIdentificacion"));
                            callStatement.setString(5, ImportaXMLPIS.getAtributo(vHijo, "descripcion"));
                            callStatement.setString(6, ImportaXMLPIS.getAtributo(vHijo, "valorUnitario"));
                            callStatement.setString(7, String.format("%.2f", Float.valueOf(Float.parseFloat(ImportaXMLPIS.getAtributo(vHijo, "importe").replaceAll(",", "")))));
                            callStatement.setString(8, ImportaXMLPIS.getAtributo(vHijo, "Impuesto"));
                            callStatement.setString(9, ImportaXMLPIS.getAtributo(vHijo, "TasaOCuota"));
                            callStatement.setString(10, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vImpuestos32, "totalImpuestosTrasladados"), "0"));
                            callStatement.setString(11, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vHijo, "ClaveProdServ"), " "));
                            callStatement.setString(12, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vComprobante, "formaPago"), " "));
                            String vDescuento = ImportaXMLPIS.getAtributo(vHijo, "descuento");
                            vDescuento = vDescuento == null ? "0" : vDescuento.replaceAll(",", "");
                            callStatement.setString(13, String.format("%.2f", Float.valueOf(Float.parseFloat(vDescuento))));
                            callStatement.setString(14, ImportaXMLPIS.getAtributo(vHijo, "Base"));
                            callStatement.setString(15, ImportaXMLPIS.getAtributo(vHijo, "TipoFactor"));
                            callStatement.setInt(16, pComprobante);
                            callStatement.execute();
                            callStatement.close();
                            callStatement = null;
                        }
                    }
                    ++i;
                }
                pbdUtil.connection.commit();
                if (callStatement != null) {
                    callStatement.close();
                    callStatement = null;
                }
            }
            catch (Exception e) {
                System.out.println("--- Error: No se pudo agregar concepto: " + e.toString());
            }
        } else {
            System.out.println("El documento no tiene CONCEPTO");
        }
    }

    public static void subirImpuesto(BDUtil pbdUtil, Node pNodo, int pComprobante, int pNumConcepto, int pNumImpuesto, String pTipoImpuesto) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarImpuestos(?,?,?,?,?,?,?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.setInt(2, pNumConcepto);
            callStatement.setInt(3, pNumImpuesto);
            callStatement.setString(4, pTipoImpuesto);
            callStatement.setString(5, ImportaXMLPIS.getAtributo(pNodo, "Base"));
            callStatement.setString(6, ImportaXMLPIS.getAtributo(pNodo, "Impuesto"));
            callStatement.setString(7, ImportaXMLPIS.getAtributo(pNodo, "TipoFactor"));
            callStatement.setString(8, ImportaXMLPIS.getAtributo(pNodo, "TasaOCuota"));
            callStatement.setString(9, ImportaXMLPIS.getAtributo(pNodo, "Importe"));
            callStatement.execute();
            pbdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
        }
        catch (Exception e) {
            System.out.println("Error: No se pudo agregar el impuesto al concepto. (SAT_CFDIMPUESTOS)" + e.toString());
        }
    }

    public static void subirImpuestos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        Statement callStatement = null;
        NodeList vNodoBase = pDocumentoXML.getElementsByTagName("cfdi:Impuestos");
        if (vNodoBase.getLength() > 0) {
            Node vImpuestos = vNodoBase.item(vNodoBase.getLength() - 1);
            if (vImpuestos != null) {
                NodeList vListaImpuestos = vImpuestos.getChildNodes();
                Node vTipoImpuesto = null;
                String vNombrePadre = "";
                String vNombreNieto = "";
                String vOpcion = "";
                int i = 0;
                while (i < vListaImpuestos.getLength()) {
                    if (vListaImpuestos.item(i).getNodeType() == 1) {
                        vNombrePadre = vListaImpuestos.item(i).getNodeName();
                        if (vNombrePadre.contains("cfdi:Traslados")) {
                            vNombreNieto = "cfdi:Traslado";
                            vOpcion = "T";
                        } else {
                            vNombreNieto = "cfdi:Retencion";
                            vOpcion = "R";
                        }
                        vTipoImpuesto = ImportaXMLPIS.getNodoNietoDe(vImpuestos, vNombrePadre, vNombreNieto);
                        String sentencia = "{ call bdPkgCfd.insertarImpuestosAgrupados(?,?,?,?,?,?,? )}";
                        try {
                            callStatement = pbdUtil.connection.prepareCall(sentencia);
                            callStatement.setInt(1, pComprobante);
                            callStatement.setString(2, vOpcion);
                            callStatement.setString(3, ImportaXMLPIS.getAtributo(vTipoImpuesto, "Impuesto"));
                            String vTipoFactor = ImportaXMLPIS.getAtributo(vTipoImpuesto, "TipoFactor");
                            if (vTipoFactor == null) {
                                vTipoFactor = " ";
                            }
                            callStatement.setString(4, vTipoFactor);
                            String vTasaOCuota = ImportaXMLPIS.getAtributo(vTipoImpuesto, "TasaOCuota");
                            if (vTasaOCuota == null) {
                                vTasaOCuota = " ";
                            }
                            callStatement.setString(5, vTasaOCuota);
                            callStatement.setString(6, ImportaXMLPIS.getAtributo(vTipoImpuesto, "Importe"));
                            callStatement.setString(7, ImportaXMLPIS.getAtributo(vTipoImpuesto, "Base"));
                            callStatement.execute();
                            callStatement.close();
                            callStatement = null;
                        }
                        catch (Exception e) {
                            System.out.println("--- Error: No se pudo agregar impuesto agrupado. (sat_cfdimpuestosagrupados) " + e.toString());
                        }
                    }
                    ++i;
                }
            } else {
                System.out.println("--- No contiene el nodo 'Impuestos'");
            }
            try {
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void subirPagos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        CallableStatement callStatement = null;
        Node vNodoBase = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        if (vNodoBase != null) {
            Node vComplemento = ImportaXMLPIS.getNodoHijoDe(vNodoBase, "cfdi:Complemento");
            Node vPagos = ImportaXMLPIS.getNodoHijoDe(vComplemento, "pago10:Pagos");
            Node vPago = ImportaXMLPIS.getNodoHijoDe(vPagos, "pago10:Pago");
            NodeList vListaPagos = vPago.getChildNodes();
            String sentencia = "{ call Insertar_CFDI_DoctoRelacionado(?,?,?,?,?,?)}";
            try {
                int i = 0;
                while (i < vListaPagos.getLength()) {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    callStatement.setInt(1, pComprobante);
                    callStatement.setString(2, "PIS");
                    callStatement.setString(3, "");
                    callStatement.setString(4, "");
                    callStatement.setString(5, "");
                    callStatement.setString(6, "");
                    callStatement.execute();
                    callStatement.close();
                    callStatement = null;
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("Error: No se pudo agregar el Pago" + e.toString());
            }
        } else {
            System.out.println("Error: Revise el nombre del nodo Origen. No existe.");
        }
    }

    public static void subirComplementoPago(BDUtil pbdUtil, Document pComprobante, int pNumComprobante) {
        block16: {
            Statement callStatement = null;
            System.out.println("INSERTANDO complemento pago");
            String sentencia = "{call bdPkgCfd.insertarComplementoPago(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
            try {
                try {
                    Node vComplemento = pComprobante.getElementsByTagName("cfdi:Complemento").item(0);
                    Element vEComplemento = (Element)vComplemento;
                    NodeList vListaPago10 = vEComplemento.getElementsByTagName("pago10:Pagos");
                    String vVersionPago = "";
                    int vLenPago10 = vListaPago10.getLength();
                    int vNumPago10 = 0;
                    Element vPago = null;
                    NodeList vListaPago = null;
                    int vLenPago = 0;
                    int i = 0;
                    while (i < vLenPago10) {
                        if (vListaPago10.item(i).getNodeType() == 1) {
                            ++vNumPago10;
                            vVersionPago = ImportaXMLPIS.getAtributo(vListaPago10.item(i), "Version");
                            vPago = (Element)vListaPago10.item(i);
                            vListaPago = vPago.getElementsByTagName("pago10:Pago");
                            vLenPago = vListaPago.getLength();
                            System.out.println("Numero de pagos: " + vLenPago);
                            int j = 0;
                            while (j < vLenPago) {
                                callStatement = pbdUtil.connection.prepareCall(sentencia);
                                if (vListaPago.item(j).getNodeType() == 1) {
                                    callStatement.setInt(1, pNumComprobante);
                                    callStatement.setInt(2, vNumPago10);
                                    callStatement.setString(3, String.valueOf(pNumComprobante));
                                    callStatement.setString(4, ImportaXMLPIS.getAtributo(vListaPago.item(j), "FechaPago"));
                                    callStatement.setString(5, ImportaXMLPIS.getAtributo(vListaPago.item(j), "FormaDePagoP"));
                                    callStatement.setString(6, ImportaXMLPIS.getAtributo(vListaPago.item(j), "MonedaP"));
                                    callStatement.setString(7, ImportaXMLPIS.getAtributo(vListaPago.item(j), "TipoCambioP"));
                                    callStatement.setString(8, ImportaXMLPIS.getAtributo(vListaPago.item(j), "Monto"));
                                    callStatement.setString(9, ImportaXMLPIS.getAtributo(vListaPago.item(j), "NumOperacion"));
                                    callStatement.setString(10, ImportaXMLPIS.getAtributo(vListaPago.item(j), "RFCEmisorCtaOrd"));
                                    callStatement.setString(11, ImportaXMLPIS.getAtributo(vListaPago.item(j), "NomBanCoordeXT"));
                                    callStatement.setString(12, ImportaXMLPIS.getAtributo(vListaPago.item(j), "CtaOrdenante"));
                                    callStatement.setString(13, ImportaXMLPIS.getAtributo(vListaPago.item(j), "RFCEMISORCTABEN"));
                                    callStatement.setString(14, ImportaXMLPIS.getAtributo(vListaPago.item(j), "CtaBeneficiario"));
                                    callStatement.setString(15, ImportaXMLPIS.getAtributo(vListaPago.item(j), "EMIS_RECEP"));
                                    callStatement.setString(16, ImportaXMLPIS.getAtributo(vListaPago.item(j), "BANCORECEPTOR"));
                                    callStatement.execute();
                                    pbdUtil.connection.commit();
                                    callStatement.close();
                                    callStatement = null;
                                    ImportaXMLPIS.subirDoctoRelacionado(pbdUtil, pNumComprobante, vNumPago10, vListaPago.item(j));
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("---Error: Al ejecutar al insertar en SAT_COMPLEMENTOPAGO. " + e.toString());
                    if (callStatement == null) break block16;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void subirDoctoRelacionado(BDUtil pbdUtil, int pNumComprobante, int pNumPago, Node pPago) {
        block14: {
            CallableStatement callStatement = null;
            String sentencia = "{call bdPkgCfd.insertarDoctoRelacionadoPago(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
            try {
                try {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    Element vDocto = (Element)pPago;
                    NodeList vListaDocto = vDocto.getElementsByTagName("pago10:DoctoRelacionado");
                    int vLenListaDocto = vListaDocto.getLength();
                    System.out.println("Total de DOCTO RELACIONADO " + vLenListaDocto);
                    int vNumDocto = 0;
                    int i = 0;
                    while (i < vLenListaDocto) {
                        System.out.println("Comprobante " + pNumComprobante + "Num De Pago " + pNumPago + " DoctoRelacionado " + i);
                        if (vListaDocto.item(i).getNodeType() == 1) {
                            callStatement.setInt(1, pNumComprobante);
                            callStatement.setInt(2, pNumPago);
                            callStatement.setInt(3, ++vNumDocto);
                            callStatement.setString(4, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "IdDocumento"));
                            callStatement.setString(5, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "Folio"));
                            callStatement.setString(6, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "MonedaDR"));
                            callStatement.setString(7, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "TIPOCAMBIODR"));
                            callStatement.setString(8, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "MetodoDePagoDR"));
                            callStatement.setString(9, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "NumParcialidad"));
                            callStatement.setString(10, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "ImpSaldoAnt"));
                            callStatement.setString(11, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "ImpPagado"));
                            callStatement.setString(12, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "ImpSaldoInsoluto"));
                            callStatement.setString(13, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "EMIS_RECEP"));
                            callStatement.setString(14, "1");
                            callStatement.setString(15, "API");
                            callStatement.setString(16, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "PAGONUMPROV"));
                            callStatement.setString(17, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "DETPAGNUM"));
                            callStatement.setString(18, ImportaXMLPIS.getAtributo(vListaDocto.item(i), "Serie"));
                            callStatement.execute();
                            pbdUtil.connection.commit();
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("---Error: No se pudo agregar a 'SAT_DOCTOSRELACIONADOSPAGOS.' " + e.toString());
                    if (callStatement == null) break block14;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void subirComprobantesRelac(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        NodeList vCfdiRelacionado = pDocumentoXML.getElementsByTagName("cfdi:CfdiRelacionados");
        int vLonCfdi = vCfdiRelacionado.getLength();
        int vLonUuid = 0;
        if (vLonCfdi > 0) {
            Statement callStatement = null;
            String sentencia = "{ call bdPkgCfd.insertarComprobantesRelac(?,?,?,?) }";
            try {
                int i = 0;
                while (i < vLonCfdi) {
                    if (vCfdiRelacionado.item(i).getNodeType() == 1) {
                        Element vAux = (Element)vCfdiRelacionado.item(i);
                        NodeList vUUID = vAux.getElementsByTagName("cfdi:CfdiRelacionado");
                        vLonUuid = vUUID.getLength();
                        int j = 0;
                        while (j < vLonUuid) {
                            if (vUUID.item(j).getNodeType() == 1) {
                                callStatement = pbdUtil.connection.prepareCall(sentencia);
                                callStatement.setInt(1, pComprobante);
                                callStatement.setString(2, null);
                                callStatement.setString(3, ImportaXMLPIS.getAtributo(vCfdiRelacionado.item(i), "TipoRelacion"));
                                callStatement.setString(4, ImportaXMLPIS.getAtributo(vUUID.item(j), "UUID"));
                                callStatement.execute();
                                pbdUtil.connection.commit();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("--- Error: No se pudieron subir los comprobantes relacionados. (subirComprobantesRelac): " + e);
            }
            if (callStatement != null) {
                try {
                    callStatement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                callStatement = null;
            }
        }
    }

    public static void registrarLog(BDUtil pbdUtil, int pComprobante, String pPathArchivo) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.INSERTAR_SAT_LOGCARGACFD(?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.setString(2, "PIS");
            callStatement.setString(3, pPathArchivo);
            callStatement.execute();
            try {
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudo agregar al LOG " + e.toString());
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getComplementoDeNomina(BDUtil pbdUtil, Node pComprobante, int pNumComprobante) {
        String paso = "";
        Node vComplemento = ImportaXMLPIS.getNodoHijoDe(pComprobante, "cfdi:Complemento");
        paso = "Complemento";
        Node vNomina = ImportaXMLPIS.getNodoSiEsNull(vComplemento, "nomina12:Nomina", "nomina:Nomina");
        paso = "Nomina";
        Node vEmisor = ImportaXMLPIS.getNodoSiEsNull(vNomina, "nomina12:Emisor", "nomina:Emisor");
        paso = "Emisor";
        Node vReceptor = ImportaXMLPIS.getNodoSiEsNull(vNomina, "nomina12:Receptor", "nomina:Receptor");
        paso = "Receptor";
        Node vPercepciones = ImportaXMLPIS.getNodoSiEsNull(vNomina, "nomina12:Percepciones", "nomina:Percepciones");
        paso = "Percepciones";
        Node vDeducciones = ImportaXMLPIS.getNodoSiEsNull(vNomina, "nomina12:Deducciones", "nomina:Deducciones");
        paso = "Deducciones";
        Node vOtrosPagos = ImportaXMLPIS.getNodoSiEsNull(vNomina, "nomina12:OtrosPagos", "nomina:OtrosPagos");
        paso = "OtrosPagos";
        Node vIndemnizacion = null;
        paso = "Indemnizacion";
        String vTotalGravadoPercepcion = "0.0";
        String vTotalExentoPercepcion = "0.0";
        String vTotalGravadoDeducion = "0.0";
        String vTotalExentoDeduccion = "0.0";
        String vTotalPercepciones = "0";
        String vtotalSueldos = "0";
        String vAnioServicio = null;
        String vUltimoSueldoMensOrd = null;
        String vIngresoAcumulable = null;
        String vIngresoNoAcumulable = null;
        String vPercepSinOtrosPagos = "0";
        String vPercepSubsidio = "0";
        String vImpuestosRetenidos = "0";
        String vDeducSinRetenidos = "0";
        String vTotalSeparIndemniza = null;
        String vTotalPagadoIndemnizacion = "0";
        Node aux = null;
        String vTotalPercepcion = "0";
        String vTotalDeduccion = "0";
        System.out.println("obteniendo valores del NODO PERCEPCIONES");
        if (vPercepciones != null) {
            vTotalGravadoPercepcion = ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vPercepciones, "TotalGravado"), "0.0");
            vTotalExentoPercepcion = ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vPercepciones, "TotalExento"), "0.0");
            vtotalSueldos = ImportaXMLPIS.getAtributo(vPercepciones, "TotalSueldos");
            vIndemnizacion = ImportaXMLPIS.getNodoHijoDe(vNomina, "nomina12:SeparacionIndemnizacion");
            vAnioServicio = ImportaXMLPIS.getAtributo(vIndemnizacion, "NumA\u00f1osServicio");
            vUltimoSueldoMensOrd = ImportaXMLPIS.getAtributo(vIndemnizacion, "UltimoSueldoMensOrd");
            vIngresoAcumulable = ImportaXMLPIS.getAtributo(vIndemnizacion, "IngresoAcumulable");
            vIngresoNoAcumulable = ImportaXMLPIS.getAtributo(vIndemnizacion, "IngresoNoAcumulable");
            vTotalPercepciones = ImportaXMLPIS.getAtributo(vIndemnizacion, "TotalGravado");
            vTotalPercepcion = vTotalGravadoPercepcion;
        }
        System.out.println("obteniendo valores del NODO DEDUCCIONES");
        if (vDeducciones != null) {
            vTotalGravadoDeducion = ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vDeducciones, "TotalGravado"), "0.0");
            vTotalExentoDeduccion = ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vDeducciones, "TotalExento"), "0.0");
            NodeList listaDeducciones = vDeducciones.getChildNodes();
            float vImpuestosRetenidosAux = 0.0f;
            float vDeducSinRetenidosAux = 0.0f;
            int i = 0;
            while (i < listaDeducciones.getLength()) {
                aux = listaDeducciones.item(i);
                if (aux.getNodeType() == 1) {
                    if (ImportaXMLPIS.getAtributo(aux, "TipoDeduccion").equals("002")) {
                        vImpuestosRetenidosAux += Float.parseFloat(ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributoSiEsNull(aux, "Importe", "ImporteExento"), "0"));
                    } else {
                        vDeducSinRetenidosAux += Float.parseFloat(ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributoSiEsNull(aux, "Importe", "ImporteExento"), "0"));
                    }
                }
                ++i;
            }
            vImpuestosRetenidos = String.format("%.2f", Float.valueOf(vImpuestosRetenidosAux));
            vDeducSinRetenidos = String.format("%.2f", Float.valueOf(vDeducSinRetenidosAux));
            vTotalDeduccion = String.format("%.2f", Float.valueOf(Float.parseFloat(vImpuestosRetenidos) + Float.parseFloat(vDeducSinRetenidos)));
            paso = "Boque deducciones";
        }
        System.out.println("obteniendo valores del NODO OTROSPAGOS");
        String vPerceptOtrosPagos = "0";
        float vPerceptOtrosPagosNum = 0.0f;
        String vSaldoAFavor = null;
        String vRemanenteAlFav = null;
        String vAnioSF = null;
        if (vOtrosPagos != null) {
            NodeList vListaOtrosPagos = vOtrosPagos.getChildNodes();
            int i = 0;
            while (i < vListaOtrosPagos.getLength()) {
                aux = vListaOtrosPagos.item(i);
                if (aux.getNodeType() == 1) {
                    System.out.println("Otros pagos: " + ImportaXMLPIS.getAtributo(aux, "Importe"));
                    vPerceptOtrosPagosNum += Float.parseFloat(ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(aux, "Importe"), "0"));
                    if (ImportaXMLPIS.getAtributo(aux, "Clave").equals("009")) {
                        Node vCompensacionSaldosAFavor = ImportaXMLPIS.getNodoHijoDe(aux, "nomina12:CompensacionSaldosAFavor");
                        vSaldoAFavor = ImportaXMLPIS.getAtributo(vCompensacionSaldosAFavor, "SaldoAFavor");
                        vRemanenteAlFav = ImportaXMLPIS.getAtributo(vCompensacionSaldosAFavor, "RemanenteSalFav");
                        vAnioSF = ImportaXMLPIS.getAtributo(vCompensacionSaldosAFavor, "A\u00f1o");
                    }
                }
                ++i;
            }
            vPerceptOtrosPagos = String.format("%.2f", Float.valueOf(vPerceptOtrosPagosNum));
            paso = "Bloque otrosPagos";
        }
        String vRegistroPatronal = "";
        vRegistroPatronal = vEmisor != null ? ImportaXMLPIS.getAtributo(vEmisor, "RegistroPatronal") : ImportaXMLPIS.getAtributo(vNomina, "RegistroPatronal");
        String vNumEmpleado = "";
        String vCurp = "";
        String vTipoRegimen = "";
        String vNumSeguridadSocial = "";
        String vAntiguedad = "";
        String vDepartamento = "";
        String vPeriodicidadPago = "";
        String vTipoJornada = "";
        String vRiesgoPuesto = "";
        String vPuesto = "";
        String vTipoContrato = "";
        String vSalarioBaseCotApor = "";
        String vSalarioDiarioIntegrado = "";
        String vFechaInicioRelLaboral = "";
        if (vReceptor != null) {
            vNumEmpleado = ImportaXMLPIS.getAtributo(vReceptor, "NumEmpleado");
            vCurp = ImportaXMLPIS.getAtributo(vReceptor, "Curp");
            vTipoRegimen = ImportaXMLPIS.getAtributo(vReceptor, "TipoRegimen");
            vNumSeguridadSocial = ImportaXMLPIS.getAtributo(vReceptor, "NumSeguridadSocial");
            vAntiguedad = ImportaXMLPIS.getAtributo(vReceptor, "Antig\u00fcedad");
            vDepartamento = ImportaXMLPIS.getAtributo(vReceptor, "Departamento");
            vPeriodicidadPago = ImportaXMLPIS.getAtributo(vReceptor, "PeriodicidadPago");
            vTipoJornada = ImportaXMLPIS.getAtributo(vReceptor, "TipoJornada");
            vRiesgoPuesto = ImportaXMLPIS.getAtributo(vReceptor, "RiesgoPuesto");
            vPuesto = ImportaXMLPIS.getAtributo(vReceptor, "Puesto");
            vTipoContrato = ImportaXMLPIS.getAtributo(vReceptor, "TipoContrato");
            vSalarioBaseCotApor = ImportaXMLPIS.getAtributo(vReceptor, "SalarioBaseCotApor");
            vSalarioDiarioIntegrado = ImportaXMLPIS.getAtributo(vReceptor, "SalarioDiarioIntegrado");
            vFechaInicioRelLaboral = ImportaXMLPIS.getAtributo(vReceptor, "FechaInicioRelLaboral");
        } else {
            vNumEmpleado = ImportaXMLPIS.getAtributo(vNomina, "NumEmpleado");
            vCurp = ImportaXMLPIS.getAtributo(vNomina, "CURP");
            vTipoRegimen = ImportaXMLPIS.getAtributo(vNomina, "TipoRegimen");
            vNumSeguridadSocial = ImportaXMLPIS.getAtributo(vNomina, "NumSeguridadSocial");
            vAntiguedad = ImportaXMLPIS.getAtributo(vNomina, "Antiguedad");
            vDepartamento = ImportaXMLPIS.getAtributo(vNomina, "Departamento");
            vPeriodicidadPago = ImportaXMLPIS.getAtributo(vNomina, "PeriodicidadPago");
            vTipoJornada = ImportaXMLPIS.getAtributo(vNomina, "TipoJornada");
            vRiesgoPuesto = ImportaXMLPIS.getAtributo(vNomina, "RiesgoPuesto");
            vPuesto = ImportaXMLPIS.getAtributo(vNomina, "Puesto");
            vTipoContrato = ImportaXMLPIS.getAtributo(vNomina, "TipoContrato");
            vSalarioBaseCotApor = ImportaXMLPIS.getAtributo(vNomina, "SalarioBaseCotApor");
            vSalarioDiarioIntegrado = ImportaXMLPIS.getAtributo(vNomina, "SalarioDiarioIntegrado");
            vFechaInicioRelLaboral = ImportaXMLPIS.getAtributo(vNomina, "FechaInicioRelLaboral");
        }
        System.out.println("Comenzanco a subir en COMPLEMENTO NOMINA");
        CallableStatement callStatement = null;
        String sentencia = "{ call SAT_INSERTA_sat_complementonomina(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pNumComprobante);
            paso = "1";
            callStatement.setString(2, ImportaXMLPIS.getAtributo(pComprobante, "Folio"));
            paso = "2";
            callStatement.setString(3, "3");
            paso = "3";
            callStatement.setString(4, ImportaXMLPIS.getAtributo(vNomina, "Version"));
            paso = "5";
            callStatement.setString(5, vRegistroPatronal);
            paso = "6";
            callStatement.setString(6, vNumEmpleado);
            paso = "7";
            callStatement.setString(7, vCurp);
            paso = "8";
            callStatement.setString(8, vTipoRegimen);
            paso = "9";
            callStatement.setString(9, vNumSeguridadSocial);
            paso = "10";
            callStatement.setString(10, ImportaXMLPIS.getAtributo(vNomina, "FechaPago"));
            paso = "11";
            callStatement.setString(11, ImportaXMLPIS.getAtributo(vNomina, "FechaInicialPago"));
            paso = "12";
            callStatement.setString(12, ImportaXMLPIS.getAtributo(vNomina, "FechaFinalPago"));
            paso = "13";
            callStatement.setString(13, ImportaXMLPIS.getAtributo(vNomina, "NumDiasPagados"));
            paso = "14";
            callStatement.setString(14, vDepartamento);
            paso = "15";
            callStatement.setString(15, ImportaXMLPIS.getAtributo(vReceptor, "CuentaBancaria"));
            paso = "16";
            callStatement.setString(16, ImportaXMLPIS.getAtributo(vReceptor, "Banco"));
            paso = "17";
            callStatement.setString(17, vFechaInicioRelLaboral);
            paso = "18";
            callStatement.setString(18, vAntiguedad);
            paso = "19";
            callStatement.setString(19, vPuesto);
            paso = "20";
            callStatement.setString(20, vTipoContrato);
            paso = "21";
            callStatement.setString(21, vTipoJornada);
            paso = "22";
            callStatement.setString(22, vPeriodicidadPago);
            paso = "23";
            callStatement.setString(23, vSalarioBaseCotApor);
            paso = "24";
            callStatement.setString(24, vRiesgoPuesto);
            paso = "25";
            callStatement.setString(25, vSalarioDiarioIntegrado);
            paso = "26";
            callStatement.setString(26, vTotalGravadoPercepcion);
            paso = "27";
            callStatement.setString(27, vTotalExentoPercepcion);
            paso = "28";
            callStatement.setString(28, vTotalGravadoDeducion);
            paso = "29";
            callStatement.setString(29, vTotalExentoDeduccion);
            paso = "30";
            callStatement.setString(30, ImportaXMLPIS.getAtributo(vReceptor, "Infonavita"));
            paso = "31";
            callStatement.setString(31, ImportaXMLPIS.getAtributo(vReceptor, "Gravablea"));
            paso = "32";
            callStatement.setString(32, ImportaXMLPIS.getAtributo(vReceptor, "ISPT"));
            paso = "33";
            callStatement.setString(33, ImportaXMLPIS.getAtributo(vReceptor, "ISRTAB"));
            paso = "34";
            callStatement.setString(34, ImportaXMLPIS.getAtributo(vReceptor, "CSTAB"));
            paso = "35";
            callStatement.setString(35, ImportaXMLPIS.getAtributo(vReceptor, "SUBTAB"));
            paso = "36";
            callStatement.setString(36, ImportaXMLPIS.getAtributo(vReceptor, "SalarioDiario"));
            paso = "37";
            callStatement.setString(37, ImportaXMLPIS.getAtributo(vNomina, "TipoNomina"));
            paso = "38";
            callStatement.setString(38, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vReceptor, "ClaveEntFed"), "SIN"));
            paso = "39";
            callStatement.setString(39, vPercepSinOtrosPagos);
            paso = "40";
            callStatement.setString(40, vPercepSubsidio);
            paso = "41";
            callStatement.setString(41, vImpuestosRetenidos);
            paso = "42";
            callStatement.setString(42, vDeducSinRetenidos);
            paso = "43";
            callStatement.setString(43, vTotalSeparIndemniza);
            paso = "44";
            callStatement.setString(44, vTotalPagadoIndemnizacion);
            paso = "45";
            callStatement.setString(45, vAnioServicio);
            paso = "46";
            callStatement.setString(46, vUltimoSueldoMensOrd);
            paso = "47";
            callStatement.setString(47, vIngresoAcumulable);
            paso = "48";
            callStatement.setString(48, vIngresoNoAcumulable);
            paso = "49";
            callStatement.setString(49, "0");
            paso = "50";
            callStatement.setString(50, vPerceptOtrosPagos);
            paso = "51";
            callStatement.setString(51, null);
            paso = "52";
            callStatement.setString(52, ImportaXMLPIS.getAtributo(vReceptor, "Sindicalizado"));
            paso = "53";
            callStatement.setString(53, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vNomina, "TotalPercepciones"), vTotalPercepcion));
            paso = "54";
            callStatement.setString(54, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(vNomina, "TotalDeducciones"), vTotalDeduccion));
            paso = "55";
            callStatement.setString(55, ImportaXMLPIS.getAtributo(vEmisor, "Rfc"));
            paso = "56";
            callStatement.setString(56, vtotalSueldos);
            paso = "57";
            callStatement.setString(57, vSaldoAFavor);
            paso = "58";
            callStatement.setString(58, vAnioSF);
            paso = "59";
            callStatement.setString(59, vRemanenteAlFav);
            paso = "fin";
            callStatement.execute();
            paso = "execute";
            try {
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImportaXMLPIS.insertaSAT_PERCEPCIONES_DEDUCCIONES(pbdUtil, vPercepciones, pNumComprobante);
            ImportaXMLPIS.insertaSAT_PERCEPCIONES_DEDUCCIONES(pbdUtil, vDeducciones, pNumComprobante);
            ImportaXMLPIS.insertaSAT_PERCEPCIONES_DEDUCCIONES(pbdUtil, vOtrosPagos, pNumComprobante);
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudo insertar en ComplementoDeNomina. Paso: " + paso + " ERROR:" + e.toString());
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void insertaSAT_PERCEPCIONES_DEDUCCIONES(BDUtil pbdUtil, Node pPercepcionDeduccionOtroPago, int pNumComprobante) {
        if (pPercepcionDeduccionOtroPago != null) {
            String vPercep_deduc = null;
            String vOtrosPagos = null;
            String vNombreNodoHijo = null;
            String vAtributoImporte = null;
            String vAtributoTipo = null;
            String vNombreNodo = pPercepcionDeduccionOtroPago.getNodeName().toUpperCase();
            System.out.println("Nombre nodo percepcion Deduccion OtrosPagos: " + vNombreNodo);
            if (vNombreNodo.contains("PERCEPCION")) {
                vPercep_deduc = "P";
                vOtrosPagos = "0";
                vNombreNodoHijo = "PERCEPCION";
                vAtributoImporte = "ImporteGravado";
                vAtributoTipo = "TipoPercepcion";
            } else if (vNombreNodo.contains("DEDUCCION")) {
                vPercep_deduc = "D";
                vNombreNodoHijo = "DEDUCCION";
                vAtributoImporte = "Importe";
                vAtributoTipo = "TipoDeduccion";
            } else if (vNombreNodo.contains("OTROSPAGOS")) {
                vPercep_deduc = "P";
                vOtrosPagos = "1";
                vNombreNodoHijo = "OTROPAGO";
                vAtributoImporte = "Importe";
                vAtributoTipo = "TipoOtroPago";
            }
            NodeList vListaNodosHijos = pPercepcionDeduccionOtroPago.getChildNodes();
            Statement callStatement = null;
            String sentencia = "{ call SAT_INSERTA_PERCEPCION_DEDUCCION(?,?,?,?,?,?,?,?,?)}";
            try {
                Node nodoAux = null;
                int i = 0;
                while (i < vListaNodosHijos.getLength()) {
                    nodoAux = vListaNodosHijos.item(i);
                    if (nodoAux.getNodeType() == 1 && nodoAux.getNodeName().toUpperCase().contains(vNombreNodoHijo)) {
                        callStatement = pbdUtil.connection.prepareCall(sentencia);
                        callStatement.setInt(1, pNumComprobante);
                        callStatement.setString(2, vPercep_deduc);
                        callStatement.setString(3, ImportaXMLPIS.getAtributo(nodoAux, vAtributoTipo));
                        callStatement.setString(4, ImportaXMLPIS.getAtributo(nodoAux, "Clave"));
                        callStatement.setString(5, ImportaXMLPIS.getAtributo(nodoAux, "Concepto"));
                        callStatement.setString(6, ImportaXMLPIS.getAtributoSiEsNull(nodoAux, vAtributoImporte, "ImporteGravado"));
                        callStatement.setString(7, ImportaXMLPIS.nvl(ImportaXMLPIS.getAtributo(nodoAux, "ImporteExento"), "0"));
                        callStatement.setString(8, "0");
                        callStatement.setString(9, vOtrosPagos);
                        callStatement.execute();
                        try {
                            pbdUtil.connection.commit();
                            callStatement.close();
                            callStatement = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("--- Error: No se pudo insertar en SAT_PERCEPCIONES_DEDUCCIONES" + e.toString());
            }
            if (callStatement != null) {
                try {
                    callStatement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                callStatement = null;
            }
        }
    }

    public static void actualizaComprobante(BDUtil pbdUtil, int pNumComprobante, Document pDocumentoXML, String pSubtipoDoc) {
        Node vComprobante = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        Node vEmisor = ImportaXMLPIS.getNodoHijoDe(vComprobante, "cfdi:Emisor");
        Node vReceptor = ImportaXMLPIS.getNodoHijoDe(vComprobante, "cfdi:Receptor");
        Node vDomicilioEmisor = ImportaXMLPIS.getNodoHijoDe(vEmisor, "cfdi:DomicilioFiscal");
        Node vDomicilioReceptor = ImportaXMLPIS.getNodoHijoDe(vReceptor, "cfdi:Domicilio");
        Node vRegimenFiscalEmisor = ImportaXMLPIS.getNodoHijoDe(vEmisor, "cfdi:RegimenFiscal");
        String vSentencia = "";
        vSentencia = "UPDATE sat_comprobantes SET \tmetodoDePago = '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vComprobante, "metodoDePago"), "") + "', " + "\t\tformaDePago =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vComprobante, "formaDePago"), "") + "', " + "\t\tcalleEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "calle"), "") + "', " + "\t\tcoloniaEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "colonia"), " ") + "', " + "\t\testadoEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "estado"), "") + "', " + "\t\tpaisEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "pais"), "") + "', " + "\t\tcodigoPostalEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "codigoPostal"), "") + "', " + "\t\tlocalidadEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "localidad"), "") + "', " + "\t\tnoExteriorEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "noExterior"), "") + "', " + "\t\tmunicipioEmisor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioEmisor, "municipio"), "") + "', " + "\t\tregimen\t\t\t =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vRegimenFiscalEmisor, "Regimen"), "") + "', " + "\t\tcalleReceptor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioReceptor, "calle"), "") + "', " + "\t\tcoloniaReceptor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioReceptor, "colonia"), "") + "', " + "\t\testadoReceptor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioReceptor, "estado"), "") + "', " + "\t\tpaisReceptor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioReceptor, "pais"), "") + "', " + "\t\tcodigoPostalReceptor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioReceptor, "codigoPostal"), "") + "', " + "\t\tlocalidadReceptor =  '" + Utilerias.nvl(ImportaXMLPIS.getAtributo(vDomicilioReceptor, "localidad"), "") + "' " + "WHERE \tcomprobante = '" + pNumComprobante + "' ";
        try {
            pbdUtil.ejecutaSentencia(vSentencia);
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("Error: No se pudo actualizar el comprobante " + pNumComprobante + "\n" + " Raz\u00f3n: " + e.toString());
        }
    }

    public static String nvl(String pValor, String pValorSiEsNull) {
        if (pValor == null) {
            return pValorSiEsNull;
        }
        return pValor;
    }

    public static Node getNodoSiEsNull(Node pNodoOrigen, String pNodoPrimario, String pNodoSecundario) {
        Node vNodo = ImportaXMLPIS.getNodoHijoDe(pNodoOrigen, pNodoPrimario);
        if (vNodo == null) {
            vNodo = ImportaXMLPIS.getNodoHijoDe(pNodoOrigen, pNodoSecundario);
        }
        return vNodo;
    }

    public static String getAtributoSiEsNull(Node pNodoOrigen, String pAtributoPrimario, String pAtributoSecundario) {
        String vValor = ImportaXMLPIS.getAtributo(pNodoOrigen, pAtributoPrimario);
        if (vValor == null) {
            vValor = ImportaXMLPIS.getAtributo(pNodoOrigen, pAtributoSecundario);
        }
        return vValor;
    }

    public static Node getNodoHijoSiExiste(Node pNodoOrigen, String pNodoHijo) {
        Node vNodo = pNodoOrigen;
        Node vAux = ImportaXMLPIS.getNodoHijoDe(pNodoOrigen, pNodoHijo);
        if (vAux != null) {
            vNodo = vAux;
        }
        return vNodo;
    }

    public static String decodeDescConcepto(String pDescConcepto) {
        String vValor = null;
        String cAPROVECHAMIENTO = "APROVECHAMIENTO";
        String cPASAJEROS = "PASAJEROS";
        String cCONCESIONES = "CONCESIONES";
        String cPUERTO = "PUERTO";
        String cATRAQUE = "ATRAQUE";
        String cMUELLAJE = "MUELLAJE";
        String cALMACENAJE = "ALMACENAJE";
        String cREMOLQUE = "REMOLQUE";
        String cANTICIPO = "ANTICIPO";
        if (pDescConcepto != null) {
            if (pDescConcepto.startsWith(cAPROVECHAMIENTO)) {
                vValor = "apr";
            } else if (pDescConcepto.startsWith(cPASAJEROS)) {
                vValor = "pas";
            } else if (pDescConcepto.startsWith(cCONCESIONES)) {
                vValor = "ces";
            } else if (pDescConcepto.startsWith(cPUERTO)) {
                vValor = "pto";
            } else if (pDescConcepto.startsWith(cATRAQUE)) {
                vValor = "atr";
            } else if (pDescConcepto.startsWith(cMUELLAJE)) {
                vValor = "mue";
            } else if (pDescConcepto.startsWith(cALMACENAJE)) {
                vValor = "alm";
            } else if (pDescConcepto.startsWith(cREMOLQUE)) {
                vValor = "rem";
            } else if (pDescConcepto.startsWith(cANTICIPO)) {
                vValor = "ant";
            }
        }
        System.out.println("Es de subtipo:" + vValor);
        return vValor;
    }

    public static String getDescConcepto(Node pComprobante) {
        Node vConcepto;
        String vValor = null;
        Node vConceptos = ImportaXMLPIS.getNodoHijoDe(pComprobante, "cfdi:Conceptos");
        if (vConceptos != null && (vConcepto = ImportaXMLPIS.getNodoHijoDe(vConceptos, "cfdi:Concepto")) != null) {
            System.out.println("CONSEGUIREMOS EL SUBTIPODOC");
            vValor = ImportaXMLPIS.getAtributo(vConcepto, "Descripcion").toUpperCase();
            vValor = ImportaXMLPIS.decodeDescConcepto(vValor);
        }
        return vValor;
    }
}

