/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.complementos;

import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import siti.sinco.cfdi.dto.CfdImpuestosDTO;
import siti.sinco.cfdi.dto.ComplementoPagoDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.DoctoRelacionadoPagoDTO;
import siti.sinco.cfdi.tools.Conversiones;

public class ComplementoPagoXML {
    private ArrayList<ComplementoPagoDTO> complPagos;
    private Namespace cfdi;
    private Namespace ns_pago;

    public ComplementoPagoXML(ArrayList<ComplementoPagoDTO> complPagos, Namespace cfdi, Namespace ns_pago) {
        this.complPagos = complPagos;
        this.cfdi = cfdi;
        this.ns_pago = ns_pago;
    }

    public Element creaComplementoPago(ComprobanteDTO comprobante) {
        Element complemento = new Element("Complemento", this.cfdi);
        Element nodo_Totales = new Element("Totales", this.ns_pago);
        Element nodo_pago = new Element("Pagos", this.ns_pago);
        Element nodo_ImpuestosP = new Element("ImpuestosP", this.ns_pago);
        Element nodo_RetencionesP = new Element("RetencionesP", this.ns_pago);
        Element nodo_RetencionP = new Element("RetencionP", this.ns_pago);
        Element nodo_TrasladosP = new Element("TrasladosP", this.ns_pago);
        Element nodo_TrasladoP = new Element("TrasladoP", this.ns_pago);
        ArrayList<DoctoRelacionadoPagoDTO> lstDoctoRelacPago = null;
        ComplementoPagoDTO pagoDto = new ComplementoPagoDTO();
        double vMontoTotalPagos = 0.0;
        String vImpuestoR = "";
        double vImporteR = 0.0;
        double vBaseT = 0.0;
        String vImpuestoT = "";
        String vTipoFactorT = "";
        String vTasaCuotaT = "";
        double vImporteT = 0.0;
        if (comprobante.getVersion().equals("4.0")) {
            nodo_pago.addContent((Content)nodo_Totales);
        }
        int i = 0;
        while (i < this.complPagos.size()) {
            pagoDto = this.complPagos.get(i);
            lstDoctoRelacPago = pagoDto.getLstDoctoRelacPago();
            nodo_pago.setAttribute("Version", pagoDto.getVersionPago());
            Element pago = new Element("Pago", this.ns_pago);
            pago.setAttribute("FechaPago", pagoDto.getFechaPago());
            pago.setAttribute("FormaDePagoP", pagoDto.getFormaDePagoP());
            pago.setAttribute("MonedaP", pagoDto.getMonedaP());
            if (pagoDto.getTipoCambioP() != null) {
                pago.setAttribute("TipoCambioP", pagoDto.getTipoCambioP());
            }
            pago.setAttribute("Monto", Conversiones.quitarFormatoImporte(pagoDto.getMonto()));
            vMontoTotalPagos += Double.parseDouble(pagoDto.getMonto());
            if (pagoDto.getNumOperacion() != null) {
                pago.setAttribute("NumOperacion", pagoDto.getNumOperacion());
            }
            if (pagoDto.getRfcEmisorCtaOrd() != null) {
                pago.setAttribute("RfcEmisorCtaOrd", pagoDto.getRfcEmisorCtaOrd());
            }
            if (pagoDto.getNomBancoOrdExt() != null) {
                pago.setAttribute("NomBancoOrdExt", pagoDto.getNomBancoOrdExt());
            }
            if (pagoDto.getCtaOrdenante() != null) {
                pago.setAttribute("CtaOrdenante", pagoDto.getCtaOrdenante());
            }
            if (pagoDto.getRfcEmisorCtaBen() != null) {
                pago.setAttribute("RfcEmisorCtaBen", pagoDto.getRfcEmisorCtaBen());
            }
            if (pagoDto.getCtaBeneficiario() != null) {
                pago.setAttribute("CtaBeneficiario", pagoDto.getCtaBeneficiario());
            }
            Iterator<DoctoRelacionadoPagoDTO> iteraDocRelac = null;
            iteraDocRelac = lstDoctoRelacPago.iterator();
            while (iteraDocRelac.hasNext()) {
                DoctoRelacionadoPagoDTO doctoRelacPago = new DoctoRelacionadoPagoDTO();
                Element elemDoctoRelacPago = new Element("DoctoRelacionado", this.ns_pago);
                doctoRelacPago = iteraDocRelac.next();
                elemDoctoRelacPago.setAttribute("IdDocumento", doctoRelacPago.getIdDocumento());
                if (doctoRelacPago.getSerie() != null) {
                    elemDoctoRelacPago.setAttribute("Serie", doctoRelacPago.getSerie());
                }
                elemDoctoRelacPago.setAttribute("Folio", doctoRelacPago.getFolio());
                elemDoctoRelacPago.setAttribute("MonedaDR", doctoRelacPago.getMonedaDR());
                if (doctoRelacPago.getTipoCambioDR() != null) {
                    if (comprobante.getVersion().equals("4.0") && pagoDto.getVersionPago().equals("2.0")) {
                        elemDoctoRelacPago.setAttribute("EquivalenciaDR", doctoRelacPago.getTipoCambioDR());
                    } else {
                        elemDoctoRelacPago.setAttribute("TipoCambioDR", doctoRelacPago.getTipoCambioDR());
                    }
                }
                if (doctoRelacPago.getMetodoDePagoDR() != null && !comprobante.getVersion().equals("4.0") && !pagoDto.getVersionPago().equals("2.0")) {
                    elemDoctoRelacPago.setAttribute("MetodoDePagoDR", doctoRelacPago.getMetodoDePagoDR());
                }
                if (doctoRelacPago.getNumParcialidad() != null) {
                    elemDoctoRelacPago.setAttribute("NumParcialidad", doctoRelacPago.getNumParcialidad());
                }
                if (doctoRelacPago.getImpSaldoAnt() != null) {
                    elemDoctoRelacPago.setAttribute("ImpSaldoAnt", Conversiones.quitarFormatoImporte(doctoRelacPago.getImpSaldoAnt()));
                }
                if (doctoRelacPago.getImpPagado() != null) {
                    elemDoctoRelacPago.setAttribute("ImpPagado", Conversiones.quitarFormatoImporte(doctoRelacPago.getImpPagado()));
                }
                if (doctoRelacPago.getImpSaldoInsoluto() != null) {
                    elemDoctoRelacPago.setAttribute("ImpSaldoInsoluto", doctoRelacPago.getImpSaldoInsoluto());
                }
                if (comprobante.getVersion().equals("4.0") && pagoDto.getVersionPago().equals("2.0")) {
                    elemDoctoRelacPago.setAttribute("ObjetoImpDR", doctoRelacPago.getObjetoImpDR());
                }
                if (comprobante.getVersion().equals("4.0") && pagoDto.getVersionPago().equals("2.0")) {
                    nodo_Totales.setAttribute("MontoTotalPagos", pagoDto.getTotales().getMontoTotalPagos());
                }
                if (comprobante.getVersion().equals("4.0") && pagoDto.getVersionPago().equals("2.0") && doctoRelacPago.getObjetoImpDR().equals("02")) {
                    ArrayList<CfdImpuestosDTO> impuestosTrasladados = doctoRelacPago.getListaImpuestosTrasladados();
                    ArrayList<CfdImpuestosDTO> impuestosRetenidos = doctoRelacPago.getListaImpuestosRetenidos();
                    if (impuestosTrasladados != null || impuestosRetenidos != null) {
                        Element ImpuestosDR = new Element("ImpuestosDR", this.ns_pago);
                        if (impuestosTrasladados.size() > 0) {
                            Element TrasladosDR = new Element("TrasladosDR", this.ns_pago);
                            Element TrasladoDR = new Element("TrasladoDR", this.ns_pago);
                            ImpuestosDR.addContent((Content)TrasladosDR);
                            System.out.println("ImpuestosTrasladados");
                            for (CfdImpuestosDTO impuesto : impuestosTrasladados) {
                                TrasladoDR.setAttribute("BaseDR", impuesto.getBase());
                                TrasladoDR.setAttribute("ImpuestoDR", impuesto.getImpuesto());
                                TrasladoDR.setAttribute("TipoFactorDR", impuesto.getTipoFactor());
                                TrasladoDR.setAttribute("TasaOCuotaDR", impuesto.getTasaCuota());
                                TrasladoDR.setAttribute("ImporteDR", impuesto.getImporte());
                                vBaseT += Double.parseDouble(impuesto.getBase());
                                vImporteT += Double.parseDouble(impuesto.getImporte());
                                vImpuestoT = impuesto.getImpuesto();
                                vTipoFactorT = impuesto.getTipoFactor();
                                vTasaCuotaT = impuesto.getTasaCuota();
                            }
                            TrasladosDR.addContent((Content)TrasladoDR);
                        }
                        if (impuestosRetenidos.size() > 0) {
                            Element RetenidosDR = new Element("RetenidosDR", this.ns_pago);
                            Element RetenidoDR = new Element("RetenidoDR", this.ns_pago);
                            ImpuestosDR.addContent((Content)RetenidosDR);
                            System.out.println("ImpuestosRetenidos");
                            for (CfdImpuestosDTO impuesto : impuestosRetenidos) {
                                RetenidoDR.setAttribute("BaseDR", impuesto.getBase());
                                RetenidoDR.setAttribute("ImpuestoDR", impuesto.getImpuesto());
                                RetenidoDR.setAttribute("TipoFactorDR", impuesto.getTipoFactor());
                                RetenidoDR.setAttribute("TasaOCuotaDR", impuesto.getTasaCuota());
                                RetenidoDR.setAttribute("ImporteDR", impuesto.getImporte());
                                vImpuestoR = impuesto.getImpuesto();
                                vImporteR += Double.parseDouble(impuesto.getImporte());
                            }
                            RetenidosDR.addContent((Content)RetenidoDR);
                        }
                        elemDoctoRelacPago.addContent((Content)ImpuestosDR);
                        if (impuestosTrasladados != null) {
                            nodo_TrasladoP.setAttribute("BaseP", String.format("%.2f", vBaseT));
                            nodo_TrasladoP.setAttribute("ImpuestoP", vImpuestoT);
                            nodo_TrasladoP.setAttribute("TipoFactorP", vTipoFactorT);
                            nodo_TrasladoP.setAttribute("TasaOCuotaP", vTasaCuotaT);
                            nodo_TrasladoP.setAttribute("ImporteP", String.valueOf(vImporteT));
                        }
                        if (impuestosRetenidos != null) {
                            nodo_RetencionP.setAttribute("ImpuestoP", vImpuestoR);
                            nodo_RetencionP.setAttribute("ImporteP", String.valueOf(vImporteR));
                        }
                    }
                }
                pago.addContent((Content)elemDoctoRelacPago);
            }
            nodo_pago.addContent((Content)pago);
            ++i;
        }
        complemento.addContent((Content)nodo_pago);
        return complemento;
    }
}

