/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import siti.sinco.cfdi.dto.ComplementoNominaDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.HorasExtraDTO;
import siti.sinco.cfdi.dto.IncapacidadDTO;
import siti.sinco.cfdi.dto.Percepcion_DeduccionDTO;

public class NominaDAO {
    private ComprobanteDTO comprobante;

    public NominaDAO(ComprobanteDTO comprobante) {
        this.comprobante = comprobante;
    }

    public ComplementoNominaDTO leerComplementoNomina(Connection conexion, String where) throws Exception {
        String query = "SELECT comprobante, nominanum, frecnum, \t\tversionnom, registropatronal, numempleado, \t\tcurp, tiporegimen, numseguridadsocial, \t\tfechapago, fechainicialpago, fechafinalpago, \t\tnumdiaspagados, departamento, clabe, \t\tbanco, fechainiciorellaboral, antiguedad, \t\tpuesto, tipocontrato, tipojornada, \t\tperiodicidadpago, salariobasecotapor, riesgopuesto, \t\tsalariodiariointegrado, totalgravadopercepcion, totalexentopercepcion, \t\tto_char(to_number(totalsueldos, '999999.00')) totalsueldos,  \t\ttotalgravadodeduccion, totalexentodeduccion, infonavita, \t\tgravablea, ispt, isrtab, \t\tcstab, subtab, salariodiario, \t\ttipoNomina, claveEntFed, percepSinOtrosPagos, \t\tpercepSubsidio, impuestosRetenidos, deducSinRetenidos, \t\tnvl(totalSeparIndemniza, '0') totalSeparIndemniza, totalPagadoIndemnizacion, to_char(numAniosServicio) numAniosServicio, \t\tultimoSueldoMensualOrd, ingresoAcumulable, ingresoNoAcumulable, \t\tsubtabQ, percepOtrosPagos, sindicalizado, RFCPatronOrigen, TotalPercepciones, TotalDeducciones, \t \tsaldoAFavor, aniosf, remanenteSALFAV FROM   sat_complementonomina " + where;
        System.out.println("SELECT de leerComplementoNomina: " + query);
        PreparedStatement prpdStatement = conexion.prepareStatement(query);
        ResultSet rs = prpdStatement.executeQuery();
        ComplementoNominaDTO dto = null;
        try {
            try {
                while (rs.next()) {
                    dto = new ComplementoNominaDTO();
                    dto.setComprobante(rs.getInt("comprobante"));
                    dto.setNominaNum(rs.getInt("nominanum"));
                    dto.setFrecNum(rs.getString("frecnum"));
                    dto.setVersionNom(rs.getString("versionnom"));
                    dto.setRegistroPatronal(rs.getString("registropatronal"));
                    dto.setNumEmpleado(rs.getString("numempleado"));
                    dto.setCurp(rs.getString("curp"));
                    dto.setTipoRegimen(rs.getString("tiporegimen"));
                    dto.setNumSeguridadSocial(rs.getString("numseguridadsocial"));
                    dto.setFechaPago(rs.getString("fechapago"));
                    dto.setFechaInicialPago(rs.getString("fechainicialpago"));
                    dto.setFechaFinalPago(rs.getString("fechafinalpago"));
                    dto.setNumDiasPagados(rs.getString("numdiaspagados"));
                    dto.setDepartamento(rs.getString("departamento"));
                    dto.setClabe(rs.getString("clabe"));
                    dto.setBanco(rs.getString("banco"));
                    dto.setFechaInicioRelLaboral(rs.getString("fechainiciorellaboral"));
                    dto.setAntiguedad(rs.getString("antiguedad"));
                    dto.setPuesto(rs.getString("puesto"));
                    dto.setTipoContrato(rs.getString("tipocontrato"));
                    dto.setTipoJornada(rs.getString("tipojornada"));
                    dto.setPeriodicidadPago(rs.getString("periodicidadpago"));
                    dto.setSalarioBaseCotaPor(rs.getString("salariobasecotapor"));
                    dto.setRiesgoPuesto(rs.getInt("riesgopuesto"));
                    dto.setSalarioDiarioIntegrado(rs.getString("salariodiariointegrado"));
                    dto.setTotalGravadoPercepcion(rs.getString("totalgravadopercepcion"));
                    dto.setTotalExentoPercepcion(rs.getString("totalexentopercepcion"));
                    dto.setTotalGravadoDeduccion(rs.getString("totalgravadodeduccion"));
                    dto.setTotalExentoDeduccion(rs.getString("totalexentodeduccion"));
                    dto.setTotalSueldos(rs.getString("totalsueldos"));
                    dto.setInfonavita(rs.getString("infonavita"));
                    dto.setGravable(rs.getString("gravablea"));
                    dto.setIspt(rs.getString("ispt"));
                    dto.setIsrTab(rs.getString("isrtab"));
                    dto.setCsTab(rs.getString("cstab"));
                    dto.setSubTab(rs.getString("subtab"));
                    dto.setSalarioDiario(rs.getString("salariodiario"));
                    dto.setTipoNomina(rs.getString("tipoNomina"));
                    dto.setClaveEntFed(rs.getString("claveEntFed"));
                    dto.setPercepcionSinOtrosPagos(rs.getString("percepSinOtrosPagos"));
                    dto.setPercepcionSubsidio(rs.getString("percepSubsidio"));
                    dto.setImpuestosRetenidos(rs.getString("impuestosRetenidos"));
                    dto.setDeducSinRetenidos(rs.getString("deducSinRetenidos"));
                    dto.setTotalSeparIndemniza(rs.getString("totalSeparIndemniza"));
                    dto.setTotalPagadoIndemnizacion(rs.getString("totalPagadoIndemnizacion"));
                    dto.setNumAniosServicio(rs.getString("numAniosServicio"));
                    dto.setUltimoSueldoMensualOrd(rs.getString("ultimoSueldoMensualOrd"));
                    dto.setIngresoAcumulable(rs.getString("ingresoAcumulable"));
                    dto.setIngresoNoAcumulable(rs.getString("ingresoNoAcumulable"));
                    dto.setSubTabQ(rs.getString("subtabq"));
                    dto.setPercepcionOtrosPagos(rs.getString("percepOtrosPagos"));
                    dto.setSindicalizado(rs.getString("sindicalizado"));
                    dto.setRFCPatronOrigen(rs.getString("RFCPatronOrigen"));
                    dto.setTotalPercepciones(rs.getString("TotalPercepciones"));
                    dto.setTotalDeducciones(rs.getString("TotalDeducciones"));
                    dto.setSaldoAFavor(rs.getString("saldoAFavor"));
                    dto.setAnioSF(rs.getString("aniosf"));
                    dto.setRemanenteSALFAV(rs.getString("remanenteSALFAV"));
                    this.comprobante.agregaComplementoNom(dto);
                }
                rs.close();
                rs = null;
            }
            catch (SQLException sqlEx) {
                throw new Exception(String.valueOf(this.getClass().getCanonicalName()) + ": Error en leerComplementoNomina. " + sqlEx);
            }
        }
        finally {
            if (prpdStatement != null) {
                prpdStatement.close();
            }
        }
        return dto;
    }

    public ArrayList<HorasExtraDTO> leerHorasExtra(Connection conexion, String where) throws Exception {
        String query = "SELECT comprobante, partida, dias, \t\ttipohoras, horasextra, importepagado FROM   sat_horasextra " + where;
        PreparedStatement prpdStatement = conexion.prepareStatement(query);
        ResultSet rs = prpdStatement.executeQuery();
        ArrayList<HorasExtraDTO> lista_dto = new ArrayList<HorasExtraDTO>();
        try {
            while (rs.next()) {
                HorasExtraDTO dto = new HorasExtraDTO();
                dto.setComprobante(rs.getInt("comprobante"));
                dto.setPartida(rs.getInt("partida"));
                dto.setDias(rs.getInt("dias"));
                dto.setTipohoras(rs.getString("tipohoras"));
                dto.setHorasextra(rs.getInt("horasextra"));
                dto.setImportepagado(rs.getDouble("importepagado"));
                lista_dto.add(dto);
            }
            rs.close();
            rs = null;
            ArrayList<HorasExtraDTO> arrayList = lista_dto;
            return arrayList;
        }
        catch (SQLException sqlEx) {
            throw new Exception(String.valueOf(this.getClass().getCanonicalName()) + ": Error en leerHorasExtra. " + sqlEx);
        }
        finally {
            if (prpdStatement != null) {
                prpdStatement.close();
            }
        }
    }

    public ArrayList<IncapacidadDTO> leerIncapacidad(Connection conexion, String where) throws Exception {
        String query = "SELECT comprobante, partida, diasincapacidad,        lpad(tipoincapacidad, 2, '0') tipoincapacidad, descuento FROM\tsat_incapacidades " + where;
        PreparedStatement prpdStatement = conexion.prepareStatement(query);
        ResultSet rs = prpdStatement.executeQuery();
        ArrayList<IncapacidadDTO> lista_dto = new ArrayList<IncapacidadDTO>();
        try {
            while (rs.next()) {
                IncapacidadDTO dto = new IncapacidadDTO();
                dto.setComprobante(rs.getInt("comprobante"));
                dto.setPartida(rs.getInt("partida"));
                dto.setDiasincapacidad(rs.getInt("diasincapacidad"));
                dto.setTipoincapacidad(rs.getString("tipoincapacidad"));
                dto.setDescuento(rs.getDouble("descuento"));
                lista_dto.add(dto);
            }
            rs.close();
            rs = null;
            ArrayList<IncapacidadDTO> arrayList = lista_dto;
            return arrayList;
        }
        catch (SQLException sqlEx) {
            throw new Exception(String.valueOf(this.getClass().getCanonicalName()) + ": Error en leerIncapacidad. " + sqlEx);
        }
        finally {
            if (prpdStatement != null) {
                prpdStatement.close();
            }
        }
    }

    public ArrayList<Percepcion_DeduccionDTO> leerPercepcionDeduccion(Connection conexion, String where, String etiqueta) throws Exception {
        String query = "SELECT pd.comprobante, pd.percep_deduc, pd.tipo,        pd.clave, pd.concepto, ltrim(to_char(pd.importegravado, '99999999990.00')) importegravado,        ltrim(to_char(pd.importeexento, '999999999990.00')) importeexento,         ltrim(to_char(nvl(pd.importegravado,0) + nvl(pd.importeexento,0), '999999999990.00')) importeGravExen,        pd.unidades, pd.otrospagos FROM   sat_percepciones_deducciones pd " + where + " order by (nvl(pd.importegravado,0)+nvl(pd.importeexento,0)) DESC ";
        System.out.println("SELECT de " + etiqueta + ": " + query);
        PreparedStatement prpdStatement = conexion.prepareStatement(query);
        ResultSet rs = prpdStatement.executeQuery();
        ArrayList<Percepcion_DeduccionDTO> lista_dto = new ArrayList<Percepcion_DeduccionDTO>();
        try {
            while (rs.next()) {
                Percepcion_DeduccionDTO dto = new Percepcion_DeduccionDTO();
                dto.setComprobante(rs.getInt("comprobante"));
                dto.setPercep_deduc(rs.getString("percep_deduc"));
                dto.setTipo(rs.getString("tipo"));
                dto.setClave(rs.getString("clave"));
                dto.setConcepto(rs.getString("concepto"));
                dto.setImporteGravado(rs.getString("importegravado"));
                dto.setImporteExento(rs.getString("importeexento"));
                dto.setImporteGravExen(rs.getString("importeGravExen"));
                dto.setUnidades(rs.getInt("unidades"));
                dto.setOtrosPagos(rs.getString("otrospagos"));
                lista_dto.add(dto);
            }
            rs.close();
            rs = null;
            ArrayList<Percepcion_DeduccionDTO> arrayList = lista_dto;
            return arrayList;
        }
        catch (SQLException sqlEx) {
            throw new Exception(String.valueOf(this.getClass().getCanonicalName()) + ": Error en leerPercepcionDeduccion. " + sqlEx);
        }
        finally {
            if (prpdStatement != null) {
                prpdStatement.close();
            }
        }
    }
}

