/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.lowagie.text.ExceptionConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.CFDenXML;
import siti.sinco.cfdi.dto.CfdConceptosDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.pdf.CeldasPDF;
import siti.sinco.cfdi.tools.CodigoQR;
import siti.sinco.cfdi.tools.Conversiones;
import siti.sinco.cfdi.tools.Utilerias;

public class CFDenPDFSitiNC
extends PdfPageEventHelper {
    protected PdfTemplate total;
    protected BaseFont helv;
    private ComprobanteDTO comprobante;
    private ConfiguracionDTO configuracion;
    private final int ACTIVA = 1;
    private final int CANCELADA = 0;
    private String nombrePDF;
    private String ruta;
    private String nombreCompleto;
    private String leyenda = "Este documento es una representaci\u00f3n impresa de un CFDI";

    public CFDenPDFSitiNC(ComprobanteDTO objComprobante, ConfiguracionDTO objConfiguracion) {
        this.comprobante = objComprobante;
        this.configuracion = objConfiguracion;
    }

    public CFDenPDFSitiNC() {
    }

    public String generarPDF(String modo, String sobreEscribe) throws IOException, DocumentException {
        System.out.println("NC");
        Locale.setDefault(new Locale("es", "MX"));
        Document document = new Document(PageSize.POSTCARD, 6.0f, 6.0f, 6.0f, 6.0f);
        this.nombrePDF = this.comprobante.getVersion().equals("3.2") ? String.valueOf(this.comprobante.getFolioDoc()) + "_" + this.comprobante.getRfcReceptor() + "_" + this.comprobante.getFecha().toString().substring(0, 10).replace("-", "") : String.valueOf(this.comprobante.getComprobante()) + "_" + this.comprobante.getRfcReceptor() + "_" + this.comprobante.getFecha().toString().substring(0, 10).replace("-", "");
        this.ruta = String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaPdf(this.comprobante.getTipoDoc());
        File rutaPDF = new File(this.ruta);
        String ruta_archivo = "";
        ruta_archivo = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".pdf";
        File fichero = new File(ruta_archivo);
        System.out.println("ruta: " + ruta_archivo);
        if (!rutaPDF.exists()) {
            System.out.println("Se ha creado la ruta: " + this.ruta);
            rutaPDF.mkdirs();
        }
        if (fichero.exists()) {
            if (sobreEscribe.equals("SI")) {
                System.out.println("El archivo se va a sobreescribir.");
                FileUtils.forceDelete((File)fichero);
            }
        } else {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(ruta_archivo));
            writer.setPageEvent((PdfPageEvent)new CFDenPDFSitiNC());
            Rectangle rct = new Rectangle(36.0f, 54.0f, 559.0f, 788.0f);
            writer.setBoxSize("art", rct);
            Paragraph lineaVacia = new Paragraph(" ", new Font(Font.FontFamily.TIMES_ROMAN, 2.0f));
            if (modo.equals("TEST")) {
                this.leyenda = String.valueOf(this.leyenda) + "\n ESTE DOCUMENTO NO TIENE VALIDEZ FISCAL PUES ES UNA PRUEBA";
            }
            Paragraph leyendaDigital = new Paragraph("** " + this.leyenda + " **", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
            leyendaDigital.setAlignment(1);
            document.open();
            document.add((Element)this.tablaLogo());
            document.add((Element)this.tablaEmisor());
            document.add((Element)this.tablaReceptor());
            document.add((Element)lineaVacia);
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaEncabezado());
            document.add((Element)this.tablaDetalle());
            document.add((Element)this.tablaTotales());
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaRegimen());
            if (this.comprobante.getLeyendaPago() != null) {
                document.add((Element)this.tablaLeyendapago());
            }
            document.add((Element)lineaVacia);
            document.add((Element)this.tablaDatosDigitales());
            document.add((Element)leyendaDigital);
            document.close();
            File rutaImagenQR = new File(this.nombreCompleto);
            if (rutaImagenQR.exists()) {
                FileUtils.forceDelete((File)rutaImagenQR);
            }
        }
        System.out.println("------------------\nRUTA ARCHIVO" + ruta_archivo + "\n----------------------------");
        return ruta_archivo;
    }

    public PdfPTable tablaLogo() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaLogo = new PdfPTable(5);
        tablaLogo.setWidthPercentage(100.0f);
        tablaLogo.getDefaultCell().setBorder(0);
        PdfPTable tablaDerecha = new PdfPTable(2);
        tablaDerecha.setWidthPercentage(60.0f);
        tablaDerecha.getDefaultCell().setBorder(0);
        Image imagen = null;
        imagen = Image.getInstance((String)(String.valueOf(LeeConexion.path) + "/recursos/" + this.comprobante.getEmpNum() + "/logo.jpg"));
        imagen.scalePercent(30.0f);
        imagen.setAlignment(0);
        PdfPCell celda = new PdfPCell(imagen);
        celda.setColspan(2);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaLogo.addCell(celda);
        System.out.println("NOTA DE CREDITO");
        CeldasPDF.celdaTabla(tablaLogo, "NOTA DE CREDITO", 1, 0, 0.0f, CeldasPDF.fontHeaderTipo, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "Documento", 2, 0, 2.0f, CeldasPDF.fontHeaderSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, String.valueOf(this.comprobante.getTipoDoc()) + " - " + this.comprobante.getFolioDoc(), 2, 1, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "Folio Fiscal", 2, 0, 2.0f, CeldasPDF.fontHeaderSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getUUID(), 2, 1, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorder(0);
        celda.setColspan(2);
        tablaLogo.addCell(celda);
        return tablaLogo;
    }

    public PdfPTable tablaEmisor() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaEmisor = new PdfPTable(5);
        tablaEmisor.setWidthPercentage(100.0f);
        Paragraph parrafNombreEmisor = new Paragraph(this.comprobante.getNombreEmisor(), CeldasPDF.fontTitBold);
        parrafNombreEmisor.add("\nR.F.C. " + this.comprobante.getRfcEmisor() + CFDenPDFSitiNC.espacios(22));
        parrafNombreEmisor.setAlignment(0);
        String noExt = "";
        String noInt = "";
        String colonia = "";
        String telefono = "";
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorEmisor(), "");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorEmisor(), "");
        colonia = Utilerias.nvl(this.comprobante.getColoniaEmisor(), "");
        if (this.comprobante.getTelefono() != null) {
            telefono = "Tels: " + this.comprobante.getTelefono();
        }
        Paragraph parrafDomicEmisor = new Paragraph(String.valueOf(this.comprobante.getCalleEmisor()) + " " + noExt + " " + noInt + " " + colonia, CeldasPDF.fontTit);
        parrafDomicEmisor.add("\nC.P. " + this.comprobante.getCodigoPostalEmisor() + " " + this.comprobante.getMunicipioEmisor() + ", " + this.comprobante.getEstadoEmisor() + ".");
        parrafDomicEmisor.add("\n" + telefono);
        parrafDomicEmisor.setAlignment(0);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)parrafNombreEmisor);
        celda.addElement((Element)parrafDomicEmisor);
        celda.setColspan(3);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tablaEmisor.addCell(celda);
        PdfPTable tablaDerecha = new PdfPTable(1);
        tablaDerecha.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaDerecha, "", 1, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "N\u00famero de Certificado del Emisor", 2, 0, 2.0f, CeldasPDF.fontHeaderSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, this.configuracion.getNoCertificado(), 2, 1, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "", 1, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "No de Serie del Certificado del SAT", 1, 0, 2.0f, CeldasPDF.fontHeaderSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getNoCertificadoSAT(), 2, 1, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "", 1, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorder(0);
        celda.setColspan(2);
        tablaEmisor.addCell(celda);
        return tablaEmisor;
    }

    public PdfPTable tablaReceptor() {
        PdfPTable tablaReceptor = new PdfPTable(5);
        tablaReceptor.setWidthPercentage(100.0f);
        PdfPTable tablaVacia = new PdfPTable(2);
        tablaVacia.setWidthPercentage(60.0f);
        PdfPTable tablaDerecha = new PdfPTable(2);
        tablaDerecha.setWidthPercentage(60.0f);
        String nombre = "";
        String calle = "";
        String noExt = "";
        String noInt = "";
        String colonia = "";
        String cp = "";
        String municipio = "";
        String estado = "";
        nombre = Utilerias.nvl(this.comprobante.getNombreReceptor(), "");
        calle = Utilerias.nvl(this.comprobante.getCalleReceptor(), "");
        noExt = Utilerias.nvl(this.comprobante.getNoExteriorReceptor(), "");
        noInt = Utilerias.nvl(this.comprobante.getNoInteriorReceptor(), "");
        if (this.comprobante.getColoniaReceptor() != null) {
            colonia = String.valueOf(this.comprobante.getColoniaReceptor()) + ", ";
        }
        if (this.comprobante.getCodigoPostalReceptor() != null) {
            cp = "C.P. " + this.comprobante.getCodigoPostalReceptor();
        }
        municipio = Utilerias.nvl(this.comprobante.getMunicipioReceptor(), "");
        if (this.comprobante.getEstadoReceptor() != null) {
            estado = ", " + this.comprobante.getEstadoReceptor();
        }
        Paragraph p2 = new Paragraph(nombre, CeldasPDF.fontTit);
        p2.add("\n" + calle + " " + noExt + " " + noInt);
        p2.add("\n" + colonia + cp);
        p2.add("\n" + municipio + estado);
        p2.setAlignment(0);
        Paragraph p3 = new Paragraph("R.F.C. " + this.comprobante.getRfcReceptor(), CeldasPDF.fontTitBold);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)p2);
        celda.addElement((Element)p3);
        celda.setColspan(2);
        celda.setHorizontalAlignment(0);
        tablaReceptor.addCell(celda);
        CeldasPDF.celdaTabla(tablaVacia, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaVacia);
        celda.setBorder(0);
        celda.setColspan(1);
        tablaReceptor.addCell(celda);
        String hrs = this.comprobante.getFecha().toString().substring(11, 19);
        String str = this.comprobante.getFecha().toString().substring(0, 10);
        String a\u00f1o = str.substring(0, 4);
        String mes = str.substring(5, 7);
        String dia = str.substring(8, 10);
        String fechaFinal = String.valueOf(dia) + " / " + mes + " / " + a\u00f1o + "   - " + hrs;
        CeldasPDF.celdaTabla(tablaDerecha, "Lugar, fecha y hora de emisi\u00f3n", 2, 0, 2.0f, CeldasPDF.fontHeaderSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, String.valueOf(this.comprobante.getEstadoEmisor()) + ", " + this.comprobante.getMunicipioEmisor() + ". " + fechaFinal, 2, 1, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaDerecha, "Fecha y hora de certificaci\u00f3n", 2, 0, 2.0f, CeldasPDF.fontHeaderSmall, 1);
        CeldasPDF.celdaTabla(tablaDerecha, this.comprobante.getFechaTimbrado(), 2, 1, 0.0f, CeldasPDF.fontTitBold, 1);
        celda = new PdfPCell(tablaDerecha);
        celda.setBorder(0);
        celda.setColspan(2);
        tablaReceptor.addCell(celda);
        return tablaReceptor;
    }

    public PdfPTable tablaDatosPedidos() {
        PdfPTable tablaPedidos = new PdfPTable(52);
        String pedidoNum = " ";
        String condicionPago = " ";
        pedidoNum = Utilerias.nvl(this.comprobante.getPedNumSITI(), "");
        condicionPago = Utilerias.nvl(this.comprobante.getCondicionesDePago2(), "");
        Paragraph p1 = new Paragraph("PEDIDO No.", CeldasPDF.fontTitBold);
        p1.setAlignment(1);
        Paragraph p01 = new Paragraph(pedidoNum, CeldasPDF.fontTit);
        p01.setAlignment(1);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)p1);
        celda.addElement((Element)p01);
        celda.setColspan(17);
        celda.setPaddingTop(0.0f);
        celda.setPaddingBottom(3.0f);
        celda.setHorizontalAlignment(1);
        tablaPedidos.addCell(celda);
        tablaPedidos.setWidthPercentage(100.0f);
        Paragraph p2 = new Paragraph("CONDICIONES DE PAGO", CeldasPDF.fontTitBold);
        p2.setAlignment(1);
        Paragraph p02 = new Paragraph(condicionPago, CeldasPDF.fontTit);
        p02.setAlignment(1);
        celda = new PdfPCell();
        celda.addElement((Element)p2);
        celda.addElement((Element)p02);
        celda.setColspan(18);
        celda.setPaddingTop(0.0f);
        celda.setPaddingBottom(3.0f);
        celda.setHorizontalAlignment(1);
        tablaPedidos.addCell(celda);
        Paragraph p3 = new Paragraph("VENDEDOR", CeldasPDF.fontTitBold);
        p3.setAlignment(1);
        Paragraph p03 = new Paragraph("", CeldasPDF.fontTit);
        p03.setAlignment(1);
        celda = new PdfPCell();
        celda.addElement((Element)p3);
        celda.addElement((Element)p03);
        celda.setColspan(17);
        celda.setPaddingTop(0.0f);
        celda.setPaddingBottom(3.0f);
        celda.setHorizontalAlignment(1);
        tablaPedidos.addCell(celda);
        return tablaPedidos;
    }

    public PdfPTable tablaEncabezado() {
        PdfPTable tablaEncabezado = new PdfPTable(12);
        tablaEncabezado.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaEncabezado, "CANT.", 1, 1, 1.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "UNIDAD", 2, 1, 1.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "DESCRIPCION", 5, 1, 1.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "PRECIO UNIT", 2, 1, 1.0f, CeldasPDF.fontHeader, 1);
        CeldasPDF.celdaTabla(tablaEncabezado, "IMPORTE", 2, 1, 1.0f, CeldasPDF.fontHeader, 1);
        return tablaEncabezado;
    }

    public PdfPTable tablaDetalle() {
        CfdConceptosDTO concepto = null;
        PdfPTable tablaDetalle = new PdfPTable(12);
        tablaDetalle.setWidthPercentage(100.0f);
        PdfPTable tablaDetalleLeyenda = new PdfPTable(12);
        tablaDetalleLeyenda.setWidthPercentage(100.0f);
        PdfPTable tablaDetalleMaster = new PdfPTable(1);
        tablaDetalleMaster.setWidthPercentage(100.0f);
        String unidad = "";
        System.out.println("---------------------------\n CONCEPTOS:" + this.comprobante.conceptos.size() + "\n---------------------------");
        int renglon = 0;
        while (renglon < this.comprobante.conceptos.size()) {
            concepto = this.comprobante.conceptos.elementAt(renglon);
            unidad = concepto.getUnidad() != null ? concepto.getUnidad().toString() : " ";
            CeldasPDF.celdaTabla(tablaDetalle, concepto.getCantidad().toString(), 1, 0, 0.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tablaDetalle, unidad, 2, 0, 0.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tablaDetalle, concepto.getDescripcion(), 5, 0, 0.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tablaDetalle, concepto.getValorUnitario().toString(), 2, 0, 0.0f, CeldasPDF.fontDatos, 0);
            CeldasPDF.celdaTabla(tablaDetalle, concepto.getImporte().toString(), 2, 0, 0.0f, CeldasPDF.fontDatos, 0);
            ++renglon;
        }
        tablaDetalleMaster.addCell(tablaDetalle);
        return tablaDetalleMaster;
    }

    public PdfPTable tablaTotales() {
        CFDenXML cant = new CFDenXML(null, null, 1, null);
        PdfPTable tablaMaster = new PdfPTable(2);
        tablaMaster.setWidthPercentage(34.0f);
        tablaMaster.setHorizontalAlignment(1);
        PdfPTable tablaTotalesL = new PdfPTable(6);
        tablaTotalesL.setWidthPercentage(100.0f);
        tablaTotalesL.setHorizontalAlignment(1);
        PdfPTable tablaTotalesLB = new PdfPTable(1);
        tablaTotalesLB.setWidthPercentage(60.0f);
        tablaTotalesLB.setHorizontalAlignment(1);
        PdfPTable tablaTotales = new PdfPTable(1);
        tablaTotales.setWidthPercentage(34.0f);
        tablaTotales.setHorizontalAlignment(2);
        PdfPTable tablaTotales2 = new PdfPTable(1);
        tablaTotales2.setWidthPercentage(34.0f);
        tablaTotales2.setHorizontalAlignment(2);
        if (this.comprobante.getDescuento() == null || Conversiones.quitarFormatoImporte(this.comprobante.getDescuento()).equals("00.00")) {
            CeldasPDF.celdaTabla(tablaTotales, "SUB-TOTAL:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getSubtotal(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales, "16% I.V.A:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getTotalImpuestosTrasladados(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales, "TOTAL:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getTotal(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
        } else {
            CeldasPDF.celdaTabla(tablaTotales, "SUB-TOTAL:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getSubtotal(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales, "DESCUENTO:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getDescuento(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales, "16% I.V.A:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getTotalImpuestosTrasladados(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales, "TOTAL:", 1, 0, 0.0f, CeldasPDF.fontTitTotales, 2);
            CeldasPDF.celdaTabla(tablaTotales2, this.comprobante.getTotal(), 1, 0, 0.0f, CeldasPDF.fontTotales, 2);
        }
        CeldasPDF.celdaTabla(tablaTotalesLB, "", 4, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaTotalesLB, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        PdfPCell celda = null;
        String condicionesPago = "";
        if (this.comprobante.getFormaDePago() != null) {
            condicionesPago = this.comprobante.getFormaDePago();
        }
        Paragraph parrafo = new Paragraph(condicionesPago, FontFactory.getFont((String)"arial", (float)5.0f, (int)1, (BaseColor)BaseColor.BLACK));
        parrafo.setAlignment(1);
        Paragraph parrafo2 = new Paragraph(String.valueOf(this.comprobante.getTotalEnLetra()) + "\n", CeldasPDF.fontTitTotales);
        parrafo2.setAlignment(1);
        celda = new PdfPCell();
        celda.addElement((Element)parrafo2);
        celda.setColspan(4);
        celda.setHorizontalAlignment(1);
        tablaTotalesLB.addCell(celda);
        CeldasPDF.celdaTabla(tablaTotalesLB, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        CeldasPDF.celdaTabla(tablaTotalesLB, "", 2, 0, 0.0f, CeldasPDF.fontTitBold, 1);
        PdfPCell celdaS = new PdfPCell(tablaTotalesLB);
        celdaS.setBorder(0);
        celdaS.setHorizontalAlignment(1);
        celdaS.setColspan(4);
        tablaTotalesL.addCell(celdaS);
        celdaS = new PdfPCell(tablaTotales);
        celdaS.setBorder(0);
        celdaS.setColspan(1);
        tablaTotalesL.addCell(celdaS);
        celdaS = new PdfPCell(tablaTotales2);
        celdaS.setColspan(1);
        tablaTotalesL.addCell(celdaS);
        return tablaTotalesL;
    }

    public PdfPTable tablaLeyendasMotivo() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(52);
        tabla.setWidthPercentage(100.0f);
        String conceptoCredito = "";
        Paragraph p1 = new Paragraph("", new Font(Font.FontFamily.TIMES_ROMAN, 4.0f, 1));
        p1.add("CONCEPTO DEL CREDITO: XXXXXX");
        p1.add("\n ");
        p1.setAlignment(0);
        PdfPCell celda1 = new PdfPCell();
        celda1.setColspan(52);
        celda1.addElement((Element)p1);
        celda1.setHorizontalAlignment(0);
        tabla.addCell(celda1);
        return tabla;
    }

    public PdfPTable tablaProveedor() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tablaProveedor = new PdfPTable(1);
        tablaProveedor.setWidthPercentage(100.0f);
        CeldasPDF.celdaTabla(tablaProveedor, "Proveedor: 6001012329", 1, 0, 0.0f, CeldasPDF.fontTitHeader, 1);
        CeldasPDF.celdaTabla(tablaProveedor, "", 1, 0, 0.0f, CeldasPDF.fontTitHeader, 1);
        return tablaProveedor;
    }

    public PdfPTable tablaLeyendapago() throws BadElementException, MalformedURLException, IOException {
        PdfPTable miTabla = new PdfPTable(1);
        miTabla.setWidthPercentage(100.0f);
        Paragraph p1 = new Paragraph(this.comprobante.getLeyendaPago(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f, 1));
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)p1);
        celda.setColspan(1);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        miTabla.addCell(celda);
        return miTabla;
    }

    public PdfPTable tablaRegimen() throws BadElementException, MalformedURLException, IOException {
        PdfPTable miTabla = new PdfPTable(1);
        miTabla.setWidthPercentage(100.0f);
        Paragraph p1 = new Paragraph(this.comprobante.getRegimen(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f, 1));
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)p1);
        celda.setColspan(1);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        miTabla.addCell(celda);
        return miTabla;
    }

    public PdfPTable tablaDatosDigitales() throws BadElementException, MalformedURLException, IOException {
        PdfPTable tabla = new PdfPTable(28);
        tabla.setWidthPercentage(100.0f);
        this.nombreCompleto = String.valueOf(this.ruta) + File.separator + this.nombrePDF + ".png";
        String datosQR = "?re=" + this.comprobante.getRfcEmisor() + "&rr=" + this.comprobante.getRfcReceptor() + "&tt=" + this.comprobante.getTotal() + "&id=" + this.comprobante.getUUID();
        CodigoQR qr = new CodigoQR();
        qr.creaImagen(datosQR, this.nombreCompleto);
        Image imagen = null;
        imagen = Image.getInstance((String)this.nombreCompleto);
        imagen.setAlignment(0);
        PdfPCell celda = new PdfPCell();
        celda.addElement((Element)imagen);
        celda.setColspan(7);
        celda.setBorder(0);
        celda.setHorizontalAlignment(1);
        tabla.addCell(celda);
        celda = new PdfPCell();
        celda.setColspan(21);
        Paragraph p = null;
        p = new Paragraph("Sello Digital del CFDI:", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
        p.setAlignment(0);
        celda.addElement((Element)p);
        p = new Paragraph(this.comprobante.getSello(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
        p.setAlignment(0);
        celda.addElement((Element)p);
        p = new Paragraph("Sello del SAT:", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
        p.setAlignment(0);
        celda.addElement((Element)p);
        p = new Paragraph(this.comprobante.getSelloSAT(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
        p.setAlignment(0);
        celda.addElement((Element)p);
        p = new Paragraph("Cadena Original del complemento de certificacion digital del SAT:", new Font(Font.FontFamily.TIMES_ROMAN, 5.0f, 1));
        p.setAlignment(0);
        celda.addElement((Element)p);
        p = new Paragraph(this.comprobante.getCadenaOriginalSAT(), new Font(Font.FontFamily.TIMES_ROMAN, 3.0f));
        p.setAlignment(0);
        p.setHyphenation(null);
        p.setKeepTogether(true);
        celda.addElement((Element)p);
        celda.setBorder(0);
        celda.setHorizontalAlignment(0);
        tabla.addCell(celda);
        return tabla;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.total.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        try {
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(((Object)((Object)this)).getClass().getName(), "onOpenDocument", e.toString(), "ERROR JAVA");
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        String text = "Pag. " + writer.getPageNumber() + " de ";
        float textBase = document.bottom() - 4.0f;
        float textSize = this.helv.getWidthPoint(text, 4.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 4.0f);
        float adjust = this.helv.getWidthPoint("0", 4.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.right() - adjust, textBase);
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.helv, 4.0f);
        this.total.setTextMatrix(0.0f, 0.0f);
        this.total.showText(String.valueOf(writer.getPageNumber() - 1));
        this.total.endText();
    }

    public static String espacios(int numEspacios) {
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < numEspacios) {
            str.append(" ");
            ++i;
        }
        return str.toString();
    }
}

