/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.ssl.PKCS8Key;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.CFDenXML;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ComprobantesDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.LogcfdDAO;
import siti.sinco.cfdi.dao.ParametroCFDConnectDAO;
import siti.sinco.cfdi.dto.CFDICanceladosDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.tools.ArchivoXml;
import siti.sinco.cfdi.tools.Archivos;
import siti.sinco.cfdi.tools.CfdiCliente;
import siti.sinco.cfdi.tools.CfdiExceptionPac;
import siti.sinco.cfdi.tools.CfdiExceptionSiti;
import siti.sinco.cfdi.tools.EnvioCorreo;
import siti.sinco.cfdi.tools.NodoComplemento;

public class CFDUtil {
    private int empNum;
    private ConfiguracionDTO configuracion;
    private ComprobanteDTO comprobante;
    private ComprobantesDAO comprobantesDAO;
    private ConfiguracionDAO configDAO;

    public CFDUtil(BDUtil bdUtil, ComprobanteDTO comprobante, ConfiguracionDTO configuracion, int empNum) {
        this.empNum = empNum;
        this.configuracion = configuracion;
        this.configDAO = new ConfiguracionDAO();
        this.comprobantesDAO = new ComprobantesDAO(this.configuracion.getRutaSalidaTimbre());
        this.comprobante = comprobante;
    }

    public String getSelloDigital(String nombreArchivoKey, String password, int longitud, ComprobanteDTO comprobante) throws GeneralSecurityException {
        String cadenaOriginal = comprobante.getCadenaOriginal();
        String sello = "";
        Signature firma = null;
        FileInputStream archivoClavePrivada = null;
        byte[] clavePrivada = null;
        System.out.println("1TRY");
        try {
            archivoClavePrivada = new FileInputStream(nombreArchivoKey);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "getSelloDigital", e.toString(), "ERROR JAVA");
        }
        System.out.println("DESPUESTRY");
        clavePrivada = CFDUtil.getBytes(archivoClavePrivada, longitud);
        char[] cPassword = password.toCharArray();
        PKCS8Key pkcs8 = new PKCS8Key(clavePrivada, cPassword);
        PrivateKey pk = pkcs8.getPrivateKey();
        if (!comprobante.getTipoDoc().equals("DV")) {
            firma = Signature.getInstance("SHA256withRSA");
        } else if (comprobante.getTipoDoc().equals("DV")) {
            firma = Signature.getInstance("SHA1withRSA");
        }
        firma.initSign(pk);
        try {
            System.out.println("cadena original que se sella: " + cadenaOriginal);
            firma.update(cadenaOriginal.getBytes("UTF-8"));
            sello = Base64.encodeBase64String((byte[])firma.sign()).toString();
        }
        catch (UnsupportedEncodingException e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "getSelloDigital", e.toString(), "ERROR JAVA");
        }
        catch (SignatureException e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "getSelloDigital", e.toString(), "ERROR JAVA");
        }
        return sello;
    }

    public String getCertificado(FileInputStream archivoClavePrivada, int longitud) throws GeneralSecurityException {
        byte[] archivoCER = CFDUtil.getBytes(archivoClavePrivada, longitud);
        String certificado = "";
        certificado = Base64.encodeBase64String((byte[])archivoCER).toString();
        return certificado;
    }

    public static byte[] getBytes(FileInputStream is, int longitud) {
        byte[] buffer = null;
        try {
            buffer = new byte[longitud];
            is.read(buffer, 0, longitud);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public String getCFD() {
        Format format = Format.getPrettyFormat();
        format.setEncoding("utf-8");
        format.setTextMode(Format.TextMode.NORMALIZE);
        XMLOutputter xmlOutputer = new XMLOutputter(format);
        String res = xmlOutputer.outputString(new Document());
        try {
            res = new String(res.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "getCFD", e.toString(), "ERROR JAVA");
        }
        return res;
    }

    public String cancelaCFD(CFDICanceladosDTO cfdiCanceladoDto, String modo) {
        String passwordKey = this.configuracion.getClavePrivada();
        String nombreArchivoKey = this.configuracion.getArchivoEntradaKey();
        String xmlCancelado = "";
        char[] cPassword = null;
        String certificado = "";
        String keyPem = "";
        try {
            FileInputStream archivoClavePrivada = new FileInputStream(nombreArchivoKey);
            int longitudKey = (int)new File(nombreArchivoKey).length();
            keyPem = this.getCertificado(archivoClavePrivada, longitudKey);
            cPassword = passwordKey.toCharArray();
            String nombreArchivoCER = this.configuracion.getArchivoEntradaCer();
            FileInputStream archivoCER = new FileInputStream(nombreArchivoCER);
            int longitudCER = (int)new File(nombreArchivoCER).length();
            certificado = this.getCertificado(archivoCER, longitudCER);
        }
        catch (Exception e) {
            System.out.println("error en cancelaCFD " + e.toString());
        }
        CfdiCliente cfdiCiente = new CfdiCliente();
        try {
            xmlCancelado = cfdiCiente.cancelarCFDICSD(this.configuracion.getUsuarioPac(), this.configuracion.getPassPac(), certificado, keyPem, passwordKey, cfdiCanceladoDto, modo);
            System.out.println("xmlCancelado= " + xmlCancelado);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return xmlCancelado;
    }

    public void generaCFD(BDUtil bdUtil, String modo, String tipodoc, int preview) {
        System.out.println("Inicia generaCFD");
        String vPaso = "";
        String selloDigital = "";
        Object rutaXML = null;
        Boolean con_sellodigital = true;
        NodoComplemento complemento = null;
        int timbrado = 0;
        String path = LeeConexion.path;
        ComprobantesDAO comprobantesDAO = new ComprobantesDAO(this.configuracion.getRutaSalidaTimbre());
        LogcfdDAO log = new LogcfdDAO();
        try {
            selloDigital = this.comprobante.getSello();
            if (selloDigital == null) {
                con_sellodigital = false;
                String password = this.configuracion.getClavePrivada();
                String nombreArchivoKey = this.configuracion.getArchivoEntradaKey();
                FileInputStream archivoClavePrivada = new FileInputStream(nombreArchivoKey);
                int longitudKey = (int)new File(nombreArchivoKey).length();
                this.comprobante.setNocertificado(this.configuracion.getNoCertificado());
                selloDigital = this.getSelloDigital(nombreArchivoKey, password, longitudKey, this.comprobante);
                this.comprobante.setSello(selloDigital);
            }
            String nombreArchivoCER = this.configuracion.getArchivoEntradaCer();
            FileInputStream archivoCER = new FileInputStream(nombreArchivoCER);
            int longitudCER = (int)new File(nombreArchivoCER).length();
            String certificado = this.getCertificado(archivoCER, longitudCER);
            this.comprobante.setCertificado(certificado);
        }
        catch (Exception e) {
            System.out.println("CFDUTIL 1 error: " + e.toString());
            return;
        }
        timbrado = this.comprobante.getUUID() == null ? 0 : 1;
        String nombreArchivoXML = "";
        CFDenXML gxml = new CFDenXML(this.comprobante, this.configuracion, timbrado, tipodoc);
        nombreArchivoXML = gxml.generarXML(selloDigital, timbrado);
        this.comprobante.setRutaOriginal(nombreArchivoXML);
        String rutaXml = "";
        String rutaXmlBase = "";
        if (!con_sellodigital.booleanValue()) {
            rutaXmlBase = gxml.getRutaBaseXml();
            String prefijo = "";
            String nombreArchivo = ComprobantesDAO.creaNombreArchivo(this.comprobante.getComprobante());
            File archivoXmlOrig = new File(rutaXmlBase);
            if (!archivoXmlOrig.exists()) {
                archivoXmlOrig.mkdirs();
                System.out.println("Se cre\u00f3 a ruta: " + rutaXmlBase);
            }
            String rutaSalidaXml = String.valueOf(rutaXmlBase) + File.separator + "CFDI";
            String rutaSalidaError = String.valueOf(rutaXmlBase) + File.separator + "ERROR";
            String rutaNombreEntradaXml = String.valueOf(rutaXmlBase) + File.separator + "ORIGINAL" + File.separator + nombreArchivo + ".xml";
            System.out.println("rutaSalidaXml=       " + rutaSalidaXml);
            System.out.println("rutaSalidaError=     " + rutaSalidaError);
            System.out.println("rutaNombreEntradaXml=" + rutaNombreEntradaXml);
            File archivoXmlTimbrado = new File(rutaSalidaXml);
            if (!archivoXmlTimbrado.exists()) {
                archivoXmlTimbrado.mkdirs();
            }
            try {
                vPaso = "Creando archivoXML";
                ArchivoXml xmlFile = new ArchivoXml();
                String xmlString = xmlFile.XmlToArray(rutaNombreEntradaXml);
                String xmlTimbrado = null;
                CfdiCliente cfdiCliente = new CfdiCliente();
                try {
                    vPaso = "0010 getTimbre";
                    xmlTimbrado = cfdiCliente.getTimbreCfdi(this.configuracion.getUsuarioPac(), this.configuracion.getPassPac(), xmlString, modo, this.comprobante.getTipoDoc());
                    if (xmlTimbrado != null) {
                        vPaso = "0011 leerTimbre";
                        complemento = cfdiCliente.leerNodo(0, xmlTimbrado);
                        vPaso = "0012 actualizaComprobante01";
                        comprobantesDAO.actualizaComprobante(bdUtil, this.comprobante, 0, complemento);
                        vPaso = "0013 actualizarComprobante02";
                        comprobantesDAO.actualizaComprobante(bdUtil, this.comprobante, 1, complemento);
                        vPaso = "0014 version";
                        this.comprobante.setVersionTFD(complemento.getVersion());
                        vPaso = "0015 getUUID";
                        this.comprobante.setUUID(complemento.getUUID());
                        vPaso = "0016 fechaTimbrado";
                        this.comprobante.setFechaTimbrado(complemento.getFechaTimbrado());
                        vPaso = "0017 certiicadoSAT";
                        this.comprobante.setNoCertificadoSAT(complemento.getNoCertificadoSAT());
                        vPaso = "0018 selloSAT";
                        this.comprobante.setSelloSAT(complemento.getSelloSAT());
                        vPaso = "0010 gtRFCProvCertif";
                        this.comprobante.setRfcProvCertif(complemento.getRfcProvCertif());
                        vPaso = "0020 actualizaLog";
                        log.actualizaLogCfd(bdUtil, this.comprobante.getComprobante(), 1, "TIMBRADO");
                        vPaso = "0021 DENXML";
                        CFDenXML gxmlTimbrado = new CFDenXML(this.comprobante, this.configuracion, 1, tipodoc);
                        vPaso = "0022 generaXML";
                        nombreArchivoXML = gxmlTimbrado.generarXML(selloDigital, 1);
                        vPaso = "0023 rutaCFDi";
                        this.comprobante.setRutaCdfi(nombreArchivoXML);
                        System.out.println("Despues de timbrado, la ruta es:" + this.comprobante.getRutaCdfi());
                        vPaso = "0024 CFDenXML";
                        CFDenXML gxmlInterpretado = new CFDenXML(this.comprobante, this.configuracion, 1, tipodoc);
                        vPaso = "0025 generarXML";
                        nombreArchivoXML = gxmlInterpretado.generarXML(selloDigital, 2);
                        vPaso = "0026 rutaInterpretado";
                        this.comprobante.setRutaInterpretado(nombreArchivoXML);
                        vPaso = "0027 CFDemisioDAO";
                        CfdEmisionDAO pCfd = new CfdEmisionDAO();
                        vPaso = "0028 IF de NM";
                        if (tipodoc.equals("NM")) {
                            pCfd.insertaCfdiEmisionNomina(bdUtil, this.comprobante.getComprobante());
                            pCfd.insertaCfdiCustomDataNomina(bdUtil, this.comprobante.getComprobante());
                        } else {
                            pCfd.insertaCfdiEmision2(bdUtil, this.comprobante.getComprobante());
                            pCfd.insertaCfdiCustomData2(bdUtil, this.comprobante.getComprobante());
                            if (this.comprobante.getTipoDoc().equals("CB")) {
                                pCfd.insertaDoctoRelacionado(bdUtil, this.comprobante.getFolioDoc());
                            }
                        }
                        vPaso = "0029 actualizaFolioFiscal";
                        comprobantesDAO.actualizarFolioFiscal(bdUtil, this.comprobante.getFolio(), this.comprobante.getUUID());
                        File salidaError = new File(String.valueOf(rutaSalidaError) + File.separator);
                        String cadenafiltro = this.comprobante.getFolioDoc();
                        File[] files = salidaError.listFiles();
                        if (files != null) {
                            int i = 0;
                            while (i < files.length) {
                                if (files[i].getName().contains(cadenafiltro)) {
                                    System.out.println("Archivo encontrado :" + files[i].getName());
                                    File archivoError = new File(files[i].getAbsolutePath());
                                    if (archivoError.exists()) {
                                        FileUtils.forceDelete((File)archivoError);
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    vPaso = "1000 fin";
                }
                catch (CfdiExceptionPac e) {
                    try {
                        System.out.println("Guardando el archivo");
                        String vRutaXMLRecibido = String.valueOf(rutaSalidaError) + "\\" + this.comprobante.getFolioDoc() + this.comprobante.getSubtipoDoc() + "_ERROR" + ".txt";
                        File vXMLRecibido = new File(vRutaXMLRecibido);
                        if (!vXMLRecibido.exists()) {
                            vXMLRecibido.createNewFile();
                        }
                        FileWriter fw = new FileWriter(vXMLRecibido);
                        BufferedWriter bw = new BufferedWriter(fw);
                        if (xmlTimbrado == null && ((xmlTimbrado = String.valueOf(e.getCod()) + ", " + e.getText() + ", " + e.getTextCode()).contains("40147") || xmlTimbrado.toUpperCase().contains("DOMICILIOFISCALRESCEPTOR"))) {
                            xmlTimbrado = String.valueOf(xmlTimbrado) + "<br>" + "(" + this.comprobante.getRfcReceptor() + ") " + "Receptor: " + this.comprobante.getNombreReceptor() + " C.P: " + this.comprobante.getCodigoPostalReceptor();
                        }
                        bw.write(xmlTimbrado.replace("\n", ""));
                        bw.close();
                        String vMensaje = "<div style=\" padding:5% 10%; text-align: left; \"><h3>No timbrado</h3><div style=\"padding:0% 5%;\"><p>Ocurri\u00f3 algo que provoc\u00f3 que el timbrado fallara. Revice el comprobante con folio: <b>" + this.comprobante.getFolioDoc() + "</b> y folio interno:<b>" + this.comprobante.getFolio() + "</b>." + "<br>Se adjunta la ubicacion del XML recibido,el error y el archivo XML recibido por el PAC." + "<br>" + "<br><b>Ubicacion del archivo: <br></b>" + vRutaXMLRecibido + "</p>" + "<p><b>Detalles del error:</b> <br>   " + xmlTimbrado + "</p>" + "</div>" + "</div>";
                        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
                        String destinatarios = parametro.obtenparametro(bdUtil, "mail.recipients_monitor", "NOTIFICACIONES MAIL");
                        String vAsunto = "Error en el timbrado";
                        if (this.comprobante.getTipoDoc().equals("NM")) {
                            vAsunto = String.valueOf(vAsunto) + " de un recibo de n\u00f3mina";
                            destinatarios = parametro.obtenparametro(bdUtil, "mail.recipients_monitor_nom", "NOTIFICACIONES MAIL");
                        }
                        EnvioCorreo envioCorreo = new EnvioCorreo(bdUtil, this.configuracion);
                        if (bdUtil.Modo.equals("PROD")) {
                            System.out.println("ENVIANDO CORREO DE NOTIFICACION DE ERROR");
                            envioCorreo.enviarCorreo(destinatarios, vAsunto, vMensaje, vRutaXMLRecibido, this.comprobante.getNombreEmisor());
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("No se pudo guardar el XML devuelto por DIGIBOX. ERROR:" + ex.toString());
                    }
                    System.out.println("El formato es incorrecto: " + e.getCod() + ", " + e.getText() + ", " + e.getTextCode());
                    File archivoSalidaError = new File(rutaSalidaError);
                    if (!archivoSalidaError.exists()) {
                        archivoSalidaError.mkdirs();
                    }
                    File archivoOrigenXml = new File(rutaNombreEntradaXml);
                    Archivos archivos = new Archivos();
                    archivos.copiar(archivoOrigenXml, archivoSalidaError, 1);
                    archivoOrigenXml.delete();
                    selloDigital = "";
                    this.comprobante.setSello(selloDigital);
                    log.actualizaLogError(bdUtil, this.comprobante.getComprobante(), e.getCod(), e.getText(), e.getTextCode(), "ERROR");
                    System.out.println("Error del PAC:" + e.toString());
                }
            }
            catch (CfdiExceptionSiti e) {
                log.actualizaLogError(bdUtil, this.comprobante.getComprobante(), Integer.toString(e.getCod()), e.getText(), e.getTextCode(), "ERROR");
                System.out.println("[CFDUtil] ERROR de excepci\u00f3n: " + vPaso + " | " + e.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.actualizaLogError(bdUtil, this.comprobante.getComprobante(), "E", "Error inesperado", e.toString(), "ERROR");
                System.out.println("[CFDUtil] ERROR de excepci\u00f3n: " + vPaso + " | " + e.toString());
            }
        }
    }

    public static String getContenidoArchivo(String ruta, String nombreArchivo) {
        String contenido = "";
        String nombreArchivoCompleto = String.valueOf(ruta) + File.separator + nombreArchivo;
        System.out.println("nombreArchivoCompleto=" + nombreArchivoCompleto);
        try {
            FileInputStream archivo = new FileInputStream(nombreArchivoCompleto);
            int longitud = (int)new File(nombreArchivoCompleto).length();
            System.out.println("longitud=" + longitud);
            byte[] archivoBytes = CFDUtil.getBytes(archivo, longitud);
            contenido = Base64.encodeBase64String((byte[])archivoBytes).toString();
        }
        catch (Exception e) {
            System.out.println("CFDUTIL 2 error: " + e.toString());
        }
        return contenido;
    }

    public static void createArchivo(String ruta, String nombreArchivo, String contenido) {
        byte[] bytes = new byte[contenido.length()];
        bytes = contenido.getBytes();
        bytes = Base64.decodeBase64((byte[])bytes);
        try {
            String nombreArchivoCompleto = String.valueOf(ruta) + File.separator + nombreArchivo;
            File archivo = new File(nombreArchivoCompleto);
            FileOutputStream fos = new FileOutputStream(archivo);
            fos.write(bytes);
            fos.close();
        }
        catch (Exception e) {
            System.out.println("CFDUTIL 3  error: " + e.toString());
        }
    }

    public String getSelloDigitalRE(ConfiguracionDTO pConfiguracion, ComprobanteDTO pComprobante) throws FileNotFoundException, GeneralSecurityException {
        String password = pConfiguracion.getClavePrivada();
        String nombreArchivoKey = pConfiguracion.getArchivoEntradaKey();
        FileInputStream archivoClavePrivada = new FileInputStream(nombreArchivoKey);
        int longitudKey = (int)new File(nombreArchivoKey).length();
        pComprobante.setNocertificado(pConfiguracion.getNoCertificado());
        return this.getSelloDigital(nombreArchivoKey, password, longitudKey, pComprobante);
    }

    public String getCertificadoRE(ConfiguracionDTO pConfiguracion) throws FileNotFoundException, GeneralSecurityException {
        FileInputStream archivoCER = new FileInputStream(pConfiguracion.getArchivoEntradaCer());
        int longitudCER = (int)new File(pConfiguracion.getArchivoEntradaCer()).length();
        return this.getCertificado(archivoCER, longitudCER);
    }
}

