/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import siti.conexion.BDUtil;
import siti.conexion.LeeConexion;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dao.CfdEmisionDAO;
import siti.sinco.cfdi.dao.ConfiguracionDAO;
import siti.sinco.cfdi.dao.ParametroCFDConnectDAO;
import siti.sinco.cfdi.dto.CFDICanceladosDTO;
import siti.sinco.cfdi.dto.CfdEmisionDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;

public class EnvioCorreo {
    private ConfiguracionDTO configuracion;
    private Properties props;
    private BDUtil bdUtil;

    public EnvioCorreo(BDUtil bdUtil, ConfiguracionDTO configuracion) {
        this.bdUtil = bdUtil;
        this.configuracion = configuracion;
    }

    public void setConfigCorreo() {
        this.props = new Properties();
        this.props.setProperty("mail.smtp.starttls.enable", "true");
        this.props.setProperty("mail.smtp.ssl.trust", this.configuracion.getIpServidorCorreo());
        this.props.setProperty("mail.smtp.user", this.configuracion.getEmailOrigen());
        this.props.setProperty("mail.smtp.password", this.configuracion.getPassEmailOrigen());
        this.props.setProperty("mail.smtp.port", this.configuracion.getPuertoServidorCorreo());
        this.props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
        this.props.setProperty("mail.smtp.auth", "true");
    }

    public void generarCorreoFactura(String mail, String nombreArchivo, String mensaje, String asunto, int noArchivos, String versionCFD, String tipoDoc, String folioDoc) {
        try {
            this.setConfigCorreo();
            Session session = Session.getDefaultInstance((Properties)this.props, null);
            MimeBodyPart texto = new MimeBodyPart();
            texto.setText(mensaje);
            MimeBodyPart adjunto = new MimeBodyPart();
            MimeBodyPart adjunto2 = null;
            if (noArchivos == 2) {
                adjunto2 = new MimeBodyPart();
            }
            if (!nombreArchivo.equals("")) {
                String nombreCompletoPDF = String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaPdf(tipoDoc) + File.separator + nombreArchivo + ".pdf";
                String nombreCompletoXML = "";
                nombreCompletoXML = versionCFD.equals("3.2") || versionCFD.equals("3.3") ? String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaTimbre(tipoDoc, folioDoc) + File.separator + "SIGN_" + nombreArchivo + ".xml" : String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaTimbre(tipoDoc, folioDoc) + File.separator + nombreArchivo + ".xml";
                System.out.println("nombreCompletoXML" + nombreCompletoXML);
                if (noArchivos == 0) {
                    adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoPDF)));
                    adjunto.setFileName(String.valueOf(nombreArchivo) + ".pdf");
                } else if (noArchivos == 1) {
                    adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoXML)));
                    adjunto.setFileName(String.valueOf(nombreArchivo) + ".xml");
                }
                if (noArchivos == 2) {
                    adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoPDF)));
                    adjunto.setFileName(String.valueOf(nombreArchivo) + ".pdf");
                    adjunto2.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoXML)));
                    adjunto2.setFileName(String.valueOf(nombreArchivo) + ".xml");
                }
            }
            MimeMultipart multiParte = new MimeMultipart();
            multiParte.addBodyPart((BodyPart)texto);
            if (!nombreArchivo.equals("")) {
                multiParte.addBodyPart((BodyPart)adjunto);
                if (noArchivos == 2) {
                    multiParte.addBodyPart((BodyPart)adjunto2);
                }
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.configuracion.getEmailOrigen()));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mail));
            message.setSubject(asunto);
            message.setContent((Multipart)multiParte);
            Transport t = session.getTransport("smtp");
            t.connect(this.configuracion.getEmailOrigen(), this.configuracion.getPassEmailOrigen());
            t.sendMessage((Message)message, message.getAllRecipients());
            t.close();
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "generarCorreoFactura", e.toString(), "ERROR JAVA");
        }
    }

    public void enviarCorreoNomina(ComprobanteDTO comprobante, String nombreArchivo, String correo, String modo) {
        if (correo != null && !correo.equals("@") && comprobante.getUUID() != null) {
            String subject = "Recibo de la nomina " + comprobante.getFolioDoc() + "-" + comprobante.getNombreReceptor();
            if (modo.equals("TEST")) {
                subject = "TEST " + subject;
            }
            String mensajeCorreo = "Estimado colaborador,\n\nSERVICIOS INTEGRADOS EN TECNOLOGIA DE INFORMACION emiti\u00f3 para Usted un Comprobante Fiscal Digital por Internet.\n\nRecibo " + comprobante.getFolioDoc() + "\n" + "Factura electr\u00f3nica " + comprobante.getUUID() + "\n\n" + "Este correo y todos los archivos transmitidos son confidenciales y dirigidos a la persona especificada.\n\n" + "Si recibi\u00f3 este correo por error o los datos de facturaci\u00f3n no coinciden, favor de notificarlo a:\n\n" + "Se envia archivo electronico de CFDI conforme a lo se\u00f1alado por el LISR\n" + "NO RESPONDER AL PRESENTE, ES S\u00d3LO INFORMATIVO\n\n";
            System.out.println(String.valueOf(correo) + " " + nombreArchivo + " " + comprobante.getTipoDoc());
            this.generarCorreoFactura(correo, nombreArchivo, mensajeCorreo, subject, 0, comprobante.getVersion(), comprobante.getTipoDoc(), comprobante.getFolioDoc());
        }
    }

    public void enviarCorreoGenerico(String mail, String nombreCompletoArchivo, String mensaje, String asunto) {
        try {
            this.setConfigCorreo();
            Session session = Session.getDefaultInstance((Properties)this.props, null);
            MimeBodyPart texto = new MimeBodyPart();
            texto.setText(mensaje);
            MimeBodyPart adjunto = new MimeBodyPart();
            if (!nombreCompletoArchivo.equals("")) {
                adjunto.setDataHandler(new DataHandler((DataSource)new FileDataSource(nombreCompletoArchivo)));
                adjunto.setFileName(nombreCompletoArchivo);
            }
            MimeMultipart multiParte = new MimeMultipart();
            multiParte.addBodyPart((BodyPart)texto);
            if (!nombreCompletoArchivo.equals("")) {
                multiParte.addBodyPart((BodyPart)adjunto);
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.configuracion.getEmailOrigen()));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mail));
            message.setSubject(asunto);
            message.setContent((Multipart)multiParte);
            Transport t = session.getTransport("smtp");
            t.connect(this.configuracion.getEmailOrigen(), this.configuracion.getPassEmailOrigen());
            t.sendMessage((Message)message, message.getAllRecipients());
            t.close();
            System.out.println("Se envio correo a " + mail);
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "enviarCorreoGenerico", e.toString(), "ERROR JAVA");
        }
    }

    public void enviarCorreoGenerico2(String[] mails, String nombreCompletoArchivo, String mensaje, String asunto, String pNombreEmisor, String pSubtitulo) {
        try {
            String vLeyendaAmbiente = this.getAmbiente();
            this.setConfigCorreo();
            Session session = Session.getDefaultInstance((Properties)this.props, null);
            MimeBodyPart texto = new MimeBodyPart();
            texto.setText(mensaje);
            MimeBodyPart html = new MimeBodyPart();
            String htmlS = this.getCuerpoGeneral(pNombreEmisor, String.valueOf(vLeyendaAmbiente) + mensaje, pSubtitulo);
            html.setContent((Object)htmlS, "text/html; charset=utf-8");
            MimeMultipart multipart = new MimeMultipart("related");
            multipart.addBodyPart((BodyPart)html);
            if (!nombreCompletoArchivo.equals("")) {
                String[] listaArchivos = nombreCompletoArchivo.split(";");
                int numArchivos = listaArchivos.length;
                int i = 0;
                while (i < numArchivos) {
                    File archivoF = new File(listaArchivos[i]);
                    if (archivoF.exists()) {
                        MimeBodyPart archivoM = new MimeBodyPart();
                        archivoM.setDataHandler(new DataHandler((DataSource)new FileDataSource(archivoF.getAbsolutePath())));
                        archivoM.setFileName(archivoF.getName());
                        multipart.addBodyPart((BodyPart)archivoM);
                    }
                    ++i;
                }
                multipart.setSubType("mixed");
            }
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.configuracion.getEmailOrigen()));
            message.setSubject(asunto);
            message.setContent((Multipart)multipart);
            Transport t = session.getTransport("smtp");
            t.connect(this.configuracion.getIpServidorCorreo(), this.configuracion.getEmailOrigen(), this.configuracion.getPassEmailOrigen());
            int interador = 0;
            InternetAddress[] vDestinos = new InternetAddress[mails.length];
            System.out.print("CORREO DESTINATARIOS: ");
            String[] stringArray = mails;
            int n = mails.length;
            int n2 = 0;
            while (n2 < n) {
                String correo = stringArray[n2];
                System.out.print(correo);
                vDestinos[interador] = new InternetAddress(correo);
                ++interador;
                ++n2;
            }
            System.out.print(" | \n");
            message.setRecipients(Message.RecipientType.TO, (Address[])vDestinos);
            t.sendMessage((Message)message, message.getAllRecipients());
            t.close();
            System.out.println("\u00a1Se ha enviado el correo de forma exitosa!");
        }
        catch (Exception e) {
            RegistraLOG.registrarLog(this.getClass().getName(), "enviarCorreoGenerico2", e.toString(), "ERROR JAVA");
        }
    }

    public void enviaCorreoCancelacion(String mensaje, String destinatarios, String pNombreEmisor) {
        String archivo = "";
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "NOTIFICACIONES MAIL");
        String[] destinatariosArray = null;
        destinatariosArray = destinatarios.isEmpty() ? parametro.obtenparametro(this.bdUtil, "mail.recipients_siti", "NOTIFICACIONES MAIL").split(";") : destinatarios.split(";");
        System.out.println("Enviando correo a " + destinatarios);
        envio.enviarCorreoGenerico2(destinatariosArray, archivo, mensaje, subject, pNombreEmisor, null);
    }

    public void enviarCorreo(String pDestinatarios, String pAsunto, String pMensaje, String pArchivos, String pNombreEmisor) {
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "NOTIFICACIONES MAIL");
        String[] destinatariosArray = null;
        destinatariosArray = pDestinatarios.isEmpty() ? parametro.obtenparametro(this.bdUtil, "mail.recipients_siti", "NOTIFICACIONES MAIL").split(";") : pDestinatarios.split(";");
        String vArchivos = "";
        if (!pArchivos.isEmpty()) {
            vArchivos = pArchivos;
        }
        System.out.println("Enviando correo a " + pDestinatarios);
        envio.enviarCorreoGenerico2(destinatariosArray, vArchivos, pMensaje, String.valueOf(subject) + " | " + pAsunto, pNombreEmisor, null);
    }

    public void enviarCorreoMONITOR(String pDestinatarios, String pAsunto, String pMensaje, String pArchivos, String pNombreEmisor) {
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "NOTIFICACIONES MAIL");
        String[] destinatariosArray = null;
        if (pDestinatarios.isEmpty()) {
            destinatariosArray = pAsunto.toUpperCase().contains("DETUVO") || pAsunto.toUpperCase().contains("PROCESO") || pAsunto.toUpperCase().contains("INEXISTENTES") ? parametro.obtenparametro(this.bdUtil, "mail.recipients_monitor", "NOTIFICACIONES MAIL").split(";") : pDestinatarios.split(";");
        }
        String vArchivos = "";
        if (!pArchivos.isEmpty()) {
            vArchivos = pArchivos;
        }
        System.out.println("Enviando correo a " + pDestinatarios);
        envio.enviarCorreoGenerico2(destinatariosArray, vArchivos, pMensaje, String.valueOf(subject) + " | " + pAsunto, pNombreEmisor, null);
    }

    public static void reenvio(String pFolio, String pSerie, boolean pReenvio) {
        BDUtil bdUtil = new BDUtil();
        int vTipoEnvio = 2;
        try {
            bdUtil.setConexion();
            ConfiguracionDTO configuracionDTO = new ConfiguracionDTO();
            ConfiguracionDAO configDAO = new ConfiguracionDAO();
            configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
            ArrayList<Object> listaAComprobar = new ArrayList();
            listaAComprobar = CfdEmisionDAO.getCFDISAReenviarArchivos(bdUtil, pFolio, pSerie);
            for (CfdEmisionDTO cfdEmisionDTO : listaAComprobar) {
                String vArchivos = "";
                String vSubmensaje = "";
                if (cfdEmisionDTO.getSERIE().toUpperCase().equals("N")) {
                    vSubmensaje = " la nota de cr\u00e9dito ";
                } else if (cfdEmisionDTO.getSERIE().toUpperCase().equals("F")) {
                    vSubmensaje = " la factura ";
                } else if (cfdEmisionDTO.getSERIE().toUpperCase().equals("C")) {
                    vSubmensaje = " el complemento de pago ";
                }
                String vMensaje = "<h3>" + cfdEmisionDTO.getRFCRECEPTOR() + " - " + cfdEmisionDTO.getNOMBRERECEPTOR() + "</h3>" + "<p>Se ha timbrado " + vSubmensaje + " <b>" + cfdEmisionDTO.getFOLIO() + "</b>" + " y ha obtenido el folio fiscal: <br><b>" + cfdEmisionDTO.getUUID().toUpperCase() + "</b></br>" + "</p><br>";
                if (vTipoEnvio != 3) {
                    switch (vTipoEnvio) {
                        case 0: {
                            vArchivos = EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTAPDF());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF relacionado</p>";
                            break;
                        }
                        case 1: {
                            vArchivos = EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTACFD());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el CFDI relacionado</p>";
                            break;
                        }
                        case 2: {
                            vArchivos = String.valueOf(EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTAPDF())) + ";" + EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTACFD());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF y el CFDI relacionado</p>";
                        }
                    }
                }
                System.out.println("Archivos: " + vArchivos);
                String vAsunto = pReenvio ? "REENVIO TIMBRADO" : "TIMBRADO";
                EnvioCorreo correo = new EnvioCorreo(bdUtil, configuracionDTO);
                correo.enviarCorreo(cfdEmisionDTO.getCorreoReceptor(), vAsunto, vMensaje, vArchivos, cfdEmisionDTO.getNOMBREEMISOR());
                System.out.println("\u00c9XITO. Se reenvi\u00f3 de forma exitosa el correo de folio: " + pFolio + " de serie: " + pSerie);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println("ERROR. NO se pudo reenviar el correo a " + pFolio + " de serie:" + pSerie + ". Favor de intentarlo mas tarde.");
        }
    }

    public static String nvlArchivo(String pArchivo) {
        String vValor = "";
        if (pArchivo != null) {
            vValor = pArchivo;
        }
        return vValor;
    }

    public String getAmbiente() {
        String vValor = "";
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        String vAmbiente = parametro.obtenparametro(this.bdUtil, "TIPODEAMBIENTE", "AMBIENTE").toUpperCase();
        System.out.println(vAmbiente);
        if (!vAmbiente.startsWith("PROD") && (vAmbiente.startsWith("TEST") || vAmbiente.startsWith("DESA"))) {
            vValor = "<div style='margin-bottom: 3px;background-color:#D6DBDF; color:red;'>    \t<div align='left'><i><b>" + vAmbiente + "\t\t</b></i></div>" + "</div>";
            System.out.println(vValor);
        }
        return vValor;
    }

    public String getCuerpoGeneral(String pNombreEmisor, String pMensaje, String pSubtitulo) {
        String vSubtitulo = "<br><b><span>" + pSubtitulo + "<b></span>";
        String vValor = "<!DOCTYPE html><html lang='es'>    <head>        <meta charset='UTF-8'>        <meta http-equiv='X-UA-Compatible' content='IE=edge'>        <meta name='viewport' content='width=device-width, initial-scale=1.0'>        <title>SI-TI Emails</title>        <style type='text/css'>        *{            font-family: Helvetica,Verdana, sans-serif,Arial;        }        p{            padding-left: 15px;            padding-right: 15px;        }        .normalizar{            padding-left: 5%;        }        .centrarV{            display: flex;            align-items: center;        }        </style>    </head>    <body style=\"background-color:#D6DBDF; padding-top:50px; padding-bottom:50px;\">        <table align='center' style='text-align:center; width: 90%; box-shadow: 0px 0px 5px 2px #888888; background-color: white; border-radius: 10px; padding-top: 20px; padding-bottom: 20px; '>            <tr>                <td>                    <div style='display: flex; align-items: center; justify-content:first baseline; padding-left: 5%;'>                        <img src='https://mediport.puertomazatlan.com.mx/Imagenes/LogoAPIMazLogin1.jpg' width='75px' height='75px' style='border-radius: 10px;'>                        <p> <b><span style='font-size:14px;'>" + pNombreEmisor + "</span></b> " + (pSubtitulo != null ? vSubtitulo : "") + "</p>" + "                    </div>" + "                </td>" + "            </tr>" + "            <tr>                <td align='center' width= '90%' valign='center' style='text-align: center;'><div style='background-color: gray; width: 100%; height: 3px; border-radius: 10px; '></div></td>            </tr>" + "            <tr>" + "                <td>" + "                    <div class='normalizar'>" + pMensaje + "                    </div>" + "                </td>" + "            </tr>" + "            <tr>                <td align='center' width= '90%' valign='center' style='text-align: center;'><div style='background-color: gray; width: 100%; height: 3px; border-radius: 10px; '></div></td>            </tr>" + "        </table>" + "    </body>" + "</html>";
        return vValor;
    }

    public String getCuerpoCancelacion(String pParrafo, String pTipoDocumento, CFDICanceladosDTO pCFDICanceladoDTO) {
        String vValor = "<div style=\" padding:5% 10%; text-align: left;\"><h3>Cancelaci\u00f3n</h3><div style=\"padding:0% 5%;\">" + pParrafo + "<br>" + pTipoDocumento + " (<b>" + pCFDICanceladoDTO.getFactura() + "</b>) con folio <b>" + pCFDICanceladoDTO.getFolio() + "</b>. <br>Con el UUID: <b>" + pCFDICanceladoDTO.getUuid() + "</b></p>";
        if (pCFDICanceladoDTO.getClavesatcancelacion() != null && pCFDICanceladoDTO.getClavesatcancelacion().equals("01")) {
            vValor = String.valueOf(vValor) + "Se cancel\u00f3 con la clave <b>" + pCFDICanceladoDTO.getClavesatcancelacion() + "</b> y el UUID vigente es:<b> " + pCFDICanceladoDTO.getUuid_sustitucion() + "</b>.";
        }
        vValor = String.valueOf(vValor) + "</div>" + "</div>";
        return vValor;
    }

    public String getCuerpoCancelacionRecibo(String pParrafo, String pTipoDocumento, CFDICanceladosDTO pCFDICanceladoDTO) {
        String vValor = "<div style=\" padding:5% 10%; text-align: left;\"><h3>Cancelaci\u00f3n</h3><div style=\"padding:0% 5%;\">" + pParrafo + "<br>" + pCFDICanceladoDTO.getDescripcion() + " ha sido cancelado." + "</div>" + "</div>";
        return vValor;
    }

    public String getFormatoEncuestaServicio(String pLinkEncuesta, String pServicio) {
        String vValor = "<div style='margin-bottom: 3px;'>    <div align='left'>        <h3>Se ha completado la petici\u00f3n: </h3>        <p>Favor de responder la siguiente encuesta relacionada con la solicitud <b>" + pServicio + "</b> dando clic en el siguiente enlace:</p>" + "    </div>" + "    <a href='" + pLinkEncuesta + "'>Encuesta de satisfaccci\u00f3n" + " \t<svg xmlns='http://www.w3.org/2000/svg' width='16' height='16' fill='currentColor' class='bi bi-emoji-smile' viewBox='0 0 16 16'>" + " \t\t<path d='M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z'/>" + " \t\t<path d='M4.285 9.567a.5.5 0 0 1 .683.183A3.498 3.498 0 0 0 8 11.5a3.498 3.498 0 0 0 3.032-1.75.5.5 0 1 1 .866.5A4.498 4.498 0 0 1 8 12.5a4.498 4.498 0 0 1-3.898-2.25.5.5 0 0 1 .183-.683zM7 6.5C7 7.328 6.552 8 6 8s-1-.672-1-1.5S5.448 5 6 5s1 .672 1 1.5zm4 0c0 .828-.448 1.5-1 1.5s-1-.672-1-1.5S9.448 5 10 5s1 .672 1 1.5z'/>" + "\t\t</svg>" + "    </a>" + "</div>";
        return vValor;
    }

    public void enviarCorreoEncuestasServicio(String pNombreEmisor, String pDestinatarios, String pLink, String pServicio) {
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "ENCUESTAS");
        String[] destinatariosArray = pDestinatarios.split(";");
        String vMensaje = this.getFormatoEncuestaServicio(pLink, pServicio);
        envio.enviarCorreoGenerico2(destinatariosArray, "", vMensaje, String.valueOf(subject) + " | Servicio " + pServicio, pNombreEmisor, null);
    }

    public String getFormatoCreacionSolicitudMesaDeApoyo(String pServicio, String pCreador, String pAsunto, String pDescripcion) {
        String vDescripcion = pDescripcion == null ? "" : "<p>&emsp;<i>'" + pDescripcion + "'</i></p>";
        String vFormato = "<div style='margin-bottom: 3px;'>    <div align='left'>        <h3>Se ha creado la petici\u00f3n: <font color='green'>" + pServicio + "</font>.</h3>" + "\t\t   <p>El usuario <b>" + pCreador + "</b> cre\u00f3 una solicitud con el servicio: <b>" + pAsunto + "</b>.</p>" + vDescripcion + "    </div>" + "</div>";
        return vFormato;
    }

    public void enviarCorreoCreacionSolicitudMesaDeApoyo(String pNombreEmisor, String pMensaje, String pServicio, String pSubtitulo) {
        System.out.println("SE ENVIAR\u00c1 CORREO DE LA CREACI\u00d3N DE UNA SOLICITUD DE MESA DE APOYO");
        ParametroCFDConnectDAO parametro = new ParametroCFDConnectDAO();
        EnvioCorreo envio = new EnvioCorreo(this.bdUtil, this.configuracion);
        String subject = parametro.obtenparametro(this.bdUtil, "mail.subject", "MESA DE APOYO");
        String[] destinatariosArray = parametro.obtenparametro(this.bdUtil, "mail.recipients", "MESA DE APOYO").split(";");
        envio.enviarCorreoGenerico2(destinatariosArray, "", pMensaje, String.valueOf(subject) + " | Servicio " + pServicio, pNombreEmisor, pSubtitulo);
    }

    public static void reenvioNomina(String pFolio, boolean pEsReenvio) {
        BDUtil bdUtil = new BDUtil();
        int vTipoEnvio = 2;
        try {
            bdUtil.setConexion();
            ConfiguracionDTO configuracionDTO = new ConfiguracionDTO();
            ConfiguracionDAO configDAO = new ConfiguracionDAO();
            configDAO.llenarConfiguracion(bdUtil, configuracionDTO, 1);
            ArrayList<Object> listaAComprobar = new ArrayList();
            listaAComprobar = CfdEmisionDAO.getRecibosAReenviarArchivos(bdUtil, pFolio);
            for (CfdEmisionDTO cfdEmisionDTO : listaAComprobar) {
                String vArchivos = "";
                String vSubmensaje = "el recibo";
                String vMensaje = "<h3>" + cfdEmisionDTO.getRFCRECEPTOR() + " - " + cfdEmisionDTO.getNOMBRERECEPTOR() + "</h3>" + "<p>Se ha timbrado " + vSubmensaje + " <b>" + cfdEmisionDTO.getFOLIO() + "</b>" + " y ha obtenido el folio fiscal: <br><b>" + cfdEmisionDTO.getUUID().toUpperCase() + "</b></br>" + "</p><br>";
                if (vTipoEnvio != 3) {
                    switch (vTipoEnvio) {
                        case 0: {
                            vArchivos = EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTAPDF());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF relacionado</p>";
                            break;
                        }
                        case 1: {
                            vArchivos = EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTACFD());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el CFDI relacionado</p>";
                            break;
                        }
                        case 2: {
                            vArchivos = String.valueOf(EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTAPDF())) + ";" + EnvioCorreo.nvlArchivo(cfdEmisionDTO.getRUTACFD());
                            vMensaje = String.valueOf(vMensaje) + "<p>Se adjunta el PDF y el CFDI relacionado</p>";
                        }
                    }
                }
                System.out.println("Archivos: " + vArchivos);
                EnvioCorreo correo = new EnvioCorreo(bdUtil, configuracionDTO);
                String vAsunto = pEsReenvio ? "REENVIO TIMBRADO" : "TIMBRADO";
                correo.enviarCorreo(cfdEmisionDTO.getCorreoReceptor(), vAsunto, vMensaje, vArchivos, cfdEmisionDTO.getNOMBREEMISOR());
                System.out.println("\u00c9XITO. Se reenvi\u00f3 de forma exitosa el correo de folio: " + pFolio);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println("ERROR. NO se pudo reenviar el correo a " + pFolio + " de serie:" + pFolio + ". Favor de intentarlo mas tarde.");
        }
    }
}

