/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FileUtils;

public class ManejadorArchivos {
    public static boolean moverArchivo(String pOrigen, String pDestino) {
        boolean procesoExitoso = false;
        String mensaje = "";
        File origen = new File(pOrigen);
        if (origen.exists()) {
            if (origen.isFile()) {
                File vDestinoF = new File(pDestino);
                if (!vDestinoF.exists()) {
                    vDestinoF.mkdirs();
                    System.out.println("Se cre\u00f3 la carpeta donde se pondr\u00e1 el archivo");
                }
                String vOrigen = pOrigen.replace("\\", "/");
                String[] vNombreArchivo = vOrigen.split("/");
                String vDestino = String.valueOf(pDestino.replace("\\", "/")) + "/" + vNombreArchivo[vNombreArchivo.length - 1];
                Path vOrigenPATH = Paths.get(vOrigen, new String[0]);
                Path vDestinoPATH = Paths.get(vDestino, new String[0]);
                try {
                    Files.move(vOrigenPATH, vDestinoPATH, StandardCopyOption.REPLACE_EXISTING);
                    procesoExitoso = true;
                    mensaje = "Se ha movido con exito: " + vDestino;
                }
                catch (Exception e) {
                    mensaje = "No se pudo mover el archivo: " + e.toString();
                }
            } else {
                mensaje = "Debe de insertar una ruta de un archivo, no de una carpeta.";
            }
        } else {
            mensaje = "No existe el archivo ubicado en: " + pOrigen + ".";
        }
        System.out.println(mensaje);
        return procesoExitoso;
    }

    public static boolean copiarArchivo(String pOrigen, String pDestino) {
        boolean procesoExitoso = false;
        String mensaje = "";
        File origen = new File(pOrigen);
        if (origen.exists()) {
            if (origen.isFile()) {
                File vDestinoF = new File(pDestino);
                if (!vDestinoF.exists()) {
                    vDestinoF.mkdirs();
                    System.out.println("Se cre\u00f3 la carpeta donde se pondr\u00e1 el archivo");
                }
                String vOrigen = pOrigen.replace("\\", "/");
                String[] vNombreArchivo = vOrigen.split("/");
                String vDestino = String.valueOf(pDestino.replace("\\", "/")) + "/" + vNombreArchivo[vNombreArchivo.length - 1];
                Path vOrigenPATH = Paths.get(vOrigen, new String[0]);
                Path vDestinoPATH = Paths.get(vDestino, new String[0]);
                try {
                    Files.copy(vOrigenPATH, vDestinoPATH, StandardCopyOption.REPLACE_EXISTING);
                    procesoExitoso = true;
                    mensaje = "Se ha copiado con exito: " + vDestino;
                }
                catch (Exception e) {
                    mensaje = "No se pudo copiar el archivo: " + e.toString();
                }
            } else {
                mensaje = "Debe de insertar una ruta de un archivo, no de una carpeta.";
            }
        } else {
            mensaje = "No existe el archivo ubicado en: " + pOrigen + ".";
        }
        System.out.println(mensaje);
        return procesoExitoso;
    }

    public static boolean copiarArchivoConDiferenteNombre(String pOrigen, String pDestino, String pNombre) {
        boolean procesoExitoso = false;
        String mensaje = "";
        File origen = new File(pOrigen);
        if (origen.exists()) {
            if (origen.isFile()) {
                File vDestinoF = new File(pDestino);
                if (!vDestinoF.exists()) {
                    vDestinoF.mkdirs();
                    System.out.println("Se cre\u00f3 la carpeta donde se pondr\u00e1 el archivo");
                }
                String vOrigen = pOrigen.replace("\\", "/");
                String[] vNombreArchivo = vOrigen.split("/");
                String[] vExtension = vNombreArchivo[vNombreArchivo.length - 1].split("\\.");
                String vDestino = String.valueOf(pDestino.replace("\\", "/")) + "/" + pNombre + "." + vExtension[vExtension.length - 1];
                Path vOrigenPATH = Paths.get(vOrigen, new String[0]);
                Path vDestinoPATH = Paths.get(vDestino, new String[0]);
                try {
                    Files.copy(vOrigenPATH, vDestinoPATH, StandardCopyOption.REPLACE_EXISTING);
                    procesoExitoso = true;
                    mensaje = "Se ha copiado con exito: " + vDestino;
                }
                catch (Exception e) {
                    mensaje = "No se pudo copiar el archivo: " + e.toString();
                }
            } else {
                mensaje = "Debe de insertar una ruta de un archivo, no de una carpeta.";
            }
        } else {
            mensaje = "No existe el archivo ubicado en: " + pOrigen + ".";
        }
        System.out.println(mensaje);
        return procesoExitoso;
    }

    public static boolean moverArchivoConDiferenteNombre(String pOrigen, String pDestino, String pNombre) {
        boolean procesoExitoso = false;
        String mensaje = "";
        File origen = new File(pOrigen);
        if (origen.exists()) {
            if (origen.isFile()) {
                File vDestinoF = new File(pDestino);
                if (!vDestinoF.exists()) {
                    vDestinoF.mkdirs();
                    System.out.println("Se cre\u00f3 la carpeta donde se pondr\u00e1 el archivo");
                }
                String vOrigen = pOrigen.replace("\\", "/");
                String[] vNombreArchivo = vOrigen.split("/");
                String[] vExtension = vNombreArchivo[vNombreArchivo.length - 1].split("\\.");
                String vDestino = String.valueOf(pDestino.replace("\\", "/")) + "/" + pNombre + "." + vExtension[vExtension.length - 1];
                Path vOrigenPATH = Paths.get(vOrigen, new String[0]);
                Path vDestinoPATH = Paths.get(vDestino, new String[0]);
                try {
                    Files.move(vOrigenPATH, vDestinoPATH, StandardCopyOption.REPLACE_EXISTING);
                    procesoExitoso = true;
                    mensaje = "Se ha movido con exito: " + vDestino;
                }
                catch (Exception e) {
                    mensaje = "No se pudo mover el archivo: " + e.toString();
                }
            } else {
                mensaje = "Debe de insertar una ruta de un archivo, no de una carpeta.";
            }
        } else {
            mensaje = "No existe el archivo ubicado en: " + pOrigen + ".";
        }
        System.out.println(mensaje);
        return procesoExitoso;
    }

    public static boolean buscaYElimina(String pRuta, String pNombreArchivo) {
        boolean procesoExitoso = true;
        return procesoExitoso;
    }

    public static void eliminarCarpetas(String pCarpeta) {
        File carpeta = new File(pCarpeta);
        File[] vListaArchivos = carpeta.listFiles();
        String[] aux = pCarpeta.replace("\\", "/").split("/");
        String nuev = "\\";
        int j = 0;
        while (j < aux.length - 2) {
            nuev = j == 0 ? String.valueOf(nuev) + aux[j] : String.valueOf(nuev) + "\\" + aux[j];
            ++j;
        }
        if (carpeta.listFiles().length > 0) {
            int i = 0;
            while (i < vListaArchivos.length) {
                System.out.println(vListaArchivos[i]);
                try {
                    if (vListaArchivos[i].isDirectory()) {
                        vListaArchivos[i].renameTo(new File(String.valueOf(nuev) + "\\1"));
                    } else {
                        vListaArchivos[i].renameTo(new File(String.valueOf(nuev) + "\\2.pdf"));
                    }
                    ManejadorArchivos.eliminarCarpetas(vListaArchivos[i].getAbsolutePath());
                    vListaArchivos[i].delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        System.out.println("se elimin\u00f3 carpeta basura");
    }

    public static boolean renombrarArchivo(String pOrigen, String pNombreNuevoArchivo) {
        boolean procesoExitoso = false;
        String mensaje = "";
        File origen = new File(pOrigen);
        if (origen.exists()) {
            if (origen.isFile()) {
                String vOrigen = pOrigen.replace("\\", "/");
                String[] vRutaArchivo = vOrigen.split("/");
                String[] vExtension = vRutaArchivo[vRutaArchivo.length - 1].split("\\.");
                String vArchivoRenombrado = vOrigen.replace(vRutaArchivo[vRutaArchivo.length - 1], pNombreNuevoArchivo);
                vArchivoRenombrado = String.valueOf(vArchivoRenombrado) + "." + vExtension[vExtension.length - 1];
                File archivoRenombrado = new File(vArchivoRenombrado);
                try {
                    origen.renameTo(archivoRenombrado);
                    procesoExitoso = true;
                    mensaje = "Se ha renombrado con exito: " + vArchivoRenombrado;
                }
                catch (Exception e) {
                    mensaje = "No se pudo mover el archivo: " + e.toString();
                }
            } else {
                mensaje = "Debe de insertar una ruta de un archivo, no de una carpeta.";
            }
        } else {
            mensaje = "No existe el archivo ubicado en: " + pOrigen + ".";
        }
        System.out.println(mensaje);
        return procesoExitoso;
    }

    public static void eliminaArchivo(String pRuta) {
        File vArchivo = new File(pRuta);
        if (vArchivo.exists()) {
            try {
                FileUtils.forceDelete((File)vArchivo);
            }
            catch (IOException e) {
                System.out.println("Se elimin\u00f3 el archivo:" + pRuta);
            }
        }
    }
}

