/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.contaElec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import siti.sinco.contaElec.CreaArchivo;
import siti.sinco.contaElec.Utilerias;
import siti.sinco.contaElec.dto.CabeceraBalanzaDTO;
import siti.sinco.contaElec.dto.CuentaBalanzaDTO;

public class BalanzaXml {
    public String ruta;
    private String FechaModBal;

    public String quitarRuidoNumero(String pNumero) {
        return pNumero.replace(" ", "").replace(",", "").replace("-", "");
    }

    public ArrayList<CuentaBalanzaDTO> leerLista(String pRutaLista) {
        System.out.println(pRutaLista);
        File vRutaLista = new File(pRutaLista);
        ArrayList<CuentaBalanzaDTO> listaCuentas = new ArrayList<CuentaBalanzaDTO>();
        if (vRutaLista.exists()) {
            if (vRutaLista.isFile()) {
                BufferedReader br = null;
                try {
                    try {
                        FileReader fr = new FileReader(pRutaLista);
                        br = new BufferedReader(fr);
                        String vLinea = br.readLine();
                        Object aux = null;
                        boolean seLeyoRFc = false;
                        boolean seLeyoMes = false;
                        boolean seLeyoAnio = false;
                        int vNumCtaL = 19;
                        int vDescripcion = vNumCtaL + 1 + 20;
                        int vSaldoIniL = vDescripcion + 21;
                        int vDebeL = vSaldoIniL + 19;
                        int vHaberL = vDebeL + 19;
                        boolean vSaldoFinL = false;
                        String vNumCta = null;
                        String vSaldoIni = null;
                        String vDebe = null;
                        String vHaber = null;
                        String vSaldoFin = null;
                        while (vLinea != null) {
                            if (!(vLinea.length() <= 1 || vLinea.length() < 117 || vLinea.contains("Cuenta") && vLinea.contains("Descripci\u00f3n") && vLinea.contains("Saldos Iniciales"))) {
                                if (!vLinea.contains("Ejercicio:") || !vLinea.contains("Fecha:")) {
                                    if (!vLinea.contains("-------") && !vLinea.substring(0, vNumCtaL).replace(" ", "").isEmpty()) {
                                        System.out.println(vLinea);
                                        CuentaBalanzaDTO balanzaDTO = new CuentaBalanzaDTO();
                                        vNumCta = vLinea.substring(0, vNumCtaL);
                                        vSaldoIni = vLinea.substring(vDescripcion, vSaldoIniL);
                                        vDebe = vLinea.substring(vSaldoIniL, vDebeL);
                                        vHaber = vLinea.substring(vDebeL, vHaberL);
                                        vSaldoFin = vLinea.substring(vHaberL, vLinea.length());
                                        balanzaDTO.setNumCta(this.quitarRuidoNumero(vNumCta));
                                        balanzaDTO.setSaldoIni(this.quitarRuidoNumero(vSaldoIni));
                                        balanzaDTO.setDebe(this.quitarRuidoNumero(vDebe));
                                        balanzaDTO.setHaber(this.quitarRuidoNumero(vHaber));
                                        balanzaDTO.setSaldoFin(this.quitarRuidoNumero(vSaldoFin));
                                        listaCuentas.add(balanzaDTO);
                                    }
                                } else {
                                    System.out.println("Obteniendo fecha:" + vLinea);
                                    String[] Aux = vLinea.split("Fecha:");
                                    System.out.println("Fecha:" + vLinea);
                                    String fechaAux = Aux[Aux.length - 1].replace(" ", "");
                                    this.setFechaModBal(fechaAux);
                                }
                            }
                            vLinea = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Ocurri\u00f3 un error a la hora de leer el archivo: " + e.toString());
                        try {
                            if (br != null) {
                                br.close();
                            }
                        }
                        catch (Exception e2) {
                            System.out.println("Sucedi\u00f3 un error al intentar el archivo: " + e2.getMessage());
                        }
                    }
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Sucedi\u00f3 un error al intentar el archivo: " + e.getMessage());
                    }
                }
                return listaCuentas;
            }
            System.out.println("La ruta de la lista no existe.");
        }
        return listaCuentas;
    }

    public void generaXML(String pRutaDestino, String pRutaTXT, String pRFC, String pVersion, String pEjercicio, String pPeriodo) {
        CabeceraBalanzaDTO cabeceraDto = new CabeceraBalanzaDTO();
        String tipoEnvio = "N";
        if (pRutaTXT.contains("BC")) {
            tipoEnvio = "C";
        }
        ArrayList<CuentaBalanzaDTO> listaBalanza = this.leerLista(pRutaTXT);
        cabeceraDto.setVersion(pVersion);
        cabeceraDto.setTipoEnvio(tipoEnvio);
        cabeceraDto.setFechaModBal(this.getFechaModBal());
        cabeceraDto.setAnio(pEjercicio);
        cabeceraDto.setMes(pPeriodo);
        cabeceraDto.setRfc(pRFC);
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Namespace bce = Namespace.getNamespace((String)"BCE", (String)"http://www.sat.gob.mx/esquemas/ContabilidadE/1_3/BalanzaComprobacion");
        Element elementoRaiz = new Element("Balanza", bce);
        elementoRaiz.setAttribute("schemaLocation", "http://www.sat.gob.mx/esquemas/ContabilidadE/1_3/BalanzaComprobacion http://www.sat.gob.mx/esquemas/ContabilidadE/1_3/BalanzaComprobacion/BalanzaComprobacion_1_3.xsd", xsi);
        elementoRaiz.setAttribute("Version", cabeceraDto.getVersion());
        elementoRaiz.setAttribute("TipoEnvio", cabeceraDto.getTipoEnvio());
        if (tipoEnvio.equals("C")) {
            Utilerias.setElementoOpcional("FechaModBal", Utilerias.cambiaFormatoFecha(cabeceraDto.getFechaModBal()), elementoRaiz);
        }
        elementoRaiz.setAttribute("RFC", cabeceraDto.getRfc());
        elementoRaiz.setAttribute("Mes", cabeceraDto.getMes());
        elementoRaiz.setAttribute("Anio", cabeceraDto.getAnio());
        cabeceraDto.setBalanza(listaBalanza);
        CuentaBalanzaDTO balanzaDto = new CuentaBalanzaDTO();
        int renglon = 0;
        while (renglon < listaBalanza.size()) {
            balanzaDto = listaBalanza.get(renglon);
            Element ctaElem = new Element("Ctas", bce);
            ctaElem.setAttribute("NumCta", balanzaDto.getNumCta());
            ctaElem.setAttribute("SaldoIni", balanzaDto.getSaldoIni());
            ctaElem.setAttribute("Debe", balanzaDto.getDebe());
            ctaElem.setAttribute("Haber", balanzaDto.getHaber());
            ctaElem.setAttribute("SaldoFin", balanzaDto.getSaldoFin());
            elementoRaiz.addContent((Content)ctaElem);
            ++renglon;
        }
        String[] aux = pRutaTXT.replace("\\", "/").split("/");
        String vNombreArchivo = aux[aux.length - 1];
        new CreaArchivo().creaXml(pRutaDestino, elementoRaiz, cabeceraDto, tipoEnvio, vNombreArchivo);
    }

    public String getFechaModBal() {
        return this.FechaModBal;
    }

    public void setFechaModBal(String fechaModBal) {
        this.FechaModBal = fechaModBal;
    }
}

