/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi;

import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import siti.conexion.BDUtil;
import siti.sinco.cfdi.test.testPDF;

public class ImportaXML {
    public static void leerCarpeta(BDUtil bdUtil, String pPathCarpeta, String modo, int niveles, String tipo) throws ParserConfigurationException, SAXException {
        testPDF pdf = null;
        int vComprobante = 0;
        String nombreArchivo = "";
        int numArchivos = 0;
        if (!pPathCarpeta.isEmpty()) {
            File pCarpeta = new File(pPathCarpeta);
            if (pCarpeta.exists() && pCarpeta.isDirectory()) {
                if (niveles == 1) {
                    pPathCarpeta = String.valueOf(pPathCarpeta) + File.separator + "INTERPRETADO";
                    pCarpeta = new File(pPathCarpeta);
                }
                System.out.println("Leyendo archivos de la carpeta: " + pPathCarpeta + " con tipo " + tipo);
                File[] pArchivosEncontrados = pCarpeta.listFiles();
                int x = 0;
                while (x < pArchivosEncontrados.length) {
                    if (pArchivosEncontrados[x].isDirectory() && niveles == 2) {
                        ImportaXML.leerCarpeta(bdUtil, pArchivosEncontrados[x].getAbsolutePath(), modo, niveles - 1, tipo);
                    }
                    if ((nombreArchivo = pArchivosEncontrados[x].getName().toUpperCase()).endsWith(".XML")) {
                        System.out.println("archivo a listar: " + nombreArchivo);
                        if (tipo.equals("FC") && (nombreArchivo.contains("APR") || nombreArchivo.contains("ATR") || nombreArchivo.contains("CES") || nombreArchivo.contains("MAN") || nombreArchivo.contains("MUE") || nombreArchivo.contains("PED") || nombreArchivo.contains("PTO")) || nombreArchivo.contains(tipo)) {
                            System.out.println("archivo a analizar: " + pArchivosEncontrados[x].getName());
                            vComprobante = ImportaXML.leerArchivoXML(bdUtil, pArchivosEncontrados[x].getAbsolutePath());
                            if (vComprobante > 0) {
                                String vRutaPDF = pArchivosEncontrados[x].getAbsolutePath();
                                pdf = new testPDF(1, vComprobante, "C:\\SITI\\APIMAZ\\CFDI", "@", bdUtil, 0, modo, "FC", 3, 0, vRutaPDF);
                                System.out.println("ARCHIVO PROCESO NUM: " + ++numArchivos);
                            }
                        } else if (tipo.equals("CB") && nombreArchivo.toUpperCase().contains("COB")) {
                            System.out.println("archivo a analizar: " + pArchivosEncontrados[x].getName());
                            vComprobante = ImportaXML.leerArchivoXML(bdUtil, pArchivosEncontrados[x].getAbsolutePath());
                            if (vComprobante > 0) {
                                pdf = new testPDF(1, vComprobante, "C:\\SITI\\APIMAZ\\CFDI", "@", bdUtil, 0, modo, "CB", 3, 0, pArchivosEncontrados[x].getAbsolutePath());
                                System.out.println("ARCHIVO PROCESO NUM: " + ++numArchivos);
                            }
                        } else if (tipo.equals("NC") && nombreArchivo.toUpperCase().contains("NCREDIT")) {
                            System.out.println("archivo a analizar: " + pArchivosEncontrados[x].getName());
                            vComprobante = ImportaXML.leerArchivoXML(bdUtil, pArchivosEncontrados[x].getAbsolutePath());
                            if (vComprobante > 0) {
                                pdf = new testPDF(1, vComprobante, "C:\\SITI\\APIMAZ\\CFDI", "@", bdUtil, 0, modo, "NC", 3, 0, pArchivosEncontrados[x].getAbsolutePath());
                                System.out.println("ARCHIVO PROCESO NUM: " + ++numArchivos);
                            }
                        } else if (tipo.equals("NM")) {
                            System.out.println("archivo a analizar: " + pArchivosEncontrados[x].getName());
                            vComprobante = ImportaXML.leerArchivoXML(bdUtil, pArchivosEncontrados[x].getAbsolutePath());
                            if (vComprobante > 0) {
                                pdf = new testPDF(1, vComprobante, "C:\\SITI\\APIMAZ\\CFDI", "@", bdUtil, 0, modo, "NM", 3, 0, pArchivosEncontrados[x].getAbsolutePath());
                                System.out.println("ARCHIVO PROCESO NUM: " + ++numArchivos);
                            }
                        }
                    }
                    ++x;
                }
                System.out.println("Se terminaron de leer los archivos de la carpeta:\n\t" + pPathCarpeta);
            } else {
                System.out.println("Favor de revisar el nombre de la carpeta, no existe.");
            }
        } else {
            System.out.println("No has seleccionado una carpeta.");
        }
    }

    public static int leerArchivoXML(BDUtil bdUtil, String pPathArchivo) throws ParserConfigurationException, SAXException {
        int vComprobante;
        block5: {
            vComprobante = 0;
            if (!pPathArchivo.isEmpty()) {
                try {
                    File file = new File(pPathArchivo);
                    if (file.exists()) {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document documentoXML = db.parse(file);
                        documentoXML.getDocumentElement().normalize();
                        String vSubtipodoc = "";
                        vSubtipodoc = file.getName().toUpperCase().contains("APR") ? "apr" : (file.getName().toUpperCase().contains("ATR") ? "atr" : (file.getName().toUpperCase().contains("CES") ? "ces" : (file.getName().toUpperCase().contains("COB") ? "cob" : (file.getName().toUpperCase().contains("MAN") ? "man" : (file.getName().toUpperCase().contains("MUE") ? "mue" : (file.getName().toUpperCase().contains("PED") ? "ped" : (file.getName().toUpperCase().contains("PTO") ? "pto" : (file.getName().toUpperCase().contains("NC") ? "ncr" : "nom"))))))));
                        System.out.println("Archivo: " + file.getName());
                        vComprobante = ImportaXML.subirComprobante(bdUtil, documentoXML, pPathArchivo, vSubtipodoc);
                        break block5;
                    }
                    System.out.print("Error: No existe el archivo indicado.");
                    vComprobante = -1;
                }
                catch (IOException e) {
                    System.out.println("Error: No se pudo abrir el archivo :" + e);
                    vComprobante = -1;
                }
            } else {
                System.out.println("Error: La ruta al archivo: " + pPathArchivo + " no es v\u00e1lida.");
                vComprobante = -1;
            }
        }
        System.out.println("Se termin\u00f3 de leer el archivo " + pPathArchivo);
        return vComprobante;
    }

    public static String getAtributo(Node pNodo, String pAtributo) {
        String vValor = null;
        if (pNodo != null) {
            int vLongitud = pNodo.getAttributes().getLength();
            if (vLongitud > 0) {
                NamedNodeMap vAtributos = pNodo.getAttributes();
                int i = 0;
                while (i < vLongitud) {
                    if (vAtributos.item(i).getNodeName().toUpperCase().equals(pAtributo.toUpperCase())) {
                        vValor = vAtributos.item(i).getNodeValue();
                        break;
                    }
                    ++i;
                }
                if (vValor == null) {
                    System.out.println("No se encontr\u00f3 el atributo: " + pAtributo + " en el nodo:" + pNodo.getNodeName());
                }
            } else {
                System.out.println("--- No contiene atributos el nodo: '" + pNodo.getNodeName() + "'");
            }
        }
        return vValor;
    }

    public static String getAtributoDe(Document pXML, String pEtiqueta, String pAtributo) {
        Node vNodoHijo = pXML.getElementsByTagName(pEtiqueta).item(0);
        String vValor = "";
        if (vNodoHijo != null) {
            vValor = ImportaXML.getAtributo(vNodoHijo, pAtributo);
        } else {
            System.out.println("--- No existe el nodo: '" + pEtiqueta + "'");
            vValor = null;
        }
        return vValor;
    }

    public static String getContenidoDe(Node pNodo, String pEtiqueta) {
        String vValor = null;
        Element vElement = (Element)pNodo;
        Node vNodo = vElement.getElementsByTagName(pEtiqueta).item(0);
        if (vNodo != null) {
            vValor = vElement.getElementsByTagName(pEtiqueta).item(0).getTextContent();
            System.out.println("Nodo: " + pNodo.getNodeName() + " Valor: " + vValor);
        } else {
            System.out.println("Etiqueta: " + pEtiqueta + " | No existe.");
        }
        return vValor;
    }

    public static Node getNodoDe(Document pXML, String pNodo) {
        Node vNodo = pXML.getElementsByTagName(pNodo).item(0);
        if (vNodo == null) {
            System.out.println("---Error: No existe el nodo '" + pNodo + "'.");
        }
        return vNodo;
    }

    public static String getAtributoHijoDe(Document pXML, String pNodoPadre, String pNodoHijo, String pAtributo) {
        String vValor = "";
        Node vNodoPadre = pXML.getElementsByTagName(pNodoPadre).item(0);
        if (vNodoPadre != null) {
            Element vElement = (Element)vNodoPadre;
            NodeList vListaNodosHijos = vElement.getElementsByTagName(pNodoHijo);
            Node vNodoHijo = null;
            int i = 0;
            while (i < vListaNodosHijos.getLength()) {
                if (vListaNodosHijos.item(i).getNodeType() == 1 && vListaNodosHijos.item(i).getParentNode() == vNodoPadre) {
                    vNodoHijo = vListaNodosHijos.item(i);
                }
                ++i;
            }
            if (vNodoHijo != null) {
                vValor = ImportaXML.getAtributo(vNodoHijo, pAtributo);
            } else {
                System.out.println("--- Etiqueta: " + pAtributo + " | No existe.");
                vValor = null;
            }
        } else {
            vValor = null;
        }
        return vValor;
    }

    public static Node getNodoHijoDe(Node pNodoPadre, String pNodoHijo) {
        Node vNodoR = null;
        if (pNodoPadre != null) {
            Element vElement = (Element)pNodoPadre;
            if (vElement.getElementsByTagName(pNodoHijo).item(0) != null) {
                vNodoR = vElement.getElementsByTagName(pNodoHijo).item(0);
            } else {
                System.out.println("--- Nodo '" + pNodoHijo + "' no existe.");
            }
        }
        return vNodoR;
    }

    public static Node getNodoNietoDe(Node pNodoAbuelo, String pNodoPadre, String pNodoNieto) {
        Node vPadre = null;
        Node vNodoR = null;
        Element vDescendenciaAbuelo = (Element)pNodoAbuelo;
        if (vDescendenciaAbuelo.getElementsByTagName(pNodoPadre).item(0) != null) {
            vPadre = vDescendenciaAbuelo.getElementsByTagName(pNodoPadre).item(0);
            vNodoR = ImportaXML.getNodoHijoDe(vPadre, pNodoNieto);
        } else {
            System.out.println("--- Nodo padre no existe.");
        }
        return vNodoR;
    }

    public static int subirComprobante(BDUtil pbdUtil, Document pDocumentoXML, String pPathArchivo, String pSubtipodoc) {
        int vNumComprobante;
        block34: {
            CallableStatement callStatement = null;
            String tipoDoc = "FC";
            vNumComprobante = 0;
            String paso = "0";
            System.out.println("SubtipoDoc:" + pSubtipodoc);
            if (pSubtipodoc.equals("ncr")) {
                tipoDoc = "NC";
            } else if (pSubtipodoc.equals("cob")) {
                tipoDoc = "CB";
            } else if (pSubtipodoc.equals("nom")) {
                tipoDoc = "NM";
            }
            String sentencia = "";
            sentencia = "{ call verifica_elimina_compr_import( ?, ?, ? ) }";
            try {
                callStatement = pbdUtil.connection.prepareCall(sentencia);
                callStatement.setString(1, tipoDoc);
                System.out.println("tipoDoc: " + tipoDoc);
                String vfolio = ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio");
                callStatement.setString(2, vfolio);
                System.out.println("---folio: " + vfolio);
                callStatement.registerOutParameter(3, 4);
                callStatement.execute();
                vNumComprobante = callStatement.getInt(3);
                System.out.println("vNumComprobante: " + vNumComprobante);
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
                System.out.println("folio=" + ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio"));
            }
            catch (Exception e) {
                System.out.println("Error en verifica_elimina_compr_import=" + e.toString());
            }
            if (vNumComprobante < 0) {
                sentencia = "{ call BDPKGCFD.insertarComprobantes(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) }";
                try {
                    try {
                        paso = "100";
                        callStatement = pbdUtil.connection.prepareCall(sentencia);
                        paso = "200";
                        callStatement.setInt(1, 1);
                        callStatement.setString(2, "API");
                        callStatement.setString(3, tipoDoc);
                        callStatement.setString(4, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio"));
                        callStatement.setString(5, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Version"));
                        callStatement.setString(6, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Serie"));
                        paso = "210";
                        if (pSubtipodoc.equals("cob")) {
                            if (ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio").length() > 6) {
                                callStatement.setInt(7, Integer.parseInt(ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio").substring(1, 5)));
                            } else {
                                callStatement.setInt(7, Integer.parseInt(ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio")));
                            }
                        } else {
                            callStatement.setInt(7, Integer.parseInt(ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Folio")));
                        }
                        paso = "220";
                        callStatement.setString(8, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Fecha"));
                        callStatement.setString(9, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Sello"));
                        callStatement.setString(10, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "noAprobacion"));
                        callStatement.setString(11, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "anoAprobacion"));
                        callStatement.setString(12, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "FormaPago"));
                        callStatement.setString(13, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "NoCertificado"));
                        paso = "230";
                        callStatement.setString(14, null);
                        callStatement.setString(15, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "SubTotal"));
                        paso = "231";
                        String vDescuento = ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Descuento");
                        if (vDescuento == null) {
                            callStatement.setString(16, vDescuento);
                        } else {
                            callStatement.setString(16, String.format("%,.2f", Float.valueOf(Float.parseFloat(vDescuento.replaceAll(",", "")))));
                        }
                        paso = "232";
                        callStatement.setString(17, null);
                        callStatement.setString(18, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Total"));
                        callStatement.setString(19, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "MetodoPago"));
                        callStatement.setString(20, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "TipoDeComprobante"));
                        paso = "240";
                        callStatement.setString(21, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Emisor", "Rfc"));
                        callStatement.setString(22, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Emisor", "Nombre"));
                        String pAuxCalle = ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "calle");
                        callStatement.setString(23, ImportaXML.nvl(pAuxCalle, "INT. RECINTO FISCAL"));
                        callStatement.setString(24, ImportaXML.nvl(ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "noExterior"), "S/N"));
                        callStatement.setString(25, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "noInterior"));
                        callStatement.setString(26, ImportaXML.nvl(ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "colonia"), "CENTRO"));
                        callStatement.setString(27, ImportaXML.nvl(ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "localidad"), "MAZATLAN"));
                        callStatement.setString(28, null);
                        String vDomicilioEmisor = ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "municipio");
                        callStatement.setString(29, ImportaXML.nvl(vDomicilioEmisor, "MAZATLAN"));
                        String vEstadoEmisor = ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "estado");
                        callStatement.setString(30, ImportaXML.nvl(vEstadoEmisor, "SINALOA"));
                        String vPaisEmisor = ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "pais");
                        callStatement.setString(31, ImportaXML.nvl(vPaisEmisor, "M\u00c9XICO"));
                        String vCodigoPostalEmisor = ImportaXML.getAtributoHijoDe(pDocumentoXML, "Emisor", "Domicilio", "codigoPostal");
                        callStatement.setString(32, ImportaXML.nvl(vCodigoPostalEmisor, "82000"));
                        callStatement.setString(33, null);
                        callStatement.setString(34, null);
                        callStatement.setString(35, null);
                        callStatement.setString(36, null);
                        callStatement.setString(37, null);
                        callStatement.setString(38, null);
                        callStatement.setString(39, null);
                        callStatement.setString(40, null);
                        callStatement.setString(41, null);
                        callStatement.setString(42, null);
                        paso = "\tRECEPTOR";
                        callStatement.setString(43, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Receptor", "Rfc"));
                        callStatement.setString(44, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Receptor", "Nombre"));
                        callStatement.setString(45, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "calle"));
                        callStatement.setString(46, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "noExterior"));
                        callStatement.setString(47, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "noInterior"));
                        callStatement.setString(48, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "colonia"));
                        callStatement.setString(49, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "localidad"));
                        callStatement.setString(50, null);
                        callStatement.setString(51, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "municipio"));
                        callStatement.setString(52, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "estado"));
                        String vPaisReceptor = ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "pais");
                        if (vPaisReceptor == null) {
                            vPaisReceptor = " ";
                        }
                        callStatement.setString(53, vPaisReceptor);
                        callStatement.setString(54, ImportaXML.getAtributoHijoDe(pDocumentoXML, "Receptor", "Domicilio", "codigoPostal"));
                        callStatement.setString(55, ImportaXML.getAtributoHijoDe(pDocumentoXML, "cfdi:Comprobante", "cfdi:Impuestos", "TotalImpuestosTrasladados"));
                        callStatement.setString(56, ImportaXML.getAtributoDe(pDocumentoXML, "Complemento", "conLetra"));
                        callStatement.setInt(57, 1);
                        callStatement.setString(58, null);
                        callStatement.setString(59, null);
                        callStatement.setString(60, null);
                        callStatement.setInt(61, 0);
                        callStatement.setString(62, null);
                        callStatement.setString(63, null);
                        callStatement.setString(64, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "Moneda"));
                        callStatement.setString(65, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "LugarExp\u00e9dicion"));
                        callStatement.setString(66, null);
                        callStatement.setString(67, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Emisor", "RegimenFiscal"));
                        callStatement.setString(68, null);
                        callStatement.setString(69, ImportaXML.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "Version"));
                        callStatement.setString(70, ImportaXML.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "UUID"));
                        callStatement.setString(71, ImportaXML.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "FechaTimbrado"));
                        callStatement.setString(72, ImportaXML.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "NoCertificadoSAT"));
                        callStatement.setString(73, ImportaXML.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "SelloSAT"));
                        callStatement.setString(74, null);
                        callStatement.setString(75, null);
                        callStatement.setString(76, null);
                        callStatement.setString(77, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "MetodoPago"));
                        callStatement.setString(78, ImportaXML.getAtributoHijoDe(pDocumentoXML, "cfdi:Complemento", "tfd:TimbreFiscalDigital", "Version"));
                        callStatement.setString(79, ImportaXML.getAtributoHijoDe(pDocumentoXML, "cfdi:Complemento", "tfd:TimbreFiscalDigital", "Version"));
                        callStatement.setString(80, null);
                        callStatement.setString(81, null);
                        callStatement.setString(82, null);
                        callStatement.setString(83, ImportaXML.getAtributoDe(pDocumentoXML, "cfdi:Comprobante", "MetodoPago"));
                        callStatement.setString(84, ImportaXML.getAtributoDe(pDocumentoXML, "tfd:TimbreFiscalDigital", "RfcProvCertif"));
                        callStatement.setString(85, null);
                        callStatement.setString(86, ImportaXML.getAtributoHijoDe(pDocumentoXML, "cfdi:Comprobante", "cfdi:Impuestos", "TotalImpuestosRetenidos"));
                        callStatement.setString(87, pSubtipodoc);
                        paso = "300";
                        callStatement.registerOutParameter(88, 4);
                        paso = "400";
                        callStatement.execute();
                        paso = "500";
                        vNumComprobante = callStatement.getInt(88);
                        System.out.println("--NUMERO DE COMPR0OBANTE:" + vNumComprobante);
                        if (!pSubtipodoc.equals("nom")) {
                            paso = "600";
                            ImportaXML.subirConceptos(pbdUtil, pDocumentoXML, vNumComprobante);
                            paso = "700";
                            ImportaXML.subirImpuestos(pbdUtil, pDocumentoXML, vNumComprobante);
                            paso = "800";
                            ImportaXML.subirComprobantesRelac(pbdUtil, pDocumentoXML, vNumComprobante);
                            paso = "900";
                            if (pSubtipodoc.equals("cob")) {
                                ImportaXML.subirComplementoPago(pbdUtil, pDocumentoXML, vNumComprobante);
                            }
                        } else {
                            paso = "520";
                            Node vComprobante = ImportaXML.getNodoDe(pDocumentoXML, "cfdi:Comprobante");
                            paso = "521";
                            ImportaXML.getComplementoDeNomina(pbdUtil, vComprobante, vNumComprobante);
                            paso = "522";
                        }
                        paso = "1000";
                        ImportaXML.subirMetadatos(pbdUtil, pDocumentoXML, vNumComprobante, pSubtipodoc);
                        paso = "1100";
                        ImportaXML.registrarLog(pbdUtil, vNumComprobante, pPathArchivo);
                        paso = "1200";
                        pbdUtil.connection.commit();
                        callStatement.close();
                        callStatement = null;
                    }
                    catch (Exception e) {
                        System.out.println("Error: al insertar en la BD COMPROBANTES. Paso: " + paso + " " + e.toString());
                        vNumComprobante = 0;
                        if (callStatement == null) break block34;
                        try {
                            callStatement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        callStatement = null;
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (callStatement != null) {
                        try {
                            callStatement.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        callStatement = null;
                    }
                    throw throwable;
                }
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            } else if (tipoDoc.equals("NC") || tipoDoc.equals("FC")) {
                System.out.println("La factura ya habia sido importada, s\u00f3lo se subir\u00e1 el concepto");
                ImportaXML.subirConceptos(pbdUtil, pDocumentoXML, vNumComprobante);
                ImportaXML.actualizaComprobante(pbdUtil, vNumComprobante, pDocumentoXML, pSubtipodoc);
            } else {
                vNumComprobante = -1;
            }
        }
        System.out.println("Termin\u00f3 ImportarXML");
        return vNumComprobante;
    }

    public static void subirConceptos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        Statement callStatement = null;
        Node vConceptos = pDocumentoXML.getElementsByTagName("cfdi:Conceptos").item(0);
        Node vComprobante = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        Node vHijo = null;
        String paso = "0";
        String sentencia = "{ call BDPKGCFD.Insertar_SATCFDCONCEPTOS(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) }";
        if (vConceptos != null) {
            try {
                NodeList vListaConceptos = vConceptos.getChildNodes();
                int longitud = vListaConceptos.getLength();
                int vNumConcepto = 0;
                int vNumImpuesto = 0;
                String vTipoImp = "";
                int i = 0;
                while (i < longitud) {
                    vHijo = vListaConceptos.item(i);
                    if (vHijo.getNodeType() == 1) {
                        ++vNumConcepto;
                        Node vImpuestos = ImportaXML.getNodoHijoDe(vListaConceptos.item(i), "cfdi:Impuestos");
                        if (vImpuestos != null) {
                            NodeList vListaImpuestos = vImpuestos.getChildNodes();
                            int vLongitudListaImpuestos = vListaImpuestos.getLength();
                            vNumImpuesto = 0;
                            int j = 0;
                            while (j < vLongitudListaImpuestos) {
                                if (vListaImpuestos.item(j).getNodeType() == 1) {
                                    ++vNumImpuesto;
                                    Node vTipoImpuesto = null;
                                    if (vListaImpuestos.item(j).getNodeName().toUpperCase().contains("CFDI:TRASLADOS")) {
                                        vTipoImpuesto = ImportaXML.getNodoHijoDe(vListaImpuestos.item(j), "cfdi:Traslado");
                                        vTipoImp = "T";
                                    } else {
                                        vTipoImpuesto = ImportaXML.getNodoHijoDe(vListaImpuestos.item(j), "cfdi:Retencion");
                                        vTipoImp = "R";
                                    }
                                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                                    callStatement.setInt(1, vNumConcepto);
                                    callStatement.setString(2, ImportaXML.getAtributo(vListaConceptos.item(i), "Cantidad"));
                                    callStatement.setString(3, ImportaXML.getAtributo(vListaConceptos.item(i), "Unidad"));
                                    callStatement.setString(4, ImportaXML.getAtributo(vListaConceptos.item(i), "NoIdentificacion"));
                                    callStatement.setString(5, ImportaXML.getAtributo(vListaConceptos.item(i), "Descripcion"));
                                    callStatement.setString(6, ImportaXML.getAtributo(vListaConceptos.item(i), "ValorUnitario"));
                                    callStatement.setString(7, String.format("%.2f", Float.valueOf(Float.parseFloat(ImportaXML.getAtributo(vListaConceptos.item(i), "Importe").replaceAll(",", "")))));
                                    callStatement.setString(8, ImportaXML.getAtributo(vTipoImpuesto, "Impuesto"));
                                    callStatement.setString(9, ImportaXML.getAtributo(vTipoImpuesto, "TasaOCuota"));
                                    callStatement.setString(10, ImportaXML.getAtributo(vTipoImpuesto, "Importe"));
                                    callStatement.setString(11, ImportaXML.getAtributo(vListaConceptos.item(i), "ClaveProdServ"));
                                    callStatement.setString(12, ImportaXML.getAtributo(vComprobante, "FormaPago"));
                                    String vDescuento = ImportaXML.getAtributo(vListaConceptos.item(i), "Descuento");
                                    vDescuento = vDescuento == null ? "0" : vDescuento.replaceAll(",", "");
                                    callStatement.setString(13, String.format("%.2f", Float.valueOf(Float.parseFloat(vDescuento))));
                                    callStatement.setString(14, ImportaXML.getAtributo(vTipoImpuesto, "Base"));
                                    callStatement.setString(15, ImportaXML.getAtributo(vTipoImpuesto, "TipoFactor"));
                                    callStatement.setInt(16, pComprobante);
                                    callStatement.execute();
                                    callStatement.close();
                                    callStatement = null;
                                    ImportaXML.subirImpuesto(pbdUtil, vTipoImpuesto, pComprobante, vNumConcepto, vNumImpuesto, vTipoImp);
                                }
                                ++j;
                            }
                        }
                        if (vHijo.getNodeName().toUpperCase().equals("CFDI:CONCEPTO") && vImpuestos == null) {
                            Node vImpuestos32 = ImportaXML.getNodoHijoDe(vComprobante, "cfdi:Impuestos");
                            callStatement = pbdUtil.connection.prepareCall(sentencia);
                            callStatement.setInt(1, vNumConcepto);
                            callStatement.setString(2, ImportaXML.getAtributo(vHijo, "cantidad"));
                            callStatement.setString(3, ImportaXML.getAtributo(vHijo, "unidad"));
                            callStatement.setString(4, ImportaXML.getAtributo(vHijo, "NoIdentificacion"));
                            callStatement.setString(5, ImportaXML.getAtributo(vHijo, "descripcion"));
                            callStatement.setString(6, ImportaXML.getAtributo(vHijo, "valorUnitario"));
                            callStatement.setString(7, String.format("%.2f", Float.valueOf(Float.parseFloat(ImportaXML.getAtributo(vHijo, "importe").replaceAll(",", "")))));
                            callStatement.setString(8, ImportaXML.getAtributo(vHijo, "Impuesto"));
                            callStatement.setString(9, ImportaXML.getAtributo(vHijo, "TasaOCuota"));
                            callStatement.setString(10, ImportaXML.nvl(ImportaXML.getAtributo(vImpuestos32, "totalImpuestosTrasladados"), "0"));
                            callStatement.setString(11, ImportaXML.nvl(ImportaXML.getAtributo(vHijo, "ClaveProdServ"), " "));
                            callStatement.setString(12, ImportaXML.nvl(ImportaXML.getAtributo(vComprobante, "formaPago"), " "));
                            String vDescuento = ImportaXML.getAtributo(vHijo, "descuento");
                            vDescuento = vDescuento == null ? "0" : vDescuento.replaceAll(",", "");
                            callStatement.setString(13, String.format("%.2f", Float.valueOf(Float.parseFloat(vDescuento))));
                            callStatement.setString(14, ImportaXML.getAtributo(vHijo, "Base"));
                            callStatement.setString(15, ImportaXML.getAtributo(vHijo, "TipoFactor"));
                            callStatement.setInt(16, pComprobante);
                            callStatement.execute();
                            callStatement.close();
                            callStatement = null;
                        }
                    }
                    ++i;
                }
                pbdUtil.connection.commit();
                if (callStatement != null) {
                    callStatement.close();
                    callStatement = null;
                }
            }
            catch (Exception e) {
                System.out.println("--- Error: No se pudo agregar concepto: " + e.toString());
            }
        } else {
            System.out.println("El documento no tiene CONCEPTO");
        }
    }

    public static void subirImpuesto(BDUtil pbdUtil, Node pNodo, int pComprobante, int pNumConcepto, int pNumImpuesto, String pTipoImpuesto) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarImpuestos(?,?,?,?,?,?,?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.setInt(2, pNumConcepto);
            callStatement.setInt(3, pNumImpuesto);
            callStatement.setString(4, pTipoImpuesto);
            callStatement.setString(5, ImportaXML.getAtributo(pNodo, "Base"));
            callStatement.setString(6, ImportaXML.getAtributo(pNodo, "Impuesto"));
            callStatement.setString(7, ImportaXML.getAtributo(pNodo, "TipoFactor"));
            callStatement.setString(8, ImportaXML.getAtributo(pNodo, "TasaOCuota"));
            callStatement.setString(9, ImportaXML.getAtributo(pNodo, "Importe"));
            callStatement.execute();
            pbdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
        }
        catch (Exception e) {
            System.out.println("Error: No se pudo agregar el impuesto al concepto. (SAT_CFDIMPUESTOS)" + e.toString());
        }
    }

    public static void subirImpuestos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        Statement callStatement = null;
        Node vNodoBase = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        Node vImpuestos = ImportaXML.getNodoHijoDe(vNodoBase, "cfdi:Impuestos");
        if (vImpuestos != null) {
            NodeList vListaImpuestos = vImpuestos.getChildNodes();
            Node vTipoImpuesto = null;
            String vNombrePadre = "";
            String vNombreNieto = "";
            String vOpcion = "";
            int i = 0;
            while (i < vListaImpuestos.getLength()) {
                if (vListaImpuestos.item(i).getNodeType() == 1) {
                    vNombrePadre = vListaImpuestos.item(i).getNodeName();
                    if (vNombrePadre.contains("cfdi:Traslados")) {
                        vNombreNieto = "cfdi:Traslado";
                        vOpcion = "T";
                    } else {
                        vNombreNieto = "cfdi:Retencion";
                        vOpcion = "R";
                    }
                    vTipoImpuesto = ImportaXML.getNodoNietoDe(vImpuestos, vNombrePadre, vNombreNieto);
                    String sentencia = "{ call bdPkgCfd.insertarImpuestosAgrupados(?,?,?,?,?,?)}";
                    try {
                        callStatement = pbdUtil.connection.prepareCall(sentencia);
                        callStatement.setInt(1, pComprobante);
                        callStatement.setString(2, vOpcion);
                        callStatement.setString(3, ImportaXML.getAtributo(vTipoImpuesto, "Impuesto"));
                        String vTipoFactor = ImportaXML.getAtributo(vTipoImpuesto, "TipoFactor");
                        if (vTipoFactor == null) {
                            vTipoFactor = " ";
                        }
                        callStatement.setString(4, vTipoFactor);
                        String vTasaOCuota = ImportaXML.getAtributo(vTipoImpuesto, "TasaOCuota");
                        if (vTasaOCuota == null) {
                            vTasaOCuota = " ";
                        }
                        callStatement.setString(5, vTasaOCuota);
                        callStatement.setString(6, ImportaXML.getAtributo(vTipoImpuesto, "Importe"));
                        callStatement.execute();
                        callStatement.close();
                        callStatement = null;
                    }
                    catch (Exception e) {
                        System.out.println("--- Error: No se pudo agregar impuesto agrupado. (sat_cfdimpuestosagrupados) " + e.toString());
                    }
                }
                ++i;
            }
        } else {
            System.out.println("--- No contiene el nodo 'Impuestos'");
        }
        try {
            pbdUtil.connection.commit();
            callStatement.close();
            callStatement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void subirPagos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        CallableStatement callStatement = null;
        Node vNodoBase = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        if (vNodoBase != null) {
            Node vComplemento = ImportaXML.getNodoHijoDe(vNodoBase, "cfdi:Complemento");
            Node vPagos = ImportaXML.getNodoHijoDe(vComplemento, "pago10:Pagos");
            Node vPago = ImportaXML.getNodoHijoDe(vPagos, "pago10:Pago");
            NodeList vListaPagos = vPago.getChildNodes();
            String sentencia = "{ call Insertar_CFDI_DoctoRelacionado(?,?,?,?,?,?)}";
            try {
                int i = 0;
                while (i < vListaPagos.getLength()) {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    callStatement.setInt(1, pComprobante);
                    callStatement.setString(2, "XML");
                    callStatement.setString(3, "");
                    callStatement.setString(4, "");
                    callStatement.setString(5, "");
                    callStatement.setString(6, "");
                    callStatement.execute();
                    callStatement.close();
                    callStatement = null;
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("Error: No se pudo agregar el Pago" + e.toString());
            }
        } else {
            System.out.println("Error: Revise el nombre del nodo Origen. No existe.");
        }
    }

    public static void subirMetadatos(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante, String pSubtipodoc) {
        block36: {
            block34: {
                Node vMetadatos = pDocumentoXML.getElementsByTagName("Metadata").item(0);
                System.out.println("SUBTIPO DE DOCUMENTO A CONSEGUIR EL METADATO " + pSubtipodoc);
                if (vMetadatos == null) break block34;
                switch (pSubtipodoc.toUpperCase()) {
                    case "APR": {
                        ImportaXML.getMetadatosAPR(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "ATR": {
                        ImportaXML.getMetadatosATR(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "CES": {
                        ImportaXML.getMetadatosCES(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "COB": {
                        ImportaXML.getMetadatosCOB(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "MAN": {
                        ImportaXML.getMetadatosMAN(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "MUE": {
                        ImportaXML.getMetadatosMUE(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "PED": {
                        ImportaXML.getMetadatosPED(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "PTO": {
                        ImportaXML.getMetadatosPTO(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "NCR": {
                        ImportaXML.getMetadatosNCR(pbdUtil, vMetadatos, pComprobante);
                        break;
                    }
                    case "NOM": {
                        ImportaXML.getMetadatosNomina(pbdUtil, vMetadatos, pComprobante);
                    }
                }
                break block36;
            }
            System.out.println("No existen metadatos.");
        }
    }

    public static void getMetadatosEstandar(CallableStatement pConsulta, Node pMetadatos, int pComprobante) throws SQLException {
        pConsulta.setInt(1, pComprobante);
        pConsulta.setString(2, ImportaXML.getContenidoDe(pMetadatos, "customData_FOLIO_SIP"));
        pConsulta.setString(3, ImportaXML.getContenidoDe(pMetadatos, "customData_TIPO_FACTURA"));
        pConsulta.setString(4, ImportaXML.getContenidoDe(pMetadatos, "auto_hostimpresora"));
        pConsulta.setString(5, ImportaXML.getContenidoDe(pMetadatos, "auto_nombreimpresora"));
        pConsulta.setInt(6, Integer.parseInt(ImportaXML.getContenidoDe(pMetadatos, "impresion_nocopias")));
        pConsulta.setString(7, ImportaXML.getContenidoDe(pMetadatos, "Leyenda_RFC"));
        pConsulta.setString(8, ImportaXML.getContenidoDe(pMetadatos, "ReferenciaBancaria"));
        pConsulta.setString(9, ImportaXML.getContenidoDe(pMetadatos, "cuentaBancaria"));
        pConsulta.setString(10, ImportaXML.getContenidoDe(pMetadatos, "regimenFiscal"));
        pConsulta.setString(11, ImportaXML.getContenidoDe(pMetadatos, "metodoPago"));
        pConsulta.setString(12, ImportaXML.getContenidoDe(pMetadatos, "formaPago"));
        pConsulta.setString(13, ImportaXML.getContenidoDe(pMetadatos, "usoCFDI"));
        pConsulta.setString(14, ImportaXML.getContenidoDe(pMetadatos, "tipoRelacion"));
    }

    public static void subirComplementoPago(BDUtil pbdUtil, Document pComprobante, int pNumComprobante) {
        block16: {
            Statement callStatement = null;
            System.out.println("INSERTANDO complemento pago");
            String sentencia = "{call BDPKGCFD.insertarComplementoPago(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
            try {
                try {
                    Node vComplemento = pComprobante.getElementsByTagName("cfdi:Complemento").item(0);
                    Element vEComplemento = (Element)vComplemento;
                    NodeList vListaPago10 = vEComplemento.getElementsByTagName("pago10:Pagos");
                    String vVersionPago = "";
                    int vLenPago10 = vListaPago10.getLength();
                    int vNumPago10 = 0;
                    Element vPago = null;
                    NodeList vListaPago = null;
                    int vLenPago = 0;
                    int i = 0;
                    while (i < vLenPago10) {
                        if (vListaPago10.item(i).getNodeType() == 1) {
                            ++vNumPago10;
                            vVersionPago = ImportaXML.getAtributo(vListaPago10.item(i), "Version");
                            vPago = (Element)vListaPago10.item(i);
                            vListaPago = vPago.getElementsByTagName("pago10:Pago");
                            vLenPago = vListaPago.getLength();
                            System.out.println("Numero de pagos: " + vLenPago);
                            int j = 0;
                            while (j < vLenPago) {
                                callStatement = pbdUtil.connection.prepareCall(sentencia);
                                if (vListaPago.item(j).getNodeType() == 1) {
                                    callStatement.setInt(1, pNumComprobante);
                                    callStatement.setInt(2, vNumPago10);
                                    callStatement.setString(3, String.valueOf(pNumComprobante));
                                    callStatement.setString(4, ImportaXML.getAtributo(vListaPago.item(j), "FechaPago"));
                                    callStatement.setString(5, ImportaXML.getAtributo(vListaPago.item(j), "FormaDePagoP"));
                                    callStatement.setString(6, ImportaXML.getAtributo(vListaPago.item(j), "MonedaP"));
                                    callStatement.setString(7, ImportaXML.getAtributo(vListaPago.item(j), "TipoCambioP"));
                                    callStatement.setString(8, ImportaXML.getAtributo(vListaPago.item(j), "Monto"));
                                    callStatement.setString(9, ImportaXML.getAtributo(vListaPago.item(j), "NumOperacion"));
                                    callStatement.setString(10, ImportaXML.getAtributo(vListaPago.item(j), "RFCEmisorCtaOrd"));
                                    callStatement.setString(11, ImportaXML.getAtributo(vListaPago.item(j), "NomBanCoordeXT"));
                                    callStatement.setString(12, ImportaXML.getAtributo(vListaPago.item(j), "CtaOrdenante"));
                                    callStatement.setString(13, ImportaXML.getAtributo(vListaPago.item(j), "RFCEMISORCTABEN"));
                                    callStatement.setString(14, ImportaXML.getAtributo(vListaPago.item(j), "CtaBeneficiario"));
                                    callStatement.setString(15, ImportaXML.getAtributo(vListaPago.item(j), "EMIS_RECEP"));
                                    callStatement.setString(16, ImportaXML.getAtributo(vListaPago.item(j), "BANCORECEPTOR"));
                                    callStatement.execute();
                                    pbdUtil.connection.commit();
                                    callStatement.close();
                                    callStatement = null;
                                    ImportaXML.subirDoctoRelacionado(pbdUtil, pNumComprobante, vNumPago10, vListaPago.item(j));
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("---Error: Al ejecutar al insertar en SAT_COMPLEMENTOPAGO. " + e.toString());
                    if (callStatement == null) break block16;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void subirDoctoRelacionado(BDUtil pbdUtil, int pNumComprobante, int pNumPago, Node pPago) {
        block14: {
            CallableStatement callStatement = null;
            String sentencia = "{call BDPKGCFD.insertarDoctoRelacionadoPago(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
            try {
                try {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    Element vDocto = (Element)pPago;
                    NodeList vListaDocto = vDocto.getElementsByTagName("pago10:DoctoRelacionado");
                    int vLenListaDocto = vListaDocto.getLength();
                    System.out.println("Total de DOCTO RELACIONADO " + vLenListaDocto);
                    int vNumDocto = 0;
                    int i = 0;
                    while (i < vLenListaDocto) {
                        System.out.println("Comprobante " + pNumComprobante + "Num De Pago " + pNumPago + " DoctoRelacionado " + i);
                        if (vListaDocto.item(i).getNodeType() == 1) {
                            callStatement.setInt(1, pNumComprobante);
                            callStatement.setInt(2, pNumPago);
                            callStatement.setInt(3, ++vNumDocto);
                            callStatement.setString(4, ImportaXML.getAtributo(vListaDocto.item(i), "IdDocumento"));
                            callStatement.setString(5, ImportaXML.getAtributo(vListaDocto.item(i), "Folio"));
                            callStatement.setString(6, ImportaXML.getAtributo(vListaDocto.item(i), "MonedaDR"));
                            callStatement.setString(7, ImportaXML.getAtributo(vListaDocto.item(i), "TIPOCAMBIODR"));
                            callStatement.setString(8, ImportaXML.getAtributo(vListaDocto.item(i), "MetodoDePagoDR"));
                            callStatement.setString(9, ImportaXML.getAtributo(vListaDocto.item(i), "NumParcialidad"));
                            callStatement.setString(10, ImportaXML.getAtributo(vListaDocto.item(i), "ImpSaldoAnt"));
                            callStatement.setString(11, ImportaXML.getAtributo(vListaDocto.item(i), "ImpPagado"));
                            callStatement.setString(12, ImportaXML.getAtributo(vListaDocto.item(i), "ImpSaldoInsoluto"));
                            callStatement.setString(13, ImportaXML.getAtributo(vListaDocto.item(i), "EMIS_RECEP"));
                            callStatement.setString(14, "1");
                            callStatement.setString(15, "API");
                            callStatement.setString(16, ImportaXML.getAtributo(vListaDocto.item(i), "PAGONUMPROV"));
                            callStatement.setString(17, ImportaXML.getAtributo(vListaDocto.item(i), "DETPAGNUM"));
                            callStatement.setString(18, ImportaXML.getAtributo(vListaDocto.item(i), "Serie"));
                            callStatement.execute();
                            pbdUtil.connection.commit();
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    System.out.println("---Error: No se pudo agregar a 'SAT_DOCTOSRELACIONADOSPAGOS.' " + e.toString());
                    if (callStatement == null) break block14;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void getMetadatosAPR(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        block12: {
            CallableStatement callStatement = null;
            String sentencia = "{ call bdPkgCfd.insertarMetadatosAPR(?,?,?, ?,?,?, ?,?,?, ?,?,?, ?,?,?, ?,? ) }";
            try {
                try {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
                    Node pComplemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
                    callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
                    callStatement.setString(16, ImportaXML.getAtributo(pComplemento, "observaciones"));
                    callStatement.setString(17, ImportaXML.getAtributo(pComplemento, "campoFact"));
                    callStatement.execute();
                    pbdUtil.connection.commit();
                }
                catch (Exception e) {
                    System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
                    if (callStatement == null) break block12;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void getMetadatosATR(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        block12: {
            CallableStatement callStatement = null;
            String sentencia = "{ call bdPkgCfd.insertarMetadatosATR(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
            try {
                try {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
                    callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
                    callStatement.setString(16, ImportaXML.getContenidoDe(pMetadatos, "customData_CVE_NAVIERA"));
                    callStatement.setString(17, ImportaXML.getContenidoDe(pMetadatos, "customData_AGENTE_NAVIERO"));
                    callStatement.setString(18, ImportaXML.getContenidoDe(pMetadatos, "customData_BUQUE"));
                    callStatement.setString(19, ImportaXML.getContenidoDe(pMetadatos, "customData_F_ATRAQUE"));
                    callStatement.setString(20, ImportaXML.getContenidoDe(pMetadatos, "customData_F_ENTREGA"));
                    Node complemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
                    callStatement.setString(21, ImportaXML.getAtributo(complemento, "observacion"));
                    callStatement.setString(22, ": " + ImportaXML.getAtributo(complemento, "estadia"));
                    callStatement.setString(23, ": " + ImportaXML.getAtributo(complemento, "estadiaMalTpo"));
                    callStatement.setString(24, "Eslora: " + ImportaXML.getAtributo(complemento, "eslora") + "     F. Atraque : " + ImportaXML.getAtributo(ImportaXML.getNodoHijoDe(pMetadatos, "Complemento"), "fAtraque"));
                    callStatement.setString(25, ImportaXML.getAtributo(complemento, "bandera"));
                    callStatement.setString(26, ImportaXML.getAtributo(complemento, "descBuque"));
                    callStatement.setString(27, "TRB:      " + ImportaXML.getAtributo(complemento, "TRB") + "     F. Desatraque: " + ImportaXML.getAtributo(complemento, "fDesatraque"));
                    callStatement.execute();
                    pbdUtil.connection.commit();
                }
                catch (Exception e) {
                    System.out.println("Error: No se pudieron subir los metadatos: " + e);
                    if (callStatement == null) break block12;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void getMetadatosCES(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        block12: {
            CallableStatement callStatement = null;
            String sentencia = "{ call bdPkgCfd.insertarMetadatosCES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
            try {
                try {
                    callStatement = pbdUtil.connection.prepareCall(sentencia);
                    ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
                    callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
                    Node pComplemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
                    callStatement.setString(16, ImportaXML.getAtributo(pComplemento, "observaciones"));
                    callStatement.setString(17, ImportaXML.getAtributo(pComplemento, "desTarifa"));
                    callStatement.setString(18, ImportaXML.getAtributo(pComplemento, "contrato"));
                    callStatement.setString(19, ImportaXML.getAtributo(pComplemento, "concesion"));
                    callStatement.execute();
                    pbdUtil.connection.commit();
                }
                catch (Exception e) {
                    System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
                    if (callStatement == null) break block12;
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    callStatement = null;
                }
            }
            finally {
                if (callStatement != null) {
                    try {
                        callStatement.close();
                    }
                    catch (SQLException sQLException) {}
                    callStatement = null;
                }
            }
        }
    }

    public static void getMetadatosCOB(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        CallableStatement callStatement = null;
        System.out.println("INSERTANDO METADATOS COB");
        String sentencia = "{ call BDPKGCFD.insertarMetadatosCOB(?,?,?,?,?,?,?,?,?,?,?,?) }";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.setString(2, ImportaXML.getContenidoDe(pMetadatos, "customData_Tipo_Factura"));
            callStatement.setString(3, ImportaXML.getContenidoDe(pMetadatos, "customData_PATENTE"));
            callStatement.setString(4, ImportaXML.getContenidoDe(pMetadatos, "customData_CVE_NAVIERA"));
            callStatement.setString(5, ImportaXML.getContenidoDe(pMetadatos, "Leyenda1"));
            callStatement.setString(6, ImportaXML.getContenidoDe(pMetadatos, "Leyenda2"));
            callStatement.setString(7, ImportaXML.getContenidoDe(pMetadatos, "Leyenda3"));
            callStatement.setString(8, ImportaXML.getContenidoDe(pMetadatos, "Leyenda4"));
            callStatement.setString(9, ImportaXML.getContenidoDe(pMetadatos, "Leyenda5"));
            Node vPago = ImportaXML.getNodoNietoDe(pMetadatos, "Pagos", "Pago");
            callStatement.setString(10, null);
            callStatement.setString(11, ImportaXML.getAtributo(vPago, "FormaPago"));
            Node vComprobanteMeta = ImportaXML.getNodoHijoDe(pMetadatos, "Comprobante");
            callStatement.setString(12, ImportaXML.getAtributo(vComprobanteMeta, "UsoCFDI"));
            callStatement.execute();
            pbdUtil.connection.commit();
            System.out.println("INSERT\u00d3 METADATOS COB");
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getMetadatosMAN(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarMetadatosMAN(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
            Node pComplemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
            callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
            callStatement.setString(16, ImportaXML.getContenidoDe(pMetadatos, "customData_CVE_NAVIERA"));
            callStatement.setString(17, ImportaXML.getContenidoDe(pMetadatos, "customData_AGENTE_NAVIERO"));
            callStatement.setString(18, ImportaXML.getAtributo(pComplemento, "observaciones"));
            callStatement.setString(19, "Buque: " + ImportaXML.getAtributo(pComplemento, "noBuque"));
            callStatement.setString(20, ImportaXML.getAtributo(pComplemento, "idViaje"));
            callStatement.setString(21, "Eslora: " + ImportaXML.getAtributo(pComplemento, "eslora"));
            callStatement.setString(22, "TRB: " + ImportaXML.getAtributo(pComplemento, "TRB"));
            callStatement.setString(23, ImportaXML.getAtributo(pComplemento, "solicitud"));
            callStatement.setString(24, ImportaXML.getAtributo(pComplemento, "factura"));
            callStatement.setString(25, ImportaXML.getAtributo(pComplemento, "bandera"));
            callStatement.execute();
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("Error: No se pudieron subir los metadatos: " + e);
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getMetadatosMUE(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarMetadatosMUE(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
            callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
            callStatement.setString(16, ImportaXML.getContenidoDe(pMetadatos, "customData_CVE_NAVIERA"));
            callStatement.setString(17, ImportaXML.getContenidoDe(pMetadatos, "customData_AGENTE_NAVIERO"));
            callStatement.setString(18, ImportaXML.getContenidoDe(pMetadatos, "customData_BUQUE"));
            callStatement.setString(19, ImportaXML.getContenidoDe(pMetadatos, "customData_F_ATRAQUE"));
            callStatement.setString(20, ImportaXML.getContenidoDe(pMetadatos, "customData_CLASE"));
            callStatement.setString(21, ImportaXML.getContenidoDe(pMetadatos, "customData_CONOCIMIENTO"));
            Node pComplemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
            callStatement.setString(22, ImportaXML.getAtributo(pComplemento, "tarifa"));
            callStatement.setString(23, ImportaXML.getAtributo(pComplemento, "observaciones"));
            callStatement.setString(24, ImportaXML.getAtributo(pComplemento, "id"));
            callStatement.setString(25, ImportaXML.getAtributo(pComplemento, "descBuque"));
            callStatement.setString(26, ImportaXML.getAtributo(pComplemento, "cantidad"));
            callStatement.setString(27, "Marcas y N\u00fameros:        Peso:    " + ImportaXML.getAtributo(pComplemento, "peso"));
            callStatement.setString(28, ImportaXML.getAtributo(pComplemento, "marca"));
            callStatement.execute();
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getMetadatosPED(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarMetadatosPED(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
            Node complemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
            callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_PATENTE"));
            callStatement.setString(16, ImportaXML.getContenidoDe(pMetadatos, "customData_AGENTE_ADUANAL"));
            callStatement.setString(17, "PEDIMENTOS: " + ImportaXML.getAtributo(complemento, "pedimentos"));
            callStatement.setString(18, ImportaXML.getAtributo(complemento, "descBuque"));
            callStatement.setString(19, "F-" + ImportaXML.getAtributo(complemento, "foliosip"));
            callStatement.setString(20, ImportaXML.getAtributo(complemento, "idViaje"));
            callStatement.setString(21, ImportaXML.getAtributo(complemento, "observaciones"));
            callStatement.setString(22, ImportaXML.getAtributo(complemento, "descTarifa"));
            callStatement.setString(23, ImportaXML.getAtributo(complemento, "cveAgente"));
            callStatement.execute();
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getMetadatosPTO(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarMetadatosPTO(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            ImportaXML.getMetadatosEstandar(callStatement, pMetadatos, pComprobante);
            callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
            callStatement.setString(16, ImportaXML.getContenidoDe(pMetadatos, "customData_CVE_NAVIERA"));
            callStatement.setString(17, ImportaXML.getContenidoDe(pMetadatos, "customData_AGENTE_NAVIERO"));
            callStatement.setString(18, ImportaXML.getContenidoDe(pMetadatos, "customData_BUQUE"));
            callStatement.setString(19, ImportaXML.getContenidoDe(pMetadatos, "customData_F_ATRAQUE"));
            callStatement.setString(20, ImportaXML.getContenidoDe(pMetadatos, "customData_F_ENTREGA"));
            Node complemento = ImportaXML.getNodoHijoDe(pMetadatos, "Complemento");
            callStatement.setString(21, "TRB:      " + ImportaXML.getAtributo(complemento, "TRB"));
            callStatement.setString(22, "F. Arribo : " + ImportaXML.getAtributo(complemento, "fArribo"));
            callStatement.setString(23, "F. Des. : " + ImportaXML.getAtributo(complemento, "fDesatrque"));
            callStatement.setString(24, ImportaXML.getAtributo(complemento, "observaciones"));
            callStatement.setString(25, ImportaXML.getAtributo(complemento, "facBuque"));
            callStatement.setString(26, ImportaXML.getAtributo(complemento, "bandera"));
            callStatement.execute();
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getMetadatosNCR(BDUtil pbdUtil, Node pMetadatos, int pComprobante) {
        CallableStatement callStatement = null;
        String sentencia = "{ call bdPkgCfd.insertarMetadatosNCR(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) }";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.setString(2, ImportaXML.getContenidoDe(pMetadatos, "customData_FOLIO_SIP"));
            callStatement.setString(3, ImportaXML.getContenidoDe(pMetadatos, "customData_TIPO_FACTURA"));
            callStatement.setString(4, ImportaXML.getContenidoDe(pMetadatos, "auto_hostimpresora"));
            callStatement.setString(5, ImportaXML.getContenidoDe(pMetadatos, "auto_nombreimpresora"));
            callStatement.setInt(6, Integer.parseInt(ImportaXML.getContenidoDe(pMetadatos, "impresion_nocopias")));
            callStatement.setString(7, ImportaXML.getContenidoDe(pMetadatos, "Leyenda_RFC"));
            callStatement.setString(8, ImportaXML.getContenidoDe(pMetadatos, "ReferenciaBancaria"));
            callStatement.setString(9, ImportaXML.getContenidoDe(pMetadatos, "cuentaBancaria"));
            callStatement.setString(10, ImportaXML.getContenidoDe(pMetadatos, "regimenFiscal"));
            callStatement.setString(11, ImportaXML.getContenidoDe(pMetadatos, "metodoPago"));
            callStatement.setString(12, ImportaXML.getContenidoDe(pMetadatos, "formaPago"));
            callStatement.setString(13, ImportaXML.getContenidoDe(pMetadatos, "usoCFDI"));
            callStatement.setString(14, ImportaXML.getContenidoDe(pMetadatos, "tipoRelacion"));
            callStatement.setString(15, ImportaXML.getContenidoDe(pMetadatos, "customData_T_IVA"));
            callStatement.execute();
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudieron subir los metadatos: " + e);
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void subirComprobantesRelac(BDUtil pbdUtil, Document pDocumentoXML, int pComprobante) {
        NodeList vCfdiRelacionado = pDocumentoXML.getElementsByTagName("cfdi:CfdiRelacionados");
        int vLonCfdi = vCfdiRelacionado.getLength();
        int vLonUuid = 0;
        if (vLonCfdi > 0) {
            Statement callStatement = null;
            String sentencia = "{ call bdPkgCfd.insertarComprobantesRelac(?,?,?,?) }";
            try {
                int i = 0;
                while (i < vLonCfdi) {
                    if (vCfdiRelacionado.item(i).getNodeType() == 1) {
                        Element vAux = (Element)vCfdiRelacionado.item(i);
                        NodeList vUUID = vAux.getElementsByTagName("cfdi:CfdiRelacionado");
                        vLonUuid = vUUID.getLength();
                        int j = 0;
                        while (j < vLonUuid) {
                            if (vUUID.item(j).getNodeType() == 1) {
                                callStatement = pbdUtil.connection.prepareCall(sentencia);
                                callStatement.setInt(1, pComprobante);
                                callStatement.setString(2, null);
                                callStatement.setString(3, ImportaXML.getAtributo(vCfdiRelacionado.item(i), "TipoRelacion"));
                                callStatement.setString(4, ImportaXML.getAtributo(vUUID.item(j), "UUID"));
                                callStatement.execute();
                                pbdUtil.connection.commit();
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("--- Error: No se pudieron subir los comprobantes relacionados. (subirComprobantesRelac): " + e);
            }
            if (callStatement != null) {
                try {
                    callStatement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                callStatement = null;
            }
        }
    }

    public static void registrarLog(BDUtil pbdUtil, int pComprobante, String pPathArchivo) {
        CallableStatement callStatement = null;
        String sentencia = "{ call BDPKGCFD.INSERTAR_SAT_LOGCARGACFD(?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pComprobante);
            callStatement.setString(2, "XML");
            callStatement.setString(3, pPathArchivo);
            callStatement.execute();
            try {
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudo agregar al LOG " + e.toString());
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getComplementoDeNomina(BDUtil pbdUtil, Node pComprobante, int pNumComprobante) {
        String paso = "";
        Node vComplemento = ImportaXML.getNodoHijoDe(pComprobante, "cfdi:Complemento");
        paso = "Complemento";
        Node vNomina = ImportaXML.getNodoSiEsNull(vComplemento, "nomina12:Nomina", "nomina:Nomina");
        paso = "Nomina";
        Node vEmisor = ImportaXML.getNodoSiEsNull(vNomina, "nomina12:Emisor", "nomina:Emisor");
        paso = "Emisor";
        Node vReceptor = ImportaXML.getNodoSiEsNull(vNomina, "nomina12:Receptor", "nomina:Receptor");
        paso = "Receptor";
        Node vPercepciones = ImportaXML.getNodoSiEsNull(vNomina, "nomina12:Percepciones", "nomina:Percepciones");
        paso = "Percepciones";
        Node vDeducciones = ImportaXML.getNodoSiEsNull(vNomina, "nomina12:Deducciones", "nomina:Deducciones");
        paso = "Deducciones";
        Node vOtrosPagos = ImportaXML.getNodoSiEsNull(vNomina, "nomina12:OtrosPagos", "nomina:OtrosPagos");
        paso = "OtrosPagos";
        Node vIndemnizacion = null;
        paso = "Indemnizacion";
        String vTotalGravadoPercepcion = "0.0";
        String vTotalExentoPercepcion = "0.0";
        String vTotalGravadoDeducion = "0.0";
        String vTotalExentoDeduccion = "0.0";
        String vTotalPercepciones = "0";
        String vtotalSueldos = "0";
        String vAnioServicio = null;
        String vUltimoSueldoMensOrd = null;
        String vIngresoAcumulable = null;
        String vIngresoNoAcumulable = null;
        String vPercepSinOtrosPagos = "0";
        String vPercepSubsidio = "0";
        String vImpuestosRetenidos = "0";
        String vDeducSinRetenidos = "0";
        String vTotalSeparIndemniza = null;
        String vTotalPagadoIndemnizacion = "0";
        Node aux = null;
        String vTotalPercepcion = "0";
        String vTotalDeduccion = "0";
        System.out.println("obteniendo valores del NODO PERCEPCIONES");
        if (vPercepciones != null) {
            vTotalGravadoPercepcion = ImportaXML.nvl(ImportaXML.getAtributo(vPercepciones, "TotalGravado"), "0.0");
            vTotalExentoPercepcion = ImportaXML.nvl(ImportaXML.getAtributo(vPercepciones, "TotalExento"), "0.0");
            vtotalSueldos = ImportaXML.getAtributo(vPercepciones, "TotalSueldos");
            vIndemnizacion = ImportaXML.getNodoHijoDe(vNomina, "nomina12:SeparacionIndemnizacion");
            vAnioServicio = ImportaXML.getAtributo(vIndemnizacion, "NumA\u00f1osServicio");
            vUltimoSueldoMensOrd = ImportaXML.getAtributo(vIndemnizacion, "UltimoSueldoMensOrd");
            vIngresoAcumulable = ImportaXML.getAtributo(vIndemnizacion, "IngresoAcumulable");
            vIngresoNoAcumulable = ImportaXML.getAtributo(vIndemnizacion, "IngresoNoAcumulable");
            vTotalPercepciones = ImportaXML.getAtributo(vIndemnizacion, "TotalGravado");
            vTotalPercepcion = vTotalGravadoPercepcion;
        }
        System.out.println("obteniendo valores del NODO DEDUCCIONES");
        if (vDeducciones != null) {
            vTotalGravadoDeducion = ImportaXML.nvl(ImportaXML.getAtributo(vDeducciones, "TotalGravado"), "0.0");
            vTotalExentoDeduccion = ImportaXML.nvl(ImportaXML.getAtributo(vDeducciones, "TotalExento"), "0.0");
            NodeList listaDeducciones = vDeducciones.getChildNodes();
            float vImpuestosRetenidosAux = 0.0f;
            float vDeducSinRetenidosAux = 0.0f;
            int i = 0;
            while (i < listaDeducciones.getLength()) {
                aux = listaDeducciones.item(i);
                if (aux.getNodeType() == 1) {
                    if (ImportaXML.getAtributo(aux, "TipoDeduccion").equals("002")) {
                        vImpuestosRetenidosAux += Float.parseFloat(ImportaXML.nvl(ImportaXML.getAtributoSiEsNull(aux, "Importe", "ImporteExento"), "0"));
                    } else {
                        vDeducSinRetenidosAux += Float.parseFloat(ImportaXML.nvl(ImportaXML.getAtributoSiEsNull(aux, "Importe", "ImporteExento"), "0"));
                    }
                }
                ++i;
            }
            vImpuestosRetenidos = String.format("%.2f", Float.valueOf(vImpuestosRetenidosAux));
            vDeducSinRetenidos = String.format("%.2f", Float.valueOf(vDeducSinRetenidosAux));
            vTotalDeduccion = String.format("%.2f", Float.valueOf(Float.parseFloat(vImpuestosRetenidos) + Float.parseFloat(vDeducSinRetenidos)));
            paso = "Boque deducciones";
        }
        System.out.println("obteniendo valores del NODO OTROSPAGOS");
        String vPerceptOtrosPagos = "0";
        float vPerceptOtrosPagosNum = 0.0f;
        String vSaldoAFavor = null;
        String vRemanenteAlFav = null;
        String vAnioSF = null;
        if (vOtrosPagos != null) {
            NodeList vListaOtrosPagos = vOtrosPagos.getChildNodes();
            int i = 0;
            while (i < vListaOtrosPagos.getLength()) {
                aux = vListaOtrosPagos.item(i);
                if (aux.getNodeType() == 1) {
                    System.out.println("Otros pagos: " + ImportaXML.getAtributo(aux, "Importe"));
                    vPerceptOtrosPagosNum += Float.parseFloat(ImportaXML.nvl(ImportaXML.getAtributo(aux, "Importe"), "0"));
                    if (ImportaXML.getAtributo(aux, "Clave").equals("009")) {
                        Node vCompensacionSaldosAFavor = ImportaXML.getNodoHijoDe(aux, "nomina12:CompensacionSaldosAFavor");
                        vSaldoAFavor = ImportaXML.getAtributo(vCompensacionSaldosAFavor, "SaldoAFavor");
                        vRemanenteAlFav = ImportaXML.getAtributo(vCompensacionSaldosAFavor, "RemanenteSalFav");
                        vAnioSF = ImportaXML.getAtributo(vCompensacionSaldosAFavor, "A\u00f1o");
                    }
                }
                ++i;
            }
            vPerceptOtrosPagos = String.format("%.2f", Float.valueOf(vPerceptOtrosPagosNum));
            paso = "Bloque otrosPagos";
        }
        String vRegistroPatronal = "";
        vRegistroPatronal = vEmisor != null ? ImportaXML.getAtributo(vEmisor, "RegistroPatronal") : ImportaXML.getAtributo(vNomina, "RegistroPatronal");
        String vNumEmpleado = "";
        String vCurp = "";
        String vTipoRegimen = "";
        String vNumSeguridadSocial = "";
        String vAntiguedad = "";
        String vDepartamento = "";
        String vPeriodicidadPago = "";
        String vTipoJornada = "";
        String vRiesgoPuesto = "";
        String vPuesto = "";
        String vTipoContrato = "";
        String vSalarioBaseCotApor = "";
        String vSalarioDiarioIntegrado = "";
        String vFechaInicioRelLaboral = "";
        if (vReceptor != null) {
            vNumEmpleado = ImportaXML.getAtributo(vReceptor, "NumEmpleado");
            vCurp = ImportaXML.getAtributo(vReceptor, "Curp");
            vTipoRegimen = ImportaXML.getAtributo(vReceptor, "TipoRegimen");
            vNumSeguridadSocial = ImportaXML.getAtributo(vReceptor, "NumSeguridadSocial");
            vAntiguedad = ImportaXML.getAtributo(vReceptor, "Antig\u00fcedad");
            vDepartamento = ImportaXML.getAtributo(vReceptor, "Departamento");
            vPeriodicidadPago = ImportaXML.getAtributo(vReceptor, "PeriodicidadPago");
            vTipoJornada = ImportaXML.getAtributo(vReceptor, "TipoJornada");
            vRiesgoPuesto = ImportaXML.getAtributo(vReceptor, "RiesgoPuesto");
            vPuesto = ImportaXML.getAtributo(vReceptor, "Puesto");
            vTipoContrato = ImportaXML.getAtributo(vReceptor, "TipoContrato");
            vSalarioBaseCotApor = ImportaXML.getAtributo(vReceptor, "SalarioBaseCotApor");
            vSalarioDiarioIntegrado = ImportaXML.getAtributo(vReceptor, "SalarioDiarioIntegrado");
            vFechaInicioRelLaboral = ImportaXML.getAtributo(vReceptor, "FechaInicioRelLaboral");
        } else {
            vNumEmpleado = ImportaXML.getAtributo(vNomina, "NumEmpleado");
            vCurp = ImportaXML.getAtributo(vNomina, "CURP");
            vTipoRegimen = ImportaXML.getAtributo(vNomina, "TipoRegimen");
            vNumSeguridadSocial = ImportaXML.getAtributo(vNomina, "NumSeguridadSocial");
            vAntiguedad = ImportaXML.getAtributo(vNomina, "Antiguedad");
            vDepartamento = ImportaXML.getAtributo(vNomina, "Departamento");
            vPeriodicidadPago = ImportaXML.getAtributo(vNomina, "PeriodicidadPago");
            vTipoJornada = ImportaXML.getAtributo(vNomina, "TipoJornada");
            vRiesgoPuesto = ImportaXML.getAtributo(vNomina, "RiesgoPuesto");
            vPuesto = ImportaXML.getAtributo(vNomina, "Puesto");
            vTipoContrato = ImportaXML.getAtributo(vNomina, "TipoContrato");
            vSalarioBaseCotApor = ImportaXML.getAtributo(vNomina, "SalarioBaseCotApor");
            vSalarioDiarioIntegrado = ImportaXML.getAtributo(vNomina, "SalarioDiarioIntegrado");
            vFechaInicioRelLaboral = ImportaXML.getAtributo(vNomina, "FechaInicioRelLaboral");
        }
        System.out.println("Comenzanco a subir en COMPLEMENTO NOMINA");
        CallableStatement callStatement = null;
        String sentencia = "{ call INSERTA_sat_complementonomina(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pNumComprobante);
            paso = "1";
            callStatement.setString(2, ImportaXML.getAtributo(pComprobante, "Folio"));
            paso = "2";
            callStatement.setString(3, "3");
            paso = "3";
            callStatement.setString(4, ImportaXML.getAtributo(vNomina, "Version"));
            paso = "5";
            callStatement.setString(5, vRegistroPatronal);
            paso = "6";
            callStatement.setString(6, vNumEmpleado);
            paso = "7";
            callStatement.setString(7, vCurp);
            paso = "8";
            callStatement.setString(8, vTipoRegimen);
            paso = "9";
            callStatement.setString(9, vNumSeguridadSocial);
            paso = "10";
            callStatement.setString(10, ImportaXML.getAtributo(vNomina, "FechaPago"));
            paso = "11";
            callStatement.setString(11, ImportaXML.getAtributo(vNomina, "FechaInicialPago"));
            paso = "12";
            callStatement.setString(12, ImportaXML.getAtributo(vNomina, "FechaFinalPago"));
            paso = "13";
            callStatement.setString(13, ImportaXML.getAtributo(vNomina, "NumDiasPagados"));
            paso = "14";
            callStatement.setString(14, vDepartamento);
            paso = "15";
            callStatement.setString(15, ImportaXML.getAtributo(vReceptor, "CuentaBancaria"));
            paso = "16";
            callStatement.setString(16, ImportaXML.getAtributo(vReceptor, "Banco"));
            paso = "17";
            callStatement.setString(17, vFechaInicioRelLaboral);
            paso = "18";
            callStatement.setString(18, vAntiguedad);
            paso = "19";
            callStatement.setString(19, vPuesto);
            paso = "20";
            callStatement.setString(20, vTipoContrato);
            paso = "21";
            callStatement.setString(21, vTipoJornada);
            paso = "22";
            callStatement.setString(22, vPeriodicidadPago);
            paso = "23";
            callStatement.setString(23, vSalarioBaseCotApor);
            paso = "24";
            callStatement.setString(24, vRiesgoPuesto);
            paso = "25";
            callStatement.setString(25, vSalarioDiarioIntegrado);
            paso = "26";
            callStatement.setString(26, vTotalGravadoPercepcion);
            paso = "27";
            callStatement.setString(27, vTotalExentoPercepcion);
            paso = "28";
            callStatement.setString(28, vTotalGravadoDeducion);
            paso = "29";
            callStatement.setString(29, vTotalExentoDeduccion);
            paso = "30";
            callStatement.setString(30, ImportaXML.getAtributo(vReceptor, "Infonavita"));
            paso = "31";
            callStatement.setString(31, ImportaXML.getAtributo(vReceptor, "Gravablea"));
            paso = "32";
            callStatement.setString(32, ImportaXML.getAtributo(vReceptor, "ISPT"));
            paso = "33";
            callStatement.setString(33, ImportaXML.getAtributo(vReceptor, "ISRTAB"));
            paso = "34";
            callStatement.setString(34, ImportaXML.getAtributo(vReceptor, "CSTAB"));
            paso = "35";
            callStatement.setString(35, ImportaXML.getAtributo(vReceptor, "SUBTAB"));
            paso = "36";
            callStatement.setString(36, ImportaXML.getAtributo(vReceptor, "SalarioDiario"));
            paso = "37";
            callStatement.setString(37, ImportaXML.getAtributo(vNomina, "TipoNomina"));
            paso = "38";
            callStatement.setString(38, ImportaXML.nvl(ImportaXML.getAtributo(vReceptor, "ClaveEntFed"), "SIN"));
            paso = "39";
            callStatement.setString(39, vPercepSinOtrosPagos);
            paso = "40";
            callStatement.setString(40, vPercepSubsidio);
            paso = "41";
            callStatement.setString(41, vImpuestosRetenidos);
            paso = "42";
            callStatement.setString(42, vDeducSinRetenidos);
            paso = "43";
            callStatement.setString(43, vTotalSeparIndemniza);
            paso = "44";
            callStatement.setString(44, vTotalPagadoIndemnizacion);
            paso = "45";
            callStatement.setString(45, vAnioServicio);
            paso = "46";
            callStatement.setString(46, vUltimoSueldoMensOrd);
            paso = "47";
            callStatement.setString(47, vIngresoAcumulable);
            paso = "48";
            callStatement.setString(48, vIngresoNoAcumulable);
            paso = "49";
            callStatement.setString(49, "0");
            paso = "50";
            callStatement.setString(50, vPerceptOtrosPagos);
            paso = "51";
            callStatement.setString(51, null);
            paso = "52";
            callStatement.setString(52, ImportaXML.getAtributo(vReceptor, "Sindicalizado"));
            paso = "53";
            callStatement.setString(53, ImportaXML.nvl(ImportaXML.getAtributo(vNomina, "TotalPercepciones"), vTotalPercepcion));
            paso = "54";
            callStatement.setString(54, ImportaXML.nvl(ImportaXML.getAtributo(vNomina, "TotalDeducciones"), vTotalDeduccion));
            paso = "55";
            callStatement.setString(55, ImportaXML.getAtributo(vEmisor, "Rfc"));
            paso = "56";
            callStatement.setString(56, vtotalSueldos);
            paso = "57";
            callStatement.setString(57, vSaldoAFavor);
            paso = "58";
            callStatement.setString(58, vAnioSF);
            paso = "59";
            callStatement.setString(59, vRemanenteAlFav);
            paso = "fin";
            callStatement.execute();
            try {
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImportaXML.insertaSAT_PERCEPCIONES_DEDUCCIONES(pbdUtil, vPercepciones, pNumComprobante);
            ImportaXML.insertaSAT_PERCEPCIONES_DEDUCCIONES(pbdUtil, vDeducciones, pNumComprobante);
            ImportaXML.insertaSAT_PERCEPCIONES_DEDUCCIONES(pbdUtil, vOtrosPagos, pNumComprobante);
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudo insertar en ComplementoDeNomina. Paso: " + paso + " ERROR:" + e.toString());
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void getMetadatosNomina(BDUtil pbdUtil, Node pMetadatos, int pNumComprobante) {
        Node comprobante = ImportaXML.getNodoHijoDe(pMetadatos, "Comprobante");
        if (comprobante == null) {
            comprobante = ImportaXML.getNodoHijoDe(pMetadatos.getParentNode(), "cfdi:Comprobante");
        }
        CallableStatement callStatement = null;
        String sentencia = "{ call INSERTA_METADATOS_NOMINA(?,?,?,?,?)}";
        try {
            callStatement = pbdUtil.connection.prepareCall(sentencia);
            callStatement.setInt(1, pNumComprobante);
            callStatement.setString(2, "NOMINA");
            callStatement.setString(3, ImportaXML.getAtributoSiEsNull(comprobante, "MetodoPago", "metodoDePago"));
            callStatement.setString(4, ImportaXML.getAtributoSiEsNull(comprobante, "FormaPago", "formaDePago"));
            callStatement.setString(5, ImportaXML.getContenidoDe(pMetadatos, "customData_USERNAME_REGISTRO"));
            callStatement.execute();
            try {
                pbdUtil.connection.commit();
                callStatement.close();
                callStatement = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.out.println("--- Error: No se pudo insertar en METADATOS_NOMINA" + e.toString());
        }
        if (callStatement != null) {
            try {
                callStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            callStatement = null;
        }
    }

    public static void insertaSAT_PERCEPCIONES_DEDUCCIONES(BDUtil pbdUtil, Node pPercepcionDeduccionOtroPago, int pNumComprobante) {
        if (pPercepcionDeduccionOtroPago != null) {
            String vPercep_deduc = null;
            String vOtrosPagos = null;
            String vNombreNodoHijo = null;
            String vAtributoImporte = null;
            String vAtributoTipo = null;
            String vNombreNodo = pPercepcionDeduccionOtroPago.getNodeName().toUpperCase();
            System.out.println("Nombre nodo percepcion Deduccion OtrosPagos: " + vNombreNodo);
            if (vNombreNodo.contains("PERCEPCION")) {
                vPercep_deduc = "P";
                vOtrosPagos = "0";
                vNombreNodoHijo = "PERCEPCION";
                vAtributoImporte = "ImporteGravado";
                vAtributoTipo = "TipoPercepcion";
            } else if (vNombreNodo.contains("DEDUCCION")) {
                vPercep_deduc = "D";
                vNombreNodoHijo = "DEDUCCION";
                vAtributoImporte = "Importe";
                vAtributoTipo = "TipoDeduccion";
            } else if (vNombreNodo.contains("OTROSPAGOS")) {
                vPercep_deduc = "P";
                vOtrosPagos = "1";
                vNombreNodoHijo = "OTROPAGO";
                vAtributoImporte = "Importe";
                vAtributoTipo = "TipoOtroPago";
            }
            NodeList vListaNodosHijos = pPercepcionDeduccionOtroPago.getChildNodes();
            Statement callStatement = null;
            String sentencia = "{ call INSERTA_PERCEPCION_DEDUCCION(?,?,?,?,?,?,?,?,?)}";
            try {
                Node nodoAux = null;
                int i = 0;
                while (i < vListaNodosHijos.getLength()) {
                    nodoAux = vListaNodosHijos.item(i);
                    if (nodoAux.getNodeType() == 1 && nodoAux.getNodeName().toUpperCase().contains(vNombreNodoHijo)) {
                        callStatement = pbdUtil.connection.prepareCall(sentencia);
                        callStatement.setInt(1, pNumComprobante);
                        callStatement.setString(2, vPercep_deduc);
                        callStatement.setString(3, ImportaXML.getAtributo(nodoAux, vAtributoTipo));
                        callStatement.setString(4, ImportaXML.getAtributo(nodoAux, "Clave"));
                        callStatement.setString(5, ImportaXML.getAtributo(nodoAux, "Concepto"));
                        callStatement.setString(6, ImportaXML.getAtributoSiEsNull(nodoAux, vAtributoImporte, "ImporteGravado"));
                        callStatement.setString(7, ImportaXML.nvl(ImportaXML.getAtributo(nodoAux, "ImporteExento"), "0"));
                        callStatement.setString(8, "0");
                        callStatement.setString(9, vOtrosPagos);
                        callStatement.execute();
                        try {
                            pbdUtil.connection.commit();
                            callStatement.close();
                            callStatement = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("--- Error: No se pudo insertar en SAT_PERCEPCIONES_DEDUCCIONES" + e.toString());
            }
            if (callStatement != null) {
                try {
                    callStatement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                callStatement = null;
            }
        }
    }

    public static void actualizaComprobante(BDUtil pbdUtil, int pNumComprobante, Document pDocumentoXML, String pSubtipoDoc) {
        Node vComprobante = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        Node vEmisor = ImportaXML.getNodoHijoDe(vComprobante, "cfdi:Emisor");
        Node vReceptor = ImportaXML.getNodoHijoDe(vComprobante, "cfdi:Receptor");
        Node vDomicilioEmisor = ImportaXML.getNodoHijoDe(vEmisor, "cfdi:DomicilioFiscal");
        Node vDomicilioReceptor = ImportaXML.getNodoHijoDe(vReceptor, "cfdi:Domicilio");
        Node vRegimenFiscalEmisor = ImportaXML.getNodoHijoDe(vEmisor, "cfdi:RegimenFiscal");
        String vSentencia = "";
        vSentencia = "UPDATE comprobantes SET \tmetodoDePago = '" + ImportaXML.getAtributo(vComprobante, "metodoDePago") + "', " + "\t\tformaDePago =  '" + ImportaXML.getAtributo(vComprobante, "formaDePago") + "', " + "\t\tcalleEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "calle") + "', " + "\t\tcoloniaEmisor =  '" + ImportaXML.nvl(ImportaXML.getAtributo(vDomicilioEmisor, "colonia"), " ") + "', " + "\t\testadoEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "estado") + "', " + "\t\tpaisEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "pais") + "', " + "\t\tcodigoPostalEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "codigoPostal") + "', " + "\t\tlocalidadEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "localidad") + "', " + "\t\tnoExteriorEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "noExterior") + "', " + "\t\tmunicipioEmisor =  '" + ImportaXML.getAtributo(vDomicilioEmisor, "municipio") + "', " + "\t\tregimen\t\t\t =  '" + ImportaXML.getAtributo(vRegimenFiscalEmisor, "Regimen") + "', " + "\t\tcalleReceptor =  '" + ImportaXML.getAtributo(vDomicilioReceptor, "calle") + "', " + "\t\tcoloniaReceptor =  '" + ImportaXML.getAtributo(vDomicilioReceptor, "colonia") + "', " + "\t\testadoReceptor =  '" + ImportaXML.getAtributo(vDomicilioReceptor, "estado") + "', " + "\t\tpaisReceptor =  '" + ImportaXML.getAtributo(vDomicilioReceptor, "pais") + "', " + "\t\tcodigoPostalReceptor =  '" + ImportaXML.getAtributo(vDomicilioReceptor, "codigoPostal") + "', " + "\t\tlocalidadReceptor =  '" + ImportaXML.getAtributo(vDomicilioReceptor, "localidad") + "' " + "WHERE \tcomprobante = '" + pNumComprobante + "' ";
        try {
            pbdUtil.ejecutaSentencia(vSentencia);
            pbdUtil.connection.commit();
            ImportaXML.actualizaMetadatosX(pbdUtil, pNumComprobante, pDocumentoXML, pSubtipoDoc);
        }
        catch (Exception e) {
            System.out.println("Error: No se pudo actualizar el comprobante" + pNumComprobante + "\n" + " Raz\u00f3n: " + e.toString());
        }
    }

    public static void actualizaMetadatosX(BDUtil pbdUtil, int pNumComprobante, Document pDocumentoXML, String pSubtipoDoc) {
        Node vComprobante = pDocumentoXML.getElementsByTagName("cfdi:Comprobante").item(0);
        Node vEmisor = ImportaXML.getNodoHijoDe(vComprobante, "cfdi:Emisor");
        Node vRegimenFiscalEmisor = ImportaXML.getNodoHijoDe(vEmisor, "cfdi:RegimenFiscal");
        String vSentencia = "";
        String vSubtipodoc = "";
        vSubtipodoc = pSubtipoDoc.toUpperCase().contains("APR") ? "aprovechamiento" : (pSubtipoDoc.toUpperCase().contains("ATR") ? "atraque" : (pSubtipoDoc.toUpperCase().contains("CES") ? "ces" : (pSubtipoDoc.toUpperCase().contains("COB") ? "cob" : (pSubtipoDoc.toUpperCase().contains("MAN") ? "maniobras" : (pSubtipoDoc.toUpperCase().contains("MUE") ? "muellaje" : (pSubtipoDoc.toUpperCase().contains("PED") ? "pedimento" : (pSubtipoDoc.toUpperCase().contains("PTO") ? "puerto" : (pSubtipoDoc.toUpperCase().contains("NC") ? "ncr" : "nomina"))))))));
        vSentencia = "UPDATE metadatos_" + vSubtipodoc + " " + "SET \tmetodoPago = '" + ImportaXML.getAtributo(vComprobante, "metodoDePago") + "', " + "\t\tregimenFiscal = '" + ImportaXML.getAtributo(vRegimenFiscalEmisor, "Regimen") + "',  " + "\t\tformaPago =  '" + ImportaXML.getAtributo(vComprobante, "formaDePago") + "'  " + "WHERE \tcomprobante = '" + pNumComprobante + "' ";
        try {
            pbdUtil.ejecutaSentencia(vSentencia);
            pbdUtil.connection.commit();
        }
        catch (Exception e) {
            System.out.println("Error: No se pudo actualizar el METADATO_X comprobante" + pNumComprobante + "\n" + " Raz\u00f3n: " + e.toString());
        }
    }

    public static String nvl(String pValor, String pValorSiEsNull) {
        if (pValor == null) {
            return pValorSiEsNull;
        }
        return pValor;
    }

    public static Node getNodoSiEsNull(Node pNodoOrigen, String pNodoPrimario, String pNodoSecundario) {
        Node vNodo = ImportaXML.getNodoHijoDe(pNodoOrigen, pNodoPrimario);
        if (vNodo == null) {
            vNodo = ImportaXML.getNodoHijoDe(pNodoOrigen, pNodoSecundario);
        }
        return vNodo;
    }

    public static String getAtributoSiEsNull(Node pNodoOrigen, String pAtributoPrimario, String pAtributoSecundario) {
        String vValor = ImportaXML.getAtributo(pNodoOrigen, pAtributoPrimario);
        if (vValor == null) {
            vValor = ImportaXML.getAtributo(pNodoOrigen, pAtributoSecundario);
        }
        return vValor;
    }
}

