/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.pdf;

import java.io.File;
import siti.conexion.LeeConexion;
import siti.sinco.cfdi.dto.ComprobanteDTO;
import siti.sinco.cfdi.dto.ConfiguracionDTO;
import siti.sinco.cfdi.pdf.CFDenPDFSitiFact;
import siti.sinco.cfdi.pdf.CFDenPDFSitiPago;
import siti.sinco.cfdi.pdf.CFDenPDFSitiRecibo;

public class PDFBuilder {
    ComprobanteDTO comprobante;
    ConfiguracionDTO configuracion;
    boolean isCraftable;
    private String ruta;
    private String tipoDoc;
    private String modo;
    private int preview;
    private String sobreEscribe;

    public PDFBuilder(ComprobanteDTO objComprobante, ConfiguracionDTO objConfiguracion, String tipoDoc, String modo, int preview, String sobreEscribe) {
        String rutaImg;
        File rutaImagen;
        this.comprobante = objComprobante;
        this.configuracion = objConfiguracion;
        this.tipoDoc = tipoDoc;
        this.modo = modo;
        this.preview = preview;
        this.sobreEscribe = sobreEscribe;
        this.ruta = String.valueOf(LeeConexion.path) + File.separator + this.configuracion.getRutaSalidaPdf(this.comprobante.getTipoDoc());
        File rutaPDF = new File(this.ruta);
        if (!rutaPDF.exists()) {
            System.out.println("Se ha creado la ruta: " + this.ruta);
            rutaPDF.mkdirs();
        }
        if (!(rutaImagen = new File(rutaImg = String.valueOf(LeeConexion.path) + "/recursos/" + this.comprobante.getEmpNum() + "/logo.jpg")).exists()) {
            System.out.println("necesario insertar la imagen logotipo de la empesa en: " + rutaImg);
            this.isCraftable = false;
        } else {
            this.isCraftable = true;
        }
    }

    public String creaPDF(String pRutaPDF) {
        String nombreArchivo;
        block18: {
            nombreArchivo = "";
            System.out.println("Generaremos PDF de " + this.tipoDoc + " con UUID: " + this.comprobante.getUUID());
            try {
                block19: {
                    if (!(this.comprobante.getUUID() != null & this.isCraftable)) break block19;
                    switch (this.tipoDoc) {
                        case "FC": {
                            CFDenPDFSitiFact pdfFact = new CFDenPDFSitiFact(this.comprobante, this.configuracion);
                            nombreArchivo = pdfFact.generarPDF(this.modo, this.sobreEscribe, pRutaPDF);
                            break;
                        }
                        case "NC": {
                            System.out.println("Se identifica como nota de credito y creamos el objeto pdfNC");
                            CFDenPDFSitiFact pdfNC = new CFDenPDFSitiFact(this.comprobante, this.configuracion);
                            System.out.println("Llamamos a generarPDF");
                            nombreArchivo = pdfNC.generarPDF(this.modo, this.sobreEscribe, pRutaPDF);
                            break;
                        }
                        case "NM": {
                            System.out.println("Se identifica como nomina y creamos el objeto pdfRecibo");
                            CFDenPDFSitiRecibo pdfRecibo = new CFDenPDFSitiRecibo(this.comprobante, this.configuracion);
                            System.out.println("Llamamos a generarPDF");
                            nombreArchivo = pdfRecibo.generarPDF(this.modo, this.sobreEscribe, pRutaPDF);
                            break;
                        }
                        case "CB": {
                            System.out.println("Se identifica como pago y creamos el objeto pdfPago");
                            CFDenPDFSitiPago pdfPago = new CFDenPDFSitiPago(this.comprobante, this.configuracion);
                            System.out.println("Llamamos a generarPDF");
                            nombreArchivo = pdfPago.generarPDF(this.modo, this.sobreEscribe, pRutaPDF);
                            break;
                        }
                        default: {
                            nombreArchivo = "Ingrese una opcion valida para la creacion del pdf ()FC, NC, NM, CB";
                            break;
                        }
                    }
                    break block18;
                }
                nombreArchivo = "Error: no es posible crear pdf con ";
            }
            catch (Exception e) {
                System.out.println("No se pudo generar el PDF " + e.toString());
                nombreArchivo = "-Error: " + e;
            }
        }
        return nombreArchivo;
    }
}

