/*
 * Decompiled with CFR 0.152.
 */
package siti.sinco.cfdi.tools;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import siti.excepciones.RegistraLOG;
import siti.sinco.cfdi.dto.CfdConceptosDTO;
import siti.sinco.cfdi.dto.ComprobanteDTO;

public class GeneraXML {
    private String xsi = "http://www.w3.org/2001/XMLSchema-instance";
    private String cfdi = "http://www.sat.gob.mx/cfd/3";
    private String retenciones = "http://www.sat.gob.mx/esquemas/retencionpago/1";
    private String tfd = "http://www.sat.gob.mx/TimbreFiscalDigital";
    private String ns_nomina = "http://www.sat.gob.mx/nomina12";
    private String ns_pago = "http://www.sat.gob.mx/Pagos";
    private String ns_dividendo = "http://www.sat.gob.mx/esquemas/retencionpago/1/dividendos";

    public void generaxml(ComprobanteDTO comprobante, String rutaSalidaXML, int timbre) {
        block36: {
            block34: {
                StreamResult result;
                if (timbre != 0 && comprobante.getUUID() == null) break block34;
                String tipoarch = comprobante.getSubtipoDoc();
                DocumentBuilderFactory documentfactory = DocumentBuilderFactory.newInstance();
                documentfactory.setNamespaceAware(true);
                DocumentBuilder documentbuilder = null;
                try {
                    documentbuilder = documentfactory.newDocumentBuilder();
                }
                catch (Exception e) {
                    RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                }
                Document document = documentbuilder.newDocument();
                Element root = document.createElementNS(this.cfdi, "cfdi:Comprobante");
                document.setXmlStandalone(true);
                File carpetas = new File(rutaSalidaXML);
                if (!carpetas.exists()) {
                    carpetas.mkdirs();
                }
                String nombreArchivoXML = "";
                nombreArchivoXML = String.valueOf(rutaSalidaXML) + "/nuevo4.2" + comprobante.getFolioDoc() + "_" + comprobante.getRfcReceptor() + "_" + comprobante.getFecha().toString().substring(0, 10).replace("-", "") + tipoarch + ".xml";
                switch (tipoarch) {
                    case "cob": {
                        root.setAttribute("xmlns:cfdi", this.cfdi);
                        root.setAttribute("xmlns:xsi", this.xsi);
                        root.setAttribute("xmlns:pago10", this.ns_pago);
                        root.setAttribute("xsi:schemaLocation", "http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd http://www.sat.gob.mx/Pagos http://www.sat.gob.mx/sitio_internet/cfd/Pagos/Pagos10.xsd");
                        break;
                    }
                    default: {
                        root.setAttribute("xmlns:cfdi", this.cfdi);
                        root.setAttribute("xmlns:xsi", this.xsi);
                        root.setAttribute("xsi:schemaLocation", "http://www.sat.gob.mx/cfd/3 http://www.sat.gob.mx/sitio_internet/cfd/3/cfdv33.xsd");
                    }
                }
                root.setAttribute("Version", comprobante.getVersion());
                System.out.println("Serie: " + comprobante.getSerie());
                root.setAttribute("Serie", comprobante.getSerie());
                root.setAttribute("Folio", comprobante.getFolioDoc());
                root.setAttribute("Fecha", comprobante.getFecha());
                root.setAttribute("Sello", comprobante.getSello());
                root.setAttribute("FormaPago", comprobante.getFormaDePago());
                root.setAttribute("NoCertificado", comprobante.getNocertificado());
                root.setAttribute("Certificado", comprobante.getCertificado());
                root.setAttribute("SubTotal", comprobante.getSubtotal());
                root.setAttribute("Descuento", comprobante.getDescuento());
                root.setAttribute("Moneda", comprobante.getMoneda());
                root.setAttribute("Total", comprobante.getTotal());
                root.setAttribute("TipoDeComprobante", comprobante.getTipodecomprobante());
                root.setAttribute("MetodoPago", comprobante.getMetodoDePago());
                root.setAttribute("LugarExpedicion", comprobante.getLugarExpedicion());
                Element emisor = document.createElementNS(this.cfdi, "cfdi:Emisor");
                emisor.setAttribute("Nombre", comprobante.getNombreEmisor());
                emisor.setAttribute("Rfc", comprobante.getRfcEmisor());
                emisor.setAttribute("RegimenFiscal", comprobante.getRegimen());
                root.appendChild(emisor);
                Element receptor = document.createElementNS(this.cfdi, "cfdi:Receptor");
                receptor.setAttribute("Nombre", comprobante.getNombreReceptor());
                receptor.setAttribute("Rfc", comprobante.getRfcReceptor());
                receptor.setAttribute("UsoCFDI", comprobante.getUsoCFDI());
                root.appendChild(receptor);
                Element conceptos = document.createElementNS(this.cfdi, "cfdi:Conceptos");
                int i = 0;
                while (i < comprobante.conceptos.size()) {
                    Element datosconceptos = document.createElementNS(this.cfdi, "cfdi:Concepto");
                    CfdConceptosDTO concepto = comprobante.conceptos.elementAt(i);
                    datosconceptos.setAttribute("ClaveProdServ", concepto.getClaveSatProdServ());
                    datosconceptos.setAttribute("Cantidad", concepto.getCantidad());
                    datosconceptos.setAttribute("ClaveUnidad", concepto.getClaveSatUnidades());
                    datosconceptos.setAttribute("Unidad", concepto.getUnidad());
                    datosconceptos.setAttribute("Descripcion", concepto.getDescripcion());
                    datosconceptos.setAttribute("ValorUnitario", concepto.getValorUnitario());
                    datosconceptos.setAttribute("Importe", concepto.getImporte());
                    datosconceptos.setAttribute("Descuento", concepto.getDescuento());
                    Element impuestos = document.createElementNS(this.cfdi, "cfdi:Impuestos");
                    Element traslados = document.createElementNS(this.cfdi, "cfdi:Traslados");
                    int j = 0;
                    while (j < concepto.getLstTraslados().size()) {
                        Element datostraslados = document.createElementNS(this.cfdi, "cfdi:Traslado");
                        datostraslados.setAttribute("Base", concepto.getLstTraslados().get(j).getBase());
                        datostraslados.setAttribute("Impuesto", concepto.getLstTraslados().get(j).getImpuesto());
                        datostraslados.setAttribute("TipoFactor", concepto.getLstTraslados().get(j).getTipoFactor());
                        datostraslados.setAttribute("TasaOCuota", concepto.getLstTraslados().get(j).getTasaCuota());
                        datostraslados.setAttribute("Importe", concepto.getLstTraslados().get(j).getImporte());
                        traslados.appendChild(datostraslados);
                        ++j;
                    }
                    impuestos.appendChild(traslados);
                    datosconceptos.appendChild(impuestos);
                    conceptos.appendChild(datosconceptos);
                    ++i;
                }
                root.appendChild(conceptos);
                Element impuestos = document.createElementNS(this.cfdi, "cfdi:Impuestos");
                impuestos.setAttribute("TotalImpuestosTrasladados", comprobante.getTotalImpuestosTrasladados());
                Element traslados = document.createElementNS(this.cfdi, "cfdi:Traslados");
                int i2 = 0;
                while (i2 < comprobante.conceptos.size()) {
                    CfdConceptosDTO concepto = comprobante.conceptos.elementAt(i2);
                    int j = 0;
                    while (j < concepto.getLstTrasladosAgrupados().size()) {
                        Element datostraslados = document.createElementNS(this.cfdi, "cfdi:Traslado");
                        datostraslados.setAttribute("Impuesto", concepto.getLstTrasladosAgrupados().get(j).getImpuesto());
                        datostraslados.setAttribute("TipoFactor", concepto.getLstTrasladosAgrupados().get(j).getTipoFactor());
                        datostraslados.setAttribute("TasaOCuota", concepto.getLstTrasladosAgrupados().get(j).getTasaCuota());
                        datostraslados.setAttribute("Importe", concepto.getLstTrasladosAgrupados().get(j).getImporte());
                        traslados.appendChild(datostraslados);
                        ++j;
                    }
                    ++i2;
                }
                impuestos.appendChild(traslados);
                root.appendChild(impuestos);
                document.appendChild(root);
                Transformer transformer = null;
                try {
                    transformer = TransformerFactory.newInstance().newTransformer();
                }
                catch (Exception e) {
                    RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                }
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                if (timbre == 0) {
                    System.out.println("El xml para timbrar ha sido generado");
                    DOMSource source = new DOMSource(document);
                    result = new StreamResult(new File(nombreArchivoXML));
                    try {
                        transformer.transform(source, result);
                    }
                    catch (Exception e) {
                        RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                    }
                } else {
                    if (timbre == 3) {
                        DOMSource source = new DOMSource(document);
                        result = new StreamResult(new File(nombreArchivoXML));
                        try {
                            transformer.transform(source, result);
                            System.out.println("El xml para timbrar ha sido generado");
                        }
                        catch (Exception e) {
                            RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                        }
                    }
                    Element complemento = document.createElementNS(this.cfdi, "cfdi:Complemento");
                    Element timbrefiscal = document.createElementNS(this.tfd, "tfd:TimbreFiscalDigital");
                    timbrefiscal.setAttribute("xmlns:tfd", "http://www.sat.gob.mx/TimbreFiscalDigital");
                    timbrefiscal.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    timbrefiscal.setAttribute("xsi:schemaLocation", "http://www.sat.gob.mx/TimbreFiscalDigital http://www.sat.gob.mx/sitio_internet/cfd/TimbreFiscalDigital/TimbreFiscalDigitalv11.xsd");
                    timbrefiscal.setAttribute("Version", comprobante.getVersionTFD());
                    timbrefiscal.setAttribute("UUID", comprobante.getUUID());
                    timbrefiscal.setAttribute("FechaTimbrado", comprobante.getFechaTimbrado());
                    timbrefiscal.setAttribute("RfcProvCertif", comprobante.getRfcProvCertif());
                    timbrefiscal.setAttribute("SelloSAT", comprobante.getSelloSAT());
                    timbrefiscal.setAttribute("SelloCFD", comprobante.getSello());
                    timbrefiscal.setAttribute("NoCertificadoSAT", comprobante.getNoCertificadoSAT());
                    complemento.appendChild(timbrefiscal);
                    root.appendChild(complemento);
                    if (timbre == 1) {
                        DOMSource source = new DOMSource(document);
                        result = new StreamResult(new File(String.valueOf(nombreArchivoXML) + "UUID.xml"));
                        try {
                            transformer.transform(source, result);
                            System.out.println("El xml timbrado ha sido generado");
                        }
                        catch (Exception e) {
                            RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                        }
                    } else {
                        if (timbre == 3) {
                            DOMSource source = new DOMSource(document);
                            result = new StreamResult(new File(String.valueOf(nombreArchivoXML) + "UUID.xml"));
                            try {
                                transformer.transform(source, result);
                                System.out.println("El xml timbrado ha sido generado");
                            }
                            catch (Exception e) {
                                RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                            }
                        }
                        Element factura = document.createElement("CFD");
                        factura.setAttribute("idFactura", Integer.toString(comprobante.getFolioDoc_fact()));
                        factura.appendChild(root);
                        Element cadeoriginal = document.createElement("CadenaOriginal");
                        cadeoriginal.setTextContent(comprobante.getCadenaOriginal());
                        factura.appendChild(cadeoriginal);
                        Element meta = document.createElement("Metadatos");
                        try {
                            meta = this.generaNodoMetadatos(tipoarch, comprobante, document);
                        }
                        catch (Exception e) {
                            RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                        }
                        factura.appendChild(meta);
                        cadeoriginal = document.createElement("CadenaPac");
                        cadeoriginal.setTextContent(comprobante.getCadenaOriginalSAT());
                        factura.appendChild(cadeoriginal);
                        document.appendChild(factura);
                        DOMSource source = new DOMSource(document);
                        result = new StreamResult(new File(String.valueOf(nombreArchivoXML) + "INT.xml"));
                        try {
                            transformer.transform(source, result);
                            System.out.println("El xml interpretado ha sido generado");
                        }
                        catch (Exception e) {
                            RegistraLOG.registrarLog(this.getClass().getName(), "generaxml", e.toString(), "ERROR JAVA");
                        }
                    }
                }
                break block36;
            }
            System.out.println("El xml aun no ha sido timbrado");
        }
    }

    private Element generaNodoMetadatos(String tipoarch, ComprobanteDTO comprobante, Document document) throws ParserConfigurationException {
        Element meta = null;
        switch (tipoarch) {
            case "atr": {
                meta = this.nodometaAtr(comprobante, document);
                break;
            }
            case "apr": {
                meta = this.nodometaApr(comprobante, document);
                break;
            }
            case "cob": {
                meta = this.nodometaCob(comprobante, document);
                break;
            }
            case "ces": {
                meta = this.nodometaCes(comprobante, document);
                break;
            }
            case "pto": {
                meta = this.nodometaPto(comprobante, document);
                break;
            }
            case "mue": {
                meta = this.nodometaMue(comprobante, document);
                break;
            }
            case "ped": {
                meta = this.nodometaPed(comprobante, document);
                break;
            }
            case "man": {
                meta = this.nodometaMan(comprobante, document);
            }
        }
        return meta;
    }

    private Element nodometaAtr(ComprobanteDTO comprobante, Document document) {
        Element metaatr = document.createElement("Metadata");
        Element metaid = document.createElement("ID");
        Element metabuque = document.createElement("BUQUE");
        Element metacvnaviera = document.createElement("CV_NAVIERA");
        Element metaagentenav = document.createElement("AGENTE_NAVIERO");
        Element metafatraque = document.createElement("F_ATRAQUE");
        Element metafentrega = document.createElement("F_ENTREGA");
        Element metativa = document.createElement("T_IVA");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metabuque.setTextContent(comprobante.getmetadatoAtr().getBuque());
        metacvnaviera.setTextContent(comprobante.getmetadatoAtr().getClaveNaviera());
        metaagentenav.setTextContent(comprobante.getmetadatoAtr().getAgenteNaviero());
        metafatraque.setTextContent(comprobante.getmetadatoAtr().getFechaAtraque());
        metafentrega.setTextContent(comprobante.getmetadatoAtr().getFechaEntrega());
        metativa.setTextContent(comprobante.getmetadatoAtr().getTasaIva());
        metafoliosip.setTextContent(comprobante.getmetadatoAtr().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoAtr().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoAtr().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoAtr().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoAtr().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoAtr().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoAtr().getReferenciaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoAtr().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoAtr().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoAtr().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoAtr().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoAtr().getTipoRelacion());
        metacuentabancaria.setTextContent(comprobante.getmetadatoAtr().getCuentaBancaria());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaatr.appendChild(metaid);
        metaatr.appendChild(metabuque);
        metaatr.appendChild(metacvnaviera);
        metaatr.appendChild(metaagentenav);
        metaatr.appendChild(metafatraque);
        metaatr.appendChild(metafentrega);
        metaatr.appendChild(metativa);
        metaatr.appendChild(metafoliosip);
        metaatr.appendChild(metatipofact);
        metaatr.appendChild(metacomplemento);
        metaatr.appendChild(metahostimpresora);
        metaatr.appendChild(metanombreimpresora);
        metaatr.appendChild(metanocopias);
        metaatr.appendChild(metaleyendarfc);
        metaatr.appendChild(metareferenciabancaria);
        metaatr.appendChild(metacuentabancaria);
        metaatr.appendChild(metaregimenfiscal);
        metaatr.appendChild(metametodopago);
        metaatr.appendChild(metaformapago);
        metaatr.appendChild(metausocfdi);
        metaatr.appendChild(metatiporelacion);
        metaatr.appendChild(metaemisor);
        metaatr.appendChild(metareceptor);
        return metaatr;
    }

    private Element nodometaApr(ComprobanteDTO comprobante, Document document) {
        Element metaApr = document.createElement("Metadata");
        Element metativa = document.createElement("T_IVA");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metativa.setTextContent(comprobante.getmetadatoApr().getTasaIva());
        metafoliosip.setTextContent(comprobante.getmetadatoApr().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoApr().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoApr().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoApr().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoApr().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoApr().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoApr().getReferenciaBancaria());
        metacuentabancaria.setTextContent(comprobante.getmetadatoApr().getCuentaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoApr().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoApr().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoApr().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoApr().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoApr().getTipoRelacion());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaApr.appendChild(metativa);
        metaApr.appendChild(metafoliosip);
        metaApr.appendChild(metatipofact);
        metaApr.appendChild(metacomplemento);
        metaApr.appendChild(metahostimpresora);
        metaApr.appendChild(metanombreimpresora);
        metaApr.appendChild(metanocopias);
        metaApr.appendChild(metaleyendarfc);
        metaApr.appendChild(metareferenciabancaria);
        metaApr.appendChild(metacuentabancaria);
        metaApr.appendChild(metaregimenfiscal);
        metaApr.appendChild(metametodopago);
        metaApr.appendChild(metaformapago);
        metaApr.appendChild(metausocfdi);
        metaApr.appendChild(metatiporelacion);
        metaApr.appendChild(metaemisor);
        metaApr.appendChild(metareceptor);
        return metaApr;
    }

    private Element nodometaCob(ComprobanteDTO comprobante, Document document) {
        Element metaCob = document.createElement("Metadata");
        Element metaleyenda1 = document.createElement("Leyenda4");
        Element metaleyenda2 = document.createElement("Leyenda4");
        Element metaleyenda3 = document.createElement("Leyenda4");
        Element metaleyenda4 = document.createElement("Leyenda4");
        Element metaleyenda5 = document.createElement("Leyenda5");
        Element metapatente = document.createElement("PATENTE");
        Element metaclavenav = document.createElement("CV_NAVIERA");
        Element metatipofact = document.createElement("TIPO_FACTURA");
        Element metapagos = document.createElement("Pagos");
        Element metacomprobante = document.createElement("Comprobante");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        Element metaimporteletra = document.createElement("ImporteLetra");
        metaleyenda1.setTextContent(comprobante.getmetadatoCob().getLeyenda1());
        metaleyenda2.setTextContent(comprobante.getmetadatoCob().getLeyenda2());
        metaleyenda3.setTextContent(comprobante.getmetadatoCob().getLeyenda3());
        metaleyenda4.setTextContent(comprobante.getmetadatoCob().getLeyenda4());
        metaleyenda5.setTextContent(comprobante.getmetadatoCob().getLeyenda5());
        metaclavenav.setTextContent(comprobante.getmetadatoCob().getClaveNaviera());
        metapatente.setTextContent(comprobante.getmetadatoCob().getPatente());
        metatipofact.setTextContent(comprobante.getmetadatoCob().getTipoFactura());
        int i = 0;
        while (i < comprobante.getComplementosPago().size()) {
            Element metapago = document.createElement("Pago");
            metapago.setAttribute("FormaPago", comprobante.getComplementosPago().get(i).getFormaDePagoP());
            metapago.setAttribute("MonedaPago", comprobante.getComplementosPago().get(i).getMonedaP());
            metapagos.appendChild(metapago);
            ++i;
        }
        metacomprobante.setAttribute("TipoComprobante", comprobante.getTipodecomprobante());
        metacomprobante.setAttribute("Moneda", comprobante.getMoneda());
        metacomprobante.setAttribute("RegimenFiscal", comprobante.getRegimen());
        metacomprobante.setAttribute("UsoCFDI", comprobante.getUsoCFDI());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaimporteletra.setTextContent(comprobante.getTotalEnLetra());
        metaCob.appendChild(metaleyenda1);
        metaCob.appendChild(metaleyenda2);
        metaCob.appendChild(metaleyenda3);
        metaCob.appendChild(metaleyenda4);
        metaCob.appendChild(metaleyenda5);
        metaCob.appendChild(metapatente);
        metaCob.appendChild(metaclavenav);
        metaCob.appendChild(metatipofact);
        metaCob.appendChild(metapagos);
        metaCob.appendChild(metacomprobante);
        metaCob.appendChild(metaemisor);
        metaCob.appendChild(metareceptor);
        metaCob.appendChild(metaimporteletra);
        return metaCob;
    }

    private Element nodometaCes(ComprobanteDTO comprobante, Document document) {
        Element metaCes = document.createElement("Metadata");
        Element metativa = document.createElement("T_IVA");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metativa.setTextContent(comprobante.getmetadatoCes().getTasaIva());
        metafoliosip.setTextContent(comprobante.getmetadatoCes().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoCes().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoCes().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoCes().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoCes().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoCes().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoCes().getReferenciaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoCes().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoCes().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoCes().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoCes().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoCes().getTipoRelacion());
        metacuentabancaria.setTextContent(comprobante.getmetadatoCes().getCuentaBancaria());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaCes.appendChild(metativa);
        metaCes.appendChild(metafoliosip);
        metaCes.appendChild(metatipofact);
        metaCes.appendChild(metacomplemento);
        metaCes.appendChild(metahostimpresora);
        metaCes.appendChild(metanombreimpresora);
        metaCes.appendChild(metanocopias);
        metaCes.appendChild(metaleyendarfc);
        metaCes.appendChild(metareferenciabancaria);
        metaCes.appendChild(metacuentabancaria);
        metaCes.appendChild(metaregimenfiscal);
        metaCes.appendChild(metametodopago);
        metaCes.appendChild(metaformapago);
        metaCes.appendChild(metausocfdi);
        metaCes.appendChild(metatiporelacion);
        metaCes.appendChild(metaemisor);
        metaCes.appendChild(metareceptor);
        return metaCes;
    }

    private Element nodometaMan(ComprobanteDTO comprobante, Document document) {
        Element metaMan = document.createElement("Metadata");
        Element metacvnaviera = document.createElement("CV_NAVIERA");
        Element metaagentenav = document.createElement("AGENTE_NAVIERO");
        Element metativa = document.createElement("T_IVA");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metacvnaviera.setTextContent(comprobante.getmetadatoMan().getClaveNaviera());
        metaagentenav.setTextContent(comprobante.getmetadatoMan().getAgenteNaviero());
        metativa.setTextContent(comprobante.getmetadatoMan().getTasaIva());
        metafoliosip.setTextContent(comprobante.getmetadatoMan().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoMan().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoMan().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoMan().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoMan().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoMan().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoMan().getReferenciaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoMan().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoMan().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoMan().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoMan().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoMan().getTipoRelacion());
        metacuentabancaria.setTextContent(comprobante.getmetadatoMan().getCuentaBancaria());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaMan.appendChild(metacvnaviera);
        metaMan.appendChild(metaagentenav);
        metaMan.appendChild(metativa);
        metaMan.appendChild(metafoliosip);
        metaMan.appendChild(metatipofact);
        metaMan.appendChild(metacomplemento);
        metaMan.appendChild(metahostimpresora);
        metaMan.appendChild(metanombreimpresora);
        metaMan.appendChild(metanocopias);
        metaMan.appendChild(metaleyendarfc);
        metaMan.appendChild(metareferenciabancaria);
        metaMan.appendChild(metacuentabancaria);
        metaMan.appendChild(metaregimenfiscal);
        metaMan.appendChild(metametodopago);
        metaMan.appendChild(metaformapago);
        metaMan.appendChild(metausocfdi);
        metaMan.appendChild(metatiporelacion);
        metaMan.appendChild(metaemisor);
        metaMan.appendChild(metareceptor);
        return metaMan;
    }

    private Element nodometaMue(ComprobanteDTO comprobante, Document document) {
        Element metaMue = document.createElement("Metadata");
        Element metaid = document.createElement("ID");
        Element metabuque = document.createElement("BUQUE");
        Element metacvnaviera = document.createElement("CV_NAVIERA");
        Element metaagentenav = document.createElement("AGENTE_NAVIERO");
        Element metaclase = document.createElement("CLASE");
        Element metaconocimiento = document.createElement("CONOCIMIENTO");
        Element metafatraque = document.createElement("F_ATRAQUE");
        Element metativa = document.createElement("T_IVA");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metabuque.setTextContent(comprobante.getmetadatoMue().getBuque());
        metacvnaviera.setTextContent(comprobante.getmetadatoMue().getClaveNaviera());
        metaagentenav.setTextContent(comprobante.getmetadatoMue().getAgenteNaviero());
        metafatraque.setTextContent(comprobante.getmetadatoMue().getFechaAtraque());
        metaclase.setTextContent(comprobante.getmetadatoMue().getClase());
        metaclase.setTextContent(comprobante.getmetadatoMue().getConocimiento());
        metativa.setTextContent(comprobante.getmetadatoMue().getTasaIva());
        metafoliosip.setTextContent(comprobante.getmetadatoMue().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoMue().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoMue().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoMue().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoMue().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoMue().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoMue().getReferenciaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoMue().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoMue().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoMue().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoMue().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoMue().getTipoRelacion());
        metacuentabancaria.setTextContent(comprobante.getmetadatoMue().getCuentaBancaria());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaMue.appendChild(metaid);
        metaMue.appendChild(metabuque);
        metaMue.appendChild(metaclase);
        metaMue.appendChild(metaconocimiento);
        metaMue.appendChild(metacvnaviera);
        metaMue.appendChild(metaagentenav);
        metaMue.appendChild(metafatraque);
        metaMue.appendChild(metativa);
        metaMue.appendChild(metafoliosip);
        metaMue.appendChild(metatipofact);
        metaMue.appendChild(metacomplemento);
        metaMue.appendChild(metahostimpresora);
        metaMue.appendChild(metanombreimpresora);
        metaMue.appendChild(metanocopias);
        metaMue.appendChild(metaleyendarfc);
        metaMue.appendChild(metareferenciabancaria);
        metaMue.appendChild(metacuentabancaria);
        metaMue.appendChild(metaregimenfiscal);
        metaMue.appendChild(metametodopago);
        metaMue.appendChild(metaformapago);
        metaMue.appendChild(metausocfdi);
        metaMue.appendChild(metatiporelacion);
        metaMue.appendChild(metaemisor);
        metaMue.appendChild(metareceptor);
        return metaMue;
    }

    private Element nodometaPto(ComprobanteDTO comprobante, Document document) {
        Element metaPto = document.createElement("Metadata");
        Element metaid = document.createElement("ID");
        Element metabuque = document.createElement("BUQUE");
        Element metacvnaviera = document.createElement("CV_NAVIERA");
        Element metaagentenav = document.createElement("AGENTE_NAVIERO");
        Element metafatraque = document.createElement("F_ATRAQUE");
        Element metafentrega = document.createElement("F_ENTREGA");
        Element metativa = document.createElement("T_IVA");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metabuque.setTextContent(comprobante.getmetadatoPto().getBuque());
        metacvnaviera.setTextContent(comprobante.getmetadatoPto().getClaveNaviera());
        metaagentenav.setTextContent(comprobante.getmetadatoPto().getAgenteNaviero());
        metafatraque.setTextContent(comprobante.getmetadatoPto().getFechaAtraque());
        metafentrega.setTextContent(comprobante.getmetadatoPto().getFechaEntrega());
        metativa.setTextContent(comprobante.getmetadatoPto().getTasaIva());
        metafoliosip.setTextContent(comprobante.getmetadatoPto().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoPto().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoPto().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoPto().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoPto().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoPto().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoPto().getReferenciaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoPto().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoPto().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoPto().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoPto().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoPto().getTipoRelacion());
        metacuentabancaria.setTextContent(comprobante.getmetadatoPto().getCuentaBancaria());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaPto.appendChild(metaid);
        metaPto.appendChild(metabuque);
        metaPto.appendChild(metacvnaviera);
        metaPto.appendChild(metaagentenav);
        metaPto.appendChild(metafatraque);
        metaPto.appendChild(metafentrega);
        metaPto.appendChild(metativa);
        metaPto.appendChild(metafoliosip);
        metaPto.appendChild(metatipofact);
        metaPto.appendChild(metacomplemento);
        metaPto.appendChild(metahostimpresora);
        metaPto.appendChild(metanombreimpresora);
        metaPto.appendChild(metanocopias);
        metaPto.appendChild(metaleyendarfc);
        metaPto.appendChild(metareferenciabancaria);
        metaPto.appendChild(metacuentabancaria);
        metaPto.appendChild(metaregimenfiscal);
        metaPto.appendChild(metametodopago);
        metaPto.appendChild(metaformapago);
        metaPto.appendChild(metausocfdi);
        metaPto.appendChild(metatiporelacion);
        metaPto.appendChild(metaemisor);
        metaPto.appendChild(metareceptor);
        return metaPto;
    }

    private Element nodometaPed(ComprobanteDTO comprobante, Document document) {
        Element metaPed = document.createElement("Metadata");
        Element metapatente = document.createElement("PATENTE");
        Element metaagenteaduanal = document.createElement("AGENTE_ADUANAL");
        Element metafoliosip = document.createElement("FOLIO_SIP");
        Element metatipofact = document.createElement("TIPO_FACT");
        Element metacomplemento = document.createElement("Complemento");
        Element metahostimpresora = document.createElement("HOST_IMPRESORA");
        Element metanombreimpresora = document.createElement("NOMBRE_IMPRESORA");
        Element metanocopias = document.createElement("NO.COPIAS");
        Element metaleyendarfc = document.createElement("LEYENDA_RFC");
        Element metareferenciabancaria = document.createElement("REFERENCIA_BANCARIA");
        Element metacuentabancaria = document.createElement("CUENTA_BANCARIA");
        Element metaregimenfiscal = document.createElement("REGIMEN_FISCAL");
        Element metametodopago = document.createElement("METODO_PAGO");
        Element metaformapago = document.createElement("FORMA_PAGO");
        Element metausocfdi = document.createElement("USO_CFDI");
        Element metatiporelacion = document.createElement("TIPO_RELACION");
        Element metaemisor = document.createElement("Emisor");
        Element metareceptor = document.createElement("Receptor");
        Element metadomicilio = document.createElement("Domicilio");
        metapatente.setTextContent(comprobante.getmetadatoPed().getPatente());
        metaagenteaduanal.setTextContent(comprobante.getmetadatoPed().getAgenteAduanal());
        metafoliosip.setTextContent(comprobante.getmetadatoPed().getFolioSip());
        metatipofact.setTextContent(comprobante.getmetadatoPed().getTipoFactura());
        metahostimpresora.setTextContent(comprobante.getmetadatoPed().getHostImpresora());
        metanombreimpresora.setTextContent(comprobante.getmetadatoPed().getNombreImpresora());
        metanocopias.setTextContent(Integer.toString(comprobante.getmetadatoPed().getNoCopias()));
        metaleyendarfc.setTextContent(comprobante.getmetadatoPed().getLeyendaRFC());
        metareferenciabancaria.setTextContent(comprobante.getmetadatoPed().getReferenciaBancaria());
        metaregimenfiscal.setTextContent(comprobante.getmetadatoPed().getRegimenFiscal());
        metametodopago.setTextContent(comprobante.getmetadatoPed().getMetodoPago());
        metaformapago.setTextContent(comprobante.getmetadatoPed().getFormaPago());
        metausocfdi.setTextContent(comprobante.getmetadatoPed().getUsoCFDI());
        metatiporelacion.setTextContent(comprobante.getmetadatoPed().getTipoRelacion());
        metacuentabancaria.setTextContent(comprobante.getmetadatoPed().getCuentaBancaria());
        metadomicilio.setAttribute("Calle", comprobante.getCalleEmisor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorEmisor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorEmisor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadEmisor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoEmisor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioEmisor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalEmisor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaEmisor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisEmisor());
        metaemisor.appendChild(metadomicilio);
        metadomicilio = document.createElement("Domicilio");
        metadomicilio.setAttribute("Calle", comprobante.getCalleReceptor());
        metadomicilio.setAttribute("NoExterior", comprobante.getNoExteriorReceptor());
        metadomicilio.setAttribute("NoInterior", comprobante.getNoInteriorReceptor());
        metadomicilio.setAttribute("Localidad", comprobante.getLocalidadReceptor());
        metadomicilio.setAttribute("Estado", comprobante.getEstadoReceptor());
        metadomicilio.setAttribute("Municipio", comprobante.getMunicipioReceptor());
        metadomicilio.setAttribute("CodigoPostal", comprobante.getCodigoPostalReceptor());
        metadomicilio.setAttribute("Colonia", comprobante.getColoniaReceptor());
        metadomicilio.setAttribute("Pais", comprobante.getPaisReceptor());
        metareceptor.appendChild(metadomicilio);
        metaPed.appendChild(metapatente);
        metaPed.appendChild(metaagenteaduanal);
        metaPed.appendChild(metafoliosip);
        metaPed.appendChild(metatipofact);
        metaPed.appendChild(metacomplemento);
        metaPed.appendChild(metahostimpresora);
        metaPed.appendChild(metanombreimpresora);
        metaPed.appendChild(metanocopias);
        metaPed.appendChild(metaleyendarfc);
        metaPed.appendChild(metareferenciabancaria);
        metaPed.appendChild(metacuentabancaria);
        metaPed.appendChild(metaregimenfiscal);
        metaPed.appendChild(metametodopago);
        metaPed.appendChild(metaformapago);
        metaPed.appendChild(metausocfdi);
        metaPed.appendChild(metatiporelacion);
        metaPed.appendChild(metaemisor);
        metaPed.appendChild(metareceptor);
        return metaPed;
    }
}

